--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "dialog_story" );
  ObjAttach( "int_dialog_story", interface.originhub );
  ObjSet( "int_dialog_story", { pos_z = pos_z } );
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  private.event_anim_end = {};

  private.object_current = nil;
  private.skip_func = nil;
  private.click_func = nil;

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( "obj_int_dialog_story_continue", { input = true } );

    local skip_time = event_params[ "tme_skip" ];

    if ( skip_time > 0 ) then

      ObjSet( "tmr_int_dialog_story_skip",
      { 
        endtrig = private.SkipShow,
        time    = skip_time,
        playing = true
      } );

    else

      ObjSet( "obj_int_dialog_story_skip", { input = true } );

    end;
    ------------------------------------------------------------------------------------
  elseif ( event_id == "skip_show" ) then

    ObjSet( "obj_int_dialog_story_skip", { input = true } );

    ------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    ObjDetach( private.object_current );
    private.object_current = nil;
    private.skip_func = nil;
    private.click_func = nil;

    ObjSet( "int_dialog_story", { active = false, visible = false, input = false } );

    ------------------------------------------------------------------------------------
  elseif ( event_id == "change_begin" ) then

    local text_id = event_params;

    ObjSet( "txt_int_dialog_story", { text = text_id } );

    local next_event_id = "change_proc";
    private.event_anim_end[ next_event_id ] = {};
    int_dialog_story_impl.ChangeProcAnim( next_event_id );

   ------------------------------------------------------------------------------------
  elseif ( event_id == "change_proc" ) then

  --
  end;

end;
--******************************************************************************************
function public.Show( text_id, object_name, click_func, skip_func, skip_time, show_character )

  local event_id = "change_begin";
  private.event_anim_end[ event_id ] = text_id;
  int_dialog_story_impl.ChangeBeginAnim( event_id );

  if ( not private.object_current )
  or ( private.object_current ~= object_name )
  then

    private.object_current = object_name;
    private.skip_func = skip_func;  
    private.click_func = click_func;
    ObjSet( private.object_current, { pos_z = -1000 } );
    ObjAttach( private.object_current, "int_dialog_story" );

    ObjSet( "int_dialog_story", { active = true, visible = true, input = true } );

    ObjSet( "obj_int_dialog_story_skip", { input   = false } );
    ObjSet( "tmr_int_dialog_story_skip", { playing = false } );

    if ( skip_time == 0 ) then
      ObjSet( "obj_int_dialog_story_skip", { visible = true } );
    else
      ObjSet( "obj_int_dialog_story_skip", { visible = false } );
    end;

    ObjSet( "obj_int_dialog_story_continue", { input = false } );

    skip_w = 10 + ObjGet( "txt_int_dialog_story_skip" ).draw_width;
    skip_h = 10 + ObjGet( "txt_int_dialog_story_skip" ).draw_height;
    ObjSet( "obj_int_dialog_story_skip",
    {
      inputrect_init =                  1,
      inputrect_x    =           - skip_w,
      inputrect_y    = - ( 0.5 * skip_h ),
      inputrect_w    =        10 + skip_w,
      inputrect_h    =             skip_h
    } );

    continue_w = 10 + ObjGet( "txt_int_dialog_story_continue" ).draw_width;
    continue_h = 10 + ObjGet( "txt_int_dialog_story_continue" ).draw_height;
    ObjSet( "obj_int_dialog_story_continue",
    {
      inputrect_init =                      1,
      inputrect_x    =           - continue_w,
      inputrect_y    = - ( 0.5 * continue_h ),
      inputrect_w    =        10 + continue_w,
      inputrect_h    =             continue_h
    } );

    local event_id = "show";
    private.event_anim_end[ event_id ] = { tme_skip = skip_time };
    int_dialog_story_impl.ShowAnim( event_id );

  end;

end;
--******************************************************************************************
function public.Hide( message_type, message_params )

  if ( private.object_current ) then

    ObjSet( "obj_int_dialog_story_skip",     { input = false } );
    ObjSet( "obj_int_dialog_story_continue", { input = false } );

    local event_id = "hide";
    private.event_anim_end[ event_id ] = {};
    int_dialog_story_impl.HideAnim( event_id );

  end;

end;
--******************************************************************************************
function public.SkipClick()
  if private.skip_func ~= nil then
    private.skip_func();
  end;
end;
--******************************************************************************************
function public.ContinueClick()
  if private.click_func ~= nil then
    private.click_func();
  end;
end;
--******************************************************************************************
function private.SkipShow()

  ObjSet( "obj_int_dialog_story_skip", { visible = true } );

  local event_id = "skip_show";
  private.event_anim_end[ event_id ] = "";
  int_dialog_story_impl.SkipShowAnim( event_id );

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "dialog_story" );

end;
--******************************************************************************************