--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "dialog_ho" );
  ObjAttach( "int_dialog_ho", interface.originhub );
  ObjSet( "int_dialog_ho", { pos_z = pos_z } );
  private.event_anim_end = {};
  private.item_object_name = nil;

end;
--******************************************************************************************
function public.Destroy()

end;
--******************************************************************************************
function public.MouseDown()

  private.Hide();
  MsgSend( Event_DialogHo_Hide, {} );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( "obj_int_dialog_ho_exit", { event_mdown = public.MouseDown } );

    ObjSet( "int_dialog_ho_impl", { input = true } );

  elseif ( event_id == "hide" ) then

    ObjSet( "int_dialog_ho_impl", { active = false, visible = false } );
    ObjSet( "int_dialog_ho",      { active = false, visible = false, input = false } );

  end;
------------------------------------------------------------------------------------
end;
--******************************************************************************************
function public.Show( item )

  private.item_object_name = item;

  ObjAttach( private.item_object_name, "obj_int_dialog_ho" );

  ObjSet( private.item_object_name,
  {
    active  = true,
    visible = true,
    input   = false,
    pos_x   = 0,
    pos_y   = 0
  } );

  ObjSet( "int_dialog_ho",      { active = true, visible = true, input = true } );
  ObjSet( "int_dialog_ho_impl", { active = true, visible = true, input = false } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_dialog_ho_impl.ShowAnim( event_id );

end;
--******************************************************************************************
function private.Hide()

  ObjSet( "obj_int_dialog_ho_exit", { event_mdown = "" } );
  ObjSet( "int_dialog_ho_impl", { input = false } );

  local event_id = "hide";
  private.event_anim_end[ event_id ] = {};
  int_dialog_ho_impl.HideAnim( event_id );

end;
--******************************************************************************************