--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "dialog_character" );
  ObjAttach( "int_dialog_character", interface.originhub );
  ObjSet( "int_dialog_character", { pos_z = pos_z } );
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  private.event_anim_end = {};

  private.object_current = nil;
  private.skip_func = nil;
  private.click_func = nil;
  private.pos_x = nil;
  private.pos_y = nil;

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( "int_dialog_character_impl", { input = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    ObjSet( "int_dialog_character", { active = false, visible = false, input = false } );
    ObjDetach( private.object_current );
    private.object_current = nil;
    private.skip_func = nil;
    private.click_func = nil;
    private.pos_x = nil;
    private.pos_y = nil;

------------------------------------------------------------------------------------
  elseif ( event_id == "change_begin" ) then

    local text_id = event_params;

    private.GridSet( text_id );

    local next_event_id = "change_proc";
    private.event_anim_end[ next_event_id ] = {};
    int_dialog_character_impl.ChangeProcAnim( next_event_id );

------------------------------------------------------------------------------------
  elseif ( event_id == "change_proc" ) then

    ObjSet( "int_dialog_character_impl", { input = true } );

------------------------------------------------------------------------------------

  end;
------------------------------------------------------------------------------------
end;
--******************************************************************************************
function public.Show( text_id, object_name, click_func, skip_func, pos_x, pos_y )

  ObjSet( "int_dialog_character_impl", { input = false } );

  if ( not private.object_current )
  or ( private.object_current ~= object_name )
  then

    private.object_current = object_name;
    private.skip_func = skip_func;  
    private.click_func = click_func;
    private.pos_x = pos_x;
    private.pos_y = pos_y;

    ObjSet( "int_dialog_character", { active = true, visible = true, input = true } );

    skip_w = 10 + ObjGet( "txt_int_dialog_character_skip" ).draw_width;
    skip_h = 10 + ObjGet( "txt_int_dialog_character_skip" ).draw_height;
    ObjSet( "obj_int_dialog_character_skip",
    {
      inputrect_init =                  1,
      inputrect_x    =           - skip_w,
      inputrect_y    = - ( 0.5 * skip_h ),
      inputrect_w    =        10 + skip_w,
      inputrect_h    =             skip_h
    } );

    continue_w = 10 + ObjGet( "txt_int_dialog_character_continue" ).draw_width;
    continue_h = 10 + ObjGet( "txt_int_dialog_character_continue" ).draw_height;
    ObjSet( "obj_int_dialog_character_continue",
    {
      inputrect_init =                      1,
      inputrect_x    =           - continue_w,
      inputrect_y    = - ( 0.5 * continue_h ),
      inputrect_w    =        10 + continue_w,
      inputrect_h    =             continue_h
    } );

    private.GridSet( text_id );

    local event_id = "show";
    private.event_anim_end[ event_id ] = {};
    int_dialog_character_impl.ShowAnim( event_id );

    ObjSet( private.object_current, { pos_z = -1000 } );
    ObjAttach( private.object_current, "int_dialog_character" );

  else

    local event_id = "change_begin";
    private.event_anim_end[ event_id ] = text_id;
    int_dialog_character_impl.ChangeBeginAnim( event_id );
    private.pos_x = pos_x or private.pos_x;
    private.pos_y = pos_y or private.pos_y;

  end;

end;
--******************************************************************************************
function public.Hide( message_type, message_params )

  if ( private.object_current ) then

    ObjSet( "int_dialog_character_impl", { input = false } );

    local event_id = "hide";
    private.event_anim_end[ event_id ] = {};
    int_dialog_character_impl.HideAnim( event_id );

  end;

end;
--******************************************************************************************
function public.SkipClick()
  if private.skip_func ~= nil then
    private.skip_func();
  end;
end;
--******************************************************************************************
function public.ContinueClick()
  if private.click_func ~= nil then
    private.click_func();
  end;
end;
--******************************************************************************************
function private.GridSet( text_id )

  ObjSet( "txt_int_dialog_character", { text = text_id } );

  local set = {};
  if private.pos_x then set.pos_x = private.pos_x; end;
  if private.pos_y then set.pos_y = private.pos_y; end;
  if set.pos_x or set.pos_y then
    ObjSet( "grd_int_dialog_character", set );
  end;

  local text_params = ObjGet( "txt_int_dialog_character" );
  local out_params  = interface.GetParamsForGrid( "int_dialog_character_impl", text_params.draw_width, text_params.draw_height );

  local dialog_w = out_params.width;
  local dialog_h = out_params.height;

  local grid_corner_w = int_dialog_character_impl.GRID_CORNER_W;
  local grid_corner_h = int_dialog_character_impl.GRID_CORNER_H;

  local grid_mid_w = int_dialog_character_impl.GRID_MID_W;
  local grid_mid_h = int_dialog_character_impl.GRID_MID_H;

  interface.FrameGridSet( "int_dialog_character",
  {
    grid_w   = dialog_w,
    grid_h   = dialog_h,
    corner_w = grid_corner_w,
    corner_h = grid_corner_h,
    mid_w    = grid_mid_w,
    mid_h    = grid_mid_h
  } );

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "dialog_character" );

end;
--******************************************************************************************