--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "dialog" );
  ObjAttach( "int_dialog", interface.originhub );
  ObjSet( "int_dialog", { pos_z = pos_z } );

  private.event_anim_end = {};
  private.show = false;

end;
--******************************************************************************************
function public.Destroy()


end;
--******************************************************************************************
function public.Show( dialog_text, dialog_pos_x, dialog_pos_y, extended )

  ObjSet( "txt_int_dialog", { text = dialog_text } );

  local off_x = int_dialog_impl.GRID_BORDER_W;
  local off_y = int_dialog_impl.GRID_BORDER_H;

  local dialog_w = ObjGet( "txt_int_dialog" ).draw_width + off_x;

  if ( dialog_w < int_dialog_impl.MIN_W ) then

    dialog_w = int_dialog_impl.MIN_W;

  end;

  if ( dialog_w > int_dialog_impl.MAX_W ) then

    dialog_w = int_dialog_impl.MAX_W;

  end;

  local dialog_h = ObjGet( "txt_int_dialog" ).draw_height + off_y;

  if ( dialog_h < int_dialog_impl.MIN_H ) then

    dialog_h = int_dialog_impl.MIN_H;

  end;

  if ( dialog_h > int_dialog_impl.MAX_H ) then
  
    dialog_h = int_dialog_impl.MAX_H;

  end;

  local grid_corner_w = int_dialog_impl.GRID_CORNER_W;
  local grid_corner_h = int_dialog_impl.GRID_CORNER_H;

  local grid_mid_w = int_dialog_impl.GRID_MID_W;
  local grid_mid_h = int_dialog_impl.GRID_MID_H;

  interface.FrameGridSet( "int_dialog",
  {
    grid_w   = dialog_w,
    grid_h   = dialog_h,
    corner_w = grid_corner_w,
    corner_h = grid_corner_h,
    mid_w    = grid_mid_w,
    mid_h    = grid_mid_h
  } );

  local dialog_full_w = dialog_w;
  local dialog_full_h = dialog_h;

  ObjSet( "int_dialog",
  {
    active = 1, visible = 1, input = 1,
    inputrect_init = 1,
    inputrect_x    = - ( 0.5 * dialog_full_w ),
    inputrect_y    = - ( 0.5 * dialog_full_h ),
    inputrect_w    = dialog_full_w,
    inputrect_h    = dialog_full_h,
    pos_x = dialog_pos_x, pos_y = dialog_pos_y
  } );

  ObjSet( "int_dialog_impl", { pos_x = 0, pos_y = 0 } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = message_params;
  int_dialog_impl.ShowAnim( event_id, extended );


end;
--******************************************************************************************
function public.Hide( extended )

  private.show = false;
  ObjSet( "int_dialog", { input = false } );

  local event_id = "hide";
  private.event_anim_end[ event_id ] = message_params;
  int_dialog_impl.HideAnim( event_id, extended );

end;
--******************************************************************************************
function public.MouseDown()

  public.Hide();

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

  private.show = true;
  ObjSet( "int_dialog", { input = true, active = true, visible = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

  ObjSet( "int_dialog", { active = false, visible = false, input = false } );

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
