--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "complex_inv" );
  ObjAttach( "int_complex_inv_impl", "int_complex_inv" );
  ObjAttach( "int_complex_inv", interface.originhub );
  ObjSet( "int_complex_inv", { pos_z = pos_z } );

  private.state = "hidden";
  private.current_object = ""

end;
--******************************************************************************************
function public.Destroy()

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  if ( event_id == "show" ) then

    ObjSet( "int_complex_inv", { input = true } );
    private.state = "shown";

  elseif ( event_id == "hide" ) then

    ObjSet( "int_complex_inv", { active = false, visible = false } );
    ObjDetach( private.current_object );
    private.state = "hidden";

  end;

end;
--******************************************************************************************
function public.GetCurrentName()

  return private.current_object;

end;
--******************************************************************************************
function public.IsOnScreen()

  return private.state == "shown";

end;
--******************************************************************************************
function public.Show( inv_obj )

  if private.state == "hidden" then

    local event_id = "show";
    private.current_object = inv_obj;

    ObjSet( "int_complex_inv", { input = false, active = true, visible = true, alp = 0 } );
    ObjSet( private.current_object, { pos_x = 0, pos_y = 0 } );
    ObjAttach( private.current_object, "int_complex_inv_impl" );

    int_complex_inv_impl.ShowAnim( event_id );
    private.state = "showing";

  end;

end;
--******************************************************************************************
function public.Hide()

  if private.state == "shown" then
    
    ObjSet( "int_complex_inv", { input = false } );

    local event_id = "hide";
    int_complex_inv_impl.HideAnim( event_id );
    private.state = "hiding";

  end;

end;
--******************************************************************************************