--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "button_skip" );
  ObjAttach( "int_button_skip", interface.originhub );
  ObjSet( "int_button_skip", { pos_z = pos_z } );

  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  MsgSubscribe( Event_Level_CheatKeyPressed, private.HotKey );
  MsgSubscribe( Command_Interface_UpdateGameMode, private.UpdateGameMode );

  public.RELOAD_TIME_MIN  = 0.03;
  public.RELOAD_TIME_FULL =  nil;

  private.charging = false;
  private.event_anim_end = {};

  int_button_skip_impl.ChangeToStatic();

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  MsgUnsubscribe( Event_Level_CheatKeyPressed, private.HotKey );
  MsgUnsubscribe( Command_Interface_UpdateGameMode, private.UpdateGameMode );

end;
--******************************************************************************************
function public.Show()

  ObjSet( "int_button_skip", { active = true, visible = true } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_button_skip_impl.ShowAnim( event_id );

end;
--******************************************************************************************
function public.Hide()

  ObjSet( "int_button_skip", { input = false } );

  local event_id = "hide";
  private.event_anim_end[ event_id ] = {};
  int_button_skip_impl.HideAnim( event_id );

end;
--******************************************************************************************
function public.Reload( reload_time, reload_multiplier )

  private.reload_multiplier = reload_multiplier or 1;
  reload_time = reload_time * private.reload_multiplier;
  private.charging = false;
  local time_full   = ConfigGetSkipTime( interface.GetGameModeDesc(), 60 );
  
  local time_remain = 0;

  if time_full > 0 and time_full > 0 then
    time_remain = math.floor(reload_time * time_full);  
  end;

  if ng_global.gamemode == 3 and ng_global.custom_gamemode.use_skip == 1 then
    time_full = ng_global.custom_gamemode.skip_time;
    time_remain = time_full;
  end;

  if time_remain > 0 then 

    private.is_reloading = true;
    private.charging = true;

    local event_id = "reload";
    private.event_anim_end[ event_id ] = {};

    ObjSet( "tmr_int_button_skip_reload",
    { 
      endtrig = function () public.EventAnimEnd( event_id ); end,
      time    = time_remain,
      playing = true
    } );

    local from_begin = false;

    if ( time_remain == time_full ) then

      private.RELOAD_BEGIN_ANIM_TIME = private.RELOAD_BEGIN_ANIM_TIME or 0;
      local time_full_new = time_full - private.RELOAD_BEGIN_ANIM_TIME;

      if ( time_full_new < 0 ) then
        time_full_new = public.RELOAD_TIME_MIN;
      end;

      time_full  = time_full_new;
      from_begin = true;

    end;

    public.RELOAD_TIME_FULL = time_full;
    int_button_skip_impl.ChangeToReload( from_begin );

  else

    private.charging = false;
    int_button_skip_impl.ChangeToStatic();

  end;

end;
--******************************************************************************************
function private.UpdateGameMode( msg, params )

  int_button_skip_impl.SetHardcore( params.mode > 2 );

  --[[

    interface.button_skip.is_hardcore = true;

    ObjSet( "obj_int_button_skip_done", { active = false, visible = false } );

    if ( not private.is_reloading ) then

      ObjSet( "obj_int_button_skip_proc", { active = false } );

    end;

    ObjSet( "obj_int_button_skip_proc", { visible = false } );

    ObjSet( "obj_int_button_skip_lock", { active = true, visible = true } );

    else

    interface.button_skip.is_hardcore = false;

    if ( not private.is_reloading ) then

      ObjSet( "obj_int_button_skip_done", { active = true, visible = true } );
      ObjSet( "obj_int_button_skip_proc", { active = false, visible = false } );
      ObjSet( "obj_int_button_skip_lock", { active = false, visible = false } );

      interface.button_skip.DoneAnim();

    else

      ObjSet( "obj_int_button_skip_done", { active = false, visible = false } );
      ObjSet( "obj_int_button_skip_proc", { active = true, visible = true } );
      ObjSet( "obj_int_button_skip_lock", { active = false, visible = false } );

    end;

    end;
  ]]

end;
--******************************************************************************************
function public.MouseDown()

  MsgSend( Event_ButtonSkip_Click, { skip_ready = not private.charging } );

end;
--******************************************************************************************
function public.GetTimeFull()

  return public.RELOAD_TIME_FULL;

end;
--******************************************************************************************
function public.GetTimeMin()

  return public.RELOAD_TIME_MIN;

end;
--******************************************************************************************
function public.GetTimeRemain()

  return ObjGet( "tmr_int_button_skip_reload" ).time;

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

  ObjSet( "int_button_skip", { input = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

  ObjSet( "int_button_skip", { active = false, visible = false } );

------------------------------------------------------------------------------------
  elseif ( event_id == "reload" ) then

  private.charging = false;

  int_button_skip_impl.ChangeToStatic();

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
function private.HotKey( msg, params )

  if params.key == 83 --[[S - key]] then    
    public.Reload(0);
  end;

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "button_skip" );

end;
--******************************************************************************************