--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "button_lock" );
  ObjAttach( "int_button_lock", "obj_int_inventory_lock" );
  ObjSet( "int_button_lock", { pos_z = pos_z } );
  private.event_anim_end = {};
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.MouseDown()

  MsgSend( Event_ButtonLock_Click, {} );

end;
--******************************************************************************************
function public.SetLock( lock )

  local event_id = "set_lock";
  private.event_anim_end[ event_id ] = { lock = lock };
  int_button_lock_impl.LockAnim( lock, event_id );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];
------------------------------------------------------------------------------------
  if ( event_id == "set_lock" ) then

  --

  end;

end;
--******************************************************************************************
function public.MouseEnter()

  interface.InventoryOpen();

end;
--******************************************************************************************
function public.MouseLeave()

  interface.InventoryClose();

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "button_lock" );

end;
--******************************************************************************************

