--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "button_info" );
  ObjAttach( "int_button_info", interface.originhub );
  ObjSet( "int_button_info", { pos_z = pos_z } );
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  private.event_anim_end = {};

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.Show()

  ObjSet( "int_button_info", { active = true, visible = true } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_button_info_impl.ShowAnim( event_id );

end;
--******************************************************************************************
function public.Hide()

  ObjSet( "int_button_info", { input = false } );

  local event_id = "hide";
  private.event_anim_end[ event_id ] = {};
  int_button_info_impl.HideAnim( event_id );

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

  ObjSet( "int_button_info", { input = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

  ObjSet( "int_button_info", { active = false, visible = false } );

------------------------------------------------------------------------------------
  end;
  
end;
--******************************************************************************************
function public.MouseDown()
    
  MsgSend( Event_ButtonInfo_Click, {} );
    
end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "button_info" );

end;
--******************************************************************************************