--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "button_hint" );
  ObjAttach( "int_button_hint", interface.originhub );
  ObjSet( "int_button_hint", { pos_z = pos_z } );

  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  MsgSubscribe( Event_Level_CheatKeyPressed, private.HotKey );
  MsgSubscribe( Command_Interface_UpdateGameMode, private.UpdateGameMode );

  private.RELOAD_TIME_MIN  = 0.03;
  private.RELOAD_TIME_FULL =  nil;

  private.charging = false;
  private.event_anim_end = {};

  int_button_hint_impl.ChangeToStatic();

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );
  MsgUnsubscribe( Event_Level_CheatKeyPressed, private.HotKey );
  MsgUnsubscribe( Command_Interface_UpdateGameMode, private.UpdateGameMode );

end;
--******************************************************************************************
function public.Show()

  ObjSet( "int_button_hint", { active = true, visible = true } );

  local event_id = "show";
  private.event_anim_end[ event_id ] = {};
  int_button_hint_impl.ShowAnim( event_id );

end;
--******************************************************************************************
function public.Hide()

  ObjSet( "int_button_hint", { input = false } );

  local event_id = "hide";
  private.event_anim_end[ event_id ] = {};
  int_button_hint_impl.HideAnim( event_id );

end;
--******************************************************************************************
function public.Reload( reload_time )

  private.charging = false;
  local time_full   = ConfigGetHintTime( interface.GetGameModeDesc(), 60 );
  
  local time_remain = 0;

  if time_full > 0 and time_full > 0 then
    time_remain = math.floor(reload_time * time_full);  
  end;

  if ng_global.gamemode == 3 and ng_global.custom_gamemode.use_hint == 1 then
    time_full = ng_global.custom_gamemode.hint_rechange;
    time_remain = time_full;
  end;

  if time_remain > 0 then 

    private.is_reloading = true;
    private.charging = true;

    local event_id = "reload";
    private.event_anim_end[ event_id ] = {};

    ObjSet( "tmr_int_button_hint_reload",
    { 
      endtrig = function () public.EventAnimEnd( event_id ); end,
      time    = time_remain,
      playing = true
    } );

    local from_begin = false;

    if ( time_remain == time_full ) then

      private.RELOAD_BEGIN_ANIM_TIME = private.RELOAD_BEGIN_ANIM_TIME or 0;
      local time_full_new = time_full - private.RELOAD_BEGIN_ANIM_TIME;

      if ( time_full_new < 0 ) then
        time_full_new = private.RELOAD_TIME_MIN;
      end;

      time_full  = time_full_new;
      from_begin = true;

    end;

    private.RELOAD_TIME_FULL = time_full;
    int_button_hint_impl.ChangeToReload( from_begin );

  else

    private.charging = false;
    int_button_hint_impl.ChangeToStatic();

  end;

end;
--******************************************************************************************
function public.GetTime()

  local tme_max = private.RELOAD_TIME_FULL;

  if ( tme_max ) then

    local tme_cur = public.GetTimeRemain();
    return tme_cur * ( 1 / tme_max );

  else

    return 0;

  end;

end;
--******************************************************************************************
function private.UpdateGameMode( msg, params )

  int_button_hint_impl.SetHardcore( params.mode > 2 );

  --[[

    interface.button_hinterface.is_hardcore = true;

    ObjSet( "obj_int_button_hint_done", { active = false, visible = false } );

    if ( not private.is_reloading ) then

      ObjSet( "obj_int_button_hint_proc", { active = false } );

    end;

    ObjSet( "obj_int_button_hint_proc", { visible = false } );

    ObjSet( "obj_int_button_hint_lock", { active = true, visible = true } );

    else

    interface.button_hinterface.is_hardcore = false;

    if ( not private.is_reloading ) then

      ObjSet( "obj_int_button_hint_done", { active = true, visible = true } );
      ObjSet( "obj_int_button_hint_proc", { active = false, visible = false } );
      ObjSet( "obj_int_button_hint_lock", { active = false, visible = false } );

      interface.button_hinterface.DoneAnim();

    else

      ObjSet( "obj_int_button_hint_done", { active = false, visible = false } );
      ObjSet( "obj_int_button_hint_proc", { active = true, visible = true } );
      ObjSet( "obj_int_button_hint_lock", { active = false, visible = false } );

    end;

    end;
  ]]

end;
--******************************************************************************************
function public.MouseDown()

  MsgSend( Event_ButtonHint_Click, { hint_state = not private.charging } );

end;
--******************************************************************************************
function public.GetTimeFull()

  return private.RELOAD_TIME_FULL;

end;
--******************************************************************************************
function public.GetTimeMin()

  return private.RELOAD_TIME_MIN;

end;
--******************************************************************************************
function public.GetTimeRemain()

  return ObjGet( "tmr_int_button_hint_reload" ).time;

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

  ObjSet( "int_button_hint", { input = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

  ObjSet( "int_button_hint", { active = false, visible = false } );

------------------------------------------------------------------------------------
  elseif ( event_id == "reload" ) then

  private.charging = false;

  int_button_hint_impl.ChangeToStatic();

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
function private.HotKey( msg, params )

  if params.key == 72 --[[H - key]] then    
    public.Reload(0);
  end;

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "button_hint" );

end;
--******************************************************************************************