--******************************************************************************************
function public.Init( pos_z )

  interface.LoadImplementation( "blackbartext" );
  ObjAttach( "int_blackbartext", interface.originhub );
  ObjSet( "int_blackbartext", { pos_z = pos_z } );
  private.event_anim_end = {};
  private.isalreadyshow = false;
  MsgSubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_Interface_UpdateTextures, private.WideScreenUpdate );

end;
--******************************************************************************************
function public.Show( text, extended )

  if not ( private.Hide( text, extended ) ) then

    private.Show( text, extended );

  end;

end;
--******************************************************************************************
function public.Hide()

  private.Hide();

end;
--******************************************************************************************
function public.MouseDown()

  public.Hide();

end;
--******************************************************************************************
function public.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( "int_blackbartext", { input = true } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    if ( event_params.text and event_params.extended ) then
      
      private.Show( event_params.text, event_params.extended );

    end;

  end;

end;
--******************************************************************************************
function private.Show( text, extended )

  private.isalreadyshow = true;

  ObjSet( "int_blackbartext", { input = false } );
  ObjSet( "txt_int_blackbartext", { text = text } );

  if ( int_blackbartext.ShowExtended ) then

    int_blackbartext.ShowExtended( bbt_text, extended );

  end;

  local event_id = "show";
  private.event_anim_end[ event_id ] = { text = text, extended = extended };
  int_blackbartext_impl.ShowAnim( event_id );

end;
------------------------------------------------------------------------------------
function private.Hide( text, extended )

  if ( private.isalreadyshow ) then

    if not ( text ) then

      private.isalreadyshow = false;

    end;

    ObjSet( "int_blackbartext", { input = false } );
    local event_id = "hide";
    private.event_anim_end[ event_id ] = { text = text, extended = extended };
    int_blackbartext_impl.HideAnim( event_id );

    return true;

  end;

end;
--******************************************************************************************
function private.WideScreenUpdate()

  interface.WideScreenUpdate( "blackbartext" );

end;
--******************************************************************************************