--******************************************************************************************
function public.Init()

  ModLoad( "assets/levels/menu/rm_achievements/mod_achievements" );
  rm_achievements.Init();

  interface_impl.PopupAchievementAdd();
  --interface.WidgetAdd( InterfaceWidget_Pause, 1800 );

  ObjSet("menu_but_play", 
  {
    event_mdown = private.PlayDown,
    event_menter = function () private.ButtonMouseEnter('play'); end,
    event_mleave = function () private.ButtonMouseLeave('play'); end
  });
  ObjSet("menu_but_options", 
  {
    event_mdown = private.OptionsDown,
    event_menter = function () private.ButtonMouseEnter('options'); end,
    event_mleave = function () private.ButtonMouseLeave('options'); end
  });
  ObjSet("menu_but_credits", 
  {
    event_mdown = private.CreditsDown,
    event_menter = function () private.ButtonMouseEnter('credits'); end,
    event_mleave = function () private.ButtonMouseLeave('credits'); end
  });
  ObjSet("menu_but_quit", 
  {
    event_mdown = private.QuitDown,
    event_menter = function () private.ButtonMouseEnter('quit'); end,
    event_mleave = function () private.ButtonMouseLeave('quit'); end
  });
  ObjSet("menu_but_extra", 
  {
    event_mdown = private.ExtraDown,
    event_menter = function () private.ButtonMouseEnter('extra'); end,
    event_mleave = function () private.ButtonMouseLeave('extra'); end
  });
  ObjSet("menu_but_ach", 
  {
    event_mdown = private.AchDown,
    event_menter = function () private.ButtonMouseEnter('ach'); end,
    event_mleave = function () private.ButtonMouseLeave('ach'); end
  });
  ObjSet("menu_but_strguide", 
  {
    event_mdown = private.StrguideDown,
    event_menter = function () private.ButtonMouseEnter('strguide'); end,
    event_mleave = function () private.ButtonMouseLeave('strguide'); end
  });
  ObjSet("menu_but_profile", 
  {
    event_mdown = private.ProfileDown,
    event_menter = function () private.ButtonMouseEnter('profile'); end,
    event_mleave = function () private.ButtonMouseLeave('profile'); end
  });
  ObjSet("menu_but_shop", 
  {
    event_mdown = private.ShopDown,
    event_menter = function () private.ButtonMouseEnter('shop'); end,
    event_mleave = function () private.ButtonMouseLeave('shop'); end
  });
  ObjSet("menu_but_help", 
  {
    event_mdown = private.HelpDown,
    event_menter = function () private.ButtonMouseEnter('help'); end,
    event_mleave = function () private.ButtonMouseLeave('help'); end
  });

end;
--******************************************************************************************
function public.PreOpen()
    
  ObjSet( "menu_ce_buttons",  { active = false, visible = false, input = false } );

  if ( IsCollectorsEdition() == 1 ) then
    ObjSet( "menu_ce_buttons", { active = true, visible = true, input = true } );
  else
    ObjSet( "menu_ce_buttons", { active = false, visible = false, input = false } );
  end;

  public.SetProfileText( GetCurrentProfile() );
  public.ButtonSetPos();

  private.StartAnimMenuView();
  
end;
--******************************************************************************************
function public.Open()

  --ShowBlur("spr_menu_blur","rm_menu");

  cmn.StopAllEnv("assets/levels/common/audio/aud_main_menu_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_main_menu_env");

  if rm_achievements.in_rm_acievements then
    rm_achievements.in_rm_acievements = false;
  else
    cmn.PlayAudio( "mus", "assets/levels/common/audio/aud_surface7_mainstreet_mus", 1 );
  end;

end;
--******************************************************************************************
function public.SetProfileText ( name )
  
  local obj = "txt_menu_but_profile";
  local profile_name = "";
  if  ( name ~= "ng_noprofiles" )
  and ( name ~= "ng_error" )
  then
  profile_name = name;
  end;
  ObjSet( obj, { text = profile_name } );

end;
--******************************************************************************************
function private.PlayDown()
  common.MenuPlay();
end;
--******************************************************************************************
function private.OptionsDown()
  common.MenuOptions();
end;
--******************************************************************************************
function private.CreditsDown()
  common.MenuCredits();
end;
--******************************************************************************************
function private.QuitDown()
  common.MenuQuit();  
end;
--******************************************************************************************
function private.ExtraDown()
  common.MenuExtra();
end;
--******************************************************************************************
function private.AchDown()
  common.MenuAchievements();
end;
--******************************************************************************************
function private.StrguideDown()
  interface.StrategyGuideShow();
end;
--******************************************************************************************
function private.ProfileDown()
  common.MenuProfile();
end;
--******************************************************************************************
function private.ShopDown()
  common.MenuShop();
end;
--******************************************************************************************
function private.HelpDown()
  common.DialogWindowShow("help", nil, true);
end;
--******************************************************************************************
function private.ButtonMouseEnter ( but_name )
  SetCursor( CURSOR_HAND );
  local obj = "spr_menu_but_"..but_name.."_focus";
  local alp = ObjGet( obj ).alp;
  ObjAnimate( obj, "alp", 0, 0, "", { 0, 0, alp, ( common_impl.animtime * ( 1 - alp ) ), 0, 1 } );
  --cmn.PlayAudio( "sfx", "common/audio/aud_menter_sfx" );
end;
--******************************************************************************************
function private.ButtonMouseLeave ( but_name )
  SetCursor( CURSOR_DEFAULT );
  local obj = "spr_menu_but_"..but_name.."_focus";
  local alp = ObjGet( obj ).alp;
  ObjAnimate( obj, "alp", 0, 0, "", { 0, 0, alp, ( common_impl.animtime * alp ), 0, 0 } );
end;
--******************************************************************************************
function public.ButtonSetPos()
  local offwidth = 0.5 * ( GetAppWidth() - 1024 );
  ObjSet( "menu_objects_left",  { pos_x = ( 512 - offwidth ) } );
  ObjSet( "menu_objects_right", { pos_x = ( 512 + offwidth ) } );
end;
--******************************************************************************************
  --------------------------------------------------------------------
--*********************************************************************************************************************
--***function *** Prolax *** () end ************************************************************************************
--*********************************************************************************************************************
  --------------------------------------------------------------------
  private.del_plan = { {70, 30}, {30, 10}, {10, 5}, {20, 8} }; --[4] - fog
  --------------------------------------------------------------------
  function private.StartAnimMenuView()

    local cur_x = GetGameCursorPos()[1];
    local cur_y = GetGameCursorPos()[2];

    local del_x = 512 - cur_x;
    local del_y = 384 - cur_y;

    local move_x = (del_x/683);
    local move_y = (del_y/384);

    local new_x = 0;
    local new_y = 0;

    for i = 1, 4, 1 do

      new_x = math.floor(move_x * private.del_plan[i][1]);
      new_y = math.floor(move_y * private.del_plan[i][2]);

      ObjSet("obj_menu_plan_"..i,  { pos_x = new_x,  pos_y = new_y });

    end;

    ObjSet("tmr_menu_timer",  { time = 0.01, playing = 1, endtrig = private.AnimMenuView });

  end;
  --------------------------------------------------------------------
  function private.AnimMenuView()

    local cur_x = GetGameCursorPos()[1];
    local cur_y = GetGameCursorPos()[2];

    local del_x = 512 - cur_x;
    local del_y = 384 - cur_y;

    local move_x = (del_x/683);
    local move_y = (del_y/384);

    local new_x = 0;
    local new_y = 0;

    local old_x = 0;
    local old_y = 0;

    for i = 1, 4, 1 do

      new_x = math.floor(move_x * private.del_plan[i][1]);
      new_y = math.floor(move_y * private.del_plan[i][2]);

      if ( ObjGet("obj_menu_plan_"..i) ) then
        old_x = ObjGet("obj_menu_plan_"..i).pos_x;
        old_y = ObjGet("obj_menu_plan_"..i).pos_y;
      end;

      ObjStopAnimate("obj_menu_plan_"..i, "pos_xy");
      ObjAnimate("obj_menu_plan_"..i, "pos_xy", 0, 0, "", { 0, 0, old_x, old_y,   0.1, 0, new_x, new_y });

      --ObjSet("obj_menu_plan_"..i,  { pos_x = new_x,  pos_y = new_y });

    end;

    ObjSet("tmr_menu_timer",  { time = 0.01, playing = 1, endtrig = private.AnimMenuView });

  end;
--******************************************************************************************
