--******************************************************************************************
-- для добавления нового лого достаточно добавить его название в массив private.logo
--******************************************************************************************
private.logo = {"bigfish", "elephantgames"};
private.counter = 0;
private.objLogo = "spr_intro_logo";
--******************************************************************************************
function public.Init()

  room.Define( "rm_intro" );
  ObjSet(private.objLogo, {
    input = false,
    event_mdown = private.IntroLogoHide
  });
  private.UpdateLogoToNextRes();

end;
--******************************************************************************************
function public.Open()

  private.counter = 1;
  private.IntroLogoShow();

end;
--******************************************************************************************
function private.UpdateLogoToNextRes()

  private.counter = private.counter + 1;
  ObjSet(private.objLogo, {
    res = "assets/levels/menu/rm_intro/logo_"..private.logo[ private.counter ]
  });

end;
--******************************************************************************************
function private.IntroLogoShow()

  ObjAnimate( private.objLogo, "alp", 0, 0 ,private.IntroLogoActivate, { 0,0,0, 0.8,0,1 } );

end;
--******************************************************************************************
function private.IntroLogoActivate()

  ObjSet( private.objLogo, { input = true } );
  ObjStopAnimate( private.objLogo, "alp" );
  ObjAnimate( private.objLogo, "alp", 0, 0, private.IntroLogoHide, { 0,0,1, 3,0,1 } );

end;
--******************************************************************************************
function private.IntroLogoHide()

  local trg = function () 
    private.UpdateLogoToNextRes();
    private.IntroLogoShow(); 
  end;
  if private.counter == #private.logo then
    trg = private.IntroVideoPlay;
  end;
  ObjSet( private.objLogo, { input = false } );
  ObjStopAnimate( private.objLogo, "alp" );
  ObjAnimate( private.objLogo, "alp",0 ,0, trg, { 0,0,1, 0.8,0,0 } );

end;
--******************************************************************************************
function private.IntroVideoPlay()

  interface.DialogVideoShow( "obj_intro_video", 1, private.IntroVideoEnd );
  VidPlay( "vid_intro_video", private.IntroVideoEnd );

  cmn.PlayAudio( "vid_mus", "assets/levels/menu/rm_intro/audio/aud_preintro_mus" );
  cmn.PlayAudio( "voc", "assets/levels/menu/rm_intro/audio/aud_preintro_voc" );

end;
--******************************************************************************************
function private.IntroVideoEnd()

  interface.DialogVideoHide();
  ObjAttach( "tmr_intro_videoend", "cmn_timers" );

  SndStop( "assets/levels/menu/rm_intro/audio/aud_preintro_mus", 0.5 );
  SndStop( "assets/levels/menu/rm_intro/audio/aud_preintro_voc", 0.5 );

  local funcVideoEnd = function () 
    cmn.GotoRoom('rm_menu'); 
    ObjDelete('tmr_intro_videoend'); 
  end; 
  ObjSet( "tmr_intro_videoend", 
  { 
    endtrig = funcVideoEnd, 
    time = 0.6, 
    playing = true
  } );

end;
--******************************************************************************************