--******************************************************************************************
function public.Init()

  game.rm_achievements_array = {
    "one_ho_without_hint",
    "three_ho_without_hint",
    "five_ho_without_hint",
    "ten_ho_without_hint",
    "all_ho_without_hint",

    "three_ho_three_min",
    "five_ho_three_min",
    "ten_ho_three_min",

    "three_item_ho",
    "five_item_ho",
    "ten_item_ho",

    "one_ho_less_one_min",
    "one_ho_more_ten_min",

    "one_mg_without_skip",
    "three_mg_without_skip",
    "seven_mg_without_skip",
    "fifteen_mg_without_skip",
    "all_mg_without_skip",

    "one_mg_less_one_min",

    "collect_1_flower",
    "collect_5_flowers",
    "collect_15_flowers",
    "collect_30_flowers",
    "collect_100_flowers",
    "collect_200_flowers",
    "collector"
    };


  game.rm_acievements_state = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
  };


  private.achievements = {};
  public.in_rm_acievements = false;

end;
--******************************************************************************************
function public.PreOpen()

  public.in_rm_acievements = true;

  cmn.StopAllEnv();
  cmn.PlayAudio( "env", "assets/levels/common/audio/aud_achivements_env" );
  -------------------------------------------------------------------------
  if  ( not cmn.is_inmenunow ) then

    interface.WidgetSetInput( InterfaceWidget_Achiev, 0 );

    interface.WidgetSetInput( InterfaceWidget_Inventory, 0 );
    interface.WidgetSetInput( InterfaceWidget_BtnHint,   0 );
    interface.WidgetSetInput( InterfaceWidget_BtnGuide,  0 );
    interface.WidgetSetInput( InterfaceWidget_BtnMap,    0 );
    interface.WidgetSetInput( InterfaceWidget_BtnMenu,   0 );

    interface.WidgetSetVisible( InterfaceWidget_Inventory, 0, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnHint,   0, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnGuide,  0, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnMap,    0, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnMenu,   0, 0 );

    ObjSet( "int_inventory",        { input = 0, alp = 0 } );
    --ObjSet( "int_button_hint",      { input = 0, alp = 0 } );
    --ObjSet( "obj_int_button_guide", { input = 0, alp = 0 } );
    --ObjSet( "int_button_map",       { input = 0, alp = 0 } );
    --ObjSet( "int_button_menu",      { input = 0, alp = 0 } );

  end;

  game.rm_acievements_state = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
  };

  local local_arr = game.rm_achievements_array;

  for i = 1, #local_arr, 1 do
        ObjStopAnimate("spr_achievements_"..i.."_out", 8);
        ObjSet("spr_achievements_"..i, {alp = 0});
        ObjSet("spr_achievements_"..i.."_out",{alp = 0});
  end;
  -------------------------------------------------------------------------
  private.DrawRoom();

end;
--******************************************************************************************
function public.PreClose()

  interface_impl.PopupAchievementHide();

  if  ( not cmn.is_inmenunow ) then

    --cmn.StopAllMus();

    interface.WidgetSetInput( InterfaceWidget_Achiev,    1 );

    interface.WidgetSetInput( InterfaceWidget_Inventory, 1 );
    interface.WidgetSetInput( InterfaceWidget_BtnHint,   1 );
    interface.WidgetSetInput( InterfaceWidget_BtnGuide,  1 );
    interface.WidgetSetInput( InterfaceWidget_BtnMap,    1 );
    interface.WidgetSetInput( InterfaceWidget_BtnMenu,   1 );

    interface.WidgetSetVisible( InterfaceWidget_Inventory, 1, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnHint,   1, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnGuide,  1, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnMap,    1, 0 );
    interface.WidgetSetVisible( InterfaceWidget_BtnMenu,   1, 0 );

    ObjSet("int_inventory", {input = 1, alp = 1});
    --ObjSet("int_button_hint", {input = 1, alp = 1});
    --ObjSet("obj_int_button_guide", {alp = 1, input = 1});
    --ObjSet("int_button_map", {input = 1, alp = 1});
    --ObjSet("int_button_menu", {input = 1, alp = 1});

  end;

end;
--******************************************************************************************
function public.Close()

  common_impl.go_acievements = false;

  --костыль - чтобы снимался блок в комнате из который мы вошли в ачивки при открытом сложном предмете
  if  ( not cmn.is_inmenunow ) then

    cmn.Lock( 0 );

  end;

end;
--******************************************************************************************
-------------------------------------------------------------------------
--выход из комнат ачивок
function public.Exit()

  if cmn.is_inmenunow then
    --room.Switch("rm_extra");
    room.Switch("rm_menu");
  else
    public.in_rm_acievements = false;
    room.Switch(common.GetCurrentRoom());
  end;

end;

-------------------------------------------------------------------------
--вывод попапа и подсветка места ачивки
function public.AreaEnter( num, num1 )   --num-номер ачивки в списке, num1-состояние курсора мыши (1-в области, 0-вне области)

  local param = game.rm_achievements_array[num];

  if num1 == 1 then

    local loc_table = { { str_1 = "ce_ach_"..param, str_2 = "ce_ach_"..param.."_text", color_r_1 = 1, color_g_1 = 1, color_b_1 = 1, color_r_2 = 1, color_g_2 = 1, color_b_2 = 1 } };

    interface_impl.PopupAchievementShow( loc_table );

  else
    interface_impl.PopupAchievementHide();
  end;

  if game.rm_acievements_state[num] == 0 then
    ObjAnimate("spr_achievements_"..num.."_out", "alp", 0, 0, "", {0, 0, ObjGet("spr_achievements_"..num.."_out").alp,   1.2, 0, num1 * 0.5});
  end;

end;

------------------------------------------------------------------------------------
function public.MouseEnterBack()

  local alp = ObjGet( "spr_achievements_exit_focus" ).alp;
  ObjAnimate( "spr_achievements_exit_focus", 8,0,0, "", {0,0,alp, 0.3,0,1});
  SetCursor(CURSOR_HAND);

end;

function public.MouseLeaveBack()

  local alp = ObjGet( "spr_achievements_exit_focus" ).alp;
  ObjAnimate( "spr_achievements_exit_focus", 8,0,0, "", {0,0,alp, 0.3,0,0});
  SetCursor(CURSOR_DEFAULT);

end;

-------------------------------------------------------------------------
--отрисовка комнаты
--второй столбец в массиве ачивок здесь используется для определения первый раз мы видим ачивку или нет
function private.DrawRoom()

  ObjSet("obj_achievements_1", { alp = 1, input = 1 });
  ObjSet("obj_achievements_2", { alp = 0, input = 0 });
  ObjSet("obj_achievements_3", { alp = 0, input = 0 });
  ObjSet("obj_achievements_4", { alp = 0, input = 0 });
  ObjSet("obj_achievements_5", { alp = 0, input = 0 });

--  ObjSet("obj_achievements_9",  { alp = 1, input = 1 });
--  ObjSet("obj_achievements_10", { alp = 0, input = 0 });
--  ObjSet("obj_achievements_11", { alp = 0, input = 0 });
--
--  ObjSet("obj_achievements_6", { alp = 1, input = 1 });
--  ObjSet("obj_achievements_7", { alp = 0, input = 0 });
--  ObjSet("obj_achievements_8", { alp = 0, input = 0 });
--
--  ObjSet("obj_achievements_20", { alp = 1, input = 1 });
--  ObjSet("obj_achievements_22", { alp = 0, input = 0 });
--  ObjSet("obj_achievements_25", { alp = 0, input = 0 });
--
--  ObjSet("obj_achievements_21", { alp = 1, input = 1 });
--  ObjSet("obj_achievements_23", { alp = 0, input = 0 });
--  ObjSet("obj_achievements_24", { alp = 0, input = 0 });

  local local_arr = game.rm_achievements_array;
  local state = 0;

  for i = 1, #local_arr, 1 do

    if ng_global.achiev[""..local_arr[i]..""][1] >= ng_global.achiev[""..local_arr[i]..""][3] then

      if ng_global.achiev[""..local_arr[i]..""][2] == 0 then

        ng_global.achiev[""..local_arr[i]..""][2] = 1;
        ObjSet("fx_achievements_"..i, {active = 1, alp = 1});
        PartSysStart("fx_achievements_"..i);

      end;

      game.rm_acievements_state[i] = 1;

      if ( i == 2 ) then
        ObjSet("obj_achievements_1", { alp = 0, input = 0 });
        ObjSet("obj_achievements_2", { alp = 1, input = 1 });
        ObjSet("obj_achievements_3", { alp = 0, input = 0 });
        ObjSet("obj_achievements_4", { alp = 0, input = 0 });
        ObjSet("obj_achievements_5", { alp = 0, input = 0 });
      end;

      if ( i == 3 ) then
        ObjSet("obj_achievements_1", { alp = 0, input = 0 });
        ObjSet("obj_achievements_2", { alp = 0, input = 0 });
        ObjSet("obj_achievements_3", { alp = 1, input = 1 });
        ObjSet("obj_achievements_4", { alp = 0, input = 0 });
        ObjSet("obj_achievements_5", { alp = 0, input = 0 });
      end;

      if ( i == 4 ) then
        ObjSet("obj_achievements_1", { alp = 0, input = 0 });
        ObjSet("obj_achievements_2", { alp = 0, input = 0 });
        ObjSet("obj_achievements_3", { alp = 0, input = 0 });
        ObjSet("obj_achievements_4", { alp = 1, input = 1 });
        ObjSet("obj_achievements_5", { alp = 0, input = 0 });
      end;

      if ( i == 5 ) then
        ObjSet("obj_achievements_1", { alp = 0, input = 0 });
        ObjSet("obj_achievements_2", { alp = 0, input = 0 });
        ObjSet("obj_achievements_3", { alp = 0, input = 0 });
        ObjSet("obj_achievements_4", { alp = 0, input = 0 });
        ObjSet("obj_achievements_5", { alp = 1, input = 1 });
      end;

--      if ( i == 7 ) then
--        ObjSet("obj_achievements_6", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_7", { alp = 1, input = 1 });
--        ObjSet("obj_achievements_8", { alp = 0, input = 0 });
--      end;
--
--      if ( i == 8 ) then
--        ObjSet("obj_achievements_6", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_7", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_8", { alp = 1, input = 1 });
--      end;
--
--      if ( i == 10 ) then
--        ObjSet("obj_achievements_9",  { alp = 0, input = 0 });
--        ObjSet("obj_achievements_10", { alp = 1, input = 1 });
--        ObjSet("obj_achievements_11", { alp = 0, input = 0 });
--      end;
--
--      if ( i == 11 ) then
--        ObjSet("obj_achievements_9",  { alp = 0, input = 0 });
--        ObjSet("obj_achievements_10", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_11", { alp = 1, input = 1 });
--      end;
--
--      if ( i == 22 ) then
--        ObjSet("obj_achievements_20", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_22", { alp = 1, input = 1 });
--        ObjSet("obj_achievements_25", { alp = 0, input = 0 });
--      end;
--
--      if ( i == 25 ) then
--        ObjSet("obj_achievements_20", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_22", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_25", { alp = 1, input = 1 });
--      end;
--
--      if ( i == 23 ) then
--        ObjSet("obj_achievements_21", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_23", { alp = 1, input = 1 });
--        ObjSet("obj_achievements_24", { alp = 0, input = 0 });
--      end;
--
--      if ( i == 24 ) then
--        ObjSet("obj_achievements_21", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_23", { alp = 0, input = 0 });
--        ObjSet("obj_achievements_24", { alp = 1, input = 1 });
--      end;

      ObjSet("spr_achievements_"..i, {alp = 1});

    end;

  end;

end;
--******************************************************************************************