--*********************************************************************************************************************
function public.Init()
  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_street";
  --------------------------------------------------------------------------------------------
  ObjAttach( "zz_policecar", "room_hub" );
  ObjAttach( "zz_neighborcar", "room_hub" );
  ObjAttach( "zz_pole", "room_hub" );
  ObjAttach( "zz_mailbox", "room_hub" );

  private.Init_Subroom();
  private.Init_Pole();
  private.Init_Incidecar();
 
  --------------------------------------------------------------------------------------------
  -- function get_screwdriver () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_screwdriver" ] = {
      type = "get",
      get_obj = "spr_mailbox_screwdriver",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  local get_screwdriver_inv = function ()
  
    interface.InventoryItemAdd( "inv_screwdriver", "spr_mailbox_screwdriver" );
  
  end;
  
  local get_screwdriver_closezz = function ()
  
    ObjDelete( "spr_street_screwdriwer" );
    ObjDelete( "gzz_street_mailbox" );
  
  end;
  
  cmn.AddSubscriber( "get_screwdriver", get_screwdriver_inv );
  cmn.AddSubscriber( "get_screwdriver", get_screwdriver_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_policekeys () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_policekeys" ] = {
      type = "get",
      get_obj = "spr_pole_policekeys",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  local get_policekeys_inv = function ()
  
    interface.InventoryItemAdd( "inv_policekeys", "spr_pole_policekeys" );
  
  end;
  
  local get_policekeys_closezz = function ()
  
    --ObjDelete( "gfx_pole_policekeys" );
    --ObjDelete( "gzz_street_pole" );
  
  end;
  
  cmn.AddSubscriber( "get_policekeys", get_policekeys_inv );
  cmn.AddSubscriber( "get_policekeys", get_policekeys_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_stairs () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_stairs" ] = {
      type = "get",
      get_obj = "spr_pole_stairs",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  local get_stairs_inv = function ()
  
    interface.InventoryItemAdd( "inv_stairs", "spr_pole_stairs" );

    int_map_impl.DecreaseRoomTasks("rm_street");
  
  end;
  
  local get_stairs_closezz = function ()
  
    ObjDelete( "gfx_pole_stairs" );

    ObjDelete( "spr_street_ladder" );
    ObjDelete( "gzz_street_pole" );
  
  end;
  
  cmn.AddSubscriber( "get_stairs", get_stairs_inv );
  cmn.AddSubscriber( "get_stairs", get_stairs_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_letter5 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_letter5" ] = {
      type = "get",
      get_obj = "spr_mailbox_letter5",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  local get_letter5_inv = function ()

    interface.InventoryItemAdd( "inv_letter", "spr_mailbox_letter5", function () cmn.GetMultyObject( 'letter', 5 ); end );
  
  end;
  
  local get_letter5_closezz = function ()
  
    --if cmn.IsEventDone("get_parcel") and cmn.IsEventDone("get_photo1") then
    --  ObjDelete( "gzz_street_mailbox" );
    --end;
  
  end;
  
  cmn.AddSubscriber( "get_letter5", get_letter5_inv );
  cmn.AddSubscriber( "get_letter5", get_letter5_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_photo1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_photo1" ] = {
      type = "get",
      get_obj = "spr_mailbox_parcel",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  local get_photo1_inv = function ()
  
    interface.InventoryItemAdd( "inv_photo1", "spr_mailbox_photo1" );
  
  end;
  
  local get_photo1_closezz = function ()

    ObjDelete("anm_mailbox_use_camera");
  
    --if cmn.IsEventDone("get_parcel") and cmn.IsEventDone("get_letter5") then
    --  ObjDelete( "gzz_street_mailbox" );
    --end;
  
  end;
  
  cmn.AddSubscriber( "get_photo1", get_photo1_inv );
  cmn.AddSubscriber( "get_photo1", get_photo1_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_parcel () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_parcel" ] = {
      type = "get",
      get_obj = "spr_mailbox_parcel",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  local get_parcel_inv = function ()
  
    common_impl.InventoryComplexItemAdd( "inv_parcel", "spr_mailbox_parcel" );

    ObjSet("inv_parcel_star_light",  { alp = 1 });
  
  end;
  
  local get_parcel_closezz = function ()

    ObjDelete("spr_mailbox_box_sh");
    ObjDelete("spr_street_parcel");
    ObjDelete("spr_mailbox_note_2");

    ObjSet("spr_mailbox_screwdriver", {input = true});
  
  --  if cmn.IsEventDone("get_letter5") and cmn.IsEventDone("get_photo1") then
  --    ObjDelete( "gzz_street_mailbox" );
  --  end;
  --
  end;
  
  cmn.AddSubscriber( "get_parcel", get_parcel_inv );
  cmn.AddSubscriber( "get_parcel", get_parcel_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_bow2 () end;
  --------------------------------------------------------------------------------------------
  local get_bow2 = function ()
  
    common_impl.InventoryComplexItemAdd( "inv_bow2", "spr_pole_bow2" );
  
  end;
  
  cmn.AddSubscriber( "get_bow2", get_bow2 );
  --------------------------------------------------------------------------------------------
  -- function get_dog () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_dog" ] = {
      type = "get",
      get_obj = "obj_neighborcar_get_dog",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  local get_dog_inv = function ()
  
    interface.InventoryItemAdd( "inv_dog", "obj_neighborcar_get_dog" );
  
  end;
  
  local get_dog_closezz = function ()

    ObjDelete("vid_neighborcar_dog_jump");
    ObjDelete("obj_neighborcar_click_on_dog");
    ObjDelete("anm_neighborcar_dog_click");

  end;
  
  cmn.AddSubscriber( "get_dog", get_dog_inv );
  cmn.AddSubscriber( "get_dog", get_dog_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_net () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_net" ] = {
      type = "get",
      get_obj = "obj_neighborcar_net_get",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  local get_net_inv = function ()
  
    interface.InventoryItemAdd( "inv_net", "spr_neighborcar_net" );
  
  end;
  
  local get_net_closezz = function ()

    ObjDelete("spr_neighborcar_net_sh");
    ObjDelete("spr_street_scoopnet");
    ObjDelete("obj_neighborcar_net_get");

  end;
  
  cmn.AddSubscriber( "get_net", get_net_inv );
  cmn.AddSubscriber( "get_net", get_net_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_hankline () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_hankline" ] = {
      type = "get",
      get_obj = "spr_neighborcar_hankline",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  local get_hankline_inv = function ()
  
    interface.InventoryItemAdd( "inv_hankline", "spr_neighborcar_hankline" );
  
  end;
  
  local get_hankline_closezz = function ()

    ObjDelete("spr_neighborcar_hankline_sh");

  end;
  
  cmn.AddSubscriber( "get_hankline", get_hankline_inv );
  cmn.AddSubscriber( "get_hankline", get_hankline_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_gascanisters () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_gascanisters" ] = {
      type = "get",
      get_obj = "spr_neighborcar_gascanisters",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  local get_gascanisters_inv = function ()
  
    interface.InventoryItemAdd( "inv_gascanisters", "obj_neighborcar_get_gascanisters" );
  
  end;
  
  local get_gascanisters_closezz = function ()

    ObjDelete("gzz_street_neighborcar");

  end;
  
  cmn.AddSubscriber( "get_gascanisters", get_gascanisters_inv );
  cmn.AddSubscriber( "get_gascanisters", get_gascanisters_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_policekeys () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_policekeys" ] = {

      type = "use",
      inv_obj = "inv_policekeys",
      use_place = "obj_policecar_use_policekeys",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  local use_policekeys_inv = function ()
  
    interface.InventoryItemRemove( "inv_policekeys" );
  
  end;
  local use_policekeys_beg = function ()
  
    ObjDelete( "obj_policecar_use_policekeys" );
  
  end;
  local use_policekeys_end = function ()

     ObjSet("gzz_street_policecar", {event_mdown = private.dlg_insidecar.open});  
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_policekeys", use_policekeys_beg, private.room_objname );
  cmn.AddSubscriber( "use_policekeys", use_policekeys_inv );
  cmn.AddSubscriber( "use_policekeys", use_policekeys_end, private.room_objname );
  cmn.AddSubscriber( "use_policekeys_inv", use_policekeys_inv, private.room_objname );
  cmn.AddSubscriber( "use_policekeys_beg", use_policekeys_beg, private.room_objname );
  cmn.AddSubscriber( "use_policekeys_end", use_policekeys_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_bowstring1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_bowstring1" ] = {

      type = "use",
      inv_obj = "inv_bowstring1",
      use_place = "obj_pole_use_bowstring1",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  local use_bowstring1_inv = function ()
  
    interface.InventoryItemRemove( "inv_bowstring1" );
  
  end;
  local use_bowstring1_beg = function ()
  
    ObjDelete( "obj_pole_use_bowstring1" );
    ObjDelete("anm_pole_crow_touch");
  
  end;
  local use_bowstring1_end = function ()
  
     ObjSet( "obj_pole_mmg", { input = 1, alp = 1 } );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_bowstring1", use_bowstring1_beg, private.room_objname );
  cmn.AddSubscriber( "use_bowstring1", use_bowstring1_inv );
  cmn.AddSubscriber( "use_bowstring1", use_bowstring1_end, private.room_objname );
  cmn.AddSubscriber( "use_bowstring1_inv", use_bowstring1_inv, private.room_objname );
  cmn.AddSubscriber( "use_bowstring1_beg", use_bowstring1_beg, private.room_objname );
  cmn.AddSubscriber( "use_bowstring1_end", use_bowstring1_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_camera () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_camera" ] = {

      type = "use",
      inv_obj = "inv_camera",
      use_place = "obj_mailbox_use_camera",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_camerabarcounter" ] = {

      type = "use",
      inv_obj = "inv_camera",
      use_place = "obj_barcounter_use_camera",
      room = "rm_cafe",
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_cameramotorbike" ] = {

      type = "use",
      inv_obj = "inv_camera",
      use_place = "obj_policemotorbike_use_camera",
      room = "rm_parking",
      zz = "zz_policemotorbike",
      zz_gate = "gzz_parking_policemotorbike"
  };
  --------------------------------------------------------------------------------------------
  local use_camera_inv = function ()
  
    --interface.InventoryItemRemove( "inv_camera" );
  
  end;
  local use_camera_beg = function ()
  
    ObjDelete( "obj_mailbox_use_camera" );
  
  end;
  local use_camera_end = function ()

    ObjDelete( "anm_mailbox_use_camera" );
 
    ObjSet( "spr_mailbox_photo1", { input = true, alp = 1 } );
  
  end;

  local use_camera_beg2 = function ()
  
    ObjDelete( "obj_barcounter_use_camera" );
  
  end;
  local use_camera_end2 = function ()
  
    ObjSet( "spr_barcounter_codesafe", { input = true, alp = 1 } );

    ObjDelete( "anm_barcounter_use_camera" );
  
  end;

  local use_camera_beg3 = function ()
  
    ObjDelete( "obj_policemotorbike_use_camera" );
  
  end;
  local use_camera_end3 = function ()

    ObjDelete( "anm_policemotorbike_use_camera" );
  
    ObjSet( "spr_policemotorbike_photo3", { input = true, alp = 1 } );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_camera", use_camera_beg, private.room_objname );
  cmn.AddSubscriber( "use_camera", use_camera_inv );
  cmn.AddSubscriber( "use_camera", use_camera_end, private.room_objname );
  cmn.AddSubscriber( "use_camera_inv", use_camera_inv, private.room_objname );
  cmn.AddSubscriber( "use_camera_beg", use_camera_beg, private.room_objname );
  cmn.AddSubscriber( "use_camera_end", use_camera_end, private.room_objname );

  cmn.AddSubscriber( "use_camerabarcounter", use_camera_beg2, "rm_cafe" );
  cmn.AddSubscriber( "use_camerabarcounter", use_camera_end2, "rm_cafe" );
  cmn.AddSubscriber( "use_camera_beg2", use_camera_beg2, "rm_cafe" );
  cmn.AddSubscriber( "use_camera_end2", use_camera_end2, "rm_cafe" );

  cmn.AddSubscriber( "use_cameramotorbike", use_camera_beg3, "rm_parking" );
  cmn.AddSubscriber( "use_cameramotorbike", use_camera_end3, "rm_parking" );
  cmn.AddSubscriber( "use_camera_beg3", use_camera_beg3, "rm_parking" );
  cmn.AddSubscriber( "use_camera_end3", use_camera_end3, "rm_parking" );
  --------------------------------------------------------------------------------------------
  -- function use_flag () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_flag" ] = {

      type = "use",
      inv_obj = "inv_flag",
      use_place = "obj_mailbox_use_flag",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  local use_flag_inv = function ()
  
    interface.InventoryItemRemove( "inv_flag" );
  
  end;
  local use_flag_beg = function ()
  
    ObjDelete( "obj_mailbox_use_flag" );
  
  end;
  local use_flag_end = function ()
  
    ObjMultiSet({
                  {"spr_mailbox_flag_on",{alp = 1}},
                  {"spr_street_flag_up",{alp = 1}},
                  {"obj_mailbox_clickondrawer",{input = 1}}
                });
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_flag", use_flag_beg, private.room_objname );
  cmn.AddSubscriber( "use_flag", use_flag_inv );
  cmn.AddSubscriber( "use_flag", use_flag_end, private.room_objname );
  cmn.AddSubscriber( "use_flag_inv", use_flag_inv, private.room_objname );
  cmn.AddSubscriber( "use_flag_beg", use_flag_beg, private.room_objname );
  cmn.AddSubscriber( "use_flag_end", use_flag_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_scrap () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_scrapneighborcar" ] = {

      type = "use",
      inv_obj = "inv_scrap",
      use_place = "obj_neighborcar_use_scrap",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_scrapinpole" ] = {

      type = "use",
      inv_obj = "inv_scrap",
      use_place = "obj_pole_door_clk",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  --------------------------------------------------------------------------------------------
  local use_scrapneighborcar_inv = function ()

    if (cmn.IsEventDone("use_scrapinpole")) then
  
      interface.InventoryItemRemove( "inv_scrap" );

    end;
  
  end;
  local use_scrapneighborcar_beg = function ()
  
    ObjDelete( "obj_neighborcar_use_scrap" );
    ObjDelete( "anm_neighborcar_touch_door" );
  
  end;
  local use_scrapneighborcar_end = function ()
  
    ObjSet("anm_neighborcar_touch_door_handle", {alp = 1});
    ObjSet("obj_neighborcar_clk_door_handle", {input = 1});

    ObjDelete("anm_neighborcar_use_scrap");
  
  end;

  local use_scrapinpole_inv = function ()

    if (cmn.IsEventDone("use_scrapneighborcar")) then
  
      interface.InventoryItemRemove( "inv_scrap" );

    end;
  
  end;
  local use_scrapinpole_beg = function ()
  
    ObjDelete( "obj_pole_door_clk" );
    ObjDelete( "anm_pole_door_clk" );
  
  end;
  local use_scrapinpole_end = function ()
  
    ObjSet("obj_pole_switch_clk", {input = 1});
    ObjSet("anm_pole_use_scrap", {frame = 115, alp = 1});
    ObjDelete("spr_street_pole_lock");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_scrapneighborcar", use_scrapneighborcar_beg, private.room_objname );
  cmn.AddSubscriber( "use_scrapneighborcar", use_scrapneighborcar_inv );
  cmn.AddSubscriber( "use_scrapneighborcar", use_scrapneighborcar_end, private.room_objname );
  cmn.AddSubscriber( "use_scrapneighborcar_inv", use_scrapneighborcar_inv, private.room_objname );
  cmn.AddSubscriber( "use_scrapneighborcar_beg", use_scrapneighborcar_beg, private.room_objname );
  cmn.AddSubscriber( "use_scrapneighborcar_end", use_scrapneighborcar_end, private.room_objname );

  cmn.AddSubscriber( "use_scrapinpole", use_scrapinpole_beg, private.room_objname );
  cmn.AddSubscriber( "use_scrapinpole", use_scrapinpole_inv );
  cmn.AddSubscriber( "use_scrapinpole", use_scrapinpole_end, private.room_objname );
  cmn.AddSubscriber( "use_scrapinpole_inv", use_scrapinpole_inv, private.room_objname );
  cmn.AddSubscriber( "use_scrapinpole_beg", use_scrapinpole_beg, private.room_objname );
  cmn.AddSubscriber( "use_scrapinpole_end", use_scrapinpole_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_blade () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_bladeneighborcar" ] = {

      type = "use",
      inv_obj = "inv_blade",
      use_place = "obj_neighborcar_use_blade",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  local use_blade_inv = function ()

    --if cmn.IsEventDone("use_bladeneighborcar") then
  
      interface.InventoryItemRemove( "inv_blade" );

    --end;
  
  end;
  local use_bladeneighborcar_beg = function ()
  
    ObjDelete( "obj_neighborcar_use_blade" );
    ObjDelete("anm_neighborcar_touch_tarpaulin");
  
  end;
  local use_bladeneighborcar_end = function ()
  
    ObjSet("obj_neighborcar_tarpaulin_open", {input = 1, alp = 1});
    ObjSet("spr_street_tarpaulin_open", {alp = 1});

    ObjDelete("anm_neighborcar_use_blade");
    ObjDelete("spr_street_tarpaulin_closed");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_bladeneighborcar", use_bladeneighborcar_beg, private.room_objname );
  cmn.AddSubscriber( "use_bladeneighborcar", use_blade_inv );
  cmn.AddSubscriber( "use_bladeneighborcar", use_bladeneighborcar_end, private.room_objname );
  cmn.AddSubscriber( "use_blade_inv", use_blade_inv, private.room_objname );
  cmn.AddSubscriber( "use_bladeneighborcar_beg", use_bladeneighborcar_beg, private.room_objname );
  cmn.AddSubscriber( "use_bladeneighborcar_end", use_bladeneighborcar_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_emptycanister () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_emptycanister" ] = {

      type = "use",
      inv_obj = "inv_emptycanister",
      use_place = "obj_neighborcar_use_emptycanister",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  local use_emptycanister_inv = function ()
  
    interface.InventoryItemRemove( "inv_emptycanister" );
  
  end;
  local use_emptycanister_beg = function ()
  
    ObjDelete( "obj_neighborcar_use_emptycanister" );
  
  end;
  local use_emptycanister_end = function ()
  
    --ObjSet("obj_neighborcar_get_gascanisters", {input = 1});
    --ObjSet("anm_neighborcar_use_emptycanister", {playing = 0, frame = 81});

    ObjDelete("anm_neighborcar_touch_gastank_cover");
    ObjDelete("spr_street_gastank_cover");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_emptycanister", use_emptycanister_beg, private.room_objname );
  cmn.AddSubscriber( "use_emptycanister", use_emptycanister_inv );
  cmn.AddSubscriber( "use_emptycanister", use_emptycanister_end, private.room_objname );
  cmn.AddSubscriber( "use_emptycanister_inv", use_emptycanister_inv, private.room_objname );
  cmn.AddSubscriber( "use_emptycanister_beg", use_emptycanister_beg, private.room_objname );
  cmn.AddSubscriber( "use_emptycanister_end", use_emptycanister_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_pruner () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_prunerpole" ] = {

      type = "use",
      inv_obj = "inv_pruner",
      use_place = "obj_pole_ladder_clk",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_prunertree" ] = {

      type = "use",
      inv_obj = "inv_pruner",
      use_place = "obj_tree_use_pruner",
      room = "rm_orphanagepark",
      zz = "zz_tree",
      zz_gate = "gzz_orphanagepark_tree"
  };
  --------------------------------------------------------------------------------------------
  local use_pruner_inv1 = function ()
  
    if (cmn.IsEventDone("use_prunertree")) then
      interface.InventoryItemRemove( "inv_pruner" );
    end;
  
  end;
  local use_pruner_beg1 = function ()
  
    ObjDelete( "obj_pole_ladder_clk" );
    ObjDelete( "anm_pole_ladder_clk" );
    ObjSet("spr_pole_stairs", {alp = 1});
  
  end;
  local use_pruner_end1 = function ()
  
    ObjSet( "spr_pole_stairs", { input = true, alp = 1 } );

    ObjDelete( "anm_pole_use_pruner" );
    ObjDelete( "spr_street_ivi" );
  
  end;

  local use_pruner_inv2 = function ()
  
    if (cmn.IsEventDone("use_prunerpole")) then
      interface.InventoryItemRemove( "inv_pruner" );
    end;
  
  end;
  local use_pruner_beg2 = function ()
  
    ObjDelete( "obj_tree_use_pruner" );
    ObjDelete( "anm_tree_touch_wing" );
    ObjSet( "spr_tree_wings", { input = true, alp = 1 } );
  
  end;
  local use_pruner_end2 = function ()
  
    ObjDelete( "anm_tree_use_pruner" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_prunerpole", use_pruner_beg1, private.room_objname );
  cmn.AddSubscriber( "use_prunerpole", use_pruner_inv1 );
  cmn.AddSubscriber( "use_prunerpole", use_pruner_end1, private.room_objname );
  cmn.AddSubscriber( "use_pruner_inv1", use_pruner_inv1, private.room_objname );
  cmn.AddSubscriber( "use_pruner_beg1", use_pruner_beg1, private.room_objname );
  cmn.AddSubscriber( "use_pruner_end1", use_pruner_end1, private.room_objname );

  cmn.AddSubscriber( "use_prunertree", use_pruner_beg2, "rm_orphanagepark" );
  cmn.AddSubscriber( "use_prunertree", use_pruner_inv2 );
  cmn.AddSubscriber( "use_prunertree", use_pruner_end2, "rm_orphanagepark" );
  cmn.AddSubscriber( "use_pruner_inv2", use_pruner_inv2, "rm_orphanagepark" );
  cmn.AddSubscriber( "use_pruner_beg2", use_pruner_beg2, "rm_orphanagepark" );
  cmn.AddSubscriber( "use_pruner_end2", use_pruner_end2, "rm_orphanagepark" );

  --------------------------------------------------------------------------------------------
  -- function clk_clickondrawer () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickondrawer" ] = {

      type = "clk",
      use_place = "obj_mailbox_clickondrawer",
      room = private.room_objname,
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  local clk_clickondrawer_beg = function ()
  
    ObjSet( "obj_mailbox_clickondrawer", { input = false } );
  
  end;
  local clk_clickondrawer_end = function ()
  
    ObjDelete( "spr_mailbox_flag_on" );
    ObjDelete( "anm_mailbox_touch_cover" );
    ObjDelete( "spr_street_mailbox_closed" );
    ObjDelete( "spr_street_flag_up" );

    ObjMultiSet({
                  {"spr_mailbox_flag_off",{alp = 1}},
                  {"spr_mailbox_cover_open",{alp = 1}},
                  {"spr_mailbox_parcel",{input = 1}},
                  {"spr_street_flag_down",{alp = 1}},
                  {"spr_street_mailbox_open",{alp = 1}}
                });    
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickondrawer", clk_clickondrawer_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickondrawer", clk_clickondrawer_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickondrawer_beg", clk_clickondrawer_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickondrawer_end", clk_clickondrawer_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_policecardoor () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecardoor" ] = {

      type = "clk",
      use_place = "obj_policecar_clk_door_button",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  local clk_policecardoor_beg = function ()
  
    ObjDelete("obj_policecar_clk_door_button");
  
  end;
  local clk_policecardoor_end = function ()
  
    ObjMultiSet( { {"obj_policecar_use_policekeys", { input = true }},
                   {"spr_policecar_horn", { input = true }},
                   {"obj_policecar_note", { input = true }} } );

    ObjDelete("anm_policecar_open_door");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_policecardoor", clk_policecardoor_beg, private.room_objname );
  cmn.AddSubscriber( "clk_policecardoor", clk_policecardoor_end, private.room_objname );
  cmn.AddSubscriber( "clk_policecardoor_beg", clk_policecardoor_beg, private.room_objname );
  cmn.AddSubscriber( "clk_policecardoor_end", clk_policecardoor_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_cafedoors () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_cafedoors" ] = {

      type = "clk",
      use_place = "obj_street_clk_cafedoors",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  local clk_cafedoors_beg = function ()
  
    ObjDelete("obj_street_clk_cafedoors");
  
  end;
  local clk_cafedoors_end = function ()
  
    ObjSet( "grm_street_cafe", {input = true} );
    ObjSet("spr_street_cafeopen", {alp = 1});
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_cafedoors", clk_cafedoors_beg, private.room_objname );
  cmn.AddSubscriber( "clk_cafedoors", clk_cafedoors_end, private.room_objname );
  cmn.AddSubscriber( "clk_cafedoors_beg", clk_cafedoors_beg, private.room_objname );
  cmn.AddSubscriber( "clk_cafedoors_end", clk_cafedoors_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_cardoorhandle() end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_cardoorhandle" ] = {

      type = "clk",
      use_place = "obj_neighborcar_clk_door_handle",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  --------------------------------------------------------------------------------------------
  local clk_cardoorhandle_beg = function ()
  
    ObjDelete("obj_neighborcar_clk_door_handle");
  
  end;
  local clk_cardoorhandle_end = function ()
  
    ObjMultiSet( {
                  {"anm_neighborcar_touch_door_handle", {playing = 0, frame = 48}},
                  {"obj_neighborcar_get_dog", {input = 1}},
                  {"obj_neighborcar_use_blade", {input = 1}},
                  {"spr_street_open_trunk", {alp = 1}}
                 });  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_cardoorhandle", clk_cardoorhandle_beg, private.room_objname );
  cmn.AddSubscriber( "clk_cardoorhandle", clk_cardoorhandle_end, private.room_objname );
  cmn.AddSubscriber( "clk_cardoorhandle_beg", clk_cardoorhandle_beg, private.room_objname );
  cmn.AddSubscriber( "clk_cardoorhandle_end", clk_cardoorhandle_end, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function clk_openelectrical () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_openelectrical" ] = {

      type = "clk",
      use_place = "obj_pole_switch_clk",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  --------------------------------------------------------------------------------------------
  local clk_openelectrical = function ()

    ObjMultiSet( {
                  {"obj_pole_switch_clk", { event_mup = rm_street.clk_switch }},
                  {"spr_pole_door_open", { alp = 1 }},
                  {"spr_street_pole_door_open", { alp = 1 }}
                 });  
  
    ObjDelete("anm_pole_use_scrap");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_openelectrical", clk_openelectrical, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickontheswitch () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickontheswitch" ] = {

      type = "clk",
      use_place = "obj_pole_switch_clk",
      room = private.room_objname,
      zz = "zz_pole",
      zz_gate = "gzz_street_pole"
  };
  --------------------------------------------------------------------------------------------
  local clk_clickontheswitch = function ()

    ObjMultiSet( {
                  {"spr_pole_door_lever_off", { alp = 1 }},
                  {"spr_street_pole_door_switch_off", { alp = 1 }},
                  {"spr_pole_door_light_off", { alp = 1 }}
                 });  
  
    ObjDelete("obj_pole_switch_clk");
    ObjDelete("spr_pole_door_light_on");
    ObjDelete("spr_pole_door_lever_on");
    ObjDelete("spr_street_pole_door_switch_on");
    ObjDelete("fx_pole_flash");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickontheswitch", clk_clickontheswitch, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_switchclosezz () end;
  --------------------------------------------------------------------------------------------
  local clk_switchclosezz = function ()

    ObjSet("grm_street_parking",  { active = 1, input = 1, visible = 1 });
  
    --ObjDelete("obj_street_lock");
    ObjDelete("fx_street_electric_flash");
    ObjDelete("fx_street_p_parking_fog");
    ObjDelete("obj_street_fog_bbt");
    ObjDelete("obj_street_electricity_bbt");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_switchclosezz", clk_switchclosezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_playflashback2 () end;
  --------------------------------------------------------------------------------------------
  local clk_playflashback2 = function ()

    ObjMultiSet( { {"obj_neighborcar_click_on_dog", { event_mup = public.clk_dog }},
                   {"obj_neighborcar_clk_gastankcover", { event_mup = public.clk_gastank_cover }},
                   {"obj_neighborcar_use_scrap", { event_mup = public.touch_cardoor }} } );

    ObjDelete("obj_neighborcar_first_click");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_playflashback2", clk_playflashback2, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_gastankcover () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_gastankcover" ] = {

      type = "clk",
      use_place = "obj_neighborcar_clk_gastankcover",
      room = private.room_objname,
      zz = "zz_neighborcar",
      zz_gate = "gzz_street_neighborcar"
  };
  --------------------------------------------------------------------------------------------
  local clk_gastankcover = function ()

    ObjDelete("obj_neighborcar_clk_gastankcover");
    ObjDelete("anm_neighborcar_touch_gastank_cover");

    ObjSet("obj_neighborcar_use_emptycanister", {input = 1});
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_gastankcover", clk_gastankcover, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function opn_street () end;
  --------------------------------------------------------------------------------------------
  local opn_street = function ()
  
    int_map_impl.OpenRoom( "rm_street" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_street", opn_street );
  --------------------------------------------------------------------------------------------
  -- function opn_streetsxarysh () end;
  --------------------------------------------------------------------------------------------
  local opn_streetsxarysh = function ()
  
    --ObjDelete("obj_street_lock");
    ObjDelete("fx_street_scary_shadow");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_streetsxarysh", opn_streetsxarysh, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function opn_neighborcar () end;
  --------------------------------------------------------------------------------------------
  local opn_neighborcar = function ()
  
    ObjSet("anm_neighborcar_dog",  { alp = 1, playing = 1 });

    ObjDelete("anm_neighborcar_dog_start");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_neighborcar", opn_neighborcar, private.room_objname );

end;
--*********************************************************************************************************************
function private.Init_Subroom()
  
  subroom.Define( "zz_neighborcar" );
  subroom.Define( "zz_pole" );
  subroom.Define( "zz_policecar" );
  subroom.Define( "zz_mailbox" );
--
  function zz_pole.Open()
    if cmn.IsEventDone("use_bowstring1") and (not cmn.IsEventDone("win_pole")) then
      --cmn.MiniGameShow();
      --private.zz_pole.ShowBow();
    end;
  end;
--
  function zz_pole.PreClose()

    if cmn.IsEventDone("use_bowstring1") and (not cmn.IsEventDone("win_pole")) then
      --cmn.MiniGameHide("pole");
      --private.zz_pole.HideBow();
    end;

  end;

  function zz_pole.Close()

    if cmn.IsEventDone("win_pole") and not (cmn.IsEventDone("opn_streetsxarysh")) then

      cmn.SetEventDone("opn_streetsxarysh");
      private.cafe_shadow();

    end;

    if not(cmn.IsEventDone("clk_switchclosezz")) and cmn.IsEventDone("clk_clickontheswitch") then
      cmn.SetEventDone("clk_switchclosezz");
      private.electricity_stop();
    end;

  end;

  function zz_mailbox.Close()
    ObjSet("spr_mailbox_note_2", {input = 0, alp = 0});
  end;

  function zz_policecar.Close()
    cmn.HideNote( 0 );
    if cmn.IsEventDone("use_policekeys") then
      private.dlg_insidecar.open();
    end;
  end;

  function zz_neighborcar.Open()
    private.opn_neighborcar();
  end;

end;
--*********************************************************************************************************************
function public.Load()

  if not( cmn.IsEventDone( "use_bowstring1" ) ) then
    private.zz_pole.StartConditions();
  end;

  private.zz_pole.state = ng_global.progress[ "std" ][ "win_pole" ].state;

  if ( cmn.IsEventDone( "use_bowstring1" ) and not(cmn.IsEventDone( "win_pole" )) ) then
    private.zz_pole.DrawScene();
  end;

end;
--*********************************************************************************************************************
function public.Open()

  private.opn_street();

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_street_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_street_env");

  if not( cmn.IsEventDone( "opn_street" ) ) then
    ObjSet("rm_street",  { color_r = 0, color_g = 0, color_b = 0 });
  end;

  if not( cmn.IsEventDone( "clk_clickontheswitch" ) ) then
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_electrisity_env");
  end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_policekeys(usekeys)

  local item = "inv_policekeys";

  if cmn.ApplyObj( item, "gzz_street_policecar" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_policecar" );

  elseif ( cmn.ApplyObj( item, "obj_policecar_use_policekeys" ) or usekeys) then

    cmn.CallEventHandler( "use_policekeys_inv" );
    cmn.CallEventHandler( "use_policekeys_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_policekeys" );
      cmn.CallEventHandler( "use_policekeys_end" );

      ObjSet("obj_street_lock", {input = 1});

      cmn.Lock(0);

      common.CloseSubRoom();

    end;

    if cmn.IsEventDone("clk_policecardoor") then

      cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_usepolicekey");

      ObjSet("anm_policecar_use_key", {endtrig = trg_after, playing = 1});

      cmn.Lock(1);

    else

      public.clk_policecardoor(true);

    end;

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_bowstring1()

  local item = "inv_bowstring1";

  if cmn.ApplyObj( item, "gzz_street_pole" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_pole" );

  elseif ( cmn.ApplyObj( item, "obj_pole_use_bowstring1" ) ) then

    cmn.CallEventHandler( "use_bowstring1_inv" );
    cmn.CallEventHandler( "use_bowstring1_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_bowstring1" );
      cmn.CallEventHandler( "use_bowstring1_end" );

      --cmn.MiniGameShow();
      private.zz_pole.ShowBow();

    end;

    trg_after();

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_camera()

  local item = "inv_camera";

  if cmn.ApplyObj( item, "gzz_street_mailbox" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_mailbox" );

  elseif ( cmn.ApplyObj( item, "obj_mailbox_use_camera" ) ) then

    --cmn.CallEventHandler( "use_camera_inv" );
    cmn.CallEventHandler( "use_camera_beg" );

    local trg_after = function ()

      local trg_after = function ()

        cmn.SetEventDone( "use_camera" );
        cmn.CallEventHandler( "use_camera_end" );

        cmn.Lock(0);

      end;

      ObjAnimate( "spr_mailbox_photo1", "alp", 0, 0, trg_after,
      { 
        0.0, 0, 0.0, 
        0.5, 0, 1.0
      } );

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_usecamera");

    ObjSet("anm_mailbox_use_camera", {endtrig = trg_after, playing = 1});

    cmn.Lock(1);

  elseif cmn.ApplyObj( item, "gzz_cafe_barcounter" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_barcounter" );

  elseif ( cmn.ApplyObj( item, "obj_barcounter_use_camera" ) and cmn.IsEventDone("win_barcounter")) then

    --cmn.CallEventHandler( "use_camera_inv" );
    cmn.CallEventHandler( "use_camera_beg2" );

    local trg_after = function ()

      local trg_after = function ()

        cmn.SetEventDone( "use_camerabarcounter" );
        cmn.CallEventHandler( "use_camera_end2" );

        cmn.Lock(0);

      end;

      ObjAnimate( "spr_barcounter_codesafe", "alp", 0, 0, trg_after,
      { 
        0.0, 0, 0.0, 
        0.5, 0, 1.0
      } );

    end;

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_usecamera");

    ObjSet("anm_barcounter_use_camera", {endtrig = trg_after, playing = 1, alp = 1});


--  elseif cmn.ApplyObj( item, "gzz_parking_policemotorbike" ) then
--
--    ObjDoNotDrop( item );
--    cmn.GotoSubRoom( "zz_policemotorbike" );

  elseif ( cmn.ApplyObj( item, "obj_policemotorbike_use_camera" ) ) then

    cmn.CallEventHandler( "use_camera_beg3" );

    local trg_after = function ()

      local trg_after = function ()

        cmn.Lock(0);

        cmn.SetEventDone( "use_cameramotorbike" );
        cmn.CallEventHandler( "use_camera_end3" );

      end;

      ObjAnimate( "spr_policemotorbike_photo3", "alp", 0, 0, trg_after,
      { 
        0.0, 0, 0.0, 
        0.5, 0, 1.0
      } );

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_usecamera");

    ObjSet("anm_policemotorbike_use_camera", {alp = 1, endtrig = trg_after, playing = 1});

    cmn.Lock(1);

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_flag()

  local item = "inv_flag";

  if cmn.ApplyObj( item, "gzz_street_mailbox" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_mailbox" );

  elseif ( cmn.ApplyObj( item, "obj_mailbox_use_flag" ) ) then

    cmn.CallEventHandler( "use_flag_inv" );
    cmn.CallEventHandler( "use_flag_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_flag" );
      cmn.CallEventHandler( "use_flag_end" );

      cmn.Lock(0);

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_useflag");

    ObjAnimate( "spr_mailbox_flag_on", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.3, 0, 1.0
    } );

    cmn.Lock(1);

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_scrap()

  local item = "inv_scrap";

  if cmn.ApplyObj( item, "gzz_street_neighborcar" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_neighborcar" );

  elseif ( cmn.ApplyObj( item, "obj_neighborcar_use_scrap" ) and cmn.IsEventDone("clk_playflashback2") ) then

    cmn.CallEventHandler( "use_scrapneighborcar_inv" );
    cmn.CallEventHandler( "use_scrapneighborcar_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_scrapneighborcar" );
      cmn.CallEventHandler( "use_scrapneighborcar_end" );

      cmn.Lock(0);

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_breakwindow");

    ObjSet("anm_neighborcar_use_scrap", {endtrig = trg_after, playing = 1, alp = 1});

    cmn.Lock(1);

  elseif cmn.ApplyObj( item, "gzz_street_pole" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_pole" );

  elseif ( cmn.ApplyObj( item, "obj_pole_door_clk" ) ) then

    cmn.CallEventHandler( "use_scrapinpole_inv" );
    cmn.CallEventHandler( "use_scrapinpole_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_scrapinpole" );
      cmn.CallEventHandler( "use_scrapinpole_end" );

      cmn.Lock(0);

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_scrapinpole");

    ObjSet("anm_pole_use_scrap", {endtrig = trg_after, playing = 1, alp = 1});

    cmn.Lock(1);

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_blade()

  local item = "inv_blade";

  if cmn.ApplyObj( item, "gzz_street_neighborcar" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_neighborcar" );

  elseif ( cmn.ApplyObj( item, "obj_neighborcar_use_blade" ) ) then

    cmn.CallEventHandler( "use_blade_inv" );
    cmn.CallEventHandler( "use_bladeneighborcar_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_bladeneighborcar" );
      cmn.CallEventHandler( "use_bladeneighborcar_end" );

      cmn.Lock(0);

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_blade");

    ObjSet("anm_neighborcar_use_blade", {endtrig = trg_after, playing = 1});

    cmn.Lock(1);

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_emptycanister()

  local item = "inv_emptycanister";

  if cmn.ApplyObj( item, "gzz_street_neighborcar" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_neighborcar" );

  elseif ( cmn.ApplyObj( item, "obj_neighborcar_use_emptycanister" ) ) then

    cmn.CallEventHandler( "use_emptycanister_inv" );
    cmn.CallEventHandler( "use_emptycanister_beg" );

    local trg_after = function ()

      if not cmn.IsEventDone("clk_gastankcover") then

        cmn.SetEventDone( "clk_gastankcover" );
        cmn.CallEventHandler( "clk_gastankcover" );

      end;

      local trg_after = function ()

        cmn.SetEventDone( "use_emptycanister" );
        cmn.CallEventHandler( "use_emptycanister_end" );

        cmn.Lock(0);
        public.get_gascanisters();

      end;

      cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_emptycanister");

      ObjSet("anm_neighborcar_use_emptycanister", {endtrig = trg_after, playing = 1});

    end;

    if not cmn.IsEventDone("clk_gastankcover") then

      ObjSet("anm_neighborcar_touch_gastank_cover", {endtrig = trg_after, playing = 1});

      cmn.Lock(1);

    else 

      trg_after();

    end;

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_pruner()

  local item = "inv_pruner";

  if cmn.ApplyObj( item, "gzz_street_pole" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_pole" );

  elseif ( cmn.ApplyObj( item, "obj_pole_ladder_clk" ) ) then

    cmn.CallEventHandler( "use_pruner_inv1" );
    cmn.CallEventHandler( "use_pruner_beg1" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_prunerpole" );
      cmn.CallEventHandler( "use_pruner_end1" );

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_cut_leaves");

    ObjSet("anm_pole_use_pruner", {endtrig = trg_after, playing = 1});

  elseif cmn.ApplyObj( item, "gzz_orphanagepark_tree" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_tree" );

  elseif ( cmn.ApplyObj( item, "obj_tree_use_pruner" ) ) then

    cmn.CallEventHandler( "use_pruner_inv2" );
    cmn.CallEventHandler( "use_pruner_beg2" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_prunertree" );
      cmn.CallEventHandler( "use_pruner_end2" );

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_cutbush");

    ObjSet("anm_tree_use_pruner", {endtrig = trg_after, playing = 1, alp = 1});

  else

    cmn.WrongApply();  

  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_screwdriver()

  cmn.SetEventDone( "get_screwdriver" );
  cmn.CallEventHandler( "get_screwdriver" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_policekeys()

  cmn.SetEventDone( "get_policekeys" );
  cmn.CallEventHandler( "get_policekeys" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_stairs()

  cmn.SetEventDone( "get_stairs" );
  cmn.CallEventHandler( "get_stairs" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_letter5()

  ObjSet("spr_mailbox_letter5", {alp = 1});

  cmn.SetEventDone( "get_letter5" );
  cmn.CallEventHandler( "get_letter5" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_photo1()

  cmn.SetEventDone( "get_photo1" );
  cmn.CallEventHandler( "get_photo1" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_parcel()

  cmn.SetEventDone( "get_parcel" );
  cmn.CallEventHandler( "get_parcel" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  --if cmn.IsEventDone("get_letter5") and cmn.IsEventDone("get_photo1") then
  --  common.CloseSubRoom();
  --end;
  --
end;
--------------------------------------------------------------------------------------------
function public.get_dog()
      
  cmn.SetEventDone( "get_dog" );
  cmn.CallEventHandler( "get_dog" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");
    
end;
--------------------------------------------------------------------------------------------
function public.get_net()

  cmn.SetEventDone( "get_net" );
  cmn.CallEventHandler( "get_net" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_hankline()

  cmn.SetEventDone( "get_hankline" );
  cmn.CallEventHandler( "get_hankline" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_gascanisters()

  cmn.SetEventDone( "get_gascanisters" );
  cmn.CallEventHandler( "get_gascanisters" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_bow2()

  ObjSet("spr_pole_bow2",  { alp = 1 });

  cmn.SetEventDone( "get_bow2" );
  cmn.CallEventHandler( "get_bow2" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.clk_clickondrawer()

  cmn.CallEventHandler( "clk_clickondrawer_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_clickondrawer" );
    cmn.CallEventHandler( "clk_clickondrawer_end" );

    cmn.Lock(0);
  
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_clk_flag");

  ObjAnimate( "spr_mailbox_flag_off", "alp", 0, 0, "", 
  { 
    0.0, 0, 0.0, 
    0.3, 0, 1.0
  } );
  ObjAnimate( "spr_mailbox_flag_on", "alp", 0, 0, "", 
  { 
    0.0, 0, 1.0, 
    0.3, 0, 0.0
  } );
  ObjAnimate( "anm_mailbox_touch_cover", "alp", 0, 0, "", 
  { 
    0.0, 0, 1.0, 
    0.3, 0, 1.0,
    0.6, 0, 0.0
  } );
  ObjAnimate( "spr_mailbox_cover_open", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0.0,
    0.3, 0, 0.0, 
    0.6, 0, 1.0
  } );

  cmn.Lock(1);

end;
--------------------------------------------------------------------------------------------
function public.clk_policecardoor(usekeys)

  cmn.CallEventHandler( "clk_policecardoor_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_policecardoor" );
    cmn.CallEventHandler( "clk_policecardoor_end" );

    cmn.Lock(0);

    if usekeys then
      public.use_policekeys(true);
    end;
  
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_openpolicecardoor");

  ObjSet("anm_policecar_open_door", {endtrig = func_after, playing = 1});

  cmn.Lock(1);
  
end;
--------------------------------------------------------------------------------------------
function public.clk_cafedoors()

  cmn.CallEventHandler( "clk_cafedoors_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_cafedoors" );
    cmn.CallEventHandler( "clk_cafedoors_end" );

    cmn.Lock(0);
  
  end;

  ObjAnimate("spr_street_cafeopen", "alp", 0, 0, func_after, 
             {0, 0, 0,  0.3, 0, 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_opencafedoor");
  
end;
--------------------------------------------------------------------------------------------
function public.clk_cardoorhandle()

  cmn.CallEventHandler( "clk_cardoorhandle_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_cardoorhandle" );
    cmn.CallEventHandler( "clk_cardoorhandle_end" );

    local trg_after = function ()
      
      public.get_dog()

      cmn.Lock(0);

    end;

    cmn.ShowBbt( "neighborcar_get_dog" );

    ObjAttach("vid_neighborcar_dog_jump", "zz_neighborcar");
    VidPlay("vid_neighborcar_dog_jump", trg_after);
  
  end;

  ObjSet("anm_neighborcar_touch_door_handle", {endtrig = func_after, playing = 1});

  cmn.Lock(1);

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_rearcardoor");
  
end;
--------------------------------------------------------------------------------------------
function public.clk_openelectrical()

  local func_after = function ()

    cmn.SetEventDone( "clk_openelectrical" );
    cmn.CallEventHandler( "clk_openelectrical" );

    cmn.Lock(0);
  
  end;

  ObjAnimate("anm_pole_use_scrap", "alp", 0, 0, func_after, 
             {0, 0, 1,  0.5, 0, 0});

  ObjAnimate("spr_pole_door_open", "alp", 0, 0, "", 
             {0, 0, 0,  0.5, 0, 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_openelectrical");
  
end;
--------------------------------------------------------------------------------------------
function public.clk_switch()

  local func_after = function ()

    cmn.SetEventDone( "clk_clickontheswitch" );
    cmn.CallEventHandler( "clk_clickontheswitch" );

    --cmn.Lock(0);
    common.CloseSubRoom();
  
  end;

  local func_mid = function ()

    ObjAnimate("fx_pole_flash", "alp", 0, 0, func_after, 
                {0, 0, 1,  0.5, 0, 0});

  end;

  ObjAnimate("spr_pole_door_light_on", "alp", 0, 0, func_mid, 
             {0, 0, 1,  0.5, 0, 0});

  ObjAnimate("spr_pole_door_light_off", "alp", 0, 0, "", 
             {0, 0, 0,  0.5, 0, 1});

  ObjAnimate("spr_pole_door_lever_on", "alp", 0, 0, "", 
             {0, 0, 1,  0.5, 0, 0});

  ObjAnimate("spr_pole_door_lever_off", "alp", 0, 0, "", 
             {0, 0, 0,  0.5, 0, 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_clickontheswitch");
  
end;
--------------------------------------------------------------------------------------------
function public.clk_gastank_cover()

  local func_after = function ()

    cmn.SetEventDone( "clk_gastankcover" );
    cmn.CallEventHandler( "clk_gastankcover" );

    cmn.Lock(0);
  
  end;

  ObjSet("anm_neighborcar_touch_gastank_cover", {endtrig = func_after, playing = 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_clk_korck");

end;
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_street()

  if not ( cmn.IsEventDone( "opn_street" ) ) then

    cmn.SetEventDone( "opn_street" );
    cmn.CallEventHandler("opn_street");

    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_street/vid_ghosttown", private.opn_street_end, "assets/levels/level1/rm_street/audio/aud_ghosttown_mus", "" );

  end;

end;
---------------------------------------------------------------------------------
function private.opn_street_end()

  cmn.ShowBbt( "street_open" );
  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_street_mus");

  ObjSet("rm_street",  { color_r = 1, color_g = 1, color_b = 1 });

end;
---------------------------------------------------------------------------------------
function private.opn_neighborcar()

  if not ( cmn.IsEventDone( "opn_neighborcar" ) ) then

    local func_after = function ()

      cmn.ShowBbt( "neighborcar_open" );
      cmn.CallEventHandler("opn_neighborcar");

      cmn.Lock(0); 
      public.play_flashback2();

    end;

    cmn.Lock(1); 
    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_uprisedog");

    cmn.SetEventDone( "opn_neighborcar" );

    ObjSet("anm_neighborcar_dog_start", { endtrig = func_after, playing = 1 });

  end;

end;
---------------------------------------------------------------------------------------
function public.play_flashback2()

  int_blackbartext.Hide();

  cmn.SetEventDone( "clk_playflashback2" );
  cmn.CallEventHandler("clk_playflashback2");

  cmn.PlayCutScene( "flashback2",
                    "assets/levels/level1/rm_street/zz_neighborcar/cs/anm_flashback_1",
                    { 0 },
                    function () cmn.ShowBbt( "after_flashback2" ); cmn.PlayAudio("mus", "assets/levels/level1/rm_street/audio/aud_howl3_mus"); end, 
                    "assets/levels/level1/rm_street/audio/aud_flashback_1_mus",
                    "assets/levels/level1/rm_street/audio/aud_carol_14_voc" );


end;
---------------------------------------------------------------------------------
function public.parsel_note_show()

  ObjSet("spr_mailbox_note_2", {input = 1, alp = 1});

  ObjAnimate("spr_mailbox_note_2", "alp", 0, 0, function () cmn.Lock(0); end, 
             {0, 0, 0,  0.5, 1, 1});

  cmn.Lock(1);
  cmn.ShowBbt( "spr_mailbox_note_2" );

end;
---------------------------------------------------------------------------------
function public.parsel_note_hide()

  ObjSet("spr_mailbox_note_2", {input = 0, alp = 1});

  ObjAnimate("spr_mailbox_note_2", "alp", 0, 0, function () cmn.Lock(0); public.get_parcel(); end, 
             {0, 0, 1,  0.5, 0, 0});

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.ladder_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_staircase");

  ObjSet("anm_pole_ladder_clk", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.ShowBbt( "obj_pole_ladder_clk" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.crow_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_crow");

  local func_after = function ()

    ObjSet("anm_pole_crow_sits", { playing = 1, alp = 1 });
    ObjSet("anm_pole_crow_touch", { alp = 0 });    
    cmn.Lock(0); 

  end;

  ObjSet("anm_pole_crow_sits", { playing = 0, alp = 0 });
  ObjSet("anm_pole_crow_touch", { endtrig = func_after, playing = 1, alp = 1 });

  cmn.Lock(1);
  cmn.ShowBbt( "obj_pole_use_bowstring1" );

end;
---------------------------------------------------------------------------------
function public.carbag_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_cover");

  ObjSet("anm_neighborcar_touch_tarpaulin", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.ShowBbt( "obj_neighborcar_use_blade" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.door_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_switchboard");

  ObjSet("anm_pole_door_clk", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.ShowBbt( "obj_pole_door_clk" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.horn_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_carhorn");

  ObjAnimate("spr_policecar_horn", "alp", 0, 0, function () cmn.Lock(0); end, 
             {0, 0, 0,  0.2, 0, 1,  0.4, 0, 1,  0.6, 0, 0});

  --cmn.ShowBbt( "" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.cafesign_touch()

  local func_after = function ()

    ObjSet("fx_street_light_sign", { active = 0, visible = 0 });

    cmn.Lock(0);
  
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_banner");

  ObjSet("fx_street_light_sign", { active = 1, visible = 1 });
  PartSysRestart("fx_street_light_sign");

  ObjSet("tmr_street_timer",  { playing = 1, time = 2.65, endtrig = func_after });

  cmn.ShowBbt( "street_cafe_sign" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function private.cafe_shadow()

  cmn.StopAllMus();
  ObjSet("obj_street_lock",  { input = 1 });
  cmn.Lock(1);

  local func_after = function ()

    cmn.ShowBbt( "street_after_scary_bbt" );
    cmn.CallEventHandler("opn_streetsxarysh");

    cmn.Lock(0);
    ObjSet("obj_street_lock",  { input = 0 });

    cmn.PlayAudio("mus", "assets/levels/common/audio/aud_howlaftershadow_mus");
  
  end;

  local play_zoom = function ()

    if interface.GetCurrentComplexInv() ~= "" then
      common_impl.HideComplexItem();
    end;

    ObjSet("fx_street_scary_shadow", { active = 1, visible = 1 });
    PartSysRestart("fx_street_scary_shadow");

    ObjAnimate( "rm_street", "scale_xy", 0, 0, "", { 0,0,1,1,   1.5,0,2,2,  3,0,2,2,    3.5,0,1,1 } );
    ObjAnimate( "rm_street", "pos_xy",   0, 0, func_after, { 0,0,0,0,   1.5,0,-820,-110,   3,0,-820,-110,   3.5,0,0,0 } );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_cafeshadow");

  end;

  ObjSet("tmr_street_timer",  { time = 0.3, playing = 1, endtrig = play_zoom });

end;
---------------------------------------------------------------------------------
function private.electricity_stop()

  local func_after = function ()

    cmn.ShowBbt( "street_after_electricity_stop" );
    cmn.CallEventHandler("clk_switchclosezz");

    cmn.Lock(0);
    ObjSet("obj_street_lock",  { input = 0 });

    cmn.StopAllEnv("assets/levels/common/audio/aud_street_env");
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_street_env");
  
  end;

  ObjSet("obj_street_lock",  { input = 1 });

  ObjAnimate( "rm_street", "scale_xy", 0, 0, "", { 0,0,1,1,   1,0,1.5,1.5,  2,0,1.5,1.5,    2.5,0,1,1 } );
  ObjAnimate( "rm_street", "pos_xy",   0, 0, func_after, { 0,0,0,0,   1,0,-67,-210,   2,0,-67,-210,   2.5,0,0,0 } );

  ObjAnimate("fx_street_electric_flash", "alp", 0, 0, "", { 0, 0, 1,   1, 0, 1,    2, 0, 0 });
  ObjAnimate("fx_street_p_parking_fog", "alp", 0, 0, "", { 0, 0, 1,   1, 0, 1,    2, 0, 0 });

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.touch_cardoor()

  cmn.ShowBbt( "obj_neighborcar_use_scrap" );

  ObjSet("anm_neighborcar_touch_door", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_trunk");

end;
---------------------------------------------------------------------------------
function public.touch_mailbox()

  cmn.ShowBbt( "obj_mailbox_use_flag" );

  ObjSet("anm_mailbox_touch_cover", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.Lock(1);
  --cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_trunk");

end;
---------------------------------------------------------------------------------
function public.clk_dog()
  
  local trg_after = function ()
  
    ObjMultiSet({
                {"anm_neighborcar_dog",{playing = 1, alp = 1}},
                {"anm_neighborcar_dog_click",{playing = 0, alp = 0}},
              });  

    cmn.Lock(0);

  end;

  cmn.ShowBbt("neighborcar_open");

  ObjMultiSet({
                {"anm_neighborcar_dog",{playing = 0, alp = 0}},
                {"anm_neighborcar_dog_click",{endtrig = trg_after, playing = 1, alp = 1}},
              });

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_dog");

end;
--*********************************************************************************************************************
-- function *** MMG_POLE *** () end;
--*********************************************************************************************************************
private.zz_pole = {};
public.zz_pole = {};

function private.Init_Pole()

  private.zz_pole.mouse_in = false;

  --private.zz_pole.win_state = { 2, 3, 1, 2, 1 };
  --private.zz_pole.start_state = { 1, 2, 3, 3, 2 };

  ---------------------------------------------------------------------------------
  local win_pole = function ()

    if cmn.IsEventDone( "win_pole" ) then

      ObjDelete("obj_pole_mmg");
      ObjDelete("anm_pole_cro_fly");
      ObjDelete("anm_pole_crow_sits");
      ObjDelete("spr_street_crow");

    end;

  end;

  ---------------------------------------------------------------------------------
  cmn.AddSubscriber( "win_pole", win_pole, private.room_objname );

end;
--********************************************************************************************************************
function private.zz_pole.StartConditions()

  ng_global.progress[ "std" ][ "win_pole" ].skip = 0;

end;
-----------------------------------------------------------------------------------
function public.zz_pole.Reset()

  private.zz_pole.HideBow(1);

end;
-----------------------------------------------------------------------------------
function public.zz_pole.Skip()

  ng_global.progress[ "std" ][ "win_pole" ].skip = 1;

  private.zz_pole.Win();

--  ObjStopAnimate("spr_pole_tergeter", "pos_x");
--  ObjStopAnimate("spr_pole_tergeter", "pos_y");
--
--  ObjMultiSet({
--              {"obj_pole_target", {pos_x = 10, pos_y = -196}},
--              {"obj_pole_bow", {pos_x = 0, pos_y = 128, ang = 0}},
--              {"spr_pole_tergeter", {pos_x = 10, pos_y = -196, alp = 1}},
--              {"anm_pole_shout", {playing = 0, frame = 0}} 
--            }); 
--
--  public.zz_pole.Shoot(10, -196);
--
--  cmn.Lock(1);

end;
-----------------------------------------------------------------------------------
function private.zz_pole.DrawScene()

  if (  ng_global.progress[ "std" ][ "win_pole" ].skip == 1) then
    private.zz_pole.Win();    
  end;
 
end;
-----------------------------------------------------------------------------------
function private.zz_pole.CheckWin(px, py)
  
  local centr = {9, -188}; 
  local accuracy = 20;

  if ( (px - centr[1])^2 + (py - centr[2])^2 ) <= accuracy^2 then 

    return true;

  else

    return false;

  end; 

end;
-----------------------------------------------------------------------------------
function private.zz_pole.Win()

  private.zz_pole.HideBow();

  cmn.MiniGameHide("pole");

  local trg_after = function () 

    cmn.SetEventDone( "win_pole" );

    public.get_policekeys();

  end;

  cmn.Lock(1);

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_takeshotwinpole");

  ObjMultiSet({{"anm_pole_crow_sits", { playing = 0, alp = 0 }},
               {"spr_pole_policekeys", { alp = 1 }},
               {"anm_pole_cro_fly", { endtrig = function ()  cmn.CallEventHandler( "win_pole" ); public.get_bow2(); cmn.Lock(0); end, playing = 1, alp = 1 }}});
  ObjAnimate("spr_pole_policekeys", "scale_xy", 0, 0, trg_after, {0, 0, 1, 1,   0.3, 1, 2, 2});


--  if ng_global.progress[ "std" ][ "win_pole" ].skip == 0 and ng_global.noskipgames[ "win_pole" ] == nil then
--
--    ng_global.noskipgames[ "win_pole" ] = 1;
--    --ld.CheckAchiev("mg");
--
--  end;

end;
-----------------------------------------------------------------------------------
function public.zz_pole.Drag()

  local curspos = GetGameCursorPos();
  
  private.zz_pole.Follow((curspos[1] - 512), (curspos[2] - 384));

end;
-----------------------------------------------------------------------------------
function public.zz_pole.StopDrag()

  if private.zz_pole.mouse_in then
    local curspos = GetGameCursorPos();
    public.zz_pole.Shoot((curspos[1] - 512), (curspos[2] - 384));
    
    public.zz_pole.CursorLeave();
    cmn.Lock(1);
  end;

  interface.DialogHide();

end;
-----------------------------------------------------------------------------------
function public.zz_pole.Shoot(px, py)

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_use_bowstring1");

  local trg_after = function () private.zz_pole.HideBow(1); end;

  ObjStopAnimate("spr_pole_tergeter", "pos_x");
  ObjStopAnimate("spr_pole_tergeter", "pos_y");

  local target_spr_info = ObjGet("spr_pole_tergeter");

  px = px + target_spr_info.pos_x;
  py = py + target_spr_info.pos_y;

  if private.zz_pole.CheckWin(px, py) then
    trg_after = private.zz_pole.Win;
  end;

  ObjAnimate("spr_pole_tergeter", "alp", 0, 0, function () ObjSet("anm_pole_shout", {endtrig = trg_after, playing = 1}); end, 
             {0.0, 0, 1, 
              0.25, 0, 0});

end;
-----------------------------------------------------------------------------------
function private.zz_pole.ShowBow()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_bowtocrow");

  ObjMultiSet({
                {"obj_pole_target", {pos_x = 0, pos_y = 0}},
                {"obj_pole_bow", {pos_x = 0, pos_y = 150, ang = 0}},
                {"spr_pole_tergeter", {pos_x = 0, pos_y = 0, alp = 1}},
                {"anm_pole_shout", {playing = 0, frame = 0}} 
              }); 
  ObjAnimate("obj_pole_mmg", "pos_xy", 0, 0, public.zz_pole.Wiggle, 
             {0, 2, 512, 512, 
              1, 2, 0, 0});
  ObjAnimate("obj_pole_mmg", "ang", 0, 0, function () public.zz_pole.Shoot(9, -188); end, 
             {0, 2, 1.57, 
              1, 2, 0});

  cmn.Lock(1);

end;
-----------------------------------------------------------------------------------
function private.zz_pole.HideBow(reload)

  local trg_after = "";

  if reload then
    trg_after = private.zz_pole.ShowBow;
  end;

  ObjAnimate("obj_pole_mmg", "pos_xy", 0, 0, "", 
             {0, 0, 0, 0, 
              1, 1, 512, 512});
  ObjAnimate("obj_pole_mmg", "ang", 0, 0, trg_after, 
             {0, 0, 0, 
              1, 1, 1.57});

end;
-----------------------------------------------------------------------------------
function private.zz_pole.Follow(px, py)

  local min_xy = -189;
  local max_xy = 189;

  if private.zz_pole.mouse_in then

    if (px < -256) or (py < -256) or (px > 256) or (py > 256) then
    
      public.zz_pole.CursorLeave();

    elseif (px < min_xy) or (py < min_xy) or (px > max_xy) or (py > max_xy) then

      if (px < min_xy)then
        px = min_xy;
      elseif (px > max_xy)then
        px = max_xy;
      end;

      if (py < min_xy)then
        py = min_xy;
      elseif (py > max_xy)then
        py = max_xy;
      end;

      ObjSet("obj_pole_target", {pos_x = px, pos_y = py});
      
      ObjSet("obj_pole_bow", {pos_x = (px/2), pos_y = (py/2) + 150 });

    else   

      ObjSet("obj_pole_target", {pos_x = px, pos_y = py});
      
      ObjSet("obj_pole_bow", {pos_x = (px/2), pos_y = (py/2) + 150 });

    end;

  end;

end;
-----------------------------------------------------------------------------------
function public.zz_pole.Wiggle()

  local dev_x = 50;
  local dev_y = 25;
  local tme_step = 0.5;

  ObjAnimate("spr_pole_tergeter", "pos_x", 1, 0, "", 
             {         0.0, 0, 0, 
              tme_step * 1, 0, dev_x,
              tme_step * 2, 0, 0,
              tme_step * 3, 0, -dev_x,
              tme_step * 4, 0, 0});
  ObjAnimate("spr_pole_tergeter", "pos_y", 1, 0, "", 
             {         0.0, 3, 0, 
              tme_step * 1, 3, dev_y,
              tme_step * 2, 3, 0,
              tme_step * 3, 2, -dev_y,
              tme_step * 4, 1, 0});
     

end;
-----------------------------------------------------------------------------------
function public.zz_pole.CursorEnter()

  SetCursor( CURSOR_NULL );

  private.zz_pole.mouse_in = true;

  ObjStartDrag("obj_pole_target");  

end;
-----------------------------------------------------------------------------------
function public.zz_pole.CursorLeave()
  
  SetCursor( CURSOR_DEFAULT );

  private.zz_pole.mouse_in = false;

  ObjStopDrag(); 

end;
--*********************************************************************************************************************
-- function *** DLG_INSIDECAR *** () end;
--*********************************************************************************************************************
private.dlg_insidecar = {};
public.dlg_insidecar = {};
function private.Init_Incidecar()
  --------------------------------------------------------------------------------------------
  -- function clk_policecarkey1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarkey1" ] = {

      type = "clk",
      use_place = "obj_policecar_clk_door_button",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  local clk_policecarkey1_end = function ()
  
    ObjSet( "obj_insidecar_clk_key", {event_mup = public.dlg_insidecar.clk_key_2} );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_policecarkey1", clk_policecarkey1_end, private.room_objname );
  cmn.AddSubscriber( "clk_policecarkey1_end", clk_policecarkey1_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_policecarkey2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarkey2" ] = {

      type = "clk",
      use_place = "obj_street_keys_hint",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  local clk_policecarkey2_end = function ()
  
    ObjMultiSet({
                  {"obj_insidecar_clk_handle", {input = true}},
                  {"obj_insidecar_clk_handle_bbt", {input = true}},
                  {"dlg_street_insidecar", {pos_y = -100}},
                  {"spr_insidecar_radio_light", {alp = 1}},
                  {"spr_insidecar_green_light", {alp = 1}},
                  {"anm_insidecar_airfresher", {playing = 1}},
                  {"spr_insidecar_red_light", {alp = 0}}
                });

    ObjDelete("obj_insidecar_clk_key");
    ObjDelete("spr_insidecar_key_1");
    ObjDelete("obj_insidecar_light_bbt");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_policecarkey2", clk_policecarkey2_end, private.room_objname );
  cmn.AddSubscriber( "clk_policecarkey2_end", clk_policecarkey2_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_policecarhandle () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarhandle" ] = {

      type = "clk",
      use_place = "obj_street_handle_hint",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  local clk_policecarhandle_end = function ()
  
    ObjSet( "obj_insidecar_clk_pedal", {input = true} );
    ObjSet( "spr_insidecar_handle_2", {alp = 1} );
    ObjSet( "spr_insidecar_letter_r_light", {alp = 1} );

    ObjDelete("spr_insidecar_letter_d_light");
    ObjDelete("obj_insidecar_clk_handle");
    ObjDelete("obj_insidecar_clk_handle_bbt");
    ObjDelete("spr_insidecar_handle_1");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_policecarhandle", clk_policecarhandle_end, private.room_objname );
  cmn.AddSubscriber( "clk_policecarhandle_end", clk_policecarhandle_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_policecarpedal () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarpedal" ] = {

      type = "clk",
      use_place = "obj_street_pedal_hint",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  local clk_policecarpedal_end = function ()
  
     ObjDelete("gzz_street_policecar");
     ObjDelete("dlg_street_insidecar");
     ObjDelete("obj_street_car_hints");

     ObjSet("spr_street_policecar_2", {alp = 1});
     ObjSet("fx_street_p_policecar_2", {active = 1, visible = 1});
     ObjSet("obj_street_clk_cafedoors", {input = 1});
     ObjDelete("spr_street_policecar");
     ObjDelete("fx_street_p_policecar_1");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_policecarpedal", clk_policecarpedal_end, private.room_objname );
  cmn.AddSubscriber( "clk_policecarpedal_end", clk_policecarpedal_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_carradio () end;
  --------------------------------------------------------------------------------------------
  local clk_carradio = function ()
  
     ObjDelete("obj_insidecar_clk_radio");
     ObjSet("obj_insidecar_police_radio_on",  { alp = 1 });
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_carradio", clk_carradio, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function clk_carradiooff () end;
  --------------------------------------------------------------------------------------------
  local clk_carradiooff = function ()
  
     ObjDelete("obj_insidecar_police_radio_on");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_carradiooff", clk_carradiooff, private.room_objname );


end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.clk_policeradio()

  local trg_after = function ()

    cmn.SetEventDone( "clk_carradio" );
    cmn.CallEventHandler( "clk_carradio" );

    cmn.Lock(0);

    ObjSet("tmr_insidecar_police_radio_timer", { endtrig = private.dlg_insidecar.clk_policeradio_off, time = 3, playing = 1 } );

  end;

  cmn.Lock(1);

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_radiocar");

  ObjAnimate("obj_insidecar_police_radio_on", "alp", 0, 0, trg_after,
             { 0.0, 0, 0, 
               0.5, 0, 1 });

end;
-----------------------------------------------------------------------------------
function private.dlg_insidecar.clk_policeradio_off()

  local trg_after = function ()

    cmn.SetEventDone( "clk_carradiooff" );
    cmn.CallEventHandler( "clk_carradiooff" );

    cmn.Lock(0);

  end;

  cmn.Lock(1);

  ObjAnimate("obj_insidecar_police_radio_on", "alp", 0, 0, trg_after,
             { 0.0, 0, 1, 
               0.5, 0, 0 });

end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.clk_key_1()

  local trg_after = function ()

    cmn.SetEventDone( "clk_policecarkey1" );
    cmn.CallEventHandler( "clk_policecarkey1_end" );

    cmn.Lock(0);

  end;

  ObjAnimate("spr_insidecar_key_1", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 0,
              1.3, 0, 0,
              1.6, 0, 1});

  ObjAnimate("spr_insidecar_key_2", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 1,
              1.3, 0, 1,
              1.6, 0, 0});

  ObjAnimate("spr_insidecar_radio_light", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 0,
              0.5, 0, 0.5,
              0.6, 0, 0,
              0.8, 0, 1,
              1.0, 0, 0,
              1.2, 0, 1,
              1.3, 0, 0});
  ObjAnimate("spr_insidecar_green_light", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 0,
              0.5, 0, 1,
              0.6, 0, 0,
              0.8, 0, 1,
              1.0, 0, 0,
              1.2, 0, 1,
              1.3, 0, 0});

  ObjAnimate("spr_insidecar_red_light", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 1,
              0.5, 0, 0,
              0.6, 0, 1,
              0.8, 0, 0,
              1.0, 0, 1,
              1.2, 0, 0,
              1.3, 0, 1});

  ObjAnimate("dlg_street_insidecar", "pos_y", 0, 0, trg_after,
             {0.0, 0, 100, 
              0.3, 0, 100,
              0.5, 0, 102,
              0.6, 0, 98,
              0.8, 0, 102,
              1.0, 0, 98,
              1.2, 0, 102,
              1.4, 0, 98,
              1.6, 0, 100});

  cmn.Lock(1);

end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.clk_key_2()

  local trg_after = function ()

    cmn.SetEventDone( "clk_policecarkey2" );
    cmn.CallEventHandler( "clk_policecarkey2_end" );

    private.dlg_insidecar.shake();

    cmn.ShowBbt( "street_car_voc_1" );
    cmn.PlayAudio("voc", "assets/levels/level1/rm_street/audio/aud_carol_17_voc");
    ObjSet("tmr_insidecar_timer", { time = 2.3, playing = 1, endtrig = function () cmn.Lock(0); end });

    cmn.StopAllEnv("assets/levels/common/audio/aud_street_env");
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_workingcar_env");

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_startthecar");

  ObjAnimate("spr_insidecar_key_1", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 0,});

  ObjAnimate("spr_insidecar_key_2", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 1 });

  ObjAnimate("spr_insidecar_radio_light", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 0,
              0.5, 0, 0.5,
              0.6, 0, 0,
              0.8, 0, 1,
              1.0, 0, 0,
              1.2, 0, 1});
  ObjAnimate("spr_insidecar_green_light", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 0,
              0.5, 0, 1,
              0.6, 0, 0,
              0.8, 0, 1,
              1.0, 0, 0,
              1.2, 0, 1});

  ObjAnimate("spr_insidecar_red_light", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 1,
              0.5, 0, 0,
              0.6, 0, 1,
              0.8, 0, 0,
              1.0, 0, 1,
              1.2, 0, 0});

  ObjAnimate("dlg_street_insidecar", "pos_y", 0, 0, trg_after,
             {0.0, 0, 100, 
              0.3, 0, 100,
              0.5, 0, 102,
              0.6, 0, 98,
              0.8, 0, 102,
              1.0, 0, 98,
              1.2, 0, 102,
              1.4, 0, 98,
              1.6, 0, 100,
              2.0, 3, -100});

  cmn.Lock(1);

end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.clk_handle()

  local trg_after = function ()

    cmn.SetEventDone( "clk_policecarhandle" );
    cmn.CallEventHandler( "clk_policecarhandle_end" );

    cmn.Lock(0);
    cmn.ShowBbt( "street_final_step" );

  end;

  cmn.Lock(1);

  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_gearshift");

  ObjAnimate("spr_insidecar_handle_1", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 0,});
  ObjAnimate("spr_insidecar_handle_2", "alp", 0, 0, trg_after,
             {0.0, 0, 0, 
              0.3, 0, 1 });

  ObjAnimate("spr_insidecar_letter_d_light", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 0,});
  ObjAnimate("spr_insidecar_letter_r_light", "alp", 0, 0, "",
             {0.0, 0, 0, 
              0.3, 0, 1 });

end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.clk_pedal()

  local trg_after = function ()

      local trg_after = function ()

        cmn.SetEventDone( "clk_policecarpedal" );
        cmn.CallEventHandler( "clk_policecarpedal_end" );

        cmn.Lock(0);

        cmn.ShowBbt( "after_insidecar" );

        cmn.StopAllEnv("assets/levels/common/audio/aud_street_env");
        cmn.PlayAudio("env", "assets/levels/common/audio/aud_street_env");
    
      end;

      local trg_after_2 = function ()

        cmn.ShowBbt( "street_car_voc_2" );
        cmn.PlayAudio("voc", "assets/levels/level1/rm_street/audio/aud_carol_18_voc");
    
      end;

      ObjMultiSet( { {"spr_street_policecar", { alp = 0 }},
                     {"fx_street_p_policecar_1", { alp = 0 }},
                     {"spr_street_policecar_2", { alp = 1 }} } );

      ObjAnimate("dlg_street_insidecar", "pos_y", 0, 0, trg_after_2,
           {0.0, 0, -100, 
            0.5, 3,  0,
            0.75, 2,  -75,
            1.0, 1,  100,
            1.3, 2,  50,
            1.5, 3,  100}); 

      ObjAnimate("dlg_street_insidecar", "alp", 0, 0, trg_after,
               {0.0, 0, 1, 
                5.5, 0, 1,
                6.0, 0, 0});

      ObjAnimate("spr_insidecar_back", "scale_xy", 0, 0, "",
                 {0.0, 0, 1.3, 1.3, 
                  1.5, 0, 1, 1 });
     

   end;

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_policecarpedal");

  ObjAnimate("spr_insidecar_brake_pedal", "alp", 0, 0, trg_after,
             {0.0, 0, 1, 
              0.3, 0, 0,});

end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.push_brake_pedal()

 ObjAnimate("spr_insidecar_pedal_up", "alp", 0, 0, "",
             {0.0, 0, 1, 
              0.3, 0, 0,
              0.6, 0, 1});

  ObjAnimate("spr_insidecar_pedal_down", "alp", 0, 0, function () cmn.Lock(0); end,
             {0.0, 0, 0, 
              0.3, 0, 1,
              0.6, 0, 0 });

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_pedal");

end;
-----------------------------------------------------------------------------------
function private.dlg_insidecar.shake()

  ObjAnimate("obj_insidecar_car", "pos_y", 1, 0, "",
             {0.0, 0, 0, 
              0.1, 0, 2,
              0.2, 0, 0,
              0.3, 0, -2,
              0.4, 0, 0});

end;
-----------------------------------------------------------------------------------
function private.dlg_insidecar.open()


  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarkey2" ] = {

      type = "clk",
      use_place = "obj_street_keys_hint",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarhandle" ] = {

      type = "clk",
      use_place = "obj_street_handle_hint",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
   game.hint[ "clk_policecarpedal" ] = {

      type = "clk",
      use_place = "obj_street_pedal_hint",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------



  --if (cmn.IsEventDone("clk_carradio")) and not(cmn.IsEventDone("clk_carradiooff")) then
  --  ObjSet("tmr_insidecar_police_radio_timer", { endtrig = private.dlg_insidecar.clk_policeradio_off, time = 3-private.dlg_insidecar.radio_time, playing = 1 } );
  --end;

  if (cmn.IsEventDone("clk_policecarkey2")) then
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_workingcar_env");
  else
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_policecar_env");
  end;

  trg_after = function ()

    ObjSet("dlg_street_insidecar", {input = 1});
  
    if cmn.IsEventDone("clk_policecarkey2") then
      private.dlg_insidecar.shake();
    end;

    cmn.Lock(0);

    ObjSet("obj_street_lock", {input = 0});

    if not( cmn.IsEventDone("clk_policecarkey2") ) then
      cmn.ShowBbt( "street_get_in_car" );
    end;

  end;

  ObjAttach("dlg_street_insidecar", "rm_street");

  ObjAnimate("dlg_street_insidecar", "alp", 0, 0, trg_after,
           {0.0, 0, 0, 
            0.5, 0, 1});

  cmn.Lock(1);

end;
-----------------------------------------------------------------------------------
function public.dlg_insidecar.close()



  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarkey2" ] = {

      type = "clk",
      use_place = "obj_street_keys_hint",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_policecarhandle" ] = {

      type = "clk",
      use_place = "obj_street_handle_hint",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------
   game.hint[ "clk_policecarpedal" ] = {

      type = "clk",
      use_place = "obj_street_pedal_hint",
      room = private.room_objname,
      zz = "zz_policecar",
      zz_gate = "gzz_street_policecar"
  };
  --------------------------------------------------------------------------------------------



  --if (cmn.IsEventDone("clk_carradio")) and not(cmn.IsEventDone("clk_carradiooff")) then
  --  private.dlg_insidecar.radio_time = TimerGetTime( "tmr_insidecar_police_radio_timer" );
  --end;

  cmn.StopAllEnv("assets/levels/common/audio/aud_street_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_street_env");

  trg_after = function ()

    ObjSet("dlg_street_insidecar", {input = 0});
  
    if cmn.IsEventDone("clk_policecarkey2") then
      ObjStopAnimate("spr_insidecar_back", "alp");
    end;

    ObjDetach("dlg_street_insidecar");

    cmn.Lock(0);

  end;

  ObjAnimate("dlg_street_insidecar", "alp", 0, 0, trg_after,
           {0.0, 0, 1, 
            0.5, 0, 0});

  cmn.Lock(1);

end;
----------------------------------------------------------------------------------