--*********************************************************************************************************************
function public.Init()
  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_parking";

  private.Init_Subroom();
  --------------------------------------------------------------------------------------------
  ObjAttach( "zz_policemotorbike", "room_hub" );
  ObjAttach( "zz_garage", "room_hub" );
  
  --------------------------------------------------------------------------------------------
  -- function get_emptycanister () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_emptycanister" ] = {

      type = "get",
      get_obj = "spr_garage_emptycanister",
      room = private.room_objname,
      zz = "zz_garage",
      zz_gate = "gzz_parking_garage"
  };
  --------------------------------------------------------------------------------------------
  local get_emptycanister_inv = function ()
  
    interface.InventoryItemAdd( "inv_emptycanister", "spr_garage_emptycanister" );
  
  end;
  
  local get_emptycanister_closezz = function ()
  
    ObjDelete( "gfx_garage_emptycanister" );
    ObjDelete( "spr_garage_emptycanister_sh" );

    ObjDelete( "spr_parking_garage_can" );
  
  end;
  
  cmn.AddSubscriber( "get_emptycanister", get_emptycanister_inv );
  cmn.AddSubscriber( "get_emptycanister", get_emptycanister_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_pliers () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_pliers" ] = {

      type = "get",
      get_obj = "spr_garage_pliers",
      room = private.room_objname,
      zz = "zz_garage",
      zz_gate = "gzz_parking_garage"
  };
  --------------------------------------------------------------------------------------------
  local get_pliers_inv = function ()
  
    interface.InventoryItemAdd( "inv_pliers", "spr_garage_pliers" );
  
  end;
  
  local get_pliers_closezz = function ()
  
    ObjDelete( "gfx_garage_pliers" );
    ObjDelete( "spr_garage_pliers_sh" );

    ObjDelete( "spr_parking_garage_pliers" );
  
  end;
  
  cmn.AddSubscriber( "get_pliers", get_pliers_inv );
  cmn.AddSubscriber( "get_pliers", get_pliers_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_valve () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_valve" ] = {

      type = "get",
      get_obj = "spr_garage_valve",
      room = private.room_objname,
      zz = "zz_garage",
      zz_gate = "gzz_parking_garage"
  };
  --------------------------------------------------------------------------------------------
  local get_valve_inv = function ()
  
    interface.InventoryItemAdd( "inv_valve", "spr_garage_valve" );

    int_map_impl.DecreaseRoomTasks("rm_parking");
  
  end;
  
  local get_valve_closezz = function ()
  
    ObjDelete( "gfx_garage_valve" );
    ObjDelete( "spr_garage_valve_sh" );
    ObjDelete( "gzz_parking_garage" );

    ObjDelete( "spr_parking_garage_valve" );
  
  end;
  
  cmn.AddSubscriber( "get_valve", get_valve_inv );
  cmn.AddSubscriber( "get_valve", get_valve_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_photo3 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_photo3" ] = {

      type = "get",
      get_obj = "obj_policemotorbike_get_sticker",
      room = private.room_objname,
      zz = "zz_policemotorbike",
      zz_gate = "gzz_parking_policemotorbike"
  };
  --------------------------------------------------------------------------------------------
  local get_photo3_inv = function ()
  
    interface.InventoryItemAdd( "inv_photo3", "obj_policemotorbike_get_sticker" );
  
  end;
  
  local get_photo3_closezz = function ()
  
    ObjDelete( "gfx_policemotorbike_photo3" );
    ObjDelete( "obj_policemotorbike_get_sticker_2" );

    ObjDelete( "spr_parking_bike_sticker" );
  
  end;
  
  cmn.AddSubscriber( "get_photo3", get_photo3_inv );
  cmn.AddSubscriber( "get_photo3", get_photo3_closezz, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function use_gascanisters () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_gascanisters" ] = {

      type = "use",
      inv_obj = "inv_gascanisters",
      use_place = "obj_policemotorbike_use_gascanisters",
      room = private.room_objname,
      zz = "zz_policemotorbike",
      zz_gate = "gzz_parking_policemotorbike"
  };
  --------------------------------------------------------------------------------------------
  local use_gascanisters_inv = function ()
  
    interface.InventoryItemRemove( "inv_gascanisters" );
  
  end;
  local use_gascanisters_beg = function ()
  
    ObjDelete( "obj_policemotorbike_use_gascanisters" );
  
  end;
  local use_gascanisters_end = function ()
  
    ObjMultiSet( { {"obj_policemotorbike_use_motorbikekey", { input = true, visible = true, active = true }},
                   {"anm_policemotorbike_use_gasoline", { frame = 178 }},
                   {"spr_policemotorbike_arrow", { pos_x = -131, ang = -1.28 }} } );

    ObjDelete( "spr_policemotorbike_open_tank" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_gascanisters", use_gascanisters_beg, private.room_objname );
  cmn.AddSubscriber( "use_gascanisters", use_gascanisters_inv );
  cmn.AddSubscriber( "use_gascanisters", use_gascanisters_end, private.room_objname );
  cmn.AddSubscriber( "use_gascanisters_inv", use_gascanisters_inv, private.room_objname );
  cmn.AddSubscriber( "use_gascanisters_beg", use_gascanisters_beg, private.room_objname );
  cmn.AddSubscriber( "use_gascanisters_end", use_gascanisters_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_motorbikekey () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_motorbikekey" ] = {

      type = "use",
      inv_obj = "inv_motorbikekey",
      use_place = "obj_policemotorbike_use_motorbikekey",
      room = private.room_objname,
      zz = "zz_policemotorbike",
      zz_gate = "gzz_parking_policemotorbike"
  };
  --------------------------------------------------------------------------------------------
  local use_motorbikekey_inv = function ()
  
    interface.InventoryItemRemove( "inv_motorbikekey" );
  
  end;
  local use_motorbikekey_beg = function ()
  
    ObjDelete( "obj_policemotorbike_use_motorbikekey" );
  
  end;
  local use_motorbikekey_end = function ()
  
    ObjMultiSet( { {"obj_policemotorbike_clickmotorbike", { input = true, visible = true, active = true }},
                   {"spr_parking_bike_key", { alp = 1 }},
                   {"spr_policemotorbike_key_1", { alp = 1 }} } );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_motorbikekey", use_motorbikekey_beg, private.room_objname );
  cmn.AddSubscriber( "use_motorbikekey", use_motorbikekey_inv );
  cmn.AddSubscriber( "use_motorbikekey", use_motorbikekey_end, private.room_objname );
  cmn.AddSubscriber( "use_motorbikekey_inv", use_motorbikekey_inv, private.room_objname );
  cmn.AddSubscriber( "use_motorbikekey_beg", use_motorbikekey_beg, private.room_objname );
  cmn.AddSubscriber( "use_motorbikekey_end", use_motorbikekey_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_magnetickey () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_magnetickey" ] = {

      type = "use",
      inv_obj = "inv_magnetickey",
      use_place = "obj_garage_use_magnetickey",
      room = private.room_objname,
      zz = "zz_garage",
      zz_gate = "gzz_parking_garage"
  };
  --------------------------------------------------------------------------------------------
  local use_magnetickey_inv = function ()
  
    interface.InventoryItemRemove( "inv_magnetickey" );
  
  end;
  local use_magnetickey_beg = function ()
  
    ObjDelete( "obj_garage_use_magnetickey" );
  
  end;
  local use_magnetickey_end = function ()
  
    ObjMultiSet( { {"spr_garage_emptycanister", { input = 1 }},
                   {"obj_garage_use_wrench", { input = 1, active = 1, visible = 1 }},
                   --{"spr_garage_light_on", { alp = 1 }},
                   {"spr_parking_garage_open", { alp = 1 }},
                   {"spr_garage_pliers", { input = 1 }} } );

    ObjDelete( "anm_garage_door_touch" );
    ObjDelete( "anm_garage_use_magnetickey" );
    ObjDelete( "spr_garage_gate" );

    ObjDelete( "anm_parking_light_blink" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_magnetickey", use_magnetickey_beg, private.room_objname );
  cmn.AddSubscriber( "use_magnetickey", use_magnetickey_inv );
  cmn.AddSubscriber( "use_magnetickey", use_magnetickey_end, private.room_objname );
  cmn.AddSubscriber( "use_magnetickey_inv", use_magnetickey_inv, private.room_objname );
  cmn.AddSubscriber( "use_magnetickey_beg", use_magnetickey_beg, private.room_objname );
  cmn.AddSubscriber( "use_magnetickey_end", use_magnetickey_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_wrench () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_wrench" ] = {

      type = "use",
      inv_obj = "inv_wrench",
      use_place = "obj_garage_use_wrench",
      room = private.room_objname,
      zz = "zz_garage",
      zz_gate = "gzz_parking_garage"
  };
  --------------------------------------------------------------------------------------------
  local use_wrench_inv = function ()
  
    interface.InventoryItemRemove( "inv_wrench" );
  
  end;
  local use_wrench_beg = function ()
  
    ObjDelete( "obj_garage_use_wrench" );
  
  end;
  local use_wrench_end = function ()
  
    ObjSet( "spr_garage_valve", { input = true, alp = 1 } );

    ObjDelete( "anm_garage_valve_touch" );
    ObjDelete( "anm_garage_use_wrench" );
  
    ObjDelete( "spr_parking_garage_nut" );

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_wrench", use_wrench_beg, private.room_objname );
  cmn.AddSubscriber( "use_wrench", use_wrench_inv );
  cmn.AddSubscriber( "use_wrench", use_wrench_end, private.room_objname );
  cmn.AddSubscriber( "use_wrench_inv", use_wrench_inv, private.room_objname );
  cmn.AddSubscriber( "use_wrench_beg", use_wrench_beg, private.room_objname );
  cmn.AddSubscriber( "use_wrench_end", use_wrench_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_dog () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_dog" ] = {

      type = "use",
      inv_obj = "inv_dog",
      use_place = "obj_parking_use_dog",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local use_dog_inv = function ()
  
    interface.InventoryItemRemove( "inv_dog" );
  
  end;
  local use_dog_beg = function ()
  
    ObjDelete( "obj_parking_use_dog" );
  
  end;
  local use_dog_end = function ()
  
    ObjSet( "grm_parking_policestation", { input = true, visible = true, active = true } );

    ObjDelete( "vid_parking_birds" );
    ObjDelete( "vid_parking_birds_fly" );
    ObjDelete( "vid_parking_birds_angry" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_dog", use_dog_beg, private.room_objname );
  cmn.AddSubscriber( "use_dog", use_dog_inv );
  cmn.AddSubscriber( "use_dog", use_dog_end, private.room_objname );
  cmn.AddSubscriber( "use_dog_inv", use_dog_inv, private.room_objname );
  cmn.AddSubscriber( "use_dog_beg", use_dog_beg, private.room_objname );
  cmn.AddSubscriber( "use_dog_end", use_dog_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickmotorbike () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickmotorbike" ] = {

      type = "click",
      use_place = "obj_policemotorbike_clickmotorbike",
      room = private.room_objname,
      zz = "zz_policemotorbike",
      zz_gate = "gzz_parking_policemotorbike"

  };
  --------------------------------------------------------------------------------------------
  local clk_clickmotorbike_beg = function ()
  
    ObjSet( "obj_policemotorbike_clickmotorbike", { input = false } );
  
  end;
  local clk_clickmotorbike_end = function ()
  
    ObjDelete( "obj_policemotorbike_clickmotorbike" );
    ObjDelete( "gzz_parking_policemotorbike" );
    ObjDelete( "obj_parking_road_bbt" );

    ObjMultiSet( { {"grm_parking_orphanagepark", { input = true, visible = true, active = true }},
                   {"spr_parking_barier", { ang = 1.59 }} } );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickmotorbike", clk_clickmotorbike_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickmotorbike", clk_clickmotorbike_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickmotorbike_beg", clk_clickmotorbike_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickmotorbike_end", clk_clickmotorbike_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_gastankcovermoto () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_gastankcovermoto" ] = {

      type = "clk",
      use_place = "obj_policemotorbike_clk_gastankcover",
      room = private.room_objname,
      zz = "zz_policemotorbike",
      zz_gate = "gzz_parking_policemotorbike"
  };
  --------------------------------------------------------------------------------------------
  local clk_gastankcovermoto = function ()

    ObjMultiSet( { {"obj_policemotorbike_use_gascanisters", { input = 1 }},
                   {"spr_policemotorbike_open_tank", { alp = 1 }} } );

    ObjDelete("obj_policemotorbike_clk_gastankcover");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_gastankcovermoto", clk_gastankcovermoto, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function opn_parking () end;
  --------------------------------------------------------------------------------------------
  local opn_parking = function ()
  
    int_map_impl.OpenRoom( "rm_parking" );

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_parking", opn_parking);
  --------------------------------------------------------------------------------------------
  -- function opn_garagescary () end;
  --------------------------------------------------------------------------------------------
  local opn_garagescary = function ()

    ObjDelete("anm_garage_scary_shadow");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_garagescary", opn_garagescary, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function opn_parkingaftergo () end;
  --------------------------------------------------------------------------------------------
  local opn_parkingaftergo = function ()

    ObjSet("rm_parking",  { color_r = 1, color_g = 1, color_b = 1 });
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_parkingaftergo", opn_parkingaftergo, private.room_objname );

end;
--********************************************************************************************************************
function private.Init_Subroom()
  
  subroom.Define( "zz_garage" );

  function zz_garage.Open()

    if ( cmn.IsEventDone( "get_magnetickey" ) and not(cmn.IsEventDone( "opn_garagescary" )) ) then

      local func_after = function ()

        cmn.Lock(0);
        cmn.CallEventHandler("opn_garagescary");
        cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_howl_mus");
        cmn.ShowBbt( "garage_after_scary" );

      end;

      cmn.SetEventDone("opn_garagescary");
      cmn.Lock(1);
      cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_scaryshadow");
      ObjSet("anm_garage_scary_shadow", {endtrig = func_after, playing = 1, alp = 1});

    end;

  end;

end;
--*********************************************************************************************************************
function public.Load()

end;
--*********************************************************************************************************************
function public.Open()

  private.opn_parking();

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_parking_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_parking_env");

  if (cmn.IsEventDone("clk_clickmotorbike")) and not(cmn.IsEventDone("opn_parkingaftergo")) then
    cmn.SetEventDone("opn_parkingaftergo");
    cmn.CallEventHandler("opn_parkingaftergo");
  end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_gascanisters()

  local item = "inv_gascanisters";

  if cmn.ApplyObj( item, "gzz_parking_policemotorbike" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_policemotorbike" );

  elseif ( cmn.ApplyObj( item, "obj_policemotorbike_use_gascanisters" ) ) then

    cmn.CallEventHandler( "use_gascanisters_inv" );
    cmn.CallEventHandler( "use_gascanisters_beg" );

    if cmn.IsEventDone("clk_gastankcovermoto") then
    
      cmn.Lock( 1 );    
      private.use_gascanisters_beg();

    else 

      public.clk_gastank_cover( true );

    end;

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function private.use_gascanisters_beg()

  local trg_after = function ()

    cmn.Lock( 0 );

    cmn.SetEventDone( "use_gascanisters" );
    cmn.CallEventHandler( "use_gascanisters_end" );

  end;

  local trg_after2 = function ()

    ObjAnimate("spr_policemotorbike_open_tank", "alp", 0, 0, trg_after, { 0, 0, 1,   0.3, 0, 0 });

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_fullcanister");

  ObjSet("anm_policemotorbike_use_gasoline",  { playing = 1, endtrig = trg_after2 });

end;
--------------------------------------------------------------------------------------------
function public.use_motorbikekey()

  local item = "inv_motorbikekey";

  if cmn.ApplyObj( item, "gzz_parking_policemotorbike" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_policemotorbike" );

  elseif ( cmn.ApplyObj( item, "obj_policemotorbike_use_motorbikekey" ) and cmn.IsEventDone("use_gascanisters")) then

    cmn.CallEventHandler( "use_motorbikekey_inv" );
    cmn.CallEventHandler( "use_motorbikekey_beg" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_motorbikekey" );
      cmn.CallEventHandler( "use_motorbikekey_end" );

    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_use_motobykekey");

    ObjAnimate( "spr_policemotorbike_key_1", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.5, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_magnetickey()

  local item = "inv_magnetickey";

  if cmn.ApplyObj( item, "gzz_parking_garage" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_garage" );

  elseif ( cmn.ApplyObj( item, "obj_garage_use_magnetickey" ) ) then

    cmn.CallEventHandler( "use_magnetickey_inv" );
    cmn.CallEventHandler( "use_magnetickey_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_magnetickey" );
      cmn.CallEventHandler( "use_magnetickey_end" );

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_magickey");

    ObjMultiSet( { {"anm_garage_door_touch", { alp = 0 }},
                   {"spr_garage_gate", { alp = 0 }},
                   {"anm_garage_use_magnetickey", { alp = 1, playing = 1, endtrig = trg_after }} } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_wrench()

  local item = "inv_wrench";

  if cmn.ApplyObj( item, "gzz_parking_garage" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_garage" );

  elseif ( cmn.ApplyObj( item, "obj_garage_use_wrench" ) ) then

    cmn.CallEventHandler( "use_wrench_inv" );
    cmn.CallEventHandler( "use_wrench_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_wrench" );
      cmn.CallEventHandler( "use_wrench_end" );
    
    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_wrench");

    ObjSet("anm_garage_valve_touch",  { alp = 0 });
    ObjSet("anm_garage_use_wrench",  { alp = 1, playing = 1, endtrig = trg_after });

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_dog()

  local item = "inv_dog";

  if ( cmn.ApplyObj( item, "obj_parking_use_dog" ) ) then

    cmn.CallEventHandler( "use_dog_inv" );
    cmn.CallEventHandler( "use_dog_beg" );

    local trg_after = function ()

      --cmn.Lock(0);

      cmn.SetEventDone( "use_dog" );
      cmn.CallEventHandler( "use_dog_end" );

    end;

--    cmn.Lock(1);
--
--    ObjSet("vid_parking_birds",  { alp = 0, playing = 0 });
--    ObjAttach("vid_parking_birds_fly", "rm_parking");
--    ObjSet("vid_parking_birds_fly", { endtrig = trg_after, playing = 1, alp = 1 });

    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_parking/vid_dog_attack", trg_after, "assets/levels/level1/rm_parking/audio/aud_dog_attack_mus", "" );

  else

    cmn.WrongApply();  

  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_emptycanister()

  cmn.SetEventDone( "get_emptycanister" );
  cmn.CallEventHandler( "get_emptycanister" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_pliers()

  cmn.SetEventDone( "get_pliers" );
  cmn.CallEventHandler( "get_pliers" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_valve()

  cmn.SetEventDone( "get_valve" );
  cmn.CallEventHandler( "get_valve" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_photo3()

  local func_after = function ()

    cmn.Lock( 0 );

    cmn.SetEventDone( "get_photo3" );
    cmn.CallEventHandler( "get_photo3" );

    cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  end;

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_getnomber");

  ObjSet("anm_policemotorbike_get_sticker",  { playing = 1, endtrig = func_after });

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.clk_clickmotorbike()

  cmn.CallEventHandler( "clk_clickmotorbike_beg" );

  local func_after2 = function ()

    cmn.SetEventDone( "clk_clickmotorbike" );
    cmn.CallEventHandler( "clk_clickmotorbike_end" );

    ObjSet("rm_parking",  { color_r = 0, color_g = 0, color_b = 0 });
    cmn.GotoRoom( "rm_orphanagepark" );

  end;

  local func_after1 = function ()

    cmn.Lock(0);

    common.CloseSubRoom();
    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_parking/vid_go", func_after2, "assets/levels/level1/rm_parking/audio/aud_go_mus", "", 0 );

  end;

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_motobyke_engine");

  ObjAnimate( "spr_policemotorbike_key_1", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

  ObjAnimate( "spr_policemotorbike_key_2", "alp", 0, 0, func_after1, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1,
      1, 0, 1
  } );
  
end;
--------------------------------------------------------------------------------------------
function public.clk_gastank_cover( click )

  local func_after = function ()

    cmn.SetEventDone( "clk_gastankcovermoto" );
    cmn.CallEventHandler( "clk_gastankcovermoto" );

    if click then

      private.use_gascanisters_beg();

    else

      cmn.Lock( 0 );

    end;
  
  end;

  ObjAnimate("spr_policemotorbike_open_tank", "alp", 0, 0, func_after, { 0, 0, 0,   0.5, 0, 1 });

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_opentank");

end;
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_parking()

  if not ( cmn.IsEventDone( "opn_parking" ) ) then
    cmn.ShowBbt( "parking_open" );
    cmn.SetEventDone( "opn_parking" );
    cmn.CallEventHandler( "opn_parking" );
    cmn.PlayAudio("mus", "assets/levels/level1/rm_parking/audio/aud_parking_mus");
  end;

end;
---------------------------------------------------------------------------------
function public.birds_touch()

  local func_after = function ()

    cmn.Lock(0);

    ObjSet("vid_parking_birds",  { alp = 1, playing = 1 });
    ObjSet("vid_parking_birds_angry", { alp = 0 });
    ObjDetach("vid_parking_birds_angry");

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_xx_crows");

  ObjSet("vid_parking_birds",  { alp = 0, playing = 0 });
  ObjAttach("vid_parking_birds_angry", "rm_parking");
  ObjSet("vid_parking_birds_angry", { frame = 0, alp = 1 });
  VidPlay("vid_parking_birds_angry", func_after);

  cmn.ShowBbt( "obj_parking_use_dog" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.door_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_xx_garage");

  ObjSet("anm_garage_door_touch", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.ShowBbt( "obj_garage_use_magnetickey" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
function public.valve_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_parking/audio/aud_xx_valve");

  ObjSet("anm_garage_valve_touch", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.ShowBbt( "obj_garage_use_wrench" );

  cmn.Lock(1);

end;
---------------------------------------------------------------------------------
--********************************************************************************************************************