--*********************************************************************************************************************
function public.Init()
  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_orphanagepark";

  private.Init_Subroom();
  private.Init_Foyerentrance();
  --------------------------------------------------------------------------------------------
  ObjAttach( "zz_foyerentrance", "room_hub" );
  ObjAttach( "zz_arbor", "room_hub" );
  ObjAttach( "zz_tree", "room_hub" );
  
  ObjSet( "spr_foyerentrance_pruner", { event_mdown = private.get_pruner } );
  ObjSet( "spr_tree_wings", { event_mdown = private.get_wings } );
  
  --------------------------------------------------------------------------------------------
  -- function get_pruner () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_pruner" ] = {

      type = "get",
      get_obj = "spr_foyerentrance_pruner",
      room = private.room_objname,
      zz = "zz_foyerentrance",
      zz_gate = "gzz_orphanagepark_foyerentrance"
  };
  --------------------------------------------------------------------------------------------
  local get_pruner_inv = function ()
  
    interface.InventoryItemAdd( "inv_pruner", "spr_foyerentrance_pruner" );
  
  end;
  
  local get_pruner_closezz = function ()
  
    ObjDelete( "gfx_foyerentrance_pruner" );
    ObjDelete( "spr_foyerentrance_pruner_sh" );

  end;
  
  cmn.AddSubscriber( "get_pruner", get_pruner_inv );
  cmn.AddSubscriber( "get_pruner", get_pruner_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_wings () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_wings" ] = {

      type = "get",
      get_obj = "spr_tree_wings",
      room = private.room_objname,
      zz = "zz_tree",
      zz_gate = "gzz_orphanagepark_tree"
  };
  --------------------------------------------------------------------------------------------
  local get_wings_inv = function ()
  
    interface.InventoryItemAdd( "inv_wings", "spr_tree_wings" );
  
  end;
  
  local get_wings_closezz = function ()
  
    ObjDelete( "gfx_tree_wings" );

    ObjDelete( "spr_orphanagepark_wings" );

    if (cmn.IsEventDone("use_stairs")) then
      ObjDelete( "gzz_orphanagepark_tree" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_wings", get_wings_inv );
  cmn.AddSubscriber( "get_wings", get_wings_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_flute () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_flute" ] = {

      type = "get",
      get_obj = "obj_orphanagepark_simon_hint_3",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  local get_flute_inv = function ()
  
    interface.InventoryItemAdd( "inv_flute", "spr_orphanagepark_flute" );
    int_map_impl.AddDiarypage(3);
  
  end;
  
  local get_flute_closedlg = function ()
  
    ObjDelete( "dlg_orphanagepark_simon" );
    ObjDelete( "obj_orphanagepark_flute_hint" );
  
  end;
  
  cmn.AddSubscriber( "get_flute", get_flute_inv );
  cmn.AddSubscriber( "get_flute_inv", get_flute_inv, private.room_objname );
  cmn.AddSubscriber( "get_flute", get_flute_closedlg, private.room_objname );
  cmn.AddSubscriber( "get_flute_closedlg", get_flute_closedlg, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_wings () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_wings" ] = {

      type = "use",
      inv_obj = "inv_wings",
      use_place = "obj_foyerentrance_use_wings",
      room = private.room_objname,
      zz = "zz_foyerentrance",
      zz_gate = "gzz_orphanagepark_foyerentrance"
  };
  --------------------------------------------------------------------------------------------
  local use_wings_inv = function ()
  
    interface.InventoryItemRemove( "inv_wings" );
  
  end;
  local use_wings_beg = function ()
  
    ObjDelete( "obj_foyerentrance_use_wings" );
  
  end;
  local use_wings_end = function ()

    ObjSet( "spr_foyerentrance_angelpart_5", { alp = 1 } );
  
    if (cmn.IsEventDone("use_flute")) then
      ObjSet( "obj_foyerentrance_game", { input = 1 } );
      ObjDelete("obj_foyerentrance_door_touch");
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_wings", use_wings_beg, private.room_objname );
  cmn.AddSubscriber( "use_wings", use_wings_inv );
  cmn.AddSubscriber( "use_wings", use_wings_end, private.room_objname );
  cmn.AddSubscriber( "use_wings_inv", use_wings_inv, private.room_objname );
  cmn.AddSubscriber( "use_wings_beg", use_wings_beg, private.room_objname );
  cmn.AddSubscriber( "use_wings_end", use_wings_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_flute () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_flute" ] = {

      type = "use",
      inv_obj = "inv_flute",
      use_place = "obj_foyerentrance_use_flute",
      room = private.room_objname,
      zz = "zz_foyerentrance",
      zz_gate = "gzz_orphanagepark_foyerentrance"
  };
  --------------------------------------------------------------------------------------------
  local use_flute_inv = function ()
  
    interface.InventoryItemRemove( "inv_flute" );
  
  end;
  local use_flute_beg = function ()
  
    ObjDelete( "obj_foyerentrance_use_flute" );
  
  end;
  local use_flute_end = function ()

    ObjSet( "spr_foyerentrance_angelpart_4", { alp = 1 } );

    if (cmn.IsEventDone("use_wings")) then
      ObjSet( "obj_foyerentrance_game", { input = 1 } );
      ObjDelete("obj_foyerentrance_door_touch");
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_flute", use_flute_beg, private.room_objname );
  cmn.AddSubscriber( "use_flute", use_flute_inv );
  cmn.AddSubscriber( "use_flute", use_flute_end, private.room_objname );
  cmn.AddSubscriber( "use_flute_inv", use_flute_inv, private.room_objname );
  cmn.AddSubscriber( "use_flute_beg", use_flute_beg, private.room_objname );
  cmn.AddSubscriber( "use_flute_end", use_flute_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_doorhandle () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_doorhandle" ] = {

      type = "use",
      inv_obj = "inv_doorhandle",
      use_place = "obj_arbor_use_doorhandle",
      room = private.room_objname,
      zz = "zz_arbor",
      zz_gate = "gzz_orphanagepark_arbor"
  };
  --------------------------------------------------------------------------------------------
  local use_doorhandle_inv = function ()
  
    interface.InventoryItemRemove( "inv_doorhandle" );
  
  end;
  local use_doorhandle_beg = function ()
  
    ObjDelete( "obj_arbor_use_doorhandle" );
    ObjDelete( "anm_arbor_door_touch" );
  
  end;
  local use_doorhandle_end = function ()
  
    ObjSet( "gho_orphanagepark_hooldthings", { input = true, visible = true, active = true } );

    ObjDelete( "gzz_orphanagepark_arbor" );
    ObjDelete( "spr_orphanagepark_arbor_door" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_doorhandle", use_doorhandle_beg, private.room_objname );
  cmn.AddSubscriber( "use_doorhandle", use_doorhandle_inv );
  cmn.AddSubscriber( "use_doorhandle", use_doorhandle_end, private.room_objname );
  cmn.AddSubscriber( "use_doorhandle_inv", use_doorhandle_inv, private.room_objname );
  cmn.AddSubscriber( "use_doorhandle_beg", use_doorhandle_beg, private.room_objname );
  cmn.AddSubscriber( "use_doorhandle_end", use_doorhandle_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_stairs () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_stairs" ] = {

      type = "use",
      inv_obj = "inv_stairs",
      use_place = "obj_tree_use_stairs",
      room = private.room_objname,
      zz = "zz_tree",
      zz_gate = "gzz_orphanagepark_tree"
  };
  --------------------------------------------------------------------------------------------
  local use_stairs_inv = function ()
  
    interface.InventoryItemRemove( "inv_stairs" );
  
  end;
  local use_stairs_beg = function ()
  
    ObjDelete( "obj_tree_use_stairs" );
    ObjSet( "spr_tree_ladder", {alp = 1 } );

    ObjDelete("anm_tree_simon");
    ObjDelete("anm_tree_simon_head");
  
  end;
  local use_stairs_end = function ()
  
    ObjMultiSet( { {"spr_orphanagepark_tree_stairs", { alp = 1 }},
                   {"obj_orphanagepark_simon_bbt", { input = 1 }},
                   {"anm_orphanagepark_tree_simon_2", { alp = 1, playing = 1 }} } );

    ObjDelete("anm_tree_saimon_get_out");
    ObjDelete("anm_orphanagepark_tree_simon");

    if (cmn.IsEventDone("get_wings")) then
      ObjDelete( "gzz_orphanagepark_tree" );
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_stairs", use_stairs_beg, private.room_objname );
  cmn.AddSubscriber( "use_stairs", use_stairs_inv );
  cmn.AddSubscriber( "use_stairs", use_stairs_end, private.room_objname );
  cmn.AddSubscriber( "use_stairs_inv", use_stairs_inv, private.room_objname );
  cmn.AddSubscriber( "use_stairs_beg", use_stairs_beg, private.room_objname );
  cmn.AddSubscriber( "use_stairs_end", use_stairs_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_speaker () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_speaker" ] = {

      type = "use",
      inv_obj = "inv_speaker",
      use_place = "obj_orphanagepark_use_speaker",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local use_speaker_inv = function ()
  
    interface.InventoryItemRemove( "inv_speaker" );
  
  end;
  local use_speaker_beg = function ()
  
    ObjDelete( "obj_orphanagepark_use_speaker" );
  
  end;
  local use_speaker_end = function ()
  
    ObjSet( "gzz_orphanagepark_foyerentrance", { input = true, visible = true, active = true } );
    ObjSet( "gzz_orphanagepark_arbor", { input = true, visible = true, active = true } );

    ObjDelete( "vid_orphanagepark_birds" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_speaker", use_speaker_beg, private.room_objname );
  cmn.AddSubscriber( "use_speaker", use_speaker_inv );
  cmn.AddSubscriber( "use_speaker", use_speaker_end, private.room_objname );
  cmn.AddSubscriber( "use_speaker_inv", use_speaker_inv, private.room_objname );
  cmn.AddSubscriber( "use_speaker_beg", use_speaker_beg, private.room_objname );
  cmn.AddSubscriber( "use_speaker_end", use_speaker_end, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function clk_simondialoganswer1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_simondialoganswer1" ] = {

      type = "click",
      use_place = "obj_orphanagepark_simon_hint_2",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_simondialoganswer1 = function ()

    ObjMultiSet( { {"obj_orphanagepark_dialog_answer_1", { active = 1, visible = 1, input = 1 }},
                   {"txt_orphanagepark_dialog_answer_1_text_2", { alp = 1 }},
                   {"txt_orphanagepark_dialog_answer_2_text_2", { alp = 1 }},
                   {"obj_orphanagepark_dialog_answer_2", { pos_y = 84 }} } );

    ObjDelete( "txt_orphanagepark_dialog_answer_1_text" );
    ObjDelete( "txt_orphanagepark_dialog_answer_2_text" );

    ObjDelete("vid_orphanagepark_simon_talks_3_1");
    ObjDelete("vid_orphanagepark_simon_talks_3_2");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_simondialoganswer1", clk_simondialoganswer1, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_simondialoganswer2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_simondialoganswer2" ] = {

      type = "click",
      use_place = "obj_orphanagepark_simon_hint",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_simondialoganswer2 = function ()

    ObjSet("spr_orphanagepark_simon_hand_3",  { alp = 1, input = 1 });

    ObjDelete("obj_orphanagepark_simon_choice");
    ObjDelete("spr_orphanagepark_simon_hand_1");
    ObjDelete("spr_orphanagepark_simon_hand_2");

    ObjDelete("vid_orphanagepark_simon_talks_4");
    ObjDelete("vid_orphanagepark_simon_talks_5");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_simondialoganswer2", clk_simondialoganswer2, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_asksimonsname () end;
  --------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------
  local clk_asksimonsname = function ()

    ObjMultiSet( { {"obj_orphanagepark_dialog_answer_1", { active = 0, visible = 0, input = 0 }},
                   {"obj_orphanagepark_dialog_answer_2", { pos_y = 44 }},
                   {"obj_orphanagepark_simon_hint_2", { pos_y = 424 }} } );

    ObjDelete("vid_orphanagepark_simon_talks_2");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_asksimonsname", clk_asksimonsname, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function opn_orphanagepark () end;
  --------------------------------------------------------------------------------------------
  local opn_orphanagepark = function ()
  
    int_map_impl.OpenRoom( "rm_orphanagepark" );

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_orphanagepark", opn_orphanagepark);
  --------------------------------------------------------------------------------------------
  -- function opn_simondialog () end;
  --------------------------------------------------------------------------------------------
  local opn_simondialog = function ()

    --ObjDelete("vid_livingroom_dialog_mary_1");
    --ObjDelete("vid_livingroom_dialog_mary_2");

    ObjAttach("dlg_orphanagepark_simon", "rm_orphanagepark");

    ObjMultiSet( { {"dlg_orphanagepark_simon", { alp = 1, input = 1 }},
                   {"obj_orphanagepark_simon_choice", { alp = 1, input = 1 }} } );

    ObjDelete("anm_tree_simon");
    ObjDelete("vid_orphanagepark_simon_talks_1");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_simondialog", opn_simondialog, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function opn_tree () end;
  --------------------------------------------------------------------------------------------
  local opn_tree = function ()

    ObjSet("anm_tree_simon_head",  { alp = 1, playing = 1 });

    ObjDelete("vid_tree_simon_talks");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_tree", opn_tree, private.room_objname );

end;
--********************************************************************************************************************
function private.Init_Subroom()
  
  subroom.Define( "zz_tree" );
  subroom.Define( "zz_foyerentrance" );

  function zz_tree.Open()

    if not(cmn.IsEventDone( "opn_tree" )) then
      cmn.SetEventDone("opn_tree");
      private.play_simon_voice();
    end;

  end;

  function zz_tree.PreClose()

    if ( cmn.IsEventDone( "use_stairs" ) and not(cmn.IsEventDone( "opn_simondialog" )) ) then
      private.show_dialog();
    end;

  end;

  function zz_foyerentrance.PreOpen()
    
    if ( cmn.IsEventDone( "use_wings" ) and ( cmn.IsEventDone( "use_flute" )) and not(cmn.IsEventDone( "win_foyerentrance" )) ) then
      private.zz_foyerentrance.DrawScene();
      private.zz_foyerentrance.CheckWin();
      cmn.MiniGameShow();
    end;

  end;

  function zz_foyerentrance.PreClose()

    if ( cmn.IsEventDone( "use_wings" ) and ( cmn.IsEventDone( "use_flute" )) and not(cmn.IsEventDone( "win_foyerentrance" )) ) then
      cmn.MiniGameHide("foyerentrance");
    end;

  end;

end;
--*********************************************************************************************************************
function public.Load()

  if not( cmn.IsEventDone( "use_wings" ) and cmn.IsEventDone( "use_flute" )) then
    private.zz_foyerentrance.StartConditions();
  end;

  private.zz_foyerentrance.state = ng_global.progress[ "std" ][ "win_foyerentrance" ].state;

end;
--*********************************************************************************************************************
function public.Open()

  private.opn_orphanagepark();

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_orphanagepark_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_orphanagepark_env");

  --if (cmn.IsEventDone("opn_simondialog")) and not(cmn.IsEventDone("get_flute")) then
  --  private.AnimDialogView();
  --end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_wings()

  local item = "inv_wings";

  if cmn.ApplyObj( item, "gzz_orphanagepark_foyerentrance" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_foyerentrance" );

  elseif ( cmn.ApplyObj( item, "obj_foyerentrance_door_touch" ) ) then

    cmn.CallEventHandler( "use_wings_inv" );
    cmn.CallEventHandler( "use_wings_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_wings" );
      cmn.CallEventHandler( "use_wings_end" );

      if (cmn.IsEventDone("use_flute")) then
        cmn.MiniGameShow();
      end;

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_usehorn");

    ObjAnimate( "spr_foyerentrance_angelpart_5", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.5, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_flute()

  local item = "inv_flute";

  if cmn.ApplyObj( item, "gzz_orphanagepark_foyerentrance" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_foyerentrance" );

  elseif ( cmn.ApplyObj( item, "obj_foyerentrance_door_touch" ) ) then

    cmn.CallEventHandler( "use_flute_inv" );
    cmn.CallEventHandler( "use_flute_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_flute" );
      cmn.CallEventHandler( "use_flute_end" );

      if (cmn.IsEventDone("use_wings")) then
        cmn.MiniGameShow();
      end;

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_usehorn");

    ObjAnimate( "spr_foyerentrance_angelpart_4", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.5, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_doorhandle()

  local item = "inv_doorhandle";

  if cmn.ApplyObj( item, "gzz_orphanagepark_arbor" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_arbor" );

  elseif ( cmn.ApplyObj( item, "obj_arbor_use_doorhandle" ) ) then

    cmn.CallEventHandler( "use_doorhandle_inv" );
    cmn.CallEventHandler( "use_doorhandle_beg" );

    local trg_after = function ()

      local trg_after2 = function ()

        cmn.Lock(0);

        cmn.SetEventDone( "use_doorhandle" );
        cmn.CallEventHandler( "use_doorhandle_end" );

        common.CloseSubRoom();

      end;

      ObjAnimate("spr_arbor_door", "alp", 0, 0, trg_after2, { 0, 0, 1,   0.5, 0, 1,   1, 0, 0 });

      ObjAnimate("spr_arbor_door_handle_sh", "ang", 0, 0, "", { 0, 0, 0,   0.5, 0, 0.16 });

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_use_handle");

    ObjSet("spr_arbor_door",  { alp = 1 });

    ObjAnimate( "spr_arbor_door_handle_sh", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.5, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_stairs()

  local item = "inv_stairs";

  if cmn.ApplyObj( item, "gzz_orphanagepark_tree" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_tree" );

  elseif ( cmn.ApplyObj( item, "obj_tree_use_stairs" ) ) then

    cmn.CallEventHandler( "use_stairs_inv" );

    local trg_after = function ()

      local trg_after = function ()

        cmn.Lock(0);

        cmn.SetEventDone( "use_stairs" );
        cmn.CallEventHandler( "use_stairs_end" );

        common.CloseSubRoom();

      end;

      cmn.CallEventHandler( "use_stairs_beg" );

      ObjSet("anm_tree_saimon_get_out", {endtrig = trg_after, playing = 1, alp = 1});

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_usestairs");

    ObjAnimate( "spr_tree_ladder", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.3, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_speaker()

  local item = "inv_speaker";

  if ( cmn.ApplyObj( item, "obj_orphanagepark_use_speaker" ) ) then

    cmn.CallEventHandler( "use_speaker_inv" );
    cmn.CallEventHandler( "use_speaker_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_speaker" );
      cmn.CallEventHandler( "use_speaker_end" );

      cmn.PlayAudio("mus", "assets/levels/level1/rm_orphanagepark/audio/aud_surface7_long_mus");

    end;

    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_orphanagepark/vid_megaphoneuse", trg_after, "assets/levels/level1/rm_orphanagepark/audio/aud_megaphoneuse_mus", "" );

  else

    cmn.WrongApply();  

  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_pruner()

  cmn.SetEventDone( "get_pruner" );
  cmn.CallEventHandler( "get_pruner" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_wings()

  cmn.SetEventDone( "get_wings" );
  cmn.CallEventHandler( "get_wings" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if (cmn.IsEventDone("use_stairs")) then
    common.CloseSubRoom();
  end;

end;
--------------------------------------------------------------------------------------------
function public.get_flute()

  cmn.SetEventDone( "get_flute" );
  cmn.CallEventHandler( "get_flute_inv" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  cmn.Lock(1);
  private.hide_dialog();

  --if (cmn.IsEventDone("get_wings")) then
  --  common.CloseSubRoom();
  --end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_orphanagepark()

  if not ( cmn.IsEventDone( "opn_orphanagepark" ) ) then
    cmn.SetEventDone( "opn_orphanagepark" );
    cmn.CallEventHandler( "opn_orphanagepark" );

    cmn.ShowBbt( "orphanagepark_open" );
  end;

end;
--------------------------------------------------------------------------------------------
function private.play_simon_voice()

  local func_after = function ()

    cmn.Lock(0);

    cmn.ShowBbt( "after_simon_talks" );
    cmn.CallEventHandler("opn_tree");

  end;

  cmn.Lock(1);

  cmn.ShowDlgBbt( "simon_voc_1" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_1_voc");

  ObjSet("vid_tree_simon_talks",  { playing = 1, endtrig = func_after });

end;
--------------------------------------------------------------------------------------------
function public.door_touch( num )

  --cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_xx_switchboard");

  ObjSet("anm_foyerentrance_touch_door", {endtrig = function () cmn.Lock(0); end, playing = 1});

  if (num == 1) then
    cmn.ShowBbt( "obj_foyerentrance_use_wings" );
  elseif (num == 2) then
    cmn.ShowBbt( "obj_foyerentrance_use_flute" );
  elseif (num == 3) then
    cmn.ShowBbt( "obj_foyerentrance_door_touch" );
  end;

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_xx_door_handle");

end;
---------------------------------------------------------------------------------
function private.show_dialog()

  cmn.Lock( 1 );
  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_howl_2_mus");

  ObjAttach("dlg_orphanagepark_simon", "rm_orphanagepark");
  ObjSet("dlg_orphanagepark_simon",  { input = 1 });

  --private.AnimDialogView();

  ObjAnimate( "dlg_orphanagepark_simon", "alp", 0, 0, private.opn_dialog_simonspeaks, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

end;
--------------------------------------------------------------------------------------------
function private.hide_dialog()

  int_blackbartext.Hide();

  ObjAnimate( "dlg_orphanagepark_simon", "alp", 0, 0, function () cmn.Lock(0); cmn.CallEventHandler( "get_flute_closedlg" ); end, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------
function private.opn_dialog_simonspeaks()

  cmn.SetEventDone( "opn_simondialog" );

  cmn.ShowDlgBbt( "dlg_simon_phrase_1" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_2_voc");

  --ObjSet("tmr_orphanagepark_simon_timer",  { time = 7.3, playing = 1, endtrig = function () private.opn_dialog_show_answers(1) end });
  ObjSet("vid_orphanagepark_simon_talks_1",  { playing = 1, endtrig = function () private.opn_dialog_show_answers(1) end });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_simonspeaks2()

  local func_after = function ()

    cmn.ShowDlgBbt( "dlg_simon_answer_2" );

    cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_carol_21_voc");
    ObjSet("tmr_orphanagepark_simon_timer",  { time = 1.6, playing = 1, endtrig = function ()  cmn.CallEventHandler( "clk_asksimonsname" ); private.opn_dialog_show_answers(2) end });
  
  end;

  cmn.ShowDlgBbt( "dlg_simon_phrase_2" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_3_voc");

  --ObjSet("tmr_orphanagepark_simon_timer",  { time = 1.5, playing = 1, endtrig = func_after });

  ObjAttach("vid_orphanagepark_simon_talks_2", "obj_orphanagepark_simon_plan_1");
  ObjSet("vid_orphanagepark_simon_talks_2",  { playing = 1, endtrig = func_after });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_simonspeaks3()

  local func_after = function ()

    if (cmn.IsEventDone("clk_asksimonsname")) then
      cmn.ShowDlgBbt( "dlg_simon_phrase_3_2" );
    else 
      cmn.ShowDlgBbt( "dlg_simon_phrase_3_2_noname" );
    end;

    ObjDetach("vid_orphanagepark_simon_talks_3_1");
    ObjAttach("vid_orphanagepark_simon_talks_3_2", "obj_orphanagepark_simon_plan_1");
    ObjSet("vid_orphanagepark_simon_talks_3_2",  { playing = 1, endtrig = function () cmn.CallEventHandler( "clk_simondialoganswer1" ); private.opn_dialog_show_answers(3) end });

    cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_5_voc");
    --ObjSet("tmr_orphanagepark_simon_timer",  { time = 4.5, playing = 1, endtrig = function () cmn.CallEventHandler( "clk_simondialoganswer1" ); private.opn_dialog_show_answers(3) end });

  end;

  if (cmn.IsEventDone("clk_asksimonsname")) then
    cmn.ShowDlgBbt( "dlg_simon_phrase_3_1" );
  else 
    cmn.ShowDlgBbt( "dlg_simon_phrase_3_1_noname" );
  end;
  cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_4_voc");

  --ObjSet("tmr_orphanagepark_simon_timer",  { time = 4.8, playing = 1, endtrig = func_after });

  ObjAttach("vid_orphanagepark_simon_talks_3_1", "obj_orphanagepark_simon_plan_1");
  ObjSet("vid_orphanagepark_simon_talks_3_1",  { playing = 1, endtrig = func_after });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_simonspeaks4()

  if (cmn.IsEventDone("clk_asksimonsname")) then
    cmn.ShowDlgBbt( "dlg_simon_phrase_4" );
  else 
    cmn.ShowDlgBbt( "dlg_simon_phrase_4_noname" );
  end;
  cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_6_voc");

  if not(cmn.IsEventDone("clk_asksimonsname")) then
    ObjSet("tmr_orphanagepark_simon_timer",  { time = 4, playing = 1, endtrig = private.opn_dialog_simonspeaks5 });
  else 
    ObjSet("tmr_orphanagepark_simon_timer",  { time = 4, playing = 1, endtrig = function () cmn.Lock(0); cmn.CallEventHandler( "clk_simondialoganswer2" ); end });
  end;

  ObjAnimate("spr_orphanagepark_simon_hand_1", "alp", 0, 0, "", { 0, 0, 1,   0.5, 0, 0 });
  ObjAnimate("spr_orphanagepark_simon_hand_2", "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1,   1, 0, 1,  1.5, 0, 0 });
  ObjAnimate("spr_orphanagepark_simon_hand_3", "alp", 0, 0, "", { 0, 0, 0,   1, 0, 0,  1.5, 0, 1 });

  --ObjDetach("vid_livingroom_dialog_mary_3");
  ObjAttach("vid_orphanagepark_simon_talks_4", "obj_orphanagepark_simon_plan_1");
  ObjSet("vid_orphanagepark_simon_talks_4",  { playing = 1 });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_simonspeaks5()

  cmn.ShowDlgBbt( "dlg_simon_phrase_5" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_simon_7_voc");

  ObjSet("tmr_orphanagepark_simon_timer",  { time = 5.2, playing = 1, endtrig = function () cmn.Lock(0);  cmn.CallEventHandler( "clk_simondialoganswer2" );  end });

  ObjDetach("vid_orphanagepark_simon_talks_4");
  ObjAttach("vid_orphanagepark_simon_talks_5", "obj_orphanagepark_simon_plan_1");
  ObjSet("vid_orphanagepark_simon_talks_5",  { playing = 1 });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_show_answers( step )

  local func_after = function ()

    cmn.Lock( 0 );
    cmn.CallEventHandler( "opn_simondialog" );
  
  end;

  if (step == 2) then

    func_after = function ()

      cmn.Lock( 0 );
    
    end;

  elseif (step == 3) then

    func_after = function ()

      cmn.Lock( 0 );
    
    end;

  end;

  ObjAnimate( "obj_orphanagepark_simon_choice", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

end;
--------------------------------------------------------------------------------------------
function public.dialog_choose_answer( num )

  if not(cmn.IsEventDone("clk_simondialoganswer1")) then

    cmn.Lock( 1 );
    cmn.ShowDlgBbt( "dlg_simon_answer_1_"..num );

    if (num == 1) then

      cmn.SetEventDone( "clk_asksimonsname" );

      cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_carol_19_voc");
      ObjSet("tmr_orphanagepark_simon_timer",  { time = 1.6, playing = 1, endtrig = private.opn_dialog_simonspeaks2 });

    else 

      cmn.SetEventDone( "clk_simondialoganswer1" );

      cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_carol_20_voc");
      ObjSet("tmr_orphanagepark_simon_timer",  { time = 2, playing = 1, endtrig = private.opn_dialog_simonspeaks3 });

    end;

  else

    cmn.SetEventDone( "clk_simondialoganswer2" );

    cmn.Lock( 1 );
    cmn.ShowDlgBbt( "dlg_simon_answer_3_"..num );

    if (num == 1) then

      cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_carol_22_voc");
      ObjSet("tmr_orphanagepark_simon_timer",  { time = 2.5, playing = 1, endtrig = private.opn_dialog_simonspeaks4 });

    else 

      cmn.PlayAudio("voc", "assets/levels/level1/rm_orphanagepark/audio/aud_carol_23_voc");
      ObjSet("tmr_orphanagepark_simon_timer",  { time = 2.8, playing = 1, endtrig = private.opn_dialog_simonspeaks4 });

    end;

  end;

  ObjAnimate( "obj_orphanagepark_simon_choice", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
function public.touch_wing()

  cmn.ShowBbt( "obj_tree_use_pruner" );

  ObjSet("anm_tree_touch_wing", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_xx_bush");
  
end;
--------------------------------------------------------------------------------------------
function public.touch_arbor_door()

  cmn.ShowBbt( "obj_arbor_use_doorhandle" );

  ObjSet("anm_arbor_door_touch", {endtrig = function () cmn.Lock(0); end, playing = 1});

  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_doorlock");
  
end;
--*********************************************************************************************************************
--*********************************************************************************************************************
--***function *** Prolax *** () end ************************************************************************************
--*********************************************************************************************************************
  --------------------------------------------------------------------
  private.del_plan = { {40, 10}, {10, 5} }; 
  --------------------------------------------------------------------
  function private.AnimDialogView()

    local cur_x = GetGameCursorPos()[1];
    local cur_y = GetGameCursorPos()[2];

    local del_x = 512 - cur_x;
    local del_y = 384 - cur_y;

    local move_x = (del_x/683);
    local move_y = (del_y/384);

    for i = 1, 2, 1 do

      ObjSet("obj_orphanagepark_simon_plan_"..i,  { pos_x = math.floor(move_x * private.del_plan[i][1]),  pos_y = math.floor(move_y * private.del_plan[i][2]) });

    end;

    ObjSet("tmr_orphanagepark_simon_timer_2",  { time = 0.01, playing = 1, endtrig = private.AnimDialogView });

  end;
--*****************************************************************************************
--*********************************************************************************************************************
-- function *** MMG_foyerentrance *** () end;
--*********************************************************************************************************************
--********************************************************************************************************************
private.zz_foyerentrance = {};
public.zz_foyerentrance = {};

function private.Init_Foyerentrance()

  private.zz_foyerentrance.win_state = { 1, 1, 1, 1, 1 };
  private.zz_foyerentrance.start_state = { 3, 2, 2, 2, 3 };

  private.zz_foyerentrance.parts_pos = { {0, -0.38, -0.76}, {0, -0.5, -1}, {0, 0.28, 0.56}, {0, 0.38, 0.76}, {0, -0.32, -0.64} };

  --------------------------------------------------------------------------------------------
  game.hint[ "win_foyerentrance" ] = {

      type = "click",
      use_place = "obj_foyerentrance_game",
      room = "rm_orphanagepark",
      zz = "zz_foyerentrance",
      zz_gate = "gzz_orphanagepark_foyerentrance"
  };
  -----------------------------------------------------------------------------------
  local win_foyerentrance = function ()

    if cmn.IsEventDone( "win_foyerentrance" ) then

      ObjMultiSet( { {"grm_orphanagepark_foyer", { input = true, visible = true, active = true }},
                     {"spr_orphanagepark_entrance_open", { alp = 1 }} } );

      ObjDelete( "gzz_orphanagepark_foyerentrance" );

    end;

  end;

  -----------------------------------------------------------------------------------
  cmn.AddSubscriber( "win_foyerentrance", win_foyerentrance, "rm_orphanagepark" );

end;
--********************************************************************************************************************
-----------------------------------------------------------------------------------
function private.zz_foyerentrance.StartConditions()

  ng_global.progress[ "std" ][ "win_foyerentrance" ].skip = 0;
  ng_global.progress[ "std" ][ "win_foyerentrance" ].state = { { 3, 2, 2, 2, 3 }, { false, true, true, true, false } };

end;
-----------------------------------------------------------------------------------
function public.zz_foyerentrance.Reset()

  local need_r = false;
  local obj_name = "";

  for i = 1, 5, 1 do

    if (private.zz_foyerentrance.state[1][i] ~= private.zz_foyerentrance.start_state[i]) then

      if not(need_r) then
        need_r = true;
      end;

      obj_name = "spr_foyerentrance_angelpart_";
      if i == 1 then
        obj_name = "obj_foyerentrance_angelpart_";
      end;

      ObjAnimate( obj_name..i, "ang",   0, 0, "", { 0, 0, private.zz_foyerentrance.parts_pos[i][private.zz_foyerentrance.state[1][i]],    
                                                  0.5, 0, private.zz_foyerentrance.parts_pos[i][private.zz_foyerentrance.start_state[i]] } );

    end;

  end;

  if need_r then

    private.zz_foyerentrance.StartConditions();

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_angelpartmove");

    private.zz_foyerentrance.state = ng_global.progress[ "std" ][ "win_foyerentrance" ].state;
    ObjSet("tmr_foyerentrance_timer",  { time = 0.5, playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

  end;

end;
-----------------------------------------------------------------------------------
function public.zz_foyerentrance.Skip()

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_angelpartmove");

  local obj_name = "";

  ng_global.progress[ "std" ][ "win_foyerentrance" ].skip = 1;
  ng_global.progress[ "std" ][ "win_foyerentrance" ].state = { {1, 1, 1, 1, 1}, { true, true, true, true, true } };

  for i = 1, 5, 1 do

    if (private.zz_foyerentrance.state[1][i] ~= private.zz_foyerentrance.win_state[i]) then

      obj_name = "spr_foyerentrance_angelpart_";
      if i == 1 then
        obj_name = "obj_foyerentrance_angelpart_";
      end;

      ObjAnimate( obj_name..i, "ang",   0, 0, "", { 0, 0, private.zz_foyerentrance.parts_pos[i][private.zz_foyerentrance.state[1][i]],    
                                                  0.5, 0, private.zz_foyerentrance.parts_pos[i][private.zz_foyerentrance.win_state[i]] } );

    end;

  end;

  private.zz_foyerentrance.state = ng_global.progress[ "std" ][ "win_foyerentrance" ].state;
  ObjSet("tmr_foyerentrance_timer",  { time = 1, playing = 1, endtrig = private.zz_foyerentrance.CheckWin });

end;
-----------------------------------------------------------------------------------
function private.zz_foyerentrance.DrawScene()

  local obj_name = "";

  for i = 1, 5, 1 do

    obj_name = "spr_foyerentrance_angelpart_";
    if i == 1 then
      obj_name = "obj_foyerentrance_angelpart_";
    end;
  
    ObjSet(obj_name..i,  { ang = private.zz_foyerentrance.parts_pos[i][private.zz_foyerentrance.state[1][i]] });
    
  end;

end;
-----------------------------------------------------------------------------------
function private.zz_foyerentrance.CheckWin()

  local win_flag = true;

  for i = 1, 5, 1 do
  
    if (private.zz_foyerentrance.state[1][i] ~= private.zz_foyerentrance.win_state[i]) then
      win_flag = false;
      break;
    end;
    
  end;

  if win_flag then

    common_impl.PauseAchiev(1);
    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_win_mg_kupidons");

    ObjMultiSet( { {"spr_foyerentrance_angel_2", { alp = 0 }},
                   {"obj_foyerentrance_game", { alp = 0 }},
                   {"anm_foyerentrance_win", { alp = 1, playing = 1, endtrig = private.zz_foyerentrance.Win }} } );

  else 

    cmn.Lock( 0 );

  end;

end;
-----------------------------------------------------------------------------------
function private.zz_foyerentrance.Win()

  common_impl.PauseAchiev(0);

  cmn.MiniGameHide("foyerentrance");
  cmn.SetEventDone( "win_foyerentrance" );
  cmn.CallEventHandler( "win_foyerentrance" );

  if ng_global.progress[ "std" ][ "win_foyerentrance" ].skip == 0 and ng_global.noskipgames[ "win_foyerentrance" ] == nil then

    ng_global.noskipgames[ "win_foyerentrance" ] = 1;
    common_impl.CheckAchiev("mg");

  end;

  cmn.Lock( 0 );
  common.CloseSubRoom();

end;
-----------------------------------------------------------------------------------
function public.zz_foyerentrance.LightPart( part )

  SetCursor( CURSOR_HAND );

  local alf = ObjGet("spr_foyerentrance_angelpart_"..part.."_active").alp;
  local tme = (1 - alf)*0.3;

  ObjAnimate("spr_foyerentrance_angelpart_"..part.."_active", "alp", 0, 0, "", { 0, 0, alf,   tme, 0, 1 });

end;

function public.zz_foyerentrance.UnLightPart( part )

  SetCursor( CURSOR_DEFAULT );

  local alf = ObjGet("spr_foyerentrance_angelpart_"..part.."_active").alp;
  local tme = 0.3 - (1 - alf)*0.3;

  ObjAnimate("spr_foyerentrance_angelpart_"..part.."_active", "alp", 0, 0, "", { 0, 0, alf,   tme, 0, 0 });

end;
-----------------------------------------------------------------------------------
function public.zz_foyerentrance.ClickPart( part )

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_orphanagepark/audio/aud_angelpartmove");

  local pos = private.zz_foyerentrance.state[1][part];
  local dif = -1;

  local obj_name = "spr_foyerentrance_angelpart_";
  if part == 1 then
    obj_name = "obj_foyerentrance_angelpart_";
  end;

  if (pos == 3) then
    private.zz_foyerentrance.state[2][part] = false;
  elseif (pos == 1) then
    private.zz_foyerentrance.state[2][part] = true;
  end;

  if private.zz_foyerentrance.state[2][part] then
    dif = 1;
  end;

  private.zz_foyerentrance.state[1][part] = pos + dif;

  ObjAnimate( obj_name..part, "ang",   0, 0, private.zz_foyerentrance.CheckWin, { 0, 0, private.zz_foyerentrance.parts_pos[part][pos],    
                                                                             0.5, 0, private.zz_foyerentrance.parts_pos[part][pos + dif] } );

end;
--*****************************************************************************************************************