--*********************************************************************************************************************
function public.Init()

  private.Init_Subroom();
  private.Init_Sofa();

  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_livingroom";
  --------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------
  -- function get_number18 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_number18" ] = {

      type = "get",
      get_obj = "spr_bigtable_number18",
      room = private.room_objname,
      zz = "zz_bigtable",
      zz_gate = "gzz_livingroom_bigtable"
  };
  --------------------------------------------------------------------------------------------
  local get_number18_inv = function ()
  
    interface.InventoryItemAdd( "inv_number18", "spr_bigtable_number18" );

    ObjSet("inv_boxstaple_star_light",  { alp = 1 });
  
  end;
  
  local get_number18_closezz = function ()
  
    ObjDelete( "gfx_bigtable_number18" );
    ObjDelete( "spr_bigtable_number18_sh" );
    ObjDelete( "spr_livingroom_table_number18" );

    if ( cmn.IsEventDone( "get_letter3" ) and cmn.IsEventDone( "get_letter4" ) ) then
      ObjDelete( "gzz_livingroom_bigtable" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_number18", get_number18_inv );
  cmn.AddSubscriber( "get_number18", get_number18_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_letter3 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_letter3" ] = {

      type = "get",
      get_obj = "spr_bigtable_letter3",
      room = private.room_objname,
      zz = "zz_bigtable",
      zz_gate = "gzz_livingroom_bigtable"
  };
  --------------------------------------------------------------------------------------------
  local get_letter3_inv = function ()

    interface.InventoryItemAdd( "inv_letter", "spr_bigtable_letter3", function () cmn.GetMultyObject( 'letter', 5 ); end );
  
  end;
  
  local get_letter3_closezz = function ()
  
    ObjDelete( "gfx_bigtable_letter3" );
    ObjDelete( "spr_bigtable_letter3_sh" );
    ObjDelete( "spr_livingroom_table_letter_3" );


    if ( cmn.IsEventDone( "get_number18" ) and cmn.IsEventDone( "get_letter4" ) ) then
      ObjDelete( "gzz_livingroom_bigtable" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_letter3", get_letter3_inv );
  cmn.AddSubscriber( "get_letter3", get_letter3_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_letter4 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_letter4" ] = {

      type = "get",
      get_obj = "spr_bigtable_letter4",
      room = private.room_objname,
      zz = "zz_bigtable",
      zz_gate = "gzz_livingroom_bigtable"
  };
  --------------------------------------------------------------------------------------------
  local get_letter4_inv = function ()

    interface.InventoryItemAdd( "inv_letter", "spr_bigtable_letter4", function () cmn.GetMultyObject( 'letter', 5 ); end );
  
  end;
  
  local get_letter4_closezz = function ()
  
    ObjDelete( "gfx_bigtable_letter4" );
    ObjDelete( "spr_bigtable_letter4_sh" );
    ObjDelete( "spr_livingroom_table_letter_4" );

    if ( cmn.IsEventDone( "get_number18" ) and cmn.IsEventDone( "get_letter3" ) ) then
      ObjDelete( "gzz_livingroom_bigtable" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_letter4", get_letter4_inv );
  cmn.AddSubscriber( "get_letter4", get_letter4_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_codereel () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_codereel" ] = {

      type = "get",
      get_obj = "spr_shelf_codereel",
      room = private.room_objname,
      zz = "zz_shelf",
      zz_gate = "gzz_livingroom_shelf"
  };
  --------------------------------------------------------------------------------------------
  local get_codereel_inv = function ()
  
    interface.InventoryItemAdd( "inv_codereel", "spr_shelf_codereel" );
  
  end;
  
  local get_codereel_closezz = function ()
  
    ObjDelete( "gfx_shelf_codereel" );
    ObjDelete( "spr_shelf_codereel_sh" );
  
  end;
  
  cmn.AddSubscriber( "get_codereel", get_codereel_inv );
  cmn.AddSubscriber( "get_codereel", get_codereel_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_battery1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_battery1" ] = {

      type = "get",
      get_obj = "spr_shelf_battery1",
      room = private.room_objname,
      zz = "zz_shelf",
      zz_gate = "gzz_livingroom_shelf"
  };
  --------------------------------------------------------------------------------------------
  local get_battery1_inv = function ()
  
    --interface.InventoryItemAdd( "inv_battery1", "spr_shelf_battery1" );
    interface.InventoryItemAdd( "inv_battery", "spr_shelf_battery1", function () cmn.GetMultyObject( 'battery', 2 ); end );

    if (cmn.CheckMultiObject( "battery", 2 )) then
      ObjSet("inv_remotewithoutbatteries_star_light",  { alp = 1 });
    end;

    int_map_impl.DecreaseRoomTasks("rm_livingroom");
  
  end;
  
  local get_battery1_closezz = function ()
  
    ObjDelete( "gfx_shelf_battery1" );
    ObjDelete( "spr_shelf_battery1_sh" );
    --ObjDelete( "gzz_livingroom_shelf" );
    ObjDelete( "spr_livingroom_shelf_key" );
  
  end;
  
  cmn.AddSubscriber( "get_battery1", get_battery1_inv );
  cmn.AddSubscriber( "get_battery1", get_battery1_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_cd () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_cd" ] = {

      type = "get",
      get_obj = "obj_shelf_cd_hint",
      room = private.room_objname,
      zz = "zz_shelf",
      zz_gate = "gzz_livingroom_shelf"
  };
  --------------------------------------------------------------------------------------------
  local get_cd_inv = function ()
  
    interface.InventoryItemAdd( "inv_cd", "spr_shelf_cd" );
  
  end;
  
  local get_cd_closezz = function ()
  
    ObjDelete( "gfx_shelf_cd" );
    ObjDelete( "obj_shelf_cd_hint" );
    ObjSet("gzz_livingroom_shelf",  { visible = 0, active = 0 });
  
  end;
  
  cmn.AddSubscriber( "get_cd", get_cd_inv );
  cmn.AddSubscriber( "get_cd", get_cd_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_dograil () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_dograil" ] = {

      type = "get",
      get_obj = "spr_sofa_dograil",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  local get_dograil_inv = function ()
  
    interface.InventoryItemAdd( "inv_dograil", "spr_sofa_dograil" );
  
  end;
  
  local get_dograil_closezz = function ()
  
    ObjDelete( "gfx_sofa_dograil" );
    ObjDelete( "spr_sofa_dograil_sh" );
  
  end;
  
  cmn.AddSubscriber( "get_dograil", get_dograil_inv );
  cmn.AddSubscriber( "get_dograil", get_dograil_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_letter1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_letter1" ] = {

      type = "get",
      get_obj = "spr_sofa_letter1",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  local get_letter1_inv = function ()

    --DbgTrace("***get_letter1_inv");
  
    interface.InventoryItemAdd( "inv_letter", "spr_sofa_letter1", function () cmn.GetMultyObject( 'letter', 5 ); end );
  
  end;
  
  local get_letter1_closezz = function ()
  
    ObjDelete( "gfx_sofa_letter1" );

    if ( cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "get_arrow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
      ObjSet("gzz_livingroom_sofa",  { visible = 0, active = 0 });
    end;
  
  end;
  
  cmn.AddSubscriber( "get_letter1", get_letter1_inv );
  cmn.AddSubscriber( "get_letter1", get_letter1_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_letter2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_letter2" ] = {

      type = "get",
      get_obj = "spr_sofa_letter2",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  local get_letter2_inv = function ()

    --DbgTrace("***get_letter2_inv");
  
    interface.InventoryItemAdd( "inv_letter", "spr_sofa_letter2", function () cmn.GetMultyObject( 'letter', 5 ); end );
  
  end;
  
  local get_letter2_closezz = function ()
  
    ObjDelete( "gfx_sofa_letter2" );

    if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "get_arrow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
      ObjSet("gzz_livingroom_sofa",  { visible = 0, active = 0 });
    end;
  
  end;
  
  cmn.AddSubscriber( "get_letter2", get_letter2_inv );
  cmn.AddSubscriber( "get_letter2", get_letter2_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_bow () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_bow" ] = {

      type = "get",
      get_obj = "spr_sofa_bow",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  local get_bow_inv = function ()

    common_impl.InventoryComplexItemAdd( "inv_bow", "spr_sofa_bow" );

  end;
  
  local get_bow_closezz = function ()
  
    ObjDelete( "gfx_sofa_bow" );

    if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_arrow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
      ObjSet("gzz_livingroom_sofa",  { visible = 0, active = 0 });
    end;
  
  end;
  
  cmn.AddSubscriber( "get_bow", get_bow_inv );
  cmn.AddSubscriber( "get_bow", get_bow_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_arrow () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_arrow" ] = {

      type = "get",
      get_obj = "spr_sofa_arrow",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  local get_arrow_inv = function ()
  
    interface.InventoryItemAdd( "inv_arrow", "spr_sofa_arrow" );

    ObjSet("inv_bow_star_light",  { alp = 1 });

    int_map_impl.DecreaseRoomTasks("rm_livingroom");
  
  end;
  
  local get_arrow_closezz = function ()
  
    ObjDelete( "gfx_sofa_arrow" );
    ObjDelete( "spr_livingroom_sofa_arrow" );

    if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
      --ObjDelete( "gzz_livingroom_sofa" );
      ObjSet("gzz_livingroom_sofa",  { visible = 0, active = 0 });
    end;
  
  end;
  
  cmn.AddSubscriber( "get_arrow", get_arrow_inv );
  cmn.AddSubscriber( "get_arrow", get_arrow_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_pushpin () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pushpinbigtable1" ] = {

      type = "use",
      inv_obj = "inv_pushpin",
      use_place = "obj_bigtable_use_pushpin1",
      room = private.room_objname,
      zz = "zz_bigtable",
      zz_gate = "gzz_livingroom_bigtable"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pushpinbigtable2" ] = {

      type = "use",
      inv_obj = "inv_pushpin",
      use_place = "obj_bigtable_use_pushpin2",
      room = private.room_objname,
      zz = "zz_bigtable",
      zz_gate = "gzz_livingroom_bigtable"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pushpinsofa1" ] = {

      type = "use",
      inv_obj = "inv_pushpin",
      use_place = "obj_sofa_use_pushpin1",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pushpinsofa2" ] = {

      type = "use",
      inv_obj = "inv_pushpin",
      use_place = "obj_sofa_use_pushpin2",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pushpinshelf" ] = {

      type = "use",
      inv_obj = "inv_pushpin",
      use_place = "obj_shelf_use_pushpin",
      room = private.room_objname,
      zz = "zz_shelf",
      zz_gate = "gzz_livingroom_shelf"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pushpinmailbox" ] = {

      type = "use",
      inv_obj = "inv_pushpin",
      use_place = "obj_mailbox_use_pushpin",
      room = "rm_street",
      zz = "zz_mailbox",
      zz_gate = "gzz_street_mailbox"
  };
  --------------------------------------------------------------------------------------------
  local use_pushpin_inv = function ()
  
    if ( cmn.IsEventDone( "use_pushpinbigtable1" ) and cmn.IsEventDone( "use_pushpinbigtable2" ) and cmn.IsEventDone( "use_pushpinsofa1" ) 
     and cmn.IsEventDone( "use_pushpinsofa2" ) and cmn.IsEventDone( "use_pushpinmailbox" ) ) then

      interface.InventoryItemRemove( "inv_pushpin" );

    end;
  
  end;

  local use_pushpin_inv1 = function ()
  
    if ( cmn.IsEventDone( "use_pushpinbigtable2" ) and cmn.IsEventDone( "use_pushpinsofa1" ) 
     and cmn.IsEventDone( "use_pushpinsofa2" ) and cmn.IsEventDone( "use_pushpinmailbox" ) ) then

      interface.InventoryItemRemove( "inv_pushpin" );

    end;
  
  end;
  local use_pushpin_beg1 = function ()
  
    ObjDelete( "obj_bigtable_use_pushpin1" );
  
  end;
  local use_pushpin_end1 = function ()
  
    ObjSet( "spr_bigtable_letter3", { alp = 1 } );

    ObjDelete( "anm_bigtable_use_pin_1" );
    ObjDelete( "anm_bigtable_touch_balloon_1" );

    ObjDelete( "spr_livingroom_table_ballon_2" );
  
  end;

  local use_pushpin_inv2 = function ()
  
    if ( cmn.IsEventDone( "use_pushpinbigtable1" ) and cmn.IsEventDone( "use_pushpinsofa1" ) 
     and cmn.IsEventDone( "use_pushpinsofa2" ) and cmn.IsEventDone( "use_pushpinmailbox" ) ) then

      interface.InventoryItemRemove( "inv_pushpin" );

    end;
  
  end;
  local use_pushpin_beg2 = function ()
  
    ObjDelete( "obj_bigtable_use_pushpin2" );
  
  end;
  local use_pushpin_end2 = function ()
  
    ObjSet( "spr_bigtable_letter4", { alp = 1 } );

    ObjDelete( "anm_bigtable_use_pin_2" );
    ObjDelete( "anm_bigtable_touch_balloon_2" );

    ObjDelete( "spr_livingroom_table_ballon_1" );
  
  end;

  local use_pushpin_beg5 = function ()
  
    ObjSet( "obj_shelf_use_pushpin", { input = false } );
  
  end;
  local use_pushpin_end5 = function ()
  
    ObjSet( "obj_shelf_balloon_bursted", { input = true, alp = 1 } );

    ObjDelete( "obj_shelf_use_pushpin" );
    ObjDelete( "anm_shelf_burst_balloon" );
    ObjDelete( "anm_shelf_touch_balloon" );

    ObjSet( "spr_livingroom_shelf_balloon_burst", { alp = 1 } );
    ObjDelete( "spr_livingroom_shelf_balloon" );
  
  end;

  local use_pushpin_inv3 = function ()
  
    if ( cmn.IsEventDone( "use_pushpinbigtable1" ) and cmn.IsEventDone( "use_pushpinbigtable2" )
     and cmn.IsEventDone( "use_pushpinsofa2" ) and cmn.IsEventDone( "use_pushpinmailbox" ) ) then

      interface.InventoryItemRemove( "inv_pushpin" );

    end;
  
  end;
  local use_pushpin_beg3 = function ()
  
    ObjDelete( "obj_sofa_use_pushpin1" );
  
  end;
  local use_pushpin_end3 = function ()
  
    ObjSet( "spr_sofa_letter1", { alp = 1 } );

    ObjDelete( "anm_sofa_touch_balloon_1" );
    ObjDelete( "anm_sofa_use_pushpin_1" );

    ObjDelete( "spr_livingroom_sofa_ballon_2" );
  
  end;

  local use_pushpin_inv4 = function ()
  
    if ( cmn.IsEventDone( "use_pushpinbigtable1" ) and cmn.IsEventDone( "use_pushpinbigtable2" )
     and cmn.IsEventDone( "use_pushpinsofa1" ) and cmn.IsEventDone( "use_pushpinmailbox" ) ) then

      interface.InventoryItemRemove( "inv_pushpin" );

    end;
  
  end;
  local use_pushpin_beg4 = function ()
  
    ObjDelete( "obj_sofa_use_pushpin2" );
  
  end;
  local use_pushpin_end4 = function ()
  
    ObjSet( "spr_sofa_letter2", { alp = 1 } );

    ObjDelete( "anm_sofa_touch_balloon_2" );
    ObjDelete( "anm_sofa_use_pushpin_2" );

    ObjDelete( "spr_livingroom_sofa_ballon_1" );
  
  end;
  local use_pushpin_inv6 = function ()
  
    if ( cmn.IsEventDone( "use_pushpinbigtable1" ) and cmn.IsEventDone( "use_pushpinbigtable2" )
     and cmn.IsEventDone( "use_pushpinsofa1" ) and cmn.IsEventDone( "use_pushpinsofa2" ) ) then

      interface.InventoryItemRemove( "inv_pushpin" );

    end;
  
  end;
  local use_pushpin_beg6 = function ()
  
    ObjDelete( "obj_mailbox_use_pushpin" );
    ObjDelete( "anm_mailbox_ballon" );
  
  end;
  local use_pushpin_end6 = function ()

    ObjSet("gzz_street_mailbox",  { inputrect_y = -113, inputrect_h = 198 });
  
    ObjDelete("anm_mailbox_use_pin");
    ObjDelete("spr_street_baloon");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_pushpinbigtable1", use_pushpin_inv1 );
  cmn.AddSubscriber( "use_pushpinbigtable2", use_pushpin_inv2 );
  cmn.AddSubscriber( "use_pushpinsofa1",     use_pushpin_inv3 );
  cmn.AddSubscriber( "use_pushpinsofa2",     use_pushpin_inv4 );
  --cmn.AddSubscriber( "use_pushpinshelf",     use_pushpin_inv5 );
  cmn.AddSubscriber( "use_pushpinmailbox",   use_pushpin_inv6 );

  cmn.AddSubscriber( "use_pushpin_inv1", use_pushpin_inv1, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_inv2", use_pushpin_inv2, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_inv3", use_pushpin_inv3, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_inv4", use_pushpin_inv4, private.room_objname );
  --cmn.AddSubscriber( "use_pushpin_inv5", use_pushpin_inv5, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_inv6", use_pushpin_inv6, "rm_street" );

  cmn.AddSubscriber( "use_pushpinbigtable1", use_pushpin_beg1, private.room_objname );
  cmn.AddSubscriber( "use_pushpinbigtable1", use_pushpin_end1, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_beg1", use_pushpin_beg1, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_end1", use_pushpin_end1, private.room_objname );

  cmn.AddSubscriber( "use_pushpinbigtable2", use_pushpin_beg2, private.room_objname );
  cmn.AddSubscriber( "use_pushpinbigtable2", use_pushpin_end2, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_beg2", use_pushpin_beg2, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_end2", use_pushpin_end2, private.room_objname );

  cmn.AddSubscriber( "use_pushpinsofa1", use_pushpin_beg3, private.room_objname );
  cmn.AddSubscriber( "use_pushpinsofa1", use_pushpin_end3, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_beg3", use_pushpin_beg3, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_end3", use_pushpin_end3, private.room_objname );

  cmn.AddSubscriber( "use_pushpinsofa2", use_pushpin_beg4, private.room_objname );
  cmn.AddSubscriber( "use_pushpinsofa2", use_pushpin_end4, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_beg4", use_pushpin_beg4, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_end4", use_pushpin_end4, private.room_objname );

  cmn.AddSubscriber( "use_pushpinshelf", use_pushpin_beg5, private.room_objname );
  cmn.AddSubscriber( "use_pushpinshelf", use_pushpin_end5, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_beg5", use_pushpin_beg5, private.room_objname );
  cmn.AddSubscriber( "use_pushpin_end5", use_pushpin_end5, private.room_objname );

  cmn.AddSubscriber( "use_pushpinmailbox", use_pushpin_beg6, "rm_street" );
  cmn.AddSubscriber( "use_pushpinmailbox", use_pushpin_end6, "rm_street" );
  cmn.AddSubscriber( "use_pushpin_beg6", use_pushpin_beg6, "rm_street" );
  cmn.AddSubscriber( "use_pushpin_end6", use_pushpin_end6, "rm_street" );
  --------------------------------------------------------------------------------------------
  -- function use_dograil () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_dograil" ] = {

      type = "use",
      inv_obj = "inv_dograil",
      use_place = "obj_shelf_use_dograil",
      room = private.room_objname,
      zz = "zz_shelf",
      zz_gate = "gzz_livingroom_shelf"
  };
  --------------------------------------------------------------------------------------------
  local use_dograil_inv = function ()
  
    interface.InventoryItemRemove( "inv_dograil" );
  
  end;
  local use_dograil_beg = function ()
  
    ObjDelete( "obj_shelf_use_dograil" );
  
  end;
  local use_dograil_end = function ()
  
    ObjSet( "obj_shelf_dog_open", { input = true, alp = 1 } );

    ObjDelete( "anm_shelf_use_dogtail" );
    ObjDelete( "anm_shelf_touch_dog" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_dograil", use_dograil_beg, private.room_objname );
  cmn.AddSubscriber( "use_dograil", use_dograil_inv );
  cmn.AddSubscriber( "use_dograil", use_dograil_end, private.room_objname );
  cmn.AddSubscriber( "use_dograil_inv", use_dograil_inv, private.room_objname );
  cmn.AddSubscriber( "use_dograil_beg", use_dograil_beg, private.room_objname );
  cmn.AddSubscriber( "use_dograil_end", use_dograil_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_codereel () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_codereel" ] = {

      type = "use",
      inv_obj = "inv_codereel",
      use_place = "obj_sofa_use_codereel",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  local use_codereel_inv = function ()
  
    interface.InventoryItemRemove( "inv_codereel" );
  
  end;
  local use_codereel_beg = function ()
  
    ObjDelete( "obj_sofa_use_codereel" );
  
  end;
  local use_codereel_end = function ()
  
    ObjSet( "gzz_sofa_mmg", { input = 1, active = 1, visible = 1 } );
    ObjSet( "spr_sofa_box_codereel", { alp = 1 } );

  --  ObjDelete( "spr_sofa_box_closed" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_codereel", use_codereel_beg, private.room_objname );
  cmn.AddSubscriber( "use_codereel", use_codereel_inv );
  cmn.AddSubscriber( "use_codereel", use_codereel_end, private.room_objname );
  cmn.AddSubscriber( "use_codereel_inv", use_codereel_inv, private.room_objname );
  cmn.AddSubscriber( "use_codereel_beg", use_codereel_beg, private.room_objname );
  cmn.AddSubscriber( "use_codereel_end", use_codereel_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_policebadge () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_policebadge" ] = {

      type = "use",
      inv_obj = "inv_policebadge",
      use_place = "obj_shelf_use_policebadge",
      room = private.room_objname,
      zz = "zz_shelf",
      zz_gate = "gzz_livingroom_shelf"
  };
  --------------------------------------------------------------------------------------------
  local use_policebadge_inv = function ()
  
    interface.InventoryItemRemove( "inv_policebadge" );
  
  end;
  local use_policebadge_beg = function ()
  
    ObjDelete( "obj_shelf_use_policebadge" );
  
  end;
  local use_policebadge_end = function ()
  
    ObjSet( "spr_shelf_box_open", { alp = 1, input = 1 } );

    ObjDelete( "anm_shelf_box_touch" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_policebadge", use_policebadge_beg, private.room_objname );
  cmn.AddSubscriber( "use_policebadge", use_policebadge_inv );
  cmn.AddSubscriber( "use_policebadge", use_policebadge_end, private.room_objname );
  cmn.AddSubscriber( "use_policebadge_inv", use_policebadge_inv, private.room_objname );
  cmn.AddSubscriber( "use_policebadge_beg", use_policebadge_beg, private.room_objname );
  cmn.AddSubscriber( "use_policebadge_end", use_policebadge_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_screwdriver () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_screwdriver" ] = {

      type = "use",
      inv_obj = "inv_screwdriver",
      use_place = "obj_sofa_use_screwdriver",
      room = private.room_objname,
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_screwdrivertarget" ] = {

      type = "use",
      inv_obj = "inv_screwdriver",
      use_place = "obj_target_use_screwdriver",
      room = "rm_cafe",
      zz = "zz_target",
      zz_gate = "gzz_cafe_target"
  };
  --------------------------------------------------------------------------------------------
  local use_screwdriver_inv = function ()
  
    interface.InventoryItemRemove( "inv_screwdriver" );
  
  end;

  local use_screwdriver_beg = function ()
  
    ObjDelete( "obj_sofa_use_screwdriver" );
  
  end;
  local use_screwdriver_end = function ()
  
     --ObjSet( "spr_sofa_key", { input = true, visible = true, active = true } );

    ObjDelete( "anm_sofa_use_scredriver" );
    ObjDelete( "spr_sofa_arrow_glass" );
  
  end;

  local use_screwdriver_beg2 = function ()
  
    ObjDelete( "obj_target_use_screwdriver" );
  
  end;
  local use_screwdriver_end2 = function ()

    ObjMultiSet( { {"spr_target_battery22", { input = 1 }},
                   {"anm_target_use_screw", { alp = 1, frame = 208 }},
                   {"spr_cafe_target_radio", { ang = 1.4 }},
                   {"spr_target_radio_off", { alp = 1 }} } );
  
    ObjDelete( "anm_target_radio_touch" );
    ObjDelete( "obj_target_clk_radio" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_screwdrivertarget", use_screwdriver_inv );
  cmn.AddSubscriber( "use_screwdriver_inv", use_screwdriver_inv, "rm_cafe" );

  cmn.AddSubscriber( "use_screwdriver", use_screwdriver_beg, private.room_objname );
  cmn.AddSubscriber( "use_screwdriver", use_screwdriver_end, private.room_objname );
  cmn.AddSubscriber( "use_screwdriver_beg", use_screwdriver_beg, private.room_objname );
  cmn.AddSubscriber( "use_screwdriver_end", use_screwdriver_end, private.room_objname );

  cmn.AddSubscriber( "use_screwdrivertarget", use_screwdriver_beg2, "rm_cafe" );
  cmn.AddSubscriber( "use_screwdrivertarget", use_screwdriver_end2, "rm_cafe" );
  cmn.AddSubscriber( "use_screwdriver_beg2", use_screwdriver_beg2, "rm_cafe" );
  cmn.AddSubscriber( "use_screwdriver_end2", use_screwdriver_end2, "rm_cafe" );
  --------------------------------------------------------------------------------------------
  -- function clk_marydialoganswer () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_marydialoganswer" ] = {

      type = "click",
      use_place = "spr_livingroom_dialog_answer_1",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_marydialoganswer = function ()

    ObjDelete( "obj_livingroom_dialog" );
    ObjDelete( "spr_livingroom_mary" );
    ObjDelete( "spr_livingroom_mary_2" );

    ObjDelete("vid_livingroom_dialog_mary_3");
    --ObjDelete("vid_livingroom_dialog_mary_4");

  end;
  --------------------------------------------------------------------------------------------
  local clk_marydialoganswer_dairypageadd = function ()

    int_map_impl.AddDiarypage(1);
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_marydialoganswer", clk_marydialoganswer, private.room_objname );
  cmn.AddSubscriber( "clk_marydialoganswer", clk_marydialoganswer_dairypageadd );

  --------------------------------------------------------------------------------------------
  -- function clk_clickonphone () end;
  --------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------
  local clk_clickonphone_beg = function ()
  
    ObjSet( "obj_sofa_clickonphone", { input = false } );
  
  end;
  local clk_clickonphone_end = function ()

    ObjSet("spr_sofa_phone_2",  { alp = 1 });
  
    ObjDelete( "obj_sofa_clickonphone" );
    ObjDelete( "spr_sofa_phone" );

    if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "get_arrow" ) ) then
      ObjDelete( "gzz_livingroom_sofa" );
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickonphone", clk_clickonphone_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonphone", clk_clickonphone_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickonphone_beg", clk_clickonphone_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonphone_end", clk_clickonphone_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function opn_livingroom () end;
  --------------------------------------------------------------------------------------------
  local opn_livingroom = function ()
  
    int_map_impl.OpenRoom( "rm_livingroom" );

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_livingroom", opn_livingroom);
  --------------------------------------------------------------------------------------------
  -- function opn_sofascaryface () end;
  --------------------------------------------------------------------------------------------
  local opn_sofascaryface = function ()
  
    ObjMultiSet( { {"anm_sofa_mirror_face_show", { playing = 0, frame = 315 }},
                   {"spr_livingroom_sofa_mirror", { alp = 1 }} } );

  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_sofascaryface", opn_sofascaryface, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function opn_marydialog () end;
  --------------------------------------------------------------------------------------------
  local opn_marydialog = function ()

    ObjDelete("gzz_livingroom_frontdoor");
    ObjDelete("spr_livingroom_door");

    ObjDelete("vid_livingroom_dialog_mary_1");
    ObjDelete("vid_livingroom_dialog_mary_2");

    ObjAttach("obj_livingroom_dialog", "rm_livingroom");

    ObjMultiSet( { {"obj_livingroom_dialog", { alp = 1, input = 1 }},
                   {"spr_livingroom_door_open", { alp = 1 }},
                   {"spr_livingroom_dialog_mary", { alp = 1 }},
                   {"grm_livingroom_street", { active = 1, visible = 1, input = 1 }},
                   {"obj_livingroom_dialog_choice", { alp = 1, input = 1 }} } );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_marydialog", opn_marydialog, private.room_objname );

end;
--********************************************************************************************************************
function private.Init_Subroom()
  
  --subroom.Define( "zz_bigtable" );
  subroom.Define( "zz_shelf" );
  subroom.Define( "zz_frontdoor" );
  subroom.Define( "zz_sofa" );

  function zz_sofa.Open()
    
    if ( cmn.IsEventDone( "get_screwdriver" ) and not(cmn.IsEventDone( "opn_sofascaryface" )) ) then

      private.show_scaryface();

    end;

    if ( cmn.IsEventDone( "use_codereel" ) and not(cmn.IsEventDone( "win_sofa" )) ) then
      --cmn.MiniGameShow();
      --public.zz_sofa.ZoomMg()
    end;

  end;

  function zz_sofa.PreClose()

    if ( cmn.IsEventDone( "use_codereel" ) and not(cmn.IsEventDone( "win_sofa" )) ) then
      private.zz_sofa.active = 0;
      cmn.MiniGameHide("sofa");
    end;

    if ( cmn.IsEventDone( "get_bow" ) and not(cmn.IsEventDone( "opn_marydialog" )) ) then

      private.opn_dialog();

    end;

  end;

  function zz_sofa.Close()

    cmn.HideNote( 0 );

    if ( cmn.IsEventDone( "use_codereel" ) and not(cmn.IsEventDone( "win_sofa" )) ) then
      ObjSet("spr_sofa_back",  { pos_x = 0, pos_y = 0, scale_x = 1, scale_y = 1 });
      ObjSet("obj_sofa_game",  { alp = 0, input = 0 });
    end;

  end;

  function zz_frontdoor.Open()

--      cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_clk_zz_frontdoor");
--
--      local num = math.random(2);
--      cmn.ShowDlgBbt( "frontdoor_mary_"..num );

      cmn.Lock( 1 );
      ObjSet("anm_frontdoor_crow_head",  { frame = 0, playing = 1, endtrig = function () cmn.Lock( 0 ); end });

  end;

  function zz_shelf.Close()

    cmn.HideNote( 0 );

  end;

end;
--*********************************************************************************************************************
function public.Load()

  if not( cmn.IsEventDone( "use_codereel" ) ) then
    private.zz_sofa.StartConditions();
  end;

  private.zz_sofa.state = ng_global.progress[ "std" ][ "win_sofa" ].state;

  if ( cmn.IsEventDone( "use_codereel" ) and not(cmn.IsEventDone( "win_sofa" )) ) then
    private.zz_sofa.DrawScene();
  end;

end;
--*********************************************************************************************************************
function public.Open()


end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_livingroom_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_livingroom_env");

  private.opn_livingroom();

  --if not(cmn.IsEventDone("clk_marydialoganswer")) and cmn.IsEventDone("opn_marydialog") then
  --  private.AnimDialogView();
  --end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_pushpin()

  local item = "inv_pushpin";

  if cmn.ApplyObj( item, "gzz_livingroom_bigtable" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_bigtable" );

  elseif ( cmn.ApplyObj( item, "obj_bigtable_use_pushpin1" ) ) then

    --if not(cmn.IsEventDone("use_pushpinbigtable2")) then
    --  ObjDoNotDrop( item );
    --end;

    cmn.CallEventHandler( "use_pushpin_inv1" );
    cmn.CallEventHandler( "use_pushpin_beg1" );

    local trg_after = function ()

      local trg_after2 = function ()

          cmn.Lock( 0 );

          if ( cmn.IsEventDone( "get_number18" ) and cmn.IsEventDone( "get_letter4" ) ) then
            common.CloseSubRoom();
          end;

      end;

      ObjSet("tmr_bigtable_timer",  { time = 1.5, playing = 1, endtrig = trg_after2 });

      cmn.SetEventDone( "use_pushpinbigtable1" );
      cmn.CallEventHandler( "use_pushpin_end1" );

      rm_livingroom.get_letter3();

      --if not(cmn.IsEventDone("use_pushpinbigtable2")) then
      --  ObjSet(item,  { event_dragdrop = rm_livingroom.use_pushpin });
      --end;
    
    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usepushpin2");

    ObjSet("anm_bigtable_touch_balloon_1",  { alp = 0 });
    ObjSet("anm_bigtable_use_pin_1",  { alp = 1, playing = 1, endtrig = trg_after });

  elseif ( cmn.ApplyObj( item, "obj_bigtable_use_pushpin2" ) ) then

    --if not(cmn.IsEventDone("use_pushpinbigtable1")) then
    --  ObjDoNotDrop( item );
    --end;

    cmn.CallEventHandler( "use_pushpin_inv2" );
    cmn.CallEventHandler( "use_pushpin_beg2" );

    local trg_after = function ()

      local trg_after2 = function ()

          cmn.Lock( 0 );

          if ( cmn.IsEventDone( "get_number18" ) and cmn.IsEventDone( "get_letter3" ) ) then
            common.CloseSubRoom();
          end;

      end;

      ObjSet("tmr_bigtable_timer",  { time = 1.5, playing = 1, endtrig = trg_after2 });

      cmn.SetEventDone( "use_pushpinbigtable2" );
      cmn.CallEventHandler( "use_pushpin_end2" );

      rm_livingroom.get_letter4();

      --if not(cmn.IsEventDone("use_pushpinbigtable1")) then
      --  ObjSet(item,  { event_dragdrop = rm_livingroom.use_pushpin });
      --end;
    
    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usepushpin2");

    ObjSet("anm_bigtable_touch_balloon_2",  { alp = 0 });
    ObjSet("anm_bigtable_use_pin_2",  { alp = 1, playing = 1, endtrig = trg_after });

  elseif cmn.ApplyObj( item, "gzz_livingroom_sofa" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_sofa" );

  elseif ( cmn.ApplyObj( item, "obj_sofa_use_pushpin1" ) and (private.zz_sofa.active == 0) ) then

    --if not(cmn.IsEventDone("use_pushpinsofa2")) then
    --  ObjDoNotDrop( item );
    --end;

    cmn.CallEventHandler( "use_pushpin_inv3" );
    cmn.CallEventHandler( "use_pushpin_beg3" );

    local trg_after = function ()

      ObjSet("tmr_sofa_timer",  { time = 1.5, playing = 1, endtrig = function () cmn.Lock( 0 ); end });

      cmn.SetEventDone( "use_pushpinsofa1" );
      cmn.CallEventHandler( "use_pushpin_end3" );

      rm_livingroom.get_letter1();

      --if not(cmn.IsEventDone("use_pushpinsofa2")) then
      --  ObjSet(item,  { event_dragdrop = rm_livingroom.use_pushpin });
      --end;
    
    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usepushpin3");

    ObjSet("anm_sofa_touch_balloon_1",  { alp = 0 });
    ObjSet("anm_sofa_use_pushpin_1",  { alp = 1, playing = 1, endtrig = trg_after });

  elseif ( cmn.ApplyObj( item, "obj_sofa_use_pushpin2" ) and (private.zz_sofa.active == 0) ) then

    --if not(cmn.IsEventDone("use_pushpinsofa1")) then
    --  ObjDoNotDrop( item );
    --end;

    cmn.CallEventHandler( "use_pushpin_inv4" );
    cmn.CallEventHandler( "use_pushpin_beg4" );

    local trg_after = function ()

      ObjSet("tmr_sofa_timer",  { time = 1.5, playing = 1, endtrig = function () cmn.Lock( 0 ); end });

      cmn.SetEventDone( "use_pushpinsofa2" );
      cmn.CallEventHandler( "use_pushpin_end4" );

      rm_livingroom.get_letter2();

      --if not(cmn.IsEventDone("use_pushpinsofa1")) then
      --  ObjSet(item,  { event_dragdrop = rm_livingroom.use_pushpin });
      --end;
    
    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usepushpin3");

    ObjSet("anm_sofa_touch_balloon_2",  { alp = 0 });
    ObjSet("anm_sofa_use_pushpin_2",  { alp = 1, playing = 1, endtrig = trg_after });

  elseif cmn.ApplyObj( item, "gzz_livingroom_shelf" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_shelf" );

  elseif ( cmn.ApplyObj( item, "obj_shelf_use_pushpin" ) ) then

    cmn.CallEventHandler( "use_pushpin_inv5" );
    cmn.CallEventHandler( "use_pushpin_beg5" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_pushpinshelf" );
      cmn.CallEventHandler( "use_pushpin_end5" );
    
    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usepushpin");

    ObjSet("anm_shelf_touch_balloon",  { alp = 0 });
    ObjSet("anm_shelf_burst_balloon",  { alp = 1, playing = 1, endtrig = trg_after });

  elseif cmn.ApplyObj( item, "gzz_street_mailbox" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_mailbox" );

  elseif ( cmn.ApplyObj( item, "obj_mailbox_use_pushpin" ) ) then

    cmn.CallEventHandler( "use_pushpin_inv6" );
    cmn.CallEventHandler( "use_pushpin_beg6" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_pushpinmailbox" );
      cmn.CallEventHandler( "use_pushpin_end6" );

      rm_street.get_letter5();

    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_street/audio/aud_usepushpin1");
    
    ObjSet("anm_mailbox_use_pin", {endtrig = trg_after, playing = 1, alp = 1});

  elseif ( cmn.ApplyObj( item, "obj_livingroom_balloons_1" ) or cmn.ApplyObj( item, "obj_livingroom_balloons_2" ) ) then

    cmn.Lock(1);
    cmn.ShowBbt( "livingroom_pushpin_wrongapply" );
    ObjAnimate("obj_livingroom_balloons_1", "alp", 0, 0, function () cmn.Lock(0); end, { 0, 0, 1,   0.3, 0, 1 });

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_dograil()

  local item = "inv_dograil";

  if cmn.ApplyObj( item, "gzz_livingroom_shelf" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_shelf" );

  elseif ( cmn.ApplyObj( item, "obj_shelf_use_dograil" ) ) then

    cmn.CallEventHandler( "use_dograil_inv" );
    cmn.CallEventHandler( "use_dograil_beg" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_dograil" );
      cmn.CallEventHandler( "use_dograil_end" );
    
    end;

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_dograil");

    ObjMultiSet( { {"anm_shelf_touch_dog", { alp = 0 }},
                   {"anm_shelf_use_dogtail", { endtrig = trg_after, playing = 1, alp = 1 }} } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_policebadge()

  local item = "inv_policebadge";

  if cmn.ApplyObj( item, "gzz_livingroom_shelf" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_shelf" );

  elseif ( cmn.ApplyObj( item, "obj_shelf_use_policebadge" ) ) then

    cmn.CallEventHandler( "use_policebadge_inv" );
    cmn.CallEventHandler( "use_policebadge_beg" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_policebadge" );
      cmn.CallEventHandler( "use_policebadge_end" );
    
    end;

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_policebadge");

    ObjAnimate("spr_shelf_policebadge", "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1 });
    ObjAnimate("anm_shelf_box_touch", "alp", 0, 0, "", { 0, 0, 1,   0.5, 0, 1,   1, 0, 0 });
    ObjAnimate("spr_shelf_box_open", "alp", 0, 0, trg_after, { 0, 0, 0,   0.5, 0, 0,   1, 0, 1 });

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_codereel()

  local item = "inv_codereel";

  if cmn.ApplyObj( item, "gzz_livingroom_sofa" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_sofa" );

  elseif ( cmn.ApplyObj( item, "obj_sofa_use_codereel" ) ) then

    cmn.CallEventHandler( "use_codereel_inv" );
    cmn.CallEventHandler( "use_codereel_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_codereel" );
      cmn.CallEventHandler( "use_codereel_end" );

      public.zz_sofa.ZoomMg();
    
    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usecodereel");

    ObjAnimate( "spr_sofa_box_codereel", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0, 
      0.5, 0, 1
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_screwdriver()

  local item = "inv_screwdriver";

  if cmn.ApplyObj( item, "gzz_livingroom_sofa" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_sofa" );

  elseif ( cmn.ApplyObj( item, "obj_sofa_use_screwdriver" ) and cmn.IsEventDone("opn_sofascaryface") ) then

    --cmn.CallEventHandler( "use_screwdriver_inv" );
    cmn.CallEventHandler( "use_screwdriver_beg" );

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_usescrewdriver");

    ObjSet("anm_sofa_use_scredriver",  { playing = 1, endtrig = private.use_screwdriver_end });

  elseif ( cmn.ApplyObj( item, "obj_policecar_use_policekeys" ) ) then

    cmn.Lock( 1 );
    cmn.ShowBbt( "policecar_scredriver_wrongapply" );

    local func_after = function () cmn.Lock( 0 ); end;

    ObjAnimate("anm_policecar_use_key", "alp", 0, 0, func_after, { 0, 0, 1,   0.3, 0, 1 });

  elseif ( cmn.ApplyObj( item, "obj_pole_door_clk" ) ) then

    cmn.Lock( 1 );
    cmn.ShowBbt( "pole_scredriver_wrongapply" );

    local func_after = function () cmn.Lock( 0 ); end;

    ObjAnimate("obj_pole_door_clk", "alp", 0, 0, func_after, { 0, 0, 1,   0.3, 0, 1 });

  elseif cmn.ApplyObj( item, "gzz_cafe_target" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_target" );

  elseif ( cmn.ApplyObj( item, "obj_target_use_screwdriver" ) ) then

    cmn.CallEventHandler( "use_screwdriver_inv" );
    cmn.CallEventHandler( "use_screwdriver_beg2" );

    cmn.Lock( 1 );

    if rm_cafe.get_radio_play() then

      rm_cafe.set_radio_stop();

      SndStop( "assets/levels/level1/rm_cafe/audio/aud_radio_voiceover_voc", 0.5 );
      SndStop( "assets/levels/level1/rm_cafe/audio/aud_radio_2_voc", 0.5 );

      ObjAnimate( "spr_target_radio_off", "alp", 0, 0, private.use_screwdrivertarget_end, 
      { 
        0.0, 0, 0, 
        0.5, 0, 1
      } );

    else 

      private.use_screwdrivertarget_end();

    end;

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function private.use_screwdriver_end()

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_screwdriver" );
      cmn.CallEventHandler( "use_screwdriver_end" );

      public.get_arrow();
    
    end;

    ObjAnimate( "spr_sofa_arrow_glass", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 1, 
      0.5, 0, 0
    } );

end;
--------------------------------------------------------------------------------------------
function private.use_screwdrivertarget_end()

  local trg_after = function ()

    cmn.Lock( 0 );

    cmn.SetEventDone( "use_screwdrivertarget" );
    cmn.CallEventHandler( "use_screwdriver_end2" );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_openradiopanel");

  ObjMultiSet( { {"anm_target_radio_touch", { alp = 0 }},
                 {"anm_target_use_screw", { alp = 1, playing = 1, endtrig = trg_after }} } );


end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_number18()

  cmn.SetEventDone( "get_number18" );
  cmn.CallEventHandler( "get_number18" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if ( cmn.IsEventDone( "get_letter3" ) and cmn.IsEventDone( "get_letter4" ) ) then
    common.CloseSubRoom();
  end;

end;
--------------------------------------------------------------------------------------------
function public.get_letter3()

  cmn.SetEventDone( "get_letter3" );
  cmn.CallEventHandler( "get_letter3" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  --if ( cmn.IsEventDone( "get_number18" ) and cmn.IsEventDone( "get_letter4" ) ) then
  --  common.CloseSubRoom();
  --end;

end;
--------------------------------------------------------------------------------------------
function public.get_letter4()

  cmn.SetEventDone( "get_letter4" );
  cmn.CallEventHandler( "get_letter4" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  --if ( cmn.IsEventDone( "get_number18" ) and cmn.IsEventDone( "get_letter3" ) ) then
  --  common.CloseSubRoom();
  --end;

end;
--------------------------------------------------------------------------------------------
function public.get_codereel()

  cmn.SetEventDone( "get_codereel" );
  cmn.CallEventHandler( "get_codereel" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_battery1()

  cmn.SetEventDone( "get_battery1" );
  cmn.CallEventHandler( "get_battery1" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_cd()

  cmn.SetEventDone( "get_cd" );
  cmn.CallEventHandler( "get_cd" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_dograil()

  cmn.SetEventDone( "get_dograil" );
  cmn.CallEventHandler( "get_dograil" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_letter1()

  cmn.SetEventDone( "get_letter1" );
  cmn.CallEventHandler( "get_letter1" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if ( cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "get_arrow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
    common.CloseSubRoom();
  end;

end;
--------------------------------------------------------------------------------------------
function public.get_letter2()

  cmn.SetEventDone( "get_letter2" );
  cmn.CallEventHandler( "get_letter2" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "get_arrow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
    common.CloseSubRoom();
  end;

end;
--------------------------------------------------------------------------------------------
function public.get_bow()

  cmn.SetEventDone( "get_bow" );
  cmn.CallEventHandler( "get_bow" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  for i = 1, 3, 1 do

    ObjSet("spr_int_achiev_"..i,  { input = 0 });

  end;

  if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_arrow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
    common.CloseSubRoom();
  end;

end;
--------------------------------------------------------------------------------------------
function public.get_arrow()

  cmn.SetEventDone( "get_arrow" );
  cmn.CallEventHandler( "get_arrow" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "clk_clickonphone" ) ) then
    common.CloseSubRoom();
  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
--function private.clk_turnkey()
--
--  cmn.CallEventHandler( "clk_turnkey_beg" );
--
--  local func_after = function ()
--
--    common.CloseSubRoom();
--
--    cmn.SetEventDone( "clk_turnkey" );
--    cmn.CallEventHandler( "clk_turnkey_end" );
--
--    cmn.Lock( 0 );
--  
--  end;
--
--  ObjSet("anm_frontdoor_knocking",  { alp = 0, playing = 0 });
--  ObjSet("anm_frontdoor_use_key",  { alp = 1, playing = 1, endtrig = trg_after });
--  
--  cmn.Lock( 1 );
--
--end;
--------------------------------------------------------------------------------------------
function public.clk_clickonphone()

  cmn.CallEventHandler( "clk_clickonphone_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_clickonphone" );
    cmn.CallEventHandler( "clk_clickonphone_end" );

    cmn.Lock( 0 );

    if ( cmn.IsEventDone( "get_letter1" ) and cmn.IsEventDone( "get_letter2" ) and cmn.IsEventDone( "get_bow" ) and cmn.IsEventDone( "get_arrow" ) ) then
      common.CloseSubRoom();
    end;
  
  end;

  cmn.ShowBbt( "livingroom_phone" );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_clk_telephone");
  cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_operator_voc");

  ObjAnimate( "spr_sofa_phone", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

  ObjAnimate( "spr_sofa_phone_2", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1,
    4.7, 0, 1
  } );
  
  cmn.Lock( 1 );

end;
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_livingroom()

  if not ( cmn.IsEventDone( "opn_livingroom" ) ) then

    cmn.SetEventDone( "opn_livingroom" );
    cmn.CallEventHandler( "opn_livingroom" );

    ObjSet("rm_livingroom",  { color_r = 0, color_g = 0, color_b = 0 });

    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_livingroom/vid_livingroom", private.opn_livingroom_end, "assets/levels/level1/rm_livingroom/audio/aud_livingroom_mus", "assets/levels/level1/rm_livingroom/audio/aud_livingroom_voc" );

  end;

end;
--------------------------------------------------------------------------------------------
function private.opn_livingroom_end()

  local func_after = function ()

    cmn.Lock(0);

    local arrows = { { pos_x = -300, pos_y = 160, ang = 2.6 } };

    cmn.TutorialShow( "tutor_10", 0, 450, 384, arrows );

  end;

  cmn.Lock(1);

  cmn.ShowBbt( "livingroom_open" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_carol_11_voc");
  ObjSet("tmr_livingroom_timer", { time = 4, playing = 1, endtrig = func_after });

  ObjSet("rm_livingroom",  { color_r = 1, color_g = 1, color_b = 1 });

  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_10_mus");

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog()

  cmn.PlayFullscreenVideo( "assets/levels/level1/rm_livingroom/vid_guests", private.show_dialog, "assets/levels/level1/rm_livingroom/audio/aud_guests_mus", "assets/levels/level1/rm_livingroom/audio/aud_guests_voc" );

end;
--------------------------------------------------------------------------------------------
function private.show_dialog()

  if interface.GetCurrentComplexInv() ~= "" then
    common_impl.HideComplexItem();
  end;

  for i = 1, 3, 1 do

    ObjSet("spr_int_achiev_"..i,  { input = 1 });

  end;

  cmn.Lock( 1 );
  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_howl_2_mus");

  ObjAttach("obj_livingroom_dialog", "rm_livingroom");
  ObjSet("obj_livingroom_dialog",  { input = 1, alp = 1 });

  --private.AnimDialogView();

  private.opn_dialog_maryspeaks();

  --ObjAnimate( "obj_livingroom_dialog", "alp", 0, 0, private.opn_dialog_maryspeaks, 
  --{ 
  --  0.0, 0, 0, 
  --  0.5, 0, 1
  --} );

end;
--------------------------------------------------------------------------------------------
function private.hide_dialog()

  int_blackbartext.Hide();

  ObjAnimate( "obj_livingroom_dialog", "alp", 0, 0, private.mary_leaves, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
function private.mary_leaves()

  local func_after = function ()

    cmn.Lock( 0 );
    cmn.ShowBbt( "livingroom_after_dialog" );

    cmn.CallEventHandler( "clk_marydialoganswer" );
  
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_mary_leaves");

  ObjAnimate( "spr_livingroom_mary", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

  ObjAnimate( "spr_livingroom_mary_2", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1,
      1, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_maryspeaks()

  cmn.SetEventDone( "opn_marydialog" );

  cmn.ShowDlgBbt( "dlg_mary_phrase_1" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_mary_1_voc");

  --ObjSet("tmr_livingroom_dialog_timer",  { time = 6.5, playing = 1, endtrig = private.opn_dialog_maryspeaks2 });
  ObjSet("vid_livingroom_dialog_mary_1",  { playing = 1, endtrig = private.opn_dialog_maryspeaks2 });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_maryspeaks2()

  local func_after = function ()

    cmn.ShowDlgBbt( "dlg_mary_phrase_2_2" );

    --ObjSet("tmr_livingroom_dialog_timer",  { time = 6, playing = 1, endtrig = private.opn_dialog_show_answers });
  
  end;

  cmn.ShowDlgBbt( "dlg_mary_phrase_2_1" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_mary_2_voc");

  ObjSet("tmr_livingroom_dialog_timer",  { time = 4.4, playing = 1, endtrig = func_after });

  ObjDetach("vid_livingroom_dialog_mary_1");
  ObjAttach("vid_livingroom_dialog_mary_2", "obj_livingroom_dialog_plan_1");
  ObjSet("vid_livingroom_dialog_mary_2",  { playing = 1, endtrig = private.opn_dialog_show_answers });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_maryspeaks3()

  cmn.ShowDlgBbt( "dlg_mary_phrase_3" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_mary_3_voc");

  --ObjSet("tmr_livingroom_dialog_timer",  { time = 7.2, playing = 1, endtrig = private.opn_dialog_maryspeaks4 });

  ObjAttach("vid_livingroom_dialog_mary_3", "obj_livingroom_dialog_plan_1");

  ObjMultiSet( { {"vid_livingroom_dialog_mary_3", { playing = 1, endtrig = private.opn_dialog_maryspeaks4 }},
                 {"spr_livingroom_dialog_mary", { alp = 0 }} } );

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_maryspeaks4()

  cmn.ShowDlgBbt( "dlg_mary_phrase_4" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_mary_4_voc");

  --ObjSet("tmr_livingroom_dialog_timer",  { time = 6.2, playing = 1, endtrig = private.hide_dialog });

  ObjDetach("vid_livingroom_dialog_mary_3");
  ObjAttach("vid_livingroom_dialog_mary_4", "obj_livingroom_dialog_plan_1");
  ObjSet("vid_livingroom_dialog_mary_4",  { playing = 1, endtrig = private.hide_dialog });

end;
--------------------------------------------------------------------------------------------
function private.opn_dialog_show_answers()

  local func_after = function ()

    cmn.Lock( 0 );

    cmn.CallEventHandler( "opn_marydialog" );
  
  end;

  ObjAnimate( "obj_livingroom_dialog_choice", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

end;
--------------------------------------------------------------------------------------------
function public.dialog_choose_answer( num )

  cmn.SetEventDone( "clk_marydialoganswer" );

  cmn.Lock( 1 );
  cmn.ShowDlgBbt( "dlg_mary_answer_"..num );

  if (num == 1) then

    cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_carol_12_voc");
    ObjSet("tmr_livingroom_dialog_timer",  { time = 3.8, playing = 1, endtrig = private.opn_dialog_maryspeaks3 });

  else 

    cmn.PlayAudio("voc", "assets/levels/level1/rm_livingroom/audio/aud_carol_13_voc");
    ObjSet("tmr_livingroom_dialog_timer",  { time = 2.7, playing = 1, endtrig = private.opn_dialog_maryspeaks3 });

  end;

  ObjAnimate( "obj_livingroom_dialog_choice", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
function public.touch_dog()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_xx_dogkey");

  cmn.ShowBbt( "obj_shelf_use_dograil" );

  ObjSet("anm_shelf_touch_dog",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_box_shelf()

  cmn.Lock( 1 );

  cmn.ShowBbt( "obj_shelf_use_policebadge" );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_xx_box");

  ObjSet("anm_shelf_box_touch",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_ballon_shelf()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_xx_balloon3");

  cmn.ShowBbt( "use_pushpin" );

  ObjSet("anm_shelf_touch_balloon",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_frontdoor()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_xx_crowonhandle");

  cmn.ShowBbt( "obj_frontdoor_use_frontkey" );

  ObjSet("anm_frontdoor_crow_touch",  { alp = 1, playing = 1, endtrig = private.touch_frontdoor_end });

  ObjSet("anm_frontdoor_crow",  { alp = 0, playing = 0 });
  ObjSet("anm_frontdoor_crow_head",  { alp = 0, playing = 0 });
  ObjSet("spr_frontdoor_door",  { alp = 0 });

end;
--------------------------------------------------------------------------------------------
function private.touch_frontdoor_end()

  cmn.Lock( 0 );

  ObjSet("anm_frontdoor_crow_touch",  { alp = 0, playing = 0 });

  ObjSet("anm_frontdoor_crow",  { alp = 1, playing = 1 });
  ObjSet("anm_frontdoor_crow_head",  { alp = 1, playing = 1 });
  ObjSet("spr_frontdoor_door",  { alp = 1 });

end;
--------------------------------------------------------------------------------------------
function public.touch_balloons_table()

  cmn.Lock( 1 );

  cmn.ShowBbt( "use_pushpin_2" );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_xx_balloon");

  if not(cmn.IsEventDone("use_pushpinbigtable1")) then
    ObjSet("anm_bigtable_touch_balloon_1",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });
  end;

  if not(cmn.IsEventDone("use_pushpinbigtable2")) then
    ObjSet("anm_bigtable_touch_balloon_2",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });
  end;

end;
--------------------------------------------------------------------------------------------
function public.touch_balloons_sofa()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_xx_balloon1");

  cmn.ShowBbt( "use_pushpin_3" );

  if not(cmn.IsEventDone("use_pushpinsofa1")) then
    ObjSet("anm_sofa_touch_balloon_1",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });
  end;

  if not(cmn.IsEventDone("use_pushpinsofa2")) then
    ObjSet("anm_sofa_touch_balloon_2",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });
  end;

end;
--------------------------------------------------------------------------------------------
function private.show_scaryface()

  cmn.Lock( 1 );

  local func_after = function ()

    cmn.SetEventDone( "opn_sofascaryface" );
    cmn.CallEventHandler( "opn_sofascaryface" );
  
  end;

  local func_after2 = function ()

    cmn.Lock( 0 );
    cmn.ShowBbt( "sofa_after_scary" );
    cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_6_mus");
  
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_scaryface");

  ObjSet("anm_sofa_mirror_face_show",  { playing = 1, endtrig = func_after });

  ObjAnimate( "spr_sofa_back", "scale_xy", 0, 0, func_after2, { 0,0,1,1,   2.5,0,2,2,  4,0,2,2,  4.5,0,1,1 } );
  ObjAnimate( "spr_sofa_back", "pos_xy",   0, 0, "", { 0,0,0,0,   2.5,0,-200,107,  4,0,-200,107,   4.5,0,0,0 } );

end;
---------------------------------------------------------------------------------------
function public.play_flashback1()

  int_blackbartext.Hide();

  if not(cmn.IsEventDone("clk_playflashback1")) then

    cmn.SetEventDone( "clk_playflashback1" );
    --cmn.CallEventHandler("clk_playflashback1");

    cmn.PlayCutScene( "flashback1",
                      "assets/levels/level1/rm_livingroom/zz_shelf/cs/anm_cs_cafe",
                      { 5 },
                      function () cmn.ShowNote( "spr_shelf_note_2" ); cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_mus"); end, 
                      "assets/levels/level1/rm_livingroom/audio/aud_flashback_2_mus",
                      "assets/levels/level1/rm_livingroom/audio/aud_flashback_2_voc" );


  else 

    cmn.ShowNote( "spr_shelf_note_2" );

  end;

end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** MMG_SOFA *** () end;
--*********************************************************************************************************************
--********************************************************************************************************************
private.zz_sofa = {};
public.zz_sofa = {};

function private.Init_Sofa()

  private.zz_sofa.win_state = { 4, 5, 2 };
  private.zz_sofa.active = 0;

  --------------------------------------------------------------------------------------------
  game.hint[ "win_sofa" ] = {

      type = "click",
      use_place = "gzz_sofa_mmg",
      room = "rm_livingroom",
      zz = "zz_sofa",
      zz_gate = "gzz_livingroom_sofa"
  };
  -----------------------------------------------------------------------------------
  local win_sofa = function ()

    if cmn.IsEventDone( "win_sofa" ) then

      ObjSet( "obj_sofa_box_open", { alp = 1, input = 1 } );

      ObjSet( "spr_livingroom_sofa_case_open", { alp = 1 } );
      ObjDelete( "spr_livingroom_sofa_case_closed" );
    
      ObjDelete( "obj_sofa_game" );
      ObjDelete( "spr_sofa_box_closed" );
      ObjDelete( "gzz_sofa_mmg" );

    end;

  end;

  -----------------------------------------------------------------------------------
  cmn.AddSubscriber( "win_sofa", win_sofa, "rm_livingroom" );

end;
--********************************************************************************************************************
function public.zz_sofa.ZoomMg()

  cmn.Lock( 1 );

  local func_after = private.zz_sofa.ZoomMg_end;

  private.zz_sofa.active = 1;

  ObjAnimate( "spr_sofa_back", "scale_xy", 0, 0, "", { 0,0,1,1,   0.3,0,1,1,    1.5,0,2,2 } );
  ObjAnimate( "spr_sofa_back", "pos_xy",   0, 0, func_after, { 0,0,0,0,   0.3,0,0,0,    1.5,0,140,-160 } );

end;
-----------------------------------------------------------------------------------
function private.zz_sofa.ZoomMg_end()

  local func_after = function ()

    cmn.Lock( 0 );
    cmn.MiniGameShow();
    private.zz_sofa.CheckWin();

    ObjSet("spr_sofa_back",  { pos_x = 0, pos_y = 0, scale_x = 1, scale_y = 1 });
    ObjSet("obj_sofa_game",  { input = 1 });

    if not(cmn.IsEventDone("opn_mgsofa")) then

      cmn.SetEventDone("opn_mgsofa");

      local arrows = { { pos_x = 320, pos_y = 0, ang = -1.57 }, { pos_x = 300, pos_y = 120, ang = -2.6 } };

      if ( GetWideScreen() ) then

        ObjMultiSet( { {"obj_tutorial_tutor_13", { pos_x = -600 }},
                       {"obj_tutorial_tutor_13_1", { pos_x = 1127 }} } );

        arrows[1] = { pos_x = 400, pos_y = 0, ang = -1.57 };

        cmn.TutorialShow( "tutor_13", 0, 600, 511, arrows );

      else 

        ObjMultiSet( { {"obj_tutorial_tutor_13", { pos_x = -512 }},
                       {"obj_tutorial_tutor_13_1", { pos_x = 956 }} } );

        arrows[2] = { pos_x = 400, pos_y = 120, ang = -2.6 };

        cmn.TutorialShow( "tutor_13", 0, 512, 511, arrows );

      end;

    end;

  end;

  ObjAnimate( "obj_sofa_game", "alp", 0, 0, func_after, { 0, 0, 0,   0.3, 0, 1 } );

end;
-----------------------------------------------------------------------------------
function private.zz_sofa.StartConditions()

  ng_global.progress[ "std" ][ "win_sofa" ].skip = 0;
  ng_global.progress[ "std" ][ "win_sofa" ].state = { 1, 1, 1 };

end;
-----------------------------------------------------------------------------------
function public.zz_sofa.Reset()

  local need_r = false;
  local old_y = 0;

  for i = 1, 3, 1 do

    if (private.zz_sofa.state[i] ~= 1) then

      if not(need_r) then
        need_r = true;
      end;

      old_y = 360 - (private.zz_sofa.state[i] - 1)*72;

      ObjAnimate( "obj_sofa_game_wheel"..i.."_move", "pos_y",   0, 0, "", { 0, 0, old_y,    0.5, 0, 360 } );

      ObjAnimate( "spr_sofa_game_picture_"..i.."_"..private.zz_sofa.state[i], "alp",   0, 0, "", { 0, 0, 1,    0.5, 0, 0 } );
      ObjAnimate( "spr_sofa_game_picture_"..i.."_1", "alp",   0, 0, "", { 0, 0, 0,    0.5, 0, 1 } );

    end;

  end;

  if need_r then

    private.zz_sofa.StartConditions();

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_clk_codereel");

    private.zz_sofa.state = ng_global.progress[ "std" ][ "win_sofa" ].state;
    ObjSet("tmr_sofa_timer",  { time = 0.5, playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

  end;

end;
-----------------------------------------------------------------------------------
function public.zz_sofa.Skip()

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_clk_codereel");

  ng_global.progress[ "std" ][ "win_sofa" ].skip = 1;
  ng_global.progress[ "std" ][ "win_sofa" ].state = { 4, 5, 2 };

  local old_y = 0;
  local new_y = 0;

  for i = 1, 3, 1 do

    if (private.zz_sofa.state[i] ~= private.zz_sofa.win_state[i]) then

      old_y = 360 - (private.zz_sofa.state[i] - 1)*72;
      new_y = 360 - (private.zz_sofa.win_state[i] - 1)*72;

      ObjAnimate( "obj_sofa_game_wheel"..i.."_move", "pos_y",   0, 0, "", { 0, 0, old_y,    0.5, 0, new_y } );

      ObjAnimate( "spr_sofa_game_picture_"..i.."_"..private.zz_sofa.state[i], "alp",   0, 0, "", { 0, 0, 1,    0.5, 0, 0 } );
      ObjAnimate( "spr_sofa_game_picture_"..i.."_"..private.zz_sofa.win_state[i], "alp",   0, 0, "", { 0, 0, 0,    0.5, 0, 1 } );

    end;

  end;

  private.zz_sofa.state = ng_global.progress[ "std" ][ "win_sofa" ].state;
  ObjSet("tmr_sofa_timer",  { time = 0.5, playing = 1, endtrig = private.zz_sofa.CheckWin });

end;
-----------------------------------------------------------------------------------
function private.zz_sofa.DrawScene()

  for i = 1, 3, 1 do

    ObjSet("obj_sofa_game_wheel"..i.."_move",  { pos_y = 360 - (private.zz_sofa.state[i] - 1)*72 });
  
    for j = 1, 5, 1 do

      if (private.zz_sofa.state[i] == j) then
        ObjSet("spr_sofa_game_picture_"..i.."_"..j,  { alp = 1 });
      else 
        ObjSet("spr_sofa_game_picture_"..i.."_"..j,  { alp = 0 });
      end;

    end;
    
  end;

end;
-----------------------------------------------------------------------------------
function private.zz_sofa.CheckWin()

  local win_flag = true;

  for i = 1, 3, 1 do
  
    if (private.zz_sofa.state[i] ~= private.zz_sofa.win_state[i]) then
      win_flag = false;
      break;
    end;
    
  end;

  if win_flag then

    common_impl.PauseAchiev(1);

      ObjMultiSet( { {"obj_sofa_box_open", { alp = 1 }},
                     {"spr_sofa_box_closed", { alp = 0 }},
                     {"gzz_sofa_mmg", { active = 0, visible = 0, input = 0 }} } );


    cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_opencase");

    ObjAnimate( "obj_sofa_game", "alp", 0, 0, private.zz_sofa.Win,
    { 
      0.0, 0, 1, 
      0.5, 0, 1, 
        1, 0, 0
    } );

  else 

    cmn.Lock( 0 );

  end;

end;
-----------------------------------------------------------------------------------
function private.zz_sofa.Win()

  common_impl.PauseAchiev(0);

  private.zz_sofa.active = 0;

  cmn.MiniGameHide("sofa");
  cmn.SetEventDone( "win_sofa" );
  cmn.CallEventHandler( "win_sofa" );

  if ng_global.progress[ "std" ][ "win_sofa" ].skip == 0 and ng_global.noskipgames[ "win_sofa" ] == nil then

    ng_global.noskipgames[ "win_sofa" ] = 1;
    common_impl.CheckAchiev("mg");

  end;

  cmn.Lock( 0 );

end;
-----------------------------------------------------------------------------------
function public.zz_sofa.ClickWheel( num )

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_livingroom/audio/aud_clk_codereel");

  local old_y = 360 - (private.zz_sofa.state[num] - 1)*72;
  local new_y = old_y - 72;

  local old_pic = private.zz_sofa.state[num];

  local func_after = private.zz_sofa.CheckWin;

  private.zz_sofa.state[num] = private.zz_sofa.state[num] + 1;

  if (private.zz_sofa.state[num] == 6) then

    private.zz_sofa.state[num] = 1;

    func_after = function ()

      ObjSet("obj_sofa_game_wheel"..num.."_move",  { pos_y = 360 });
      private.zz_sofa.CheckWin();

    end;

  end;

  ObjAnimate( "obj_sofa_game_wheel"..num.."_move", "pos_y",   0, 0, func_after, { 0, 0, old_y,    0.5, 0, new_y } );

  ObjAnimate( "spr_sofa_game_picture_"..num.."_"..old_pic, "alp",   0, 0, "", { 0, 0, 1,    0.5, 0, 0 } );
  ObjAnimate( "spr_sofa_game_picture_"..num.."_"..private.zz_sofa.state[num], "alp",   0, 0, "", { 0, 0, 0,    0.5, 0, 1 } );

end;
--*******************************************************************************************************************
  --------------------------------------------------------------------
--*********************************************************************************************************************
--***function *** Prolax *** () end ************************************************************************************
--*********************************************************************************************************************
  --------------------------------------------------------------------
  private.del_plan = { {40, 10}, {10, 5} }; 
  --------------------------------------------------------------------
  function private.AnimDialogView()

    local cur_x = GetGameCursorPos()[1];
    local cur_y = GetGameCursorPos()[2];

    local del_x = 512 - cur_x;
    local del_y = 384 - cur_y;

    local move_x = (del_x/683);
    local move_y = (del_y/384);

    for i = 1, 2, 1 do

      ObjSet("obj_livingroom_dialog_plan_"..i,  { pos_x = math.floor(move_x * private.del_plan[i][1]),  pos_y = math.floor(move_y * private.del_plan[i][2]) });

    end;

    ObjSet("tmr_livingroom_dialog_timer_2",  { time = 0.01, playing = 1, endtrig = private.AnimDialogView });

  end;
--*****************************************************************************************