--*********************************************************************************************************************
function public.Init()

  private.Init_Subroom();
  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_foyer";
  --------------------------------------------------------------------------------------------
  ObjAttach( "zz_reception", "room_hub" );
  ObjAttach( "zz_archdoors", "room_hub" );
  ObjAttach( "zz_wallfountain", "room_hub" );
  
  --------------------------------------------------------------------------------------------
  -- function get_doorhandle () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_doorhandle" ] = {

      type = "get",
      get_obj = "spr_reception_doorhandle",
      room = private.room_objname,
      zz = "zz_reception",
      zz_gate = "gzz_foyer_reception"
  };
  --------------------------------------------------------------------------------------------
  local get_doorhandle_inv = function ()
  
    interface.InventoryItemAdd( "inv_doorhandle", "spr_reception_doorhandle" );
  
  end;
  
  local get_doorhandle_closezz = function ()

    ObjSet( "obj_reception_use_button", { input = true } );
  
    ObjDelete( "gfx_reception_doorhandle" );
    ObjDelete( "spr_reception_doorhandle_sh" );

    ObjDelete( "spr_foyer_door_handle" );
  
  end;
  
  cmn.AddSubscriber( "get_doorhandle", get_doorhandle_inv );
  cmn.AddSubscriber( "get_doorhandle", get_doorhandle_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_photo2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_photo2" ] = {

      type = "get",
      get_obj = "spr_archdoors_photo2",
      room = private.room_objname,
      zz = "zz_archdoors",
      zz_gate = "gzz_foyer_archdoors"
  };
  --------------------------------------------------------------------------------------------
  local get_photo2_inv = function ()
  
    interface.InventoryItemAdd( "inv_photo2", "spr_archdoors_photo2" );
  
  end;
  
  local get_photo2_closezz = function ()
  
    ObjDelete( "gfx_archdoors_photo2" );
  
  end;
  
  cmn.AddSubscriber( "get_photo2", get_photo2_inv );
  cmn.AddSubscriber( "get_photo2", get_photo2_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_lever () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_lever" ] = {

      type = "get",
      get_obj = "spr_wallfountain_lever",
      room = private.room_objname,
      zz = "zz_wallfountain",
      zz_gate = "gzz_foyer_wallfountain"
  };
  --------------------------------------------------------------------------------------------
  local get_lever_inv = function ()
  
    interface.InventoryItemAdd( "inv_lever", "spr_wallfountain_lever" );
  
  end;
  
  local get_lever_closezz = function ()
  
    ObjDelete( "gfx_wallfountain_lever" );
    ObjDelete( "gzz_foyer_wallfountain" );
  
  end;
  
  cmn.AddSubscriber( "get_lever", get_lever_inv );
  cmn.AddSubscriber( "get_lever", get_lever_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_insulatingtape () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_insulatingtape" ] = {

      type = "use",
      inv_obj = "inv_insulatingtape",
      use_place = "obj_reception_use_insulatingtape",
      room = private.room_objname,
      zz = "zz_reception",
      zz_gate = "gzz_foyer_reception"
  };
  --------------------------------------------------------------------------------------------
  local use_insulatingtape_inv = function ()
  
    interface.InventoryItemRemove( "inv_insulatingtape" );
  
  end;
  local use_insulatingtape_beg = function ()
  
    ObjDelete( "obj_reception_use_insulatingtape" );
  
  end;
  local use_insulatingtape_end = function ()
  
     ObjMultiSet( { {"obj_reception_cliconbutton", { input = true, visible = true, active = true }},
                    {"spr_reception_wire_2", { alp = 1 }} } );


     ObjDelete("spr_reception_wire_1");
     ObjDelete("fx_reception_p_flash");

     ObjDelete("spr_foyer_wire");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_insulatingtape", use_insulatingtape_beg, private.room_objname );
  cmn.AddSubscriber( "use_insulatingtape", use_insulatingtape_inv );
  cmn.AddSubscriber( "use_insulatingtape", use_insulatingtape_end, private.room_objname );
  cmn.AddSubscriber( "use_insulatingtape_inv", use_insulatingtape_inv, private.room_objname );
  cmn.AddSubscriber( "use_insulatingtape_beg", use_insulatingtape_beg, private.room_objname );
  cmn.AddSubscriber( "use_insulatingtape_end", use_insulatingtape_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_photo2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_photo2" ] = {

      type = "use",
      inv_obj = "inv_photo2",
      use_place = "obj_reception_use_photo2",
      room = private.room_objname,
      zz = "zz_reception",
      zz_gate = "gzz_foyer_reception"
  };
  --------------------------------------------------------------------------------------------
  local use_photo2_inv = function ()
  
    interface.InventoryItemRemove( "inv_photo2" );
  
  end;
  local use_photo2_beg = function ()
  
    ObjDelete( "obj_reception_use_photo2" );
  
  end;
  local use_photo2_end = function ()
  
    ObjSet( "gmg_foyer_keys", { input = true, visible = true, active = true } );

    ObjDelete( "gzz_foyer_reception" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_photo2", use_photo2_beg, private.room_objname );
  cmn.AddSubscriber( "use_photo2", use_photo2_inv );
  cmn.AddSubscriber( "use_photo2", use_photo2_end, private.room_objname );
  cmn.AddSubscriber( "use_photo2_inv", use_photo2_inv, private.room_objname );
  cmn.AddSubscriber( "use_photo2_beg", use_photo2_beg, private.room_objname );
  cmn.AddSubscriber( "use_photo2_end", use_photo2_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_ironkey () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_ironkey" ] = {

      type = "use",
      inv_obj = "inv_ironkey",
      use_place = "obj_archdoors_use_ironkey",
      room = private.room_objname,
      zz = "zz_archdoors",
      zz_gate = "gzz_foyer_archdoors"
  };
  --------------------------------------------------------------------------------------------
  local use_ironkey_inv = function ()
  
    interface.InventoryItemRemove( "inv_ironkey" );
  
  end;
  local use_ironkey_beg = function ()
  
    ObjDelete( "obj_archdoors_use_ironkey" );
  
  end;
  local use_ironkey_end = function ()
  
    ObjMultiSet( { {"obj_archdoors_use_pliers", { input = true, visible = true, active = true }},
                   {"anm_archdoors_key_2", { alp = 1, frame = 70 }} } );

    ObjDelete( "anm_archdoors_key_1" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_ironkey", use_ironkey_beg, private.room_objname );
  cmn.AddSubscriber( "use_ironkey", use_ironkey_inv );
  cmn.AddSubscriber( "use_ironkey", use_ironkey_end, private.room_objname );
  cmn.AddSubscriber( "use_ironkey_inv", use_ironkey_inv, private.room_objname );
  cmn.AddSubscriber( "use_ironkey_beg", use_ironkey_beg, private.room_objname );
  cmn.AddSubscriber( "use_ironkey_end", use_ironkey_end, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function use_valve () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_valve" ] = {

      type = "use",
      inv_obj = "inv_valve",
      use_place = "obj_wallfountain_use_valve",
      room = private.room_objname,
      zz = "zz_wallfountain",
      zz_gate = "gzz_foyer_wallfountain"
  };
  --------------------------------------------------------------------------------------------
  local use_valve_inv = function ()
  
    interface.InventoryItemRemove( "inv_valve" );
  
  end;
  local use_valve_beg = function ()
  
    ObjDelete( "obj_wallfountain_use_valve" );
  
  end;
  local use_valve_end = function ()
  
    ObjMultiSet( { {"anm_wallfountain_water_off", { alp = 1 }},
                   {"obj_wallfountain_clk_valve", { input = 1 }},
                   {"spr_foyer_valve", { alp = 1 }} } );

  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_valve", use_valve_beg, private.room_objname );
  cmn.AddSubscriber( "use_valve", use_valve_inv );
  cmn.AddSubscriber( "use_valve", use_valve_end, private.room_objname );
  cmn.AddSubscriber( "use_valve_inv", use_valve_inv, private.room_objname );
  cmn.AddSubscriber( "use_valve_beg", use_valve_beg, private.room_objname );
  cmn.AddSubscriber( "use_valve_end", use_valve_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_lever () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_lever" ] = {

      type = "use",
      inv_obj = "inv_lever",
      use_place = "obj_reception_use_button",
      room = private.room_objname,
      zz = "zz_reception",
      zz_gate = "gzz_foyer_reception"

  };
  --------------------------------------------------------------------------------------------
  local use_lever_inv = function ()
  
    interface.InventoryItemRemove( "inv_lever" );
  
  end;
  local use_lever_beg = function ()
  
    ObjDelete( "obj_reception_use_button" );
  
  end;
  local use_lever_end = function ()
  
    ObjMultiSet( { {"anm_reception_touch_button", { alp = 1 }},
                   {"obj_reception_cliconbutton", { input = 1 }} } );

  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_lever", use_lever_beg, private.room_objname );
  cmn.AddSubscriber( "use_lever", use_lever_inv );
  cmn.AddSubscriber( "use_lever", use_lever_end, private.room_objname );
  cmn.AddSubscriber( "use_lever_inv", use_lever_inv, private.room_objname );
  cmn.AddSubscriber( "use_lever_beg", use_lever_beg, private.room_objname );
  cmn.AddSubscriber( "use_lever_end", use_lever_end, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function clk_cliconbutton () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_cliconbutton" ] = {

      type = "clk",
      use_place = "obj_reception_cliconbutton",
      room = private.room_objname,
      zz = "zz_reception",
      zz_gate = "gzz_foyer_reception"
  };
  --------------------------------------------------------------------------------------------
  local clk_cliconbutton_beg = function ()
  
    ObjDelete( "obj_reception_cliconbutton");
    ObjDelete( "anm_reception_touch_cover");
    ObjDelete( "spr_reception_red_light");
    ObjDelete( "anm_reception_touch_button");
  
  end;
  local clk_cliconbutton_end = function ()

    --ObjSet( "obj_reception_use_photo2", { visible = true, active = true, 
    --                                      event_mup = function () cmn.ShowBbt( "obj_reception_use_photo2" ); end } );


    ObjMultiSet( { {"anm_reception_open_cover", { frame = 48, alp = 1 }},
                   {"gmg_foyer_keys", { input = true, visible = true, active = true }},
                   {"obj_foyer_keydoors_2", { alp = 1 }} } );

    ObjDelete( "gzz_foyer_reception" );
    ObjDelete( "obj_foyer_keydoors_1" );
    ObjDelete( "obj_reception_keys_touch" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_cliconbutton", clk_cliconbutton_beg, private.room_objname );
  cmn.AddSubscriber( "clk_cliconbutton", clk_cliconbutton_end, private.room_objname );
  cmn.AddSubscriber( "clk_cliconbutton_beg", clk_cliconbutton_beg, private.room_objname );
  cmn.AddSubscriber( "clk_cliconbutton_end", clk_cliconbutton_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_valve () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_valve" ] = {

      type = "clk",
      use_place = "obj_wallfountain_clk_valve",
      room = private.room_objname,
      zz = "zz_wallfountain",
      zz_gate = "gzz_foyer_wallfountain"
  };
  --------------------------------------------------------------------------------------------
  local clk_valve = function ()

    ObjMultiSet( { {"spr_wallfountain_lever", { input = true }},
                   {"anm_wallfountain_water_off", { frame = 121 }} } );
  
    ObjDelete( "obj_wallfountain_clk_valve" );
    ObjDelete( "anm_wallfountain_water_off_2" );
    ObjDelete( "fx_wallfountain_water_splash" );
    ObjDelete( "fx_wallfountain_water_rings" );
    ObjDelete( "fx_wallfountain_water_steam" );
    ObjDelete( "vid_wallfountain_water_hot" );

    ObjDelete( "fx_foyer_water" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_valve", clk_valve, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function opn_foyer () end;
  --------------------------------------------------------------------------------------------
  local opn_foyer_map = function ()
  
    int_map_impl.OpenRoom( "rm_foyer" );

  end;
  local opn_foyer_loc = function ()
  
    ObjSet("anm_foyer_horse",  { playing = 1 });

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_foyer", opn_foyer_map);
  cmn.AddSubscriber( "opn_foyer", opn_foyer_loc, private.room_objname);
  --------------------------------------------------------------------------------------------
  -- function opn_eventhall () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "opn_eventhall" ] = {

      type = "clk",
      use_place = "grm_foyer_eventhall",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local opn_eventhall = function ()

    ObjMultiSet( { {"obj_foyer_gates", { input = 0, active = 0, visible = 0 }},
                   {"rm_foyer", { color_r = 0, color_g = 0, color_b = 0 }} } );

  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_eventhall", opn_eventhall, private.room_objname );

end;
--********************************************************************************************************************
function private.Init_Subroom()
  
  subroom.Define( "zz_reception" );
  subroom.Define( "zz_wallfountain" );

  function zz_reception.Close()

    cmn.HideNote( 0 );

  end;

  function zz_reception.PreOpen()
    
    if not(cmn.IsEventDone( "use_insulatingtape" )) then

      cmn.PlayAudio("env", "assets/levels/common/audio/aud_electr_env");

    end;

  end;

  function zz_reception.PreClose()
    
    if not(cmn.IsEventDone( "use_insulatingtape" )) then

      cmn.StopAllEnv("assets/levels/common/audio/aud_foyer_env");
      cmn.PlayAudio("env", "assets/levels/common/audio/aud_foyer_env");

    end;

  end;

  function zz_wallfountain.PreOpen()
    
    if not(cmn.IsEventDone( "clk_valve" )) then

      cmn.PlayAudio("env", "assets/levels/common/audio/aud_wallfountain_env");

    end;

  end;

  function zz_wallfountain.PreClose()
    
    if not(cmn.IsEventDone( "clk_valve" )) then

      cmn.StopAllEnv("assets/levels/common/audio/aud_foyer_env");
      cmn.PlayAudio("env", "assets/levels/common/audio/aud_foyer_env");
      cmn.PlayAudio("env", "assets/levels/common/audio/aud_water_env");

    end;

  end;

end;
--*********************************************************************************************************************
function public.Load()

end;
--*********************************************************************************************************************
function public.Open()

  private.opn_foyer();

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_foyer_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_foyer_env");

  if not(cmn.IsEventDone("clk_valve")) then
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_water_env");
  end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_insulatingtape()

  local item = "inv_insulatingtape";

  if cmn.ApplyObj( item, "gzz_foyer_reception" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_reception" );

  elseif ( cmn.ApplyObj( item, "obj_reception_use_insulatingtape" )  ) then

    cmn.CallEventHandler( "use_insulatingtape_inv" );
    cmn.CallEventHandler( "use_insulatingtape_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_insulatingtape" );
      cmn.CallEventHandler( "use_insulatingtape_end" );

      cmn.StopAllEnv("assets/levels/common/audio/aud_foyer_env");
      cmn.PlayAudio("env", "assets/levels/common/audio/aud_foyer_env");

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_insulatingtape");

    ObjAnimate( "spr_reception_wire_1", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 1.0, 
      0.3, 0, 0.0
    } );
    ObjAnimate( "spr_reception_wire_2", "alp", 0, 0, "",
    { 
      0.0, 0, 0.0, 
      0.3, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_photo2()

  local item = "inv_photo2";

  if cmn.ApplyObj( item, "gzz_foyer_reception" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_reception" );

  elseif ( cmn.ApplyObj( item, "obj_reception_use_photo2" )  and cmn.IsEventDone("clk_cliconbutton")) then

    cmn.CallEventHandler( "use_photo2_inv" );
    cmn.CallEventHandler( "use_photo2_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_photo2" );
      cmn.CallEventHandler( "use_photo2_end" );

      common.CloseSubRoom();
      cmn.GotoRoom( "mg_keys" );

    end;

    --ObjAnimate( "spr", "alp", 0, 0, trg_after,
    --{ 
    --  0.0, 0, 0.0, 
    --  0.3, 0, 1.0
    --} );

    trg_after();

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_ironkey()

  local item = "inv_ironkey";

  if cmn.ApplyObj( item, "gzz_foyer_archdoors" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_archdoors" );

  elseif ( cmn.ApplyObj( item, "obj_archdoors_use_ironkey" ) ) then

    cmn.CallEventHandler( "use_ironkey_inv" );
    cmn.CallEventHandler( "use_ironkey_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_ironkey" );
      cmn.CallEventHandler( "use_ironkey_end" );
    
    end;

    local trg_after2 = function ()

      ObjSet("anm_archdoors_key_1",  { alp = 0 });
      ObjSet("anm_archdoors_key_2",  { alp = 1, playing = 1, endtrig = trg_after });
    
    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_usekey");

    ObjSet("anm_archdoors_key_1",  { playing = 1, endtrig = trg_after2 });

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_valve()

  local item = "inv_valve";

  if cmn.ApplyObj( item, "gzz_foyer_wallfountain" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_wallfountain" );

  elseif ( cmn.ApplyObj( item, "obj_wallfountain_use_valve" ) ) then

    cmn.CallEventHandler( "use_valve_inv" );
    cmn.CallEventHandler( "use_valve_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_valve" );
      cmn.CallEventHandler( "use_valve_end" );

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_valve");

    ObjAnimate( "anm_wallfountain_water_off", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0, 
      0.5, 0, 1
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_lever()

  local item = "inv_lever";

  if cmn.ApplyObj( item, "gzz_foyer_reception" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_reception" );

  elseif ( cmn.ApplyObj( item, "obj_reception_use_button" ) ) then

    cmn.CallEventHandler( "use_lever_inv" );
    cmn.CallEventHandler( "use_lever_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_lever" );
      cmn.CallEventHandler( "use_lever_end" );

    end;

    cmn.Lock(1);
    cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_loadbutton");

    ObjAnimate( "anm_reception_touch_button", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0, 
      0.5, 0, 1
    } );

  else

    cmn.WrongApply();  

  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_doorhandle()

  cmn.SetEventDone( "get_doorhandle" );
  cmn.CallEventHandler( "get_doorhandle" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_photo2()

  cmn.SetEventDone( "get_photo2" );
  cmn.CallEventHandler( "get_photo2" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_lever()

  cmn.SetEventDone( "get_lever" );
  cmn.CallEventHandler( "get_lever" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.clk_cliconbutton()

  cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_xx_red_button");

  if cmn.IsEventDone("use_insulatingtape") then

    local func_after = function ()

      cmn.SetEventDone( "clk_cliconbutton" );
      cmn.CallEventHandler( "clk_cliconbutton_end" );

      cmn.Lock( 0 );
      
      common.CloseSubRoom();
      cmn.GotoRoom( "mg_keys" );

    end;

    cmn.CallEventHandler( "clk_cliconbutton_beg" );

    ObjSet("anm_reception_open_cover", {endtrig = func_after, playing = 1, alp = 1});
    cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_opencupboard");
  
  else

   local func_after = function ()

      cmn.Lock( 0 );
    
    end;

    ObjSet("anm_reception_touch_button", {endtrig = func_after, playing = 1});

  end; 
 
  cmn.Lock( 1 );

end;
--------------------------------------------------------------------------------------------
function public.clk_valve()

  local func_after = function ()

    cmn.SetEventDone( "clk_valve" );
    cmn.CallEventHandler( "clk_valve" );

    cmn.Lock( 0 );
    cmn.StopAllEnv("assets/levels/common/audio/aud_foyer_env");
    cmn.PlayAudio("env", "assets/levels/common/audio/aud_foyer_env");
  
  end;

  ObjSet("anm_wallfountain_water_off",  { playing = 1, endtrig = func_after });
  ObjSet("anm_wallfountain_water_off_2",  { playing = 1 });

  ObjAnimate( "fx_wallfountain_water_splash", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
      1, 0, 1,
    1.2, 0, 0.7,
    1.4, 0, 0.5,
    1.6, 0, 0
  } );

  ObjAnimate( "fx_wallfountain_water_rings", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
      1, 0, 1,
    1.2, 0, 0.5,
    1.4, 0, 0.2,
    1.6, 0, 0
  } );

  ObjAnimate( "fx_wallfountain_water_steam", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
      1, 0, 1,
    1.2, 0, 0.7,
    1.4, 0, 0.5,
    1.6, 0, 0
  } );

  ObjAnimate( "vid_wallfountain_water_hot", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
      1, 0, 1,
    1.2, 0, 0.5,
    1.4, 0, 0.2,
    1.6, 0, 0
  } );
  
  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_clk_valve");

end;
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_foyer()

  if not ( cmn.IsEventDone( "opn_foyer" ) ) then

    cmn.SetEventDone( "opn_foyer" );
    cmn.CallEventHandler( "opn_foyer" );

    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_foyer/vid_scaryhorse", 
                              function () cmn.PlayAudio("mus", "assets/levels/common/audio/aud_howl3_mus"); end,
                             "assets/levels/level1/rm_foyer/audio/aud_scaryhorse_mus", "" );

  end;

end;
--*********************************************************************************************************************
function public.opn_eventhall()

  local func_after = function ()

    cmn.CallEventHandler( "opn_eventhall" );

    if ( IsDemoEdition() ) or ( IsSurveyEdition() ) then

      cmn.GotoRoom( "rm_demoscreen" );

    else

      --cmn.LevelSwitch( "level2", 2 );
      --ng_global.progress["std"].common.chapter = "level2";
      --ng_global.progress[ "std" ].common.currentroom = "rm_";

    end;

  end;

  local func_playoutro = function ()

    cmn.Lock( 0 );
    cmn.PlayFullscreenVideo( "assets/levels/level1/rm_foyer/vid_outro", func_after, "assets/levels/level1/rm_foyer/audio/aud_outro_mus", "assets/levels/level1/rm_foyer/audio/aud_outro_voc" );

  end;

  if not ( cmn.IsEventDone( "opn_eventhall" ) ) then

    cmn.SetEventDone( "opn_eventhall" );
    cmn.Lock( 1 );

    ObjAnimate( "rm_foyer", "color_r", 0, 0, func_playoutro, {0,0,1,  1,0,0} );
    ObjAnimate( "rm_foyer", "color_g", 0, 0, "", {0,0,1,  1,0,0} );
    ObjAnimate( "rm_foyer", "color_b", 0, 0, "", {0,0,1,  1,0,0} );

  end;

end;
--*********************************************************************************************************************
function public.touch_key_cover()

  cmn.ShowBbt( "touch_reception_cover" );

  ObjSet("anm_reception_touch_cover", {endtrig = function() cmn.Lock(0); end, playing = 1});
  
  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_xx_cupboard");

end;
--------------------------------------------------------------------------------------------
function public.touch_picture()

  --cmn.ShowBbt( "touch_reception_cover" );

  ObjSet("anm_foyer_picture", {endtrig = function() cmn.Lock(0); end, playing = 1});
  
  cmn.Lock(1);
  cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_crary_crow");

end;
--********************************************************************************************************************