--*********************************************************************************************************************
function public.Init()

  --DbgTrace("***rm_carolsroom.Init");

  private.Init_Subroom();
  private.Init_Window();

  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_carolsroom";
  --------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------
  -- function beg_level1 () end;
  --------------------------------------------------------------------------------------------
  local beg_level1 = function ()

    --DbgTrace("***beg_level1");

    int_map_impl.OpenRoom( "rm_carolsroom" );
  
  end;

  cmn.AddSubscriber( "beg_level1", beg_level1 );
  --------------------------------------------------------------------------------------------
  -- function get_pushpin () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_pushpin" ] = {

      type = "get",
      get_obj = "spr_window_pushpin",
      room = private.room_objname,
      zz = "zz_window",
      zz_gate = "gzz_carolsroom_window"
  };
  --------------------------------------------------------------------------------------------
  local get_pushpin_inv = function ()
  
    interface.InventoryItemAdd( "inv_pushpin", "spr_window_pushpin" );
  
  end;
  
  local get_pushpin_closezz = function ()

    --DbgTrace("***get_pushpin_closezz");
  
    ObjDelete( "spr_window_pushpin_sh" );
    ObjDelete( "gfx_window_pushpin" );
  
  end;
  
  cmn.AddSubscriber( "get_pushpin", get_pushpin_inv );
  cmn.AddSubscriber( "get_pushpin", get_pushpin_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_flag () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_flag" ] = {

      type = "get",
      get_obj = "spr_window_flag",
      room = private.room_objname,
      zz = "zz_window",
      zz_gate = "gzz_carolsroom_window"
  };
  --------------------------------------------------------------------------------------------
  local get_flag_inv = function ()
  
    interface.InventoryItemAdd( "inv_flag", "spr_window_flag" );
    int_map_impl.DecreaseRoomTasks("rm_carolsroom");
  
  end;
  
  local get_flag_closezz = function ()
  
    ObjDelete( "spr_window_flag_sh" );
    ObjDelete( "gfx_window_flag" );
    --ObjDelete( "gzz_carolsroom_window" );
    ObjSet("gzz_carolsroom_window",  { visible = 0, active = 0 });

    ObjDelete( "spr_carolsroom_window_flag" );
  
  end;
  
  cmn.AddSubscriber( "get_flag", get_flag_inv );
  cmn.AddSubscriber( "get_flag", get_flag_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_scissors () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_scissors" ] = {

      type = "get",
      get_obj = "spr_window_scissors",
      room = private.room_objname,
      zz = "zz_window",
      zz_gate = "gzz_carolsroom_window"
  };
  --------------------------------------------------------------------------------------------
  local get_scissors_inv = function ()
  
    interface.InventoryItemAdd( "inv_scissors", "spr_window_scissors" );
  
  end;
  
  local get_scissors_closezz = function ()

    --DbgTrace("***get_scissors_closezz");
  
    ObjDelete( "gfx_window_scissors" );
    ObjDelete( "spr_window_scissors_sh" );

    ObjDelete( "spr_carolsroom_window_scissors" );
  
  end;
  
  cmn.AddSubscriber( "get_scissors", get_scissors_inv );
  cmn.AddSubscriber( "get_scissors", get_scissors_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_goldenpendant () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_goldenpendant" ] = {

      type = "get",
      get_obj = "spr_window_goldenpendant",
      room = private.room_objname,
      zz = "zz_window",
      zz_gate = "gzz_carolsroom_window"
  };
  --------------------------------------------------------------------------------------------
  local get_goldenpendant_inv = function ()
  
    interface.InventoryItemAdd( "inv_goldenpendant", "spr_window_goldenpendant" );
  
  end;
  
  local get_goldenpendant_closezz = function ()

    --ObjSet("obj_window_openlouvre",  { input = 1 });
  
    ObjDelete( "gfx_window_goldenpendant" );
    ObjDelete( "spr_window_goldenpendant_sh" );

    ObjDelete( "spr_carolsroom_window_amulet" );
  
  end;
  
  cmn.AddSubscriber( "get_goldenpendant", get_goldenpendant_inv );
  cmn.AddSubscriber( "get_goldenpendant", get_goldenpendant_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_scissors () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_scissors" ] = {

      type = "use",
      inv_obj = "inv_scissors",
      use_place = "obj_deskinroom_use_scissors",
      room = private.room_objname,
      zz = "zz_deskinroom",
      zz_gate = "gzz_carolsroom_deskinroom"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_scissorsparcel" ] = {

      type = "use",
      inv_obj = "inv_scissors",
      use_place = "obj_complex_parcel_use_scissors",
      room = "int_complex_inv",
      zz = "inv_complex_parcel",
      zz_gate = "inv_parcel"
  };
  --------------------------------------------------------------------------------------------
  local use_scissors_beg = function ()
  
    ObjDelete( "obj_deskinroom_use_scissors" );
  
  end;
  local use_scissors_end = function ()
  
    ObjSet( "gho_carolsroom_hogift", { input = true, visible = true, active = true } );
    ObjSet( "spr_carolsroom_table_gift_open", { alp = 1 } );

    ObjDelete( "gzz_carolsroom_deskinroom" );
    ObjDelete( "spr_carolsroom_table_gift" );
  
  end;

  local use_scissorsparcel_inv = function ()
    
    interface.InventoryItemRemove( "inv_scissors" );

    --ObjSet("inv_parcel_star_light",  { alp = 0 });

  end;
  local use_scissorsparcel_beg = function ()
    
    ObjDelete( "obj_complex_parcel_use_scissors" );

  end;
  local use_scissorsparcel_end = function ()

    ObjMultiSet( { {"anm_complex_parcel_use_scissors", { frame = 135, pos_z = 8 }},
                   {"spr_complex_parcel_wallpicture", { input = true, alp = 1 }},
                   {"anm_complex_parcel_open_box", {frame = 46 }} } );

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_scissors", use_scissors_beg, private.room_objname );
  cmn.AddSubscriber( "use_scissors", use_scissors_end, private.room_objname );
  cmn.AddSubscriber( "use_scissors_beg", use_scissors_beg, private.room_objname );
  cmn.AddSubscriber( "use_scissors_end", use_scissors_end, private.room_objname );

  cmn.AddSubscriber( "use_scissorsparcel", use_scissorsparcel_inv );
  cmn.AddSubscriber( "use_scissorsparcel", use_scissorsparcel_beg, "inv_complex_parcel" );
  cmn.AddSubscriber( "use_scissorsparcel", use_scissorsparcel_end, "inv_complex_parcel" );
  cmn.AddSubscriber( "use_scissorsparcel_inv", use_scissorsparcel_inv );
  cmn.AddSubscriber( "use_scissorsparcel_beg", use_scissorsparcel_beg, "inv_complex_parcel" );
  cmn.AddSubscriber( "use_scissorsparcel_end", use_scissorsparcel_end, "inv_complex_parcel" );
  --------------------------------------------------------------------------------------------
  -- function use_letter () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_letter" ] = {

      type = "use",
      inv_obj = "inv_letter",
      use_place = "obj_window_use_letter",
      room = private.room_objname,
      zz = "zz_window",
      zz_gate = "gzz_carolsroom_window"
  };
  --------------------------------------------------------------------------------------------
  local use_letter_inv = function ()

    --DbgTrace("***use_letter_inv");
  
    interface.InventoryItemRemove( "inv_letter" );
  
  end;
  local use_letter_beg = function ()

    --DbgTrace("***use_letter_beg");
  
    ObjDelete( "obj_window_use_letter" );
  
  end;
  local use_letter_end = function ()

    --DbgTrace("***use_letter_end");

    ObjSet( "spr_carolsroom_window_letters", { alp = 1 } );
  
    if ( cmn.IsEventDone( "use_photo1" ) ) then
      ObjMultiSet( { {"obj_window_game", { alp = 1 }},
                     {"obj_window_pencils", { input = 1 }} } );
    else 
      ObjSet( "obj_window_game", { alp = 1 } );
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_letter", use_letter_beg, private.room_objname );
  cmn.AddSubscriber( "use_letter", use_letter_inv );
  cmn.AddSubscriber( "use_letter", use_letter_end, private.room_objname );
  cmn.AddSubscriber( "use_letter_inv", use_letter_inv, private.room_objname );
  cmn.AddSubscriber( "use_letter_beg", use_letter_beg, private.room_objname );
  cmn.AddSubscriber( "use_letter_end", use_letter_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_photo1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_photo1" ] = {

      type = "use",
      inv_obj = "inv_photo1",
      use_place = "obj_window_use_photo1",
      room = private.room_objname,
      zz = "zz_window",
      zz_gate = "gzz_carolsroom_window"
  };
  --------------------------------------------------------------------------------------------
  local use_photo1_inv = function ()
  
    interface.InventoryItemRemove( "inv_photo1" );
  
  end;
  local use_photo1_beg = function ()
  
    ObjDelete( "obj_window_use_photo1" );
  
  end;
  local use_photo1_end = function ()

    ObjMultiSet( { {"spr_window_box_closed_foto", { alp = 1 }},
                   {"obj_window_box_closed", { input = 1 }} } );
  
    if ( cmn.IsEventDone( "use_letter" ) ) then
      ObjMultiSet( { {"obj_window_game", { alp = 1 }},
                     {"obj_window_pencils", { input = 1 }} } );
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_photo1", use_photo1_beg, private.room_objname );
  cmn.AddSubscriber( "use_photo1", use_photo1_inv );
  cmn.AddSubscriber( "use_photo1", use_photo1_end, private.room_objname );
  cmn.AddSubscriber( "use_photo1_inv", use_photo1_inv, private.room_objname );
  cmn.AddSubscriber( "use_photo1_beg", use_photo1_beg, private.room_objname );
  cmn.AddSubscriber( "use_photo1_end", use_photo1_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_staple () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_staple" ] = {

      type = "use",
      inv_obj = "inv_staple",
      use_place = "obj_door_use_staple",
      room = private.room_objname,
      zz = "zz_door",
      zz_gate = "gzz_carolsroom_door"
  };
  --------------------------------------------------------------------------------------------
  local use_staple_inv = function ()
  
    interface.InventoryItemRemove( "inv_staple" );
  
  end;
  local use_staple_beg = function ()
  
    ObjDelete( "obj_door_use_staple" );
    ObjDelete( "anm_door_touch" );
  
  end;
  local use_staple_end = function ()
  
    ObjSet( "grm_carolsroom_livingroom", { active = 1, visible = 1, input = 1, 
                                           event_mdown = function () cmn.GotoRoomMDown( "carolsroom_livingroom" ); end,
                                           event_mup = function () cmn.GotoRoomMUp( "carolsroom_livingroom", "rm_livingroom" ); end } );

    ObjSet("spr_carolsroom_door_open",  { alp = 1 });

    ObjDelete( "gzz_carolsroom_door" );
    ObjDelete( "spr_carolsroom_door_closed" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_staple", use_staple_beg, private.room_objname );
  cmn.AddSubscriber( "use_staple", use_staple_inv );
  cmn.AddSubscriber( "use_staple", use_staple_end, private.room_objname );
  cmn.AddSubscriber( "use_staple_inv", use_staple_inv, private.room_objname );
  cmn.AddSubscriber( "use_staple_beg", use_staple_beg, private.room_objname );
  cmn.AddSubscriber( "use_staple_end", use_staple_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_openlouvre () end;
  --------------------------------------------------------------------------------------------
  local clk_openlouvre_beg = function ()
  
    ObjSet( "obj_window_openlouvre", { input = false } );
  
  end;
  local clk_openlouvre_end = function ()

    ObjMultiSet( { {"spr_window_flag", { input = 1 }},
                   {"spr_window_box_open_hidden_case2", { alp = 1 }},
                   {"spr_carolsroom_window_flag", { alp = 1 }} } );
  
    ObjDelete( "obj_window_openlouvre" );
    ObjDelete( "spr_window_box_open_hidden_case" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_openlouvre", clk_openlouvre_beg, private.room_objname );
  cmn.AddSubscriber( "clk_openlouvre", clk_openlouvre_end, private.room_objname );
  cmn.AddSubscriber( "clk_openlouvre_beg", clk_openlouvre_beg, private.room_objname );
  cmn.AddSubscriber( "clk_openlouvre_end", clk_openlouvre_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickonalarmclock1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickonalarmclock1" ] = {

      type = "click",
      use_place = "obj_carolsroom_clickonalarmclock1",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_clickonalarmclock1_beg = function ()
  
    ObjSet( "obj_carolsroom_clickonalarmclock1", { input = false } );
  
  end;
  local clk_clickonalarmclock1_end = function ()

    ObjMultiSet( { {"obj_carolsroom_clickonalarmclock2", { input = true }},
                   {"anm_carolsroom_dialog_hand2", { alp = 1 }} } );
  
    ObjDelete( "obj_carolsroom_clickonalarmclock1" );
    ObjDelete( "anm_carolsroom_dialog_hand1" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickonalarmclock1", clk_clickonalarmclock1_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock1", clk_clickonalarmclock1_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock1_beg", clk_clickonalarmclock1_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock1_end", clk_clickonalarmclock1_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickonalarmclock2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickonalarmclock2" ] = {

      type = "click",
      use_place = "obj_carolsroom_clickonalarmclock2",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_clickonalarmclock2_beg = function ()
  
    ObjSet( "obj_carolsroom_clickonalarmclock2", { input = false } );
  
  end;

  local clk_clickonalarmclock2_end = function ()

    ObjMultiSet( { {"obj_carolsroom_clickonalarmclock3", { input = true }},
                   {"anm_carolsroom_dialog_hand3", { alp = 1 }} } );
  
    ObjDelete( "obj_carolsroom_clickonalarmclock2" );
    ObjDelete( "anm_carolsroom_dialog_hand2" );
    ObjDelete( "vid_carolsroom_blinking" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickonalarmclock2", clk_clickonalarmclock2_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock2", clk_clickonalarmclock2_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock2_beg", clk_clickonalarmclock2_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock2_end", clk_clickonalarmclock2_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickonalarmclock3 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickonalarmclock3" ] = {

      type = "click",
      use_place = "obj_carolsroom_clickonalarmclock3",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_clickonalarmclock3_beg = function ()
  
    ObjSet( "obj_carolsroom_clickonalarmclock3", { input = false } );
    ObjAttach("obj_carolsroom_dialog_clothes", "rm_carolsroom");
  
  end;
  local clk_clickonalarmclock3_mid = function ()

    ObjSet("rm_carolsroom",  { scale_x = 1, scale_y = 1, pos_x = 0, pos_y = 0 });

  end;
  local clk_clickonalarmclock3_end = function ()

    --ObjMultiSet( { {"obj_carolsroom_dialog_clothes", { alp = 1, input = 1 }},
    --               {"spr_carolsroom_dialog_clock_button", { pos_y = 226 }} } );

    ObjDelete( "obj_carolsroom_dialog_clothes" );
    ObjDelete( "anm_carolsroom_dialog_mirror_face_appear" );
    ObjDelete( "vid_carolsroom_dialog_mirror_carol_talks" );
    ObjAttach("obj_carolsroom_dialog_mirror", "rm_carolsroom");

    ObjMultiSet( { {"obj_carolsroom_dialog_mirror", { alp = 1, input = 1 }},
                   {"anm_carolsroom_dialog_mirror_face", { alp = 1, playing = 1 }},
                   {"obj_carolsroom_dialog_mirror_exit", { input = 1 }} } );
  
    ObjDelete( "obj_carolsroom_dialog_bed" );
    ObjDelete( "anm_carolsroom_dialog_hand3" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickonalarmclock3", clk_clickonalarmclock3_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock3", clk_clickonalarmclock3_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock3", clk_clickonalarmclock3_mid, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock3_mid", clk_clickonalarmclock3_mid, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock3_beg", clk_clickonalarmclock3_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonalarmclock3_end", clk_clickonalarmclock3_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickonclothes1 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickonclothes1" ] = {

      type = "click",
      use_place = "obj_carolsroom_clickonclothes1",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_clickonclothes1_beg = function ()
  
    ObjSet( "obj_carolsroom_clickonclothes1", { input = false } );
  
  end;
  local clk_clickonclothes1_end = function ()

    ObjDelete( "obj_carolsroom_clickonclothes1" );
    ObjDelete( "obj_carolsroom_dialog_chair" );
    ObjDelete( "anm_carolsroom_dialog_get_clothes" );

    if (cmn.IsEventDone("clk_clickonclothes2")) then
      ObjDelete( "obj_carolsroom_dialog_clothes" );
      ObjDelete( "anm_carolsroom_dialog_mirror_face_appear" );
      ObjDelete( "vid_carolsroom_dialog_mirror_carol_talks" );
      ObjAttach("obj_carolsroom_dialog_mirror", "rm_carolsroom");

      ObjMultiSet( { {"obj_carolsroom_dialog_mirror", { alp = 1, input = 1 }},
                     {"anm_carolsroom_dialog_mirror_face", { alp = 1, playing = 1 }},
                     {"obj_carolsroom_dialog_mirror_exit", { input = 1 }} } );
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickonclothes1", clk_clickonclothes1_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes1", clk_clickonclothes1_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes1_beg", clk_clickonclothes1_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes1_end", clk_clickonclothes1_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_clickonclothes2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_clickonclothes2" ] = {

      type = "click",
      use_place = "obj_carolsroom_clickonclothes2",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_clickonclothes2_beg = function ()
  
    ObjSet( "obj_carolsroom_clickonclothes2", { input = false } );
  
  end;
  local clk_clickonclothes2_mid = function ()

    ObjSet("rm_carolsroom",  { scale_x = 1, scale_y = 1, pos_x = 0, pos_y = 0 });

  end;
  local clk_clickonclothes2_end = function ()

    ObjDelete( "spr_carolsroom_dialog_snikers" );
    ObjDelete( "spr_carolsroom_dialog_snikers_sh" );
    ObjDelete( "anm_carolsroom_dialog_get_snikers" );

    if (cmn.IsEventDone("clk_clickonclothes1")) then
      ObjDelete( "obj_carolsroom_dialog_clothes" );
      ObjDelete( "anm_carolsroom_dialog_mirror_face_appear" );
      ObjDelete( "vid_carolsroom_dialog_mirror_carol_talks" );
      ObjAttach("obj_carolsroom_dialog_mirror", "rm_carolsroom");

      ObjMultiSet( { {"obj_carolsroom_dialog_mirror", { alp = 1, input = 1 }},
                     {"anm_carolsroom_dialog_mirror_face", { alp = 1, playing = 1 }},
                     {"obj_carolsroom_dialog_mirror_exit", { input = 1 }} } );
    end;
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_clickonclothes2", clk_clickonclothes2_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes2", clk_clickonclothes2_end, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes2", clk_clickonclothes2_mid, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes2_mid", clk_clickonclothes2_mid, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes2_beg", clk_clickonclothes2_beg, private.room_objname );
  cmn.AddSubscriber( "clk_clickonclothes2_end", clk_clickonclothes2_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_firstclkdoor () end;
  --------------------------------------------------------------------------------------------
  local clk_firstclkdoor_beg = function ()
  
    ObjSet( "obj_carolsroom_firstclkdoor", { input = false } );
    ObjSet( "grm_carolsroom_livingroom", { active = 0, visible = 0, input = 0, event_mup = "" } );
  
  end;
  local clk_firstclkdoor_end = function ()

    ObjSet( "spr_carolsroom_door_open", { alp = 0 } );
    ObjSet( "spr_carolsroom_door_closed", { alp = 1 } );

    ObjSet( "gzz_carolsroom_door", { active = 1, visible = 1, input = 1 } );
  
    ObjDelete( "obj_carolsroom_firstclkdoor" );
    ObjDelete( "vid_carolsroom_scarydoor" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_firstclkdoor", clk_firstclkdoor_beg, private.room_objname );
  cmn.AddSubscriber( "clk_firstclkdoor", clk_firstclkdoor_end, private.room_objname );
  cmn.AddSubscriber( "clk_firstclkdoor_beg", clk_firstclkdoor_beg, private.room_objname );
  cmn.AddSubscriber( "clk_firstclkdoor_end", clk_firstclkdoor_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_closemirror () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_closemirror" ] = {

      type = "click",
      use_place = "obj_carolsroom_dialog_mirror_exit",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_closemirror = function ()

    ObjMultiSet( { {"obj_carolsroom_gates", { active = 1, visible = 1, input = 1 }},
                   {"obj_carolsroom_clk_opncurtains", { input = 1 }},
                   {"obj_carolsroom_bbts", { input = 1 }} } );

    ObjDelete( "obj_carolsroom_dialog_mirror" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_closemirror", clk_closemirror, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_opncurtains () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_opncurtains" ] = {

      type = "click",
      use_place = "obj_carolsroom_clk_opncurtains",
      room = private.room_objname

  };
  --------------------------------------------------------------------------------------------
  local clk_opncurtains = function ()

    ObjAttach("vid_carolsroom_curtains_open", "rm_carolsroom");

    ObjMultiSet( { {"gzz_carolsroom_window", { active = 1, visible = 1, input = 1 }},
                   {"vid_carolsroom_curtains_open", { alp = 1, playing = 1 }} } );

    ObjDelete( "spr_carolsroom_curtain_left_closed" );
    ObjDelete( "spr_carolsroom_curtain_right_closed" );
    ObjDelete( "obj_carolsroom_clk_opncurtains" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_opncurtains", clk_opncurtains, private.room_objname );

end;
--********************************************************************************************************************
function private.Init_Subroom()
  
  subroom.Define( "zz_window" );
  subroom.Define( "zz_deskinroom" );
  --subroom.Define( "zz_door" );

  function zz_window.Open()

    if not( cmn.IsEventDone( "opn_window" )) then
      cmn.SetEventDone("opn_window");
      local arrows = { { pos_x = 0, pos_y = 120, ang = 2.3 } };
      cmn.TutorialShow( "tutor_3", 0, 512, 220, arrows );
    end;

    if ( cmn.IsEventDone( "use_letter" ) and cmn.IsEventDone( "use_photo1" ) and not(cmn.IsEventDone( "win_window" )) ) then
      cmn.MiniGameShow();
      private.zz_window.DrawScene();
      private.zz_window.CheckWin()
    end;

  end;
  
  function zz_window.PreClose()

    if ( cmn.IsEventDone( "use_letter" ) and cmn.IsEventDone( "use_photo1" ) and not(cmn.IsEventDone( "win_window" )) ) then
      cmn.MiniGameHide("window");
    end;

  end;

  function zz_window.Close()

    cmn.HideNote( 0 );

    if not( cmn.IsEventDone( "get_scissorsclosezz" )) and cmn.IsEventDone("get_scissors") and not(common_impl.go_acievements) then

      cmn.SetEventDone("get_scissorsclosezz");

      int_inventory.Show( true );

      local scissors_pos = GetObjPosByObj("hub_int_inventory_scissors");

      ObjSet("obj_tutorial_tutor_4_2",  { pos_x = scissors_pos[1] });

      local arrows = { { pos_x = 250, pos_y = 140, ang = -2.3 }, { pos_x = scissors_pos[1] - 350, pos_y = 320, ang = 3.14 } };
      cmn.TutorialShow( "tutor_4", 0, 350, 284, arrows );

    end;

  end;
  
  function zz_deskinroom.Close()

    cmn.HideNote( 0 );

    if cmn.IsEventDone("use_scissors") then

      local arrows = { { pos_x = 250, pos_y = 140, ang = -2.3 } };
      cmn.TutorialShow( "tutor_5", 0, 350, 284, arrows );

    end;

  end;

end;
--*********************************************************************************************************************
function public.Load()

  if not( cmn.IsEventDone( "use_letter" ) ) then
    private.zz_window.StartConditions();
  end;

  private.zz_window.state = ng_global.progress[ "std" ][ "win_window" ].state;

  if ( cmn.IsEventDone( "use_letter" ) and not(cmn.IsEventDone( "win_window" )) ) then
    private.zz_window.DrawScene();
  end;

end;
--*********************************************************************************************************************
function public.Open()

  if cmn.IsEventDone("win_hogift") and cmn.IsEventDone("tutor_11") and not( cmn.IsEventDone( "opn_carolsroomafterho" ) ) then

    if (ObjGet("hub_int_inventory_boxstaple")) then

      cmn.SetEventDone("opn_carolsroomafterho");

      int_inventory.Show( true );

      local boxstaple_pos = GetObjPosByObj("hub_int_inventory_boxstaple");

      ObjMultiSet( { {"obj_tutorial_tutor_8", { pos_x = -boxstaple_pos[1] }},
                     {"obj_tutorial_tutor_8_1", { pos_x = boxstaple_pos[1] }} } );

      local arrows = { { pos_x = 0, pos_y = 160, ang = 3.14 } };
      cmn.TutorialShow( "tutor_8", 0, boxstaple_pos[1], 450, arrows );

    end;

  end;

  if not( cmn.IsEventDone( "get_scissorsclosezz" )) and cmn.IsEventDone("get_scissors") and not(common_impl.go_acievements) then

    cmn.SetEventDone("get_scissorsclosezz");

    int_inventory.Show( true );

    local scissors_pos = GetObjPosByObj("hub_int_inventory_scissors");

    ObjSet("obj_tutorial_tutor_4_2",  { pos_x = scissors_pos[1] });

    local arrows = { { pos_x = 250, pos_y = 140, ang = -2.3 }, { pos_x = scissors_pos[1] - 350, pos_y = 320, ang = 3.14 } };
    cmn.TutorialShow( "tutor_4", 0, 350, 284, arrows );

  end;

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_carolsroom_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_carolsroom_env");

  private.opn_carolsroom();

--  if not ( cmn.IsEventDone( "clk_closemirror" ) ) then
--
--    interface.WidgetSetVisible( "InterfaceWidget_Inventory", 0, 0 )
--    interface.WidgetSetInput( "InterfaceWidget_Inventory", 0 )
--
--  end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_scissors()

  local item = "inv_scissors";

  if cmn.ApplyObj( item, "gzz_carolsroom_deskinroom" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_deskinroom" );

  elseif ( cmn.ApplyObj( item, "obj_deskinroom_use_scissors" ) ) then

    cmn.CallEventHandler( "use_scissors_beg" );

    local trg_after = function ()

      cmn.Lock(0);
      common.CloseSubRoom();

      cmn.SetEventDone( "use_scissors" );
      cmn.CallEventHandler( "use_scissors_end" );

    end;

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_scissorstogift");

    ObjSet("anm_deskinroom_use_scissors",  { playing = 1, endtrig = trg_after });

  elseif cmn.ObjIntersectCheck( item, "obj_complex_parcel_use_scissors" )  then

    cmn.CallEventHandler( "use_scissorsparcel_inv", "inv_complex_parcel" );
    cmn.CallEventHandler( "use_scissorsparcel_beg", "inv_complex_parcel" );

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/inv_complex/inv_parcel/audio/aud_usescissorsparcel");

    ObjSet("anm_complex_parcel_use_scissors",  { playing = 1, endtrig = private.use_scissors_openbox });

  else

    --DbgTrace("3333333333333333");

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function private.use_scissors_openbox()

  local func_after = function ()

    cmn.Lock(0);

    cmn.SetEventDone( "use_scissorsparcel" );
    cmn.CallEventHandler( "use_scissorsparcel_end", "inv_complex_parcel" );
    
  end;

  ObjMultiSet( { {"anm_complex_parcel_use_scissors", { frame = 135, pos_z = 8 }},
                 {"anm_complex_parcel_open_box", { playing = 1, endtrig = func_after }} } );

end;
--------------------------------------------------------------------------------------------
function public.use_letter()

  local item = "inv_letter";

  if cmn.ApplyObj( item, "gzz_carolsroom_window" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_window" );

  elseif ( cmn.ApplyObj( item, "obj_window_use_letter" ) ) and ( cmn.CheckMultiObject( "letter", 5 ) ) then

    cmn.CallEventHandler( "use_letter_inv" );
    cmn.CallEventHandler( "use_letter_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_letter" );
      cmn.CallEventHandler( "use_letter_end" );
      
    end;

    if ( cmn.IsEventDone( "use_photo1" ) ) then

      trg_after = function ()

        private.start_letters_mg(1);

      end;

    end;

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_useletter");

    ObjAnimate( "obj_window_game", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.3, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function private.start_letters_mg( event )

  --local trg_after;

  cmn.Lock(0);

  if (event == 1) then

      cmn.SetEventDone( "use_letter" );
      cmn.CallEventHandler( "use_letter_end" );

  else 

      cmn.SetEventDone( "use_photo1" );
      cmn.CallEventHandler( "use_photo1_end" );

  end;

  cmn.MiniGameShow();

end;
--------------------------------------------------------------------------------------------
function public.use_photo1()

  local item = "inv_photo1";

  if cmn.ApplyObj( item, "gzz_carolsroom_window" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_window" );

  elseif ( cmn.ApplyObj( item, "obj_window_use_photo1" ) ) then

    cmn.CallEventHandler( "use_photo1_inv" );
    cmn.CallEventHandler( "use_photo1_beg" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_photo1" );
      cmn.CallEventHandler( "use_photo1_end" );
      
    end;

    if  cmn.IsEventDone( "use_letter" )  then

      trg_after = function ()

        private.start_letters_mg(2);

      end;

    end;

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_usephoto");

    ObjAnimate( "spr_window_box_closed_foto", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.3, 0, 1.0
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_staple()

  local item = "inv_staple";

  if cmn.ApplyObj( item, "gzz_carolsroom_door" )  and cmn.IsEventDone("clk_firstclkdoor") then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_door" );

  elseif ( cmn.ApplyObj( item, "obj_door_use_staple" ) ) then

    cmn.CallEventHandler( "use_staple_inv" );
    cmn.CallEventHandler( "use_staple_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      common.CloseSubRoom();

      cmn.SetEventDone( "use_staple" );
      cmn.CallEventHandler( "use_staple_end" );
    
    end;

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_usestaple");

    ObjAnimate( "spr_door_clip1", "alp", 0, 0, "",
    { 
      0.0, 0, 0.0, 
      0.3, 0, 1.0
    } );

    ObjAnimate( "obj_door_lock1", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 1, 
      0.5, 0, 1,
        1, 0, 0
    } );

    ObjAnimate( "obj_door_lock2", "alp", 0, 0, "",
    { 
      0.0, 0, 0, 
      0.5, 0, 0,
        1, 0, 1
    } );

  else

    cmn.WrongApply();  

  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_pushpin()

  cmn.SetEventDone( "get_pushpin" );
  cmn.CallEventHandler( "get_pushpin" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_flag()

  cmn.SetEventDone( "get_flag" );
  cmn.CallEventHandler( "get_flag" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_scissors()

  cmn.SetEventDone( "get_scissors" );
  cmn.CallEventHandler( "get_scissors" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_goldenpendant()

  cmn.SetEventDone( "get_goldenpendant" );
  cmn.CallEventHandler( "get_goldenpendant" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  public.clk_openlouvre();

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.clk_openlouvre()

  cmn.CallEventHandler( "clk_openlouvre_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_openlouvre" );
    cmn.CallEventHandler( "clk_openlouvre_end" );

    cmn.Lock(0);
  
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_takegoldenpendant");

  ObjAnimate( "spr_window_box_open_hidden_case2", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

  ObjAnimate( "spr_window_box_open_hidden_case", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );
  
  cmn.Lock(1);

end;
--------------------------------------------------------------------------------------------
function public.clk_clickonalarmclock1()

  cmn.CallEventHandler( "clk_clickonalarmclock1_beg" );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_alarm1");

  ObjSet("anm_carolsroom_dialog_hand1",  { playing = 1, endtrig = function () private.clk_clickonalarmclock_blink( 1 ); end });
  
  cmn.Lock(1);

end;
--------------------------------------------------------------------------------------------
function private.clk_clickonalarmclock_blink( num )

  local func_after = function ()

    ObjDetach("vid_carolsroom_blinking");

    cmn.SetEventDone( "clk_clickonalarmclock1" );
    cmn.CallEventHandler( "clk_clickonalarmclock1_end" );

    cmn.ShowBbt( "after_clk_alarm1" );
    cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_3_voc");
    ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 3.5, playing = 1, endtrig = function () cmn.Lock(0); end });
  
  end;

  if num == 2 then

    func_after = function ()

      cmn.SetEventDone( "clk_clickonalarmclock2" );
      cmn.CallEventHandler( "clk_clickonalarmclock2_end" );

      cmn.ShowBbt( "after_clk_alarm2" );
      cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_4_voc");
      ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 4.3, playing = 1, endtrig = function () cmn.Lock(0); end });
    
    end;

  end;

  ObjAttach("vid_carolsroom_blinking", "obj_carolsroom_dialog_bed");
  ObjSet("vid_carolsroom_blinking",  { frame = 0 });
  VidPlay("vid_carolsroom_blinking", func_after);

end;
--------------------------------------------------------------------------------------------
function public.clk_clickonalarmclock2()

  cmn.CallEventHandler( "clk_clickonalarmclock2_beg" );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_alarm2");

  ObjSet("anm_carolsroom_dialog_hand2",  { playing = 1, endtrig = function () private.clk_clickonalarmclock_blink( 2 ); end });
  
  cmn.Lock(1);

end;
--------------------------------------------------------------------------------------------
function public.clk_clickonalarmclock3()

  cmn.CallEventHandler( "clk_clickonalarmclock3_beg" );

  local func_after = private.clk_clickonalarmclock3_birthday;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_alarm3");

  ObjSet("anm_carolsroom_dialog_hand3",  { playing = 1, endtrig = func_after });

  ObjStopAnimate("spr_carolsroom_dialog_clock_bell", "alp");
  ObjStopAnimate("spr_carolsroom_dialog_clock_time", "alp");

  ObjAnimate( "spr_carolsroom_dialog_clock_bell", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.4, 0, 1,
    0.6, 0, 0
  } );

  ObjAnimate( "obj_carolsroom_dialog_clock", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.4, 0, 1,
    0.6, 0, 0
  } );

  cmn.Lock(1);

end;
--------------------------------------------------------------------------------------------
function private.clk_clickonalarmclock3_birthday()

  local func_after = private.clk_clickonalarmclock3_mid;

  ObjAnimate( "anm_carolsroom_dialog_hand3", "pos_xy", 0, 0, "", 
  { 
    0.0, 0, -171, 0, 
    0.4, 0, -100, 150
  } );

  ObjSet("anm_carolsroom_dialog_birthday",  { alp = 1, playing = 1, endtrig = func_after });

end;
--------------------------------------------------------------------------------------------
function private.clk_clickonalarmclock3_mid()

  cmn.ShowBbt( "carolsroom_birthday" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_5_voc");

  local func_after = function ()

    --cmn.ShowBbt( "carolsroom_clothes" );
    --cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_6_voc");
    --ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 3, playing = 1, endtrig = function () cmn.Lock(0); end });

    private.clk_clickonclothes2_zoom();
  
  end;

  ObjAnimate( "obj_carolsroom_dialog_bed", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
      2, 0, 1,
    2.5, 0, 0
  } );

  --ObjAnimate( "obj_carolsroom_dialog_clothes", "alp", 0, 0, "", 
  --{ 
  --  0.0, 0, 0, 
  --    2, 0, 0,
  --  2.5, 0, 1
  --} );

end;
--------------------------------------------------------------------------------------------
function public.clk_clickonclothes1()

  cmn.CallEventHandler( "clk_clickonclothes1_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_clickonclothes1" );
    cmn.CallEventHandler( "clk_clickonclothes1_end" );

    cmn.Lock(0);
    cmn.ShowBbt( "carolsroom_after_clothes" );
  
  end;

  if (cmn.IsEventDone("clk_clickonclothes2")) then
    func_after = function ()
      private.clk_clickonclothes2_mid(1);
    end;
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_clk_jacket");

  ObjSet("anm_carolsroom_dialog_get_clothes",  { playing = 1 });

  ObjAnimate( "obj_carolsroom_dialog_chair", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    0.9, 0, 1,
    1.3, 0, 0
  } );
  
  cmn.Lock(1);

end;
--------------------------------------------------------------------------------------------
function public.clk_clickonclothes2()

  --DbgTrace("*clk_snikers");

  cmn.CallEventHandler( "clk_clickonclothes2_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_clickonclothes2" );
    cmn.CallEventHandler( "clk_clickonclothes2_end" );

    cmn.Lock(0);
    cmn.ShowBbt( "carolsroom_after_shoes" );
  
  end;

  if (cmn.IsEventDone("clk_clickonclothes1")) then
    func_after = function ()
      private.clk_clickonclothes2_mid(2);
    end;
  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_clk_shoes");

  cmn.Lock(1);

  ObjSet("anm_carolsroom_dialog_get_snikers",  { playing = 1 });

  ObjAnimate( "spr_carolsroom_dialog_snikers", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    1.2, 0, 1,
    1.5, 0, 0
  } );

  ObjAnimate( "spr_carolsroom_dialog_snikers_sh", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    1.2, 0, 1,
    1.5, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
function private.clk_clickonclothes2_mid(num)

  --DbgTrace("*close_clothes");

  local func_after = function ()
    private.clk_clickonclothes2_zoom(num);
  end;

  ObjAnimate( "obj_carolsroom_dialog_clothes", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

end;
--------------------------------------------------------------------------------------------
function private.clk_clickonclothes2_zoom()

  --DbgTrace("*zoom_room");
  int_blackbartext.Hide();
  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_carol_walk");

  --cmn.ShowBbt( "carolsroom_go_to_mirror" );
  --cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_7_voc");

  local func_after = function ()
    private.clk_clickonclothes2_openmirror();
  end;

  ObjAnimate( "rm_carolsroom", "scale_xy", 0, 0, "", { 0,0,1,1,   0.5,0,1,1,    5,0,2.5,2.5 } );
  ObjAnimate( "rm_carolsroom", "pos_x",   0, 0, "", { 0,0,0,   0.5,0,0,    5,0,100 } );
  ObjAnimate( "rm_carolsroom", "pos_y",   0, 0, func_after, { 0,0,0,   0.5,1,0,
                                                              1,3,-60,  1.5,3,-40,   2,3,-100,   2.5,3,-80,   
                                                              3,3,-140,   3.5,3,-120,   4,3,-180,   4.5,3,-140,   5,2,-220 } );

end;
--------------------------------------------------------------------------------------------
function private.clk_clickonclothes2_openmirror()

  --DbgTrace("*show_mirror");

  local func_after_voc = function ()

    cmn.Lock(0);
    int_blackbartext.Hide();

    cmn.CallEventHandler( "clk_clickonalarmclock3_end" );

  end;

  local func_after = function ()

    cmn.SetEventDone( "clk_clickonalarmclock3" );

    ObjMultiSet( { {"anm_carolsroom_dialog_mirror_face_appear", { alp = 0 }},
                   {"vid_carolsroom_dialog_mirror_carol_talks", { alp = 1, playing = 1, endtrig = func_after_voc }} } );

    --cmn.ShowBbt( "carolsroom_look_in_mirror" );
    cmn.ShowBbt( "carolsroom_go_to_mirror" );
    cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_8_voc");
    --ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 3.8, playing = 1, endtrig = func_after_voc });
  
  end;

  cmn.CallEventHandler( "clk_clickonalarmclock3_mid" );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_carol_mirror");

  ObjSet("obj_carolsroom_dialog_mirror",  { alp = 1 });
  ObjAttach("obj_carolsroom_dialog_mirror", "rm_carolsroom");

  ObjMultiSet( { {"tmr_carolsroom_dialog_mirror_timer", { time = 7, playing = 1, endtrig = private.mirror_shadow }},
                 {"anm_carolsroom_dialog_mirror_face_appear", { playing = 1, endtrig = func_after }} } );

  --ObjAnimate( "spr_carolsroom_dialog_mirror_face", "alp", 0, 0, func_after, 
  --{ 
  --  0.0, 0, 0, 
  --    1, 0, 1,
  --    4, 0, 1
  --} );

end;
--------------------------------------------------------------------------------------------
function public.clk_closemirror()

  cmn.Lock(1);

  local func_after = function ()

    cmn.SetEventDone( "clk_closemirror" );
    cmn.CallEventHandler( "clk_closemirror" );

    local func_after2 = function ()

      cmn.Lock(0);
      local arrows = { { pos_x = -100, pos_y = -120, ang = 0.6 } };
      cmn.TutorialShow( "tutor_2", 0, 512, 450, arrows );

    end;

    cmn.ShowBbt( "carolsroom_after_mirror" );
    cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_9_voc");
    ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 7.5, playing = 1, endtrig = func_after2 });

    --interface.WidgetSetVisible( "InterfaceWidget_Inventory", 1, 1 )
    --interface.WidgetSetInput( "InterfaceWidget_Inventory", 1 )
  
  end;

  ObjAnimate( "obj_carolsroom_dialog_mirror", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );
  
end;
--------------------------------------------------------------------------------------------
function public.clk_opncurtains()

  cmn.Lock(1);

  local func_after = function ()

    cmn.SetEventDone( "clk_opncurtains" );
    cmn.CallEventHandler( "clk_opncurtains" );

    cmn.Lock(0);
    common_impl.GotoZz( "window" );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_opencurtains");

  ObjAnimate( "spr_carolsroom_curtain_left_closed", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

  ObjAnimate( "spr_carolsroom_curtain_right_closed", "alp", 0, 0, "", 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );

  ObjAttach("vid_carolsroom_curtains_open", "rm_carolsroom");
  ObjSet("vid_carolsroom_curtains_open",  { playing = 1 });

  ObjAnimate( "vid_carolsroom_curtains_open", "alp", 0, 0, "", 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

  --ObjAnimate( "spr_carolsroom_curtain_right", "alp", 0, 0, "", 
  --{ 
  --  0.0, 0, 0, 
  --  0.5, 0, 1
  --} );
  
end;
--------------------------------------------------------------------------------------------
function public.clk_firstclkdoor()

  cmn.CallEventHandler( "clk_firstclkdoor_beg" );

  local func_after = function ()

    cmn.SetEventDone( "clk_firstclkdoor" );
    cmn.CallEventHandler( "clk_firstclkdoor_end" );

    cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_howl_mus");

    cmn.ShowBbt( "carolsroom_scary_door" );
    cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_10_voc");
    ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 1.7, playing = 1, endtrig = function () cmn.Lock(0); end });
  
  end;

  local func_after2 = function ()

    ObjAnimate( "rm_carolsroom", "scale_xy", 0, 0, "", { 0,0,1.3,1.3,   0.5,0,1,1 } );
    ObjAnimate( "rm_carolsroom", "pos_xy",   0, 0, func_after, { 0,0,-357,-16,   0.5,0,0,0 } );

  end;

  ObjAnimate( "rm_carolsroom", "scale_xy", 0, 0, "", { 0,0,1,1,   0.5,0,1.3,1.3 } );
  ObjAnimate( "rm_carolsroom", "pos_xy",   0, 0, "", { 0,0,0,0,   0.5,0,-357,-16 } );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_doorshadow");

  ObjAttach("vid_carolsroom_scarydoor", "rm_carolsroom");
  ObjSet("vid_carolsroom_scarydoor",  { playing = 1, endtrig = func_after2 });
  ObjSet("spr_carolsroom_door_open",  { alp = 0 });
  
  cmn.Lock(1);

end;
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_carolsroom()

  --if not ( cmn.IsEventDone( "opn_carolsroom" ) ) then
    --cmn.SetEventDone( "opn_carolsroom" );
  --end;

  if not ( cmn.IsEventDone( "clk_clickonalarmclock3" ) ) and ( cmn.IsEventDone( "beg_level1" ) ) then
    private.set_alarm_play();
    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_singlealarm");
  end;

  if not ( cmn.IsEventDone( "beg_level1" ) ) then

    cmn.SetEventDone( "beg_level1" );
    cmn.CallEventHandler( "beg_level1" );

    ObjMultiSet( { {"rm_carolsroom", { color_r = 0, color_g = 0, color_b = 0 }},
                   {"obj_carolsroom_clickonalarmclock1", { input = 0 }},
                   {"tmr_carolsroom_dialog_bed_timer", { time = 0.01, playing = 1, endtrig =  private.start_intro }} } );

    --interface.WidgetSetVisible( "InterfaceWidget_Inventory", 0, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_Inventory", 0 );
    --interface.WidgetSetVisible( "InterfaceWidget_BtnHint", 0, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_BtnHint", 0 );
    --interface.WidgetSetVisible( "InterfaceWidget_BtnGuide", 0, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_BtnGuide", 0 );
    --interface.WidgetSetVisible( "InterfaceWidget_BtnMenu", 0, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_BtnMenu", 0 );

    --add map later

  end;

end;
-----------------------------------------------------------------------------------
function private.start_intro()

  local func_after = function ()

    private.set_alarm_play();

    ObjMultiSet( { {"rm_carolsroom", { color_r = 1, color_g = 1, color_b = 1 }},
                   {"obj_carolsroom_clickonalarmclock1", { input = 1 }} } );

    --interface.WidgetSetVisible( "InterfaceWidget_Inventory", 1, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_Inventory", 1 );
    --interface.WidgetSetVisible( "InterfaceWidget_BtnHint", 1, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_BtnHint", 1 );
    --interface.WidgetSetVisible( "InterfaceWidget_BtnGuide", 1, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_BtnGuide", 1 );
    --interface.WidgetSetVisible( "InterfaceWidget_BtnMenu", 1, 0 );
    --interface.WidgetSetInput( "InterfaceWidget_BtnMenu", 1 );

  end;

  ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 0.5, playing = 1, endtrig = func_after });

  cmn.PlayFullscreenVideo( "assets/levels/level1/rm_carolsroom/vid_intro", private.first_open_mid, "assets/levels/level1/rm_carolsroom/audio/aud_intro_mus", "", 1, 10 );

end;
-----------------------------------------------------------------------------------
function private.first_open_mid()

  cmn.Lock( 1 );

  cmn.ShowBbt( "carolsroom_time" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_1_voc");

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_singlealarm");

  ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 5.2, playing = 1, endtrig = private.first_open_end });

end;
-----------------------------------------------------------------------------------
function private.first_open_end()

  local func_after = function ()

    cmn.Lock( 0 );
    cmn.TutorialShow("tutor_enable");

  end;

  cmn.ShowBbt( "carolsroom_time2" );
  cmn.PlayAudio("voc", "assets/levels/level1/rm_carolsroom/audio/aud_carol_2_voc");

  ObjSet("tmr_carolsroom_dialog_bed_timer", { time = 3.5, playing = 1, endtrig = func_after });

end;
-----------------------------------------------------------------------------------
function private.set_alarm_play()

  ObjAnimate("spr_carolsroom_dialog_clock_bell", "alp", 1, 0, "", { 0, 2, 1,   0.3, 2, 0,   0.6, 2, 1 });
  ObjAnimate("spr_carolsroom_dialog_clock_time", "alp", 1, 0, "", { 0, 2, 1,   0.3, 2, 0,   0.6, 2, 1 });

end;
--------------------------------------------------------------------------------------------
function public.touch_door()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_xx_handle");

  cmn.ShowBbt( "obj_door_use_staple" );

  ObjSet("anm_door_touch",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function private.mirror_shadow()

  ObjSet("anm_carolsroom_dialog_mirror_shadow",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_bear()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_xx_toybear");

  --cmn.ShowBbt( "" );

  ObjSet("anm_carolsroom_dialog_mirror_bear",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_cosmetics()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_xx_perfume");

  --cmn.ShowBbt( "" );

  ObjSet("anm_carolsroom_dialog_mirror_cosmetics",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** MMG_WINDOW *** () end;
--*********************************************************************************************************************
--********************************************************************************************************************
private.zz_window = {};
public.zz_window = {};

function private.Init_Window()

  private.zz_window.win_state = { 2, 3, 1, 2, 1 };
  private.zz_window.start_state = { 1, 2, 3, 3, 2 };

  private.zz_window.pen_ang = { -0.6, -0.26, -0.23 };
  private.zz_window.pen_pos = { {7, 65}, {46, 89}, {95, 111}, {139, 133}, {180, 156} };

  -----------------------------------------------------------------------------------
  local win_window = function ()

    if cmn.IsEventDone( "win_window" ) then

      ObjMultiSet( { {"obj_window_box_open", { input = true, alp = 1 }},
                     {"obj_window_pencils", { input = 0 }},
                     {"spr_carolsroom_window_box_open", { alp = 1 }} } );

      ObjDelete("obj_window_box_closed");
      ObjDelete("obj_window_game");
      ObjDelete("spr_carolsroom_window_letters");

    end;

  end;

  -----------------------------------------------------------------------------------
  cmn.AddSubscriber( "win_window", win_window, private.room_objname );

end;
--********************************************************************************************************************
function private.zz_window.StartConditions()

  ng_global.progress[ "std" ][ "win_window" ].skip = 0;
  ng_global.progress[ "std" ][ "win_window" ].state = { 1, 2, 3, 3, 2 };

end;
-----------------------------------------------------------------------------------
function public.zz_window.Reset()

  local need_r = false;

  for i = 1, 5, 1 do

    if (private.zz_window.state[i] ~= private.zz_window.start_state[i]) then

      if not(need_r) then
        need_r = true;
      end;

      ObjAnimate( "spr_window_letter"..i.."_"..private.zz_window.state[i], "alp",   0, 0, "", { 0, 0, 1,    1, 0, 0 } );
      ObjAnimate( "spr_window_letter"..i.."_"..private.zz_window.start_state[i], "alp",   0, 0, "", { 0, 0, 0,    1, 0, 1 } );

    end;

  end;

  if need_r then

    private.zz_window.StartConditions();

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_clk_change_color");

    private.zz_window.state = ng_global.progress[ "std" ][ "win_window" ].state;

    ObjAnimate("spr_window_pencil_eraser_sh", "alp", 0, 0, function () cmn.Lock(0); end, { 0, 0, 1,   0.3, 0, 0,   1, 0, 0,  1.3, 0, 1});
    ObjSet("anm_window_pencil",  { frame = 0, playing = 1 });

    --ObjSet("tmr_window_timer",  { time = 0.5, playing = 1, endtrig = function () cmn.Lock(0); end; });

  end;

end;
-----------------------------------------------------------------------------------
function public.zz_window.Skip()

  ng_global.progress[ "std" ][ "win_window" ].skip = 1;
  ng_global.progress[ "std" ][ "win_window" ].state = { 2, 3, 1, 2, 1 };

  cmn.Lock(1);

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_clk_change_color");

  for i = 1, 5, 1 do

    if (private.zz_window.state[i] ~= private.zz_window.win_state[i]) then

      ObjAnimate( "spr_window_letter"..i.."_"..private.zz_window.state[i], "alp",   0, 0, "", { 0, 0, 1,    0.5, 0, 0 } );
      ObjAnimate( "spr_window_letter"..i.."_"..private.zz_window.win_state[i], "alp",   0, 0, "", { 0, 0, 0,    0.5, 0, 1 } );

    end;

  end;

  private.zz_window.state = ng_global.progress[ "std" ][ "win_window" ].state;

  --ObjAnimate("spr_window_pencil_sh", "alp", 0, 0, private.zz_window.CheckWin, { 0, 0, 1,   0.3, 0, 0,   1, 0, 0,  1.3, 0, 1});
  --ObjSet("anm_window_pencil",  { frame = 0, playing = 1 });

  ObjSet("tmr_window_timer",  { time = 0.5, playing = 1, endtrig = private.zz_window.CheckWin });

end;
-----------------------------------------------------------------------------------
function private.zz_window.DrawScene()

  for i = 1, 5, 1 do
  
    for j = 1, 3, 1 do

      if (private.zz_window.state[i] == j) then
        ObjSet("spr_window_letter"..i.."_"..j,  { alp = 1 });
      else 
        ObjSet("spr_window_letter"..i.."_"..j,  { alp = 0 });
      end;

    end;
    
  end;

end;
-----------------------------------------------------------------------------------
function private.zz_window.CheckWin()

  local win_flag = true;

  for i = 1, 5, 1 do
  
    if (private.zz_window.state[i] ~= private.zz_window.win_state[i]) then
      win_flag = false;
      break;
    end;
    
  end;

  if win_flag then

    common_impl.PauseAchiev(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_winmgwindow");

    ObjAnimate( "obj_window_box_closed", "alp", 0, 0, private.zz_window.Win, 
    { 
      0.0, 0, 1, 
      0.5, 0, 1,
        1, 0, 0
    } );

    ObjAnimate( "obj_window_game", "alp", 0, 0, "", 
    { 
      0.0, 0, 1, 
      0.5, 0, 1,
        1, 0, 0
    } );

    ObjAnimate( "obj_window_box_open", "alp", 0, 0, "", 
    { 
      0.0, 0, 0, 
      0.5, 0, 0,
        1, 0, 1
    } );

  else 

    cmn.Lock(0);

  end;

end;
-----------------------------------------------------------------------------------
function private.zz_window.Win()

  common_impl.PauseAchiev(0);

  cmn.MiniGameHide("window");
  cmn.SetEventDone( "win_window" );
  cmn.CallEventHandler( "win_window" );

  if ng_global.progress[ "std" ][ "win_window" ].skip == 0 and ng_global.noskipgames[ "win_window" ] == nil then

    ng_global.noskipgames[ "win_window" ] = 1;
    common_impl.CheckAchiev("mg");

  end;

  cmn.Lock(0);

end;
-----------------------------------------------------------------------------------
function public.zz_window.StartDrag( pen )

  ObjAnimate("spr_window_pencil_"..pen.."_sh", "alp", 0, 0, "", { 0, 0, 1,   0.3, 0, 0 });
  ObjAttach("spr_window_pencil_"..pen, "obj_window_game_fly");
  ObjSet("spr_window_pencil_"..pen,  { ang = 0.5 });

end;
-----------------------------------------------------------------------------------
function public.zz_window.PencilDrop( pen )

  cmn.Lock(1);
  local let = private.zz_window.CheckHit(pen);
  local anm_fun = { "func_use_blue_pencil", "func_use_red_pencil", "func_use_yellow_pencil" };

  ObjAttach("spr_window_pencil_"..pen, "obj_window_pencils");
  ObjSet("spr_window_pencil_"..pen,  { ang = private.zz_window.pen_ang[pen] });

  local color1_old = private.zz_window.state[let];

  if (let ~= 0) and (color1_old ~= pen) then

    cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_clk_change_color");

    local color1 = pen;

    private.zz_window.state[let] = color1;

    ObjAnimate("spr_window_letter"..let.."_"..color1_old, "alp", 0, 0, "", { 0, 0, 1,   0.7, 0, 0 });
    ObjAnimate("spr_window_letter"..let.."_"..color1, "alp", 0, 0, "", { 0, 0, 0,   0.7, 0, 1 });

    ObjAnimate("spr_window_pencil_"..pen.."_sh", "alp", 0, 0, "", { 0, 0, 0,   0.7, 0, 0,   1, 0, 1 });
    ObjAnimate("spr_window_pencil_"..pen, "alp", 0, 0, private.zz_window.CheckWin, { 0, 0, 0,   0.7, 0, 0,  1, 0, 1 });

    ObjSet("anm_window_pencil_color",  { animfunc = anm_fun[pen], frame = 0, playing = 1, alp = 1, pos_x = private.zz_window.pen_pos[let][1], pos_y = private.zz_window.pen_pos[let][2] });
    ObjAnimate("anm_window_pencil_color", "alp", 0, 0, "", { 0, 0, 1,   0.7, 0, 1,   1, 0, 0 });

  else 

    ObjAnimate("spr_window_pencil_"..pen.."_sh", "alp", 0, 0, function () cmn.Lock(0); end, { 0, 0, 0,   0.3, 0, 1 });

  end;

end;
-----------------------------------------------------------------------------------
function private.zz_window.CheckHit( pen )

  local curspos = GetGameCursorPos();

  curspos[1] = curspos[1] - 512;
  curspos[2] = curspos[2] - 384;

  local centr = { {27, 56}, {69, 77}, {115, 100}, {156, 121}, {202, 145} }; 
  local accuracy = 25;
  local let = 0;

  for i = 1, 5, 1 do

    if ( (curspos[1] - centr[i][1])^2 + (curspos[2] - centr[i][2])^2 ) <= accuracy^2 then 
    --if ( cmn.ApplyObj( "spr_window_pencil_"..pen, "obj_window_letter"..i ) ) then

      let = i;
      break;

    end; 

  end;

  return let;

end;
-----------------------------------------------------------------------------------
function public.zz_window.ClickLetter( let )

  cmn.Lock(1);

  cmn.PlayAudio("snd", "assets/levels/level1/rm_carolsroom/audio/aud_clk_change_color");

  local let2 = 0;
  local color1_old = private.zz_window.state[let];

  if (let == 1) then
    let2 = 3;
  elseif (let == 2) then
    let2 = 4;
  elseif (let == 5) then
    let2 = 1;
  end;

  local color1 = color1_old + 1;
  if (color1 == 4) then
    color1 = 1;
  end;

  private.zz_window.state[let] = color1;

  if (let2 > 0) then

    local color2_old = private.zz_window.state[let2];

    local color2 = color2_old + 1;
    if (color2 == 4) then
      color2 = 1;
    end;

    private.zz_window.state[let2] = color2;

    ObjAnimate("spr_window_letter"..let2.."_"..color2_old, "alp", 0, 0, "", { 0, 0, 1,   0.5, 0, 0 });
    ObjAnimate("spr_window_letter"..let2.."_"..color2, "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1 });

  end;

  --ObjAnimate("spr_window_pencil_sh", "alp", 0, 0, private.zz_window.CheckWin, { 0, 0, 1,   0.3, 0, 0,   1, 0, 0,  1.3, 0, 1});


  ObjAnimate("spr_window_letter"..let.."_"..color1_old, "alp", 0, 0, private.zz_window.CheckWin, { 0, 0, 1,   0.5, 0, 0 });
  ObjAnimate("spr_window_letter"..let.."_"..color1, "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1 });

end;
--******************************************************************************************************************
