--*********************************************************************************************************************
function public.Init()

  private.Init_Subroom();
  private.Init_Barcounter();

  private.radio = true;
  --------------------------------------------------------------------------------------------
  private.room_objname = "rm_cafe";
  --------------------------------------------------------------------------------------------
  ObjAttach( "zz_barcounter", "room_hub" );
  ObjAttach( "zz_wall", "room_hub" );
  ObjAttach( "zz_target", "room_hub" );
  
  --------------------------------------------------------------------------------------------
  -- function get_codesafe () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_codesafe" ] = {

      type = "get",
      get_obj = "spr_barcounter_codesafe",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  local get_codesafe_inv = function ()
  
    interface.InventoryItemAdd( "inv_codesafe", "spr_barcounter_codesafe" );
  
  end;
  
  local get_codesafe_closezz = function ()
  
    ObjDelete( "gfx_barcounter_codesafe" );

    if (cmn.IsEventDone("get_ringfrombox")) and (cmn.IsEventDone("get_bubblegum")) then
      ObjDelete( "gzz_cafe_barcounter" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_codesafe", get_codesafe_inv );
  cmn.AddSubscriber( "get_codesafe", get_codesafe_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_ringfrombox () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_ringfrombox" ] = {

      type = "get",
      get_obj = "spr_barcounter_ringfrombox",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  local get_ringfrombox_inv = function ()
  
    interface.InventoryItemAdd( "inv_ringfrombox", "spr_barcounter_ringfrombox" );
  
  end;
  
  local get_ringfrombox_closezz = function ()
  
    ObjDelete( "gfx_barcounter_ringfrombox" );
    ObjDelete( "spr_barcounter_ringfrombox_sh" );

    if (cmn.IsEventDone("get_codesafe")) and (cmn.IsEventDone("get_bubblegum")) then
      ObjDelete( "gzz_cafe_barcounter" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_ringfrombox", get_ringfrombox_inv );
  cmn.AddSubscriber( "get_ringfrombox", get_ringfrombox_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_bubblegum () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_bubblegum" ] = {

      type = "get",
      get_obj = "spr_barcounter_bubblegum",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  local get_bubblegum_inv = function ()
  
    interface.InventoryItemAdd( "inv_bubblegum", "spr_barcounter_bubblegum" );

    ObjSet("inv_arrow2_star_light",  { alp = 1 });

    int_map_impl.DecreaseRoomTasks("rm_cafe");
  
  end;
  
  local get_bubblegum_closezz = function ()
  
    ObjDelete( "gfx_barcounter_bubblegum" );
    ObjDelete( "spr_barcounter_bubblegum_sh" );

    ObjDelete( "spr_cafe_counter_gum" );

    if (cmn.IsEventDone("get_codesafe")) and (cmn.IsEventDone("get_ringfrombox")) then
      ObjDelete( "gzz_cafe_barcounter" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_bubblegum", get_bubblegum_inv );
  cmn.AddSubscriber( "get_bubblegum", get_bubblegum_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_bulb () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_bulb" ] = {

      type = "get",
      get_obj = "spr_target_bulb",
      room = private.room_objname,
      zz = "zz_target",
      zz_gate = "gzz_cafe_target"
  };
  --------------------------------------------------------------------------------------------
  local get_bulb_inv = function ()
  
    interface.InventoryItemAdd( "inv_bulb", "spr_target_bulb" );
  
  end;
  
  local get_bulb_closezz = function ()
  
    ObjDelete( "gfx_target_bulb" );
    ObjDelete( "anm_target_get_bulb" );

    ObjDelete( "spr_cafe_target_bulb" );

    if (cmn.IsEventDone("get_battery2")) and (cmn.IsEventDone("get_arrow2")) then
      ObjDelete( "gzz_cafe_target" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_bulb", get_bulb_inv );
  cmn.AddSubscriber( "get_bulb", get_bulb_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_battery2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_battery2" ] = {

      type = "get",
      get_obj = "spr_target_battery22",
      room = private.room_objname,
      zz = "zz_target",
      zz_gate = "gzz_cafe_target"
  };
  --------------------------------------------------------------------------------------------
  local get_battery2_inv = function ()
  
    --interface.InventoryItemAdd( "inv_battery22", "spr_target_battery22" );
    interface.InventoryItemAdd( "inv_battery", "spr_target_battery22", function () cmn.GetMultyObject( 'battery', 2 ); end );

    if (cmn.CheckMultiObject( "battery", 2 )) then
      ObjSet("inv_remotewithoutbatteries_star_light",  { alp = 1 });
    end;
  
  end;
  
  local get_battery2_closezz = function ()
  
    ObjDelete( "gfx_target_battery22" );
    ObjDelete( "spr_target_battery22_sh" );

    ObjDelete( "spr_cafe_target_battery" );

    if (cmn.IsEventDone("get_bulb")) and (cmn.IsEventDone("get_arrow2")) then
      ObjDelete( "gzz_cafe_target" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_battery2", get_battery2_inv );
  cmn.AddSubscriber( "get_battery2", get_battery2_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function get_arrow2 () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_arrow2" ] = {

      type = "get",
      get_obj = "spr_target_arrow2",
      room = private.room_objname,
      zz = "zz_target",
      zz_gate = "gzz_cafe_target"
  };
  --------------------------------------------------------------------------------------------
  local get_arrow2_inv = function ()
  
    common_impl.InventoryComplexItemAdd( "inv_arrow2", "spr_target_arrow2" );
    int_map_impl.DecreaseRoomTasks("rm_cafe");
  
  end;
  
  local get_arrow2_closezz = function ()
  
    ObjDelete( "gfx_target_arrow2" );
    ObjDelete( "spr_target_arrow2_sh" );

    ObjDelete( "spr_cafe_target_arrow" );

    if (cmn.IsEventDone("get_bulb")) and (cmn.IsEventDone("get_battery2")) then
      ObjDelete( "gzz_cafe_target" );
    end;
  
  end;
  
  cmn.AddSubscriber( "get_arrow2", get_arrow2_inv );
  cmn.AddSubscriber( "get_arrow2", get_arrow2_closezz, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_cd () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_cd" ] = {

      type = "use",
      inv_obj = "inv_cd",
      use_place = "obj_barcounter_use_cd",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  local use_cd_inv = function ()
  
    interface.InventoryItemRemove( "inv_cd" );
  
  end;
  local use_cd_beg = function ()
  
    ObjDelete( "obj_barcounter_use_cd" );
  
  end;
  local use_cd_end = function ()
  
    ObjMultiSet( { {"gzz_barcounter_mmg", { input = 1, active = 1, visible = 1 }},
                   {"spr_barcounter_laptop_game", { alp = 1 }},
                   {"spr_cafe_counter_laptop_game", { alp = 1 }} } );

    ObjDelete("txt_barcounter_laptop_text");

    ObjDelete("spr_cafe_counter_laptop_insert");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_cd", use_cd_beg, private.room_objname );
  cmn.AddSubscriber( "use_cd", use_cd_inv );
  cmn.AddSubscriber( "use_cd", use_cd_end, private.room_objname );
  cmn.AddSubscriber( "use_cd_inv", use_cd_inv, private.room_objname );
  cmn.AddSubscriber( "use_cd_beg", use_cd_beg, private.room_objname );
  cmn.AddSubscriber( "use_cd_end", use_cd_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_net () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_net" ] = {

      type = "use",
      inv_obj = "inv_net",
      use_place = "obj_barcounter_use_net",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  local use_net_inv = function ()
  
    interface.InventoryItemRemove( "inv_net" );
  
  end;
  local use_net_beg = function ()
  
    ObjDelete( "obj_barcounter_use_net" );
  
  end;
  local use_net_end = function ()
  
    ObjMultiSet( { {"spr_barcounter_ringfrombox", { alp = 1 }},
                   {"spr_barcounter_fishtank", { alp = 1 }} } );

    ObjDelete("anm_barcounter_use_net");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_net", use_net_beg, private.room_objname );
  cmn.AddSubscriber( "use_net", use_net_inv );
  cmn.AddSubscriber( "use_net", use_net_end, private.room_objname );
  cmn.AddSubscriber( "use_net_inv", use_net_inv, private.room_objname );
  cmn.AddSubscriber( "use_net_beg", use_net_beg, private.room_objname );
  cmn.AddSubscriber( "use_net_end", use_net_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_coin () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_coin" ] = {

      type = "use",
      inv_obj = "inv_coin",
      use_place = "obj_barcounter_use_coin",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  --------------------------------------------------------------------------------------------
  local use_coin_inv = function ()
  
    interface.InventoryItemRemove( "inv_coin" );
  
  end;
  local use_coin_beg = function ()
  
    ObjDelete( "obj_barcounter_use_coin" );
  
  end;
  local use_coin_end = function ()
  
    ObjMultiSet( { {"obj_barcounter_clk_gummachine", { input = 1, active = 1, visible = 1 }},
                   {"anm_barcounter_clk_machine", { alp = 1 }} } );

    ObjDelete( "anm_barcounter_use_coin" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_coin", use_coin_beg, private.room_objname );
  cmn.AddSubscriber( "use_coin", use_coin_inv );
  cmn.AddSubscriber( "use_coin", use_coin_end, private.room_objname );
  cmn.AddSubscriber( "use_coin_inv", use_coin_inv, private.room_objname );
  cmn.AddSubscriber( "use_coin_beg", use_coin_beg, private.room_objname );
  cmn.AddSubscriber( "use_coin_end", use_coin_end, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function use_wallpicture () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_wallpicture" ] = {

      type = "use",
      inv_obj = "inv_wallpicture",
      use_place = "obj_cafe_use_wallpicture",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  local use_wallpicture_inv = function ()
  
    interface.InventoryItemRemove( "inv_wallpicture" );
  
  end;
  local use_wallpicture_beg = function ()
  
    ObjDelete( "obj_cafe_use_wallpicture" );
  
  end;
  local use_wallpicture_end = function ()
  
    ObjMultiSet( { {"gmg_cafe_picturesonwall", { input = 1, active = 1, visible = 1 }},
                   {"spr_cafe_wallpicture", { alp = 1 }} } );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_wallpicture", use_wallpicture_beg, private.room_objname );
  cmn.AddSubscriber( "use_wallpicture", use_wallpicture_inv );
  cmn.AddSubscriber( "use_wallpicture", use_wallpicture_end, private.room_objname );
  cmn.AddSubscriber( "use_wallpicture_inv", use_wallpicture_inv, private.room_objname );
  cmn.AddSubscriber( "use_wallpicture_beg", use_wallpicture_beg, private.room_objname );
  cmn.AddSubscriber( "use_wallpicture_end", use_wallpicture_end, private.room_objname );

  --------------------------------------------------------------------------------------------
  -- function use_pliers () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pliers" ] = {

      type = "use",
      inv_obj = "inv_pliers",
      use_place = "obj_target_use_pliers",
      room = private.room_objname,
      zz = "zz_target",
      zz_gate = "gzz_cafe_target"
  };
  --------------------------------------------------------------------------------------------
  game.hint[ "use_pliersarchdoors" ] = {

      type = "use",
      inv_obj = "inv_pliers",
      use_place = "obj_archdoors_use_pliers",
      room = "rm_foyer",
      zz = "zz_archdoors",
      zz_gate = "gzz_foyer_archdoors"
  };
  --------------------------------------------------------------------------------------------
  local use_pliers_inv = function ()
  
    interface.InventoryItemRemove( "inv_pliers" );
    int_map_impl.DecreaseRoomTasks("rm_foyer");
  
  end;
  local use_pliers_beg = function ()
  
    ObjDelete( "obj_target_use_pliers" );
  
  end;
  local use_pliers_end = function ()
  
    ObjSet( "spr_target_arrow2", { input = true } );

    ObjDelete("anm_target_arrow_touch");
    ObjDelete("anm_target_use_pliers");
  
  end;

  local use_pliers_beg2 = function ()
  
    ObjDelete( "obj_archdoors_use_pliers" );
  
  end;
  local use_pliers_end2 = function ()
  
    ObjMultiSet( { {"grm_foyer_eventhall", { input = true, visible = true, active = true }},
                   {"fx_foyer_p_light", { visible = true, active = true }},
                   {"spr_foyer_doors_open", { alp = 1 }} } );

    ObjDelete( "gzz_foyer_archdoors" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "use_pliers", use_pliers_beg, private.room_objname );
  --cmn.AddSubscriber( "use_pliers", use_pliers_inv );
  cmn.AddSubscriber( "use_pliers", use_pliers_end, private.room_objname );
  --cmn.AddSubscriber( "use_pliers_inv", use_pliers_inv, private.room_objname );
  cmn.AddSubscriber( "use_pliers_beg", use_pliers_beg, private.room_objname );
  cmn.AddSubscriber( "use_pliers_end", use_pliers_end, private.room_objname );

  cmn.AddSubscriber( "use_pliersarchdoors", use_pliers_beg2, "rm_foyer" );
  cmn.AddSubscriber( "use_pliersarchdoors", use_pliers_inv );
  cmn.AddSubscriber( "use_pliersarchdoors", use_pliers_end2, "rm_foyer" );
  cmn.AddSubscriber( "use_pliers_inv", use_pliers_inv, "rm_foyer" );
  cmn.AddSubscriber( "use_pliers_beg2", use_pliers_beg2, "rm_foyer" );
  cmn.AddSubscriber( "use_pliers_end2", use_pliers_end2, "rm_foyer" );

  --------------------------------------------------------------------------------------------
  -- function clk_bulboff () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_bulboff" ] = {

      type = "click",
      use_place = "obj_target_clk_light",
      room = private.room_objname,
      zz = "zz_target",
      zz_gate = "gzz_cafe_target"

  };
  --------------------------------------------------------------------------------------------
  local clk_bulboff = function ()

    ObjMultiSet( { {"spr_target_bulb", { input = 1 }},
                   {"spr_target_switch_off", { alp = 1 }} } );

    ObjDelete( "obj_target_clk_light" );
    ObjDelete( "obj_target_light_bbt" );
    ObjDelete( "fx_target_bulb_light" );

    ObjDelete( "spr_cafe_target_bulb_light" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_bulboff", clk_bulboff, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_newspapercs () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_newspapercs" ] = {

      type = "click",
      use_place = "obj_barcounter_clk_newspaper",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"

  };
  --------------------------------------------------------------------------------------------
  local clk_newspapercs = function ()

    ObjMultiSet( { {"obj_barcounter_clk_laptopopen", { input = 1, visible = 1, active = 1 }},
                   {"spr_barcounter_newspaper_2", { alp = 1 }} } );

    ObjDelete( "obj_barcounter_clk_newspaper" );
    ObjDelete( "spr_barcounter_newspaper" );

    ObjDelete( "spr_cafe_counter_laptop_paper" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_newspapercs", clk_newspapercs, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_laptopopen () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_laptopopen" ] = {

      type = "click",
      use_place = "obj_barcounter_clk_laptopopen",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"

  };
  --------------------------------------------------------------------------------------------
  local clk_laptopopen = function ()

    ObjMultiSet( { {"obj_barcounter_clk_laptopon", { input = 1, visible = 1, active = 1 }},
                   {"obj_barcounter_laptop_cd", { alp = 1 }},
                   {"spr_cafe_counter_laptop_open", { alp = 1 }},
                   {"spr_barcounter_laptop_open", { alp = 1 }} } );

    ObjDelete( "obj_barcounter_clk_laptopopen" );
    ObjDelete( "spr_barcounter_laptop_closed" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_laptopopen", clk_laptopopen, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_laptopon () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_laptopon" ] = {

      type = "click",
      use_place = "obj_barcounter_clk_laptopon",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"

  };
  --------------------------------------------------------------------------------------------
  local clk_laptopon = function ()

    ObjMultiSet( { {"obj_barcounter_use_cd", { input = 1, visible = 1, active = 1 }},
                   {"spr_cafe_counter_laptop_insert", { alp = 1 }},
                   {"txt_barcounter_laptop_text", { alp = 1 }} } );

    ObjDelete( "obj_barcounter_clk_laptopon" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_laptopon", clk_laptopon, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_gummuchine () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_gummuchine" ] = {

      type = "click",
      use_place = "obj_barcounter_clk_gummachine",
      room = private.room_objname,
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"

  };
  --------------------------------------------------------------------------------------------
  local clk_gummuchine = function ()

    ObjMultiSet( { {"spr_barcounter_bubblegum", { input = 1, alp = 1 }},
                   {"spr_cafe_counter_gum", { alp = 1 }},
                   {"spr_barcounter_bubblegum_sh", { alp = 1 }} } );

    ObjDelete( "obj_barcounter_clk_gummachine" );
    ObjDelete( "anm_barcounter_clk_machine" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_gummuchine", clk_gummuchine, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function clk_cafefirst () end;
  --------------------------------------------------------------------------------------------
  local clk_cafefirst = function ()

    ObjMultiSet( { {"obj_cafe_use_wallpicture", { input = 1 }},
                   {"gzz_cafe_target", { event_mup = function () cmn.GotoSubRoomMUp( "cafe_target", "zz_target" ); end, event_mdown =  function () cmn.GotoSubRoomMDown( "cafe_target" ); end }},
                   {"gzz_cafe_barcounter", { event_mup = function () cmn.GotoSubRoomMUp( "cafe_barcounter", "zz_barcounter", { 512, 350 } ); end, event_mdown =  function () cmn.GotoSubRoomMDown( "cafe_barcounter" ); end }} } );

    ObjDelete( "obj_cafe_firstclick" );
    ObjDelete( "spr_cafe_picture_to_fall" );
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_cafefirst", clk_cafefirst, private.room_objname );
  --------------------------------------------------------------------------------------------
  -- function opn_cafe () end;
  --------------------------------------------------------------------------------------------
  local opn_cafe = function ()
  
    int_map_impl.OpenRoom( "rm_cafe" );

  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "opn_cafe", opn_cafe);

end;
--********************************************************************************************************************
function private.Init_Subroom()
  
  subroom.Define( "zz_barcounter" );
  subroom.Define( "zz_target" );

  function zz_barcounter.Open()
    
    if ( cmn.IsEventDone( "use_cd" ) and not(cmn.IsEventDone( "win_barcounter" )) ) then
      private.zz_barcounter.DrawScene();
    end;

  end;

  function zz_barcounter.PreClose()

    if ( cmn.IsEventDone( "use_cd" ) and not(cmn.IsEventDone( "win_barcounter" )) ) then
      private.zz_barcounter.active = 0;
      cmn.MiniGameHide("barcounter");
    end;

  end;

  function zz_barcounter.Close()

    if ( cmn.IsEventDone( "use_cd" ) and not(cmn.IsEventDone( "win_barcounter" )) ) then
      ObjSet("spr_barcounter_back",  { pos_x = 0, pos_y = 0, scale_x = 1, scale_y = 1 });
      ObjSet("obj_barcounter_game",  { alp = 0, input = 0 });
    end;

  end;

  function zz_target.PreOpen()
    
    if not( cmn.IsEventDone( "opn_target" ) ) then

      cmn.SetEventDone("opn_target");
      PlayVoice( "assets/levels/level1/rm_cafe/audio/aud_radio_voiceover_voc", 0, "", 0 ); 

      --ObjSet("spr_target_radio_off",  { alp = 0 });

    elseif not( cmn.IsEventDone( "opn_target2" ) ) and not( cmn.IsEventDone("use_screwdrivertarget") ) then

      cmn.SetEventDone("opn_target2");
      PlayVoice( "assets/levels/level1/rm_cafe/audio/aud_radio_2_voc", 0, "", 0 ); 

    elseif not( cmn.IsEventDone( "opn_target2" ) ) then

      cmn.SetEventDone("opn_target2");

    end;

  end;

  function zz_target.PreClose()

      SndStop( "assets/levels/level1/rm_cafe/audio/aud_radio_voiceover_voc", 0.5 );
      SndStop( "assets/levels/level1/rm_cafe/audio/aud_radio_2_voc", 0.5 );

  end;

end;
--*********************************************************************************************************************
function public.Load()

  if not( cmn.IsEventDone( "use_cd" ) ) then
    private.zz_barcounter.StartConditions();
  end;

  private.zz_barcounter.state = ng_global.progress[ "std" ][ "win_barcounter" ].state;

end;
--*********************************************************************************************************************
function public.Open()

  private.opn_cafe();

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_cafe_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_cafe_env");

  --ObjSet( "obj_cafe_gates", { input = 0, active = 0, visible = 0 } );
  --cmn.DialogWindowShow( "common", "thxplaying" );

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()
end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.use_cd()

  local item = "inv_cd";

  if cmn.ApplyObj( item, "gzz_cafe_barcounter" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_barcounter" );

  elseif ( cmn.ApplyObj( item, "obj_barcounter_use_cd" ) and cmn.IsEventDone("clk_laptopon")) then

    cmn.CallEventHandler( "use_cd_inv" );
    cmn.CallEventHandler( "use_cd_beg" );

    cmn.Lock( 1 );

    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_use_cd");

    ObjAnimate( "spr_barcounter_laptop_cd_rom", "pos_xy", 0, 0, private.use_cd_end,
    { 
      0.0, 0, 190, 11,
      0.6, 0, 197, 102,
        1, 0, 197, 102,
      1.6, 0, 190, 11
    } );

    ObjAnimate( "spr_barcounter_laptop_cd", "alp", 0, 0, "",
    { 
      0.0, 0, 0,
      0.6, 0, 0,
        1, 0, 1
    } );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function private.use_cd_end()

  local trg_after = function ()

    cmn.SetEventDone( "use_cd" );
    cmn.CallEventHandler( "use_cd_end" );
    
    public.zz_barcounter.ZoomMg();

  end;

  ObjAnimate( "txt_barcounter_laptop_text", "alp", 0, 0, "",
  { 
    0.0, 0, 1, 
    0.3, 0, 0
  } );

  ObjAnimate( "spr_barcounter_laptop_game", "alp", 0, 0, trg_after,
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

end;
--------------------------------------------------------------------------------------------
function public.use_net()

  local item = "inv_net";

  if cmn.ApplyObj( item, "gzz_cafe_barcounter" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_barcounter" );

  elseif ( cmn.ApplyObj( item, "obj_barcounter_use_net" ) ) then

    cmn.CallEventHandler( "use_net_inv" );
    cmn.CallEventHandler( "use_net_beg" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_net" );
      cmn.CallEventHandler( "use_net_end" );

      public.get_ringfrombox();

    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_getthering");

    ObjSet("anm_barcounter_use_net",  { playing = 1, endtrig = trg_after });

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_coin()

  local item = "inv_coin";

  if cmn.ApplyObj( item, "gzz_cafe_barcounter" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_barcounter" );

  elseif ( cmn.ApplyObj( item, "obj_barcounter_use_coin" ) ) then

    cmn.CallEventHandler( "use_coin_inv" );
    cmn.CallEventHandler( "use_coin_beg" );

    local trg_after = function ()

      cmn.Lock( 0 );

      cmn.SetEventDone( "use_coin" );
      cmn.CallEventHandler( "use_coin_end" );

    end;

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_coin");

    ObjSet("anm_barcounter_use_coin",  { playing = 1, endtrig = trg_after });

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_wallpicture()

  local item = "inv_wallpicture";

  if ( cmn.ApplyObj( item, "obj_cafe_use_wallpicture" ) ) then

    cmn.CallEventHandler( "use_wallpicture_inv" );
    cmn.CallEventHandler( "use_wallpicture_beg" );

    local trg_after = function ()

      cmn.SetEventDone( "use_wallpicture" );
      cmn.CallEventHandler( "use_wallpicture_end" );

      cmn.GotoRoom( "mg_picturesonwall" );
    
    end;

    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_wallpicture");

    ObjAnimate( "spr_cafe_wallpicture", "alp", 0, 0, trg_after,
    { 
      0.0, 0, 0.0, 
      0.5, 0, 1.0
    } );

    --ObjAnimate( "spr_cafe_pictures_1", "alp", 0, 0, trg_after,
    --{ 
    --  0.0, 0, 0, 
    --  0.5, 0, 0,
    --  0.8, 0, 1
    --} );

  else

    cmn.WrongApply();  

  end;

end;
--------------------------------------------------------------------------------------------
function public.use_pliers()

  local item = "inv_pliers";

  if cmn.ApplyObj( item, "gzz_cafe_target" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_target" );

  elseif ( cmn.ApplyObj( item, "obj_target_use_pliers" ) ) then

    --cmn.CallEventHandler( "use_pliers_inv" );
    cmn.CallEventHandler( "use_pliers_beg" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_pliers" );
      cmn.CallEventHandler( "use_pliers_end" );

      ObjSet("spr_target_arrow2",  { alp = 1 });
      public.get_arrow2();

    end;

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_get_arrow");

    ObjMultiSet( { {"anm_target_arrow_touch", { alp = 0 }},
                   {"anm_target_use_pliers", { alp = 1, playing = 1, endtrig = trg_after }} } );

  
  elseif cmn.ApplyObj( item, "gzz_foyer_archdoors" ) then

    ObjDoNotDrop( item );
    cmn.GotoSubRoom( "zz_archdoors" );

  elseif ( cmn.ApplyObj( item, "obj_archdoors_use_pliers" ) and cmn.IsEventDone("use_ironkey")) then

    cmn.CallEventHandler( "use_pliers_inv" );
    cmn.CallEventHandler( "use_pliers_beg2" );

    local trg_after = function ()

      cmn.Lock(0);

      cmn.SetEventDone( "use_pliersarchdoors" );
      cmn.CallEventHandler( "use_pliers_end2" );

      common.CloseSubRoom();

    end;

    cmn.Lock(1);

    cmn.PlayAudio("snd", "assets/levels/level1/rm_foyer/audio/aud_pliers");

    ObjMultiSet( { {"anm_archdoors_use_pliers", { alp = 1, playing = 1, endtrig = trg_after }},
                   {"anm_archdoors_key_2", { alp = 0 }},
                   {"spr_archdoors_door", { alp = 0 }} } );

  elseif ( cmn.ApplyObj( item, "obj_garage_use_wrench" ) ) then

    cmn.Lock(1);
    cmn.ShowBbt( "garage_pliers_wrongapply" );
    ObjAnimate("obj_garage_use_wrench", "alp", 0, 0, function () cmn.Lock(0); end, { 0, 0, 1,   0.3, 0, 1 });

  elseif ( cmn.ApplyObj( item, "obj_arbor_use_doorhandle" ) ) then

    cmn.Lock(1);
    cmn.ShowBbt( "arbor_pliers_wrongapply" );
    ObjAnimate("obj_arbor_use_doorhandle", "alp", 0, 0, function () cmn.Lock(0); end, { 0, 0, 1,   0.3, 0, 1 });

  else

    cmn.WrongApply();  

  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_codesafe()

  cmn.SetEventDone( "get_codesafe" );
  cmn.CallEventHandler( "get_codesafe" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_ringfrombox()

  cmn.SetEventDone( "get_ringfrombox" );
  cmn.CallEventHandler( "get_ringfrombox" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

end;
--------------------------------------------------------------------------------------------
function public.get_bubblegum()

  cmn.SetEventDone( "get_bubblegum" );
  cmn.CallEventHandler( "get_bubblegum" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  common.CloseSubRoom();

end;
--------------------------------------------------------------------------------------------
function public.get_bulb()

  local func_after = function ()

    cmn.Lock( 0 );
    ObjMultiSet( { {"spr_target_bulb", { alp = 1 }},
                   {"anm_target_get_bulb", { alp = 0 }} } );

    cmn.SetEventDone( "get_bulb" );
    cmn.CallEventHandler( "get_bulb" );

    cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

    if (cmn.IsEventDone("get_battery2")) and (cmn.IsEventDone("get_arrow2")) then
      common.CloseSubRoom();
    end;

  end;

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_twistbulb");

  ObjMultiSet( { {"spr_target_bulb", { alp = 0, pos_x = -156, pos_y = 80 }},
                 {"anm_target_get_bulb", { alp = 1, playing = 1, endtrig = func_after }} } );

end;
--------------------------------------------------------------------------------------------
function public.get_battery2()

  cmn.SetEventDone( "get_battery2" );
  cmn.CallEventHandler( "get_battery2" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if (cmn.IsEventDone("get_bulb")) and (cmn.IsEventDone("get_arrow2")) then
    common.CloseSubRoom();
  end;

end;
--------------------------------------------------------------------------------------------
function public.get_arrow2()

  cmn.SetEventDone( "get_arrow2" );
  cmn.CallEventHandler( "get_arrow2" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  if (cmn.IsEventDone("get_bulb")) and (cmn.IsEventDone("get_battery2")) then
    common.CloseSubRoom();
  end;

end;
--*********************************************************************************************************************
-- function *** PROGRESS CLICK *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.clk_bulboff()

  local func_after = function ()

    cmn.SetEventDone( "clk_bulboff" );
    cmn.CallEventHandler( "clk_bulboff" );

    cmn.Lock( 0 );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_light_off");

  ObjAnimate( "spr_target_switch_off", "alp", 0, 0, "", 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

  ObjAnimate( "fx_target_bulb_light", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );
  
  cmn.Lock( 1 );

end;
--------------------------------------------------------------------------------------------
function public.clk_radio()

  local func_after = function ()

    cmn.Lock( 0 );

  end;

  --cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_light_off");

  if private.radio then

    private.radio = false;

    SndStop( "assets/levels/level1/rm_cafe/audio/aud_radio_voiceover_voc", 0.5 );
    SndStop( "assets/levels/level1/rm_cafe/audio/aud_radio_2_voc", 0.5 );

    ObjAnimate( "spr_target_radio_off", "alp", 0, 0, func_after, 
    { 
      0.0, 0, 0, 
      0.5, 0, 1
    } );

  else 

    PlayVoice( "assets/levels/level1/rm_cafe/audio/aud_radio_voiceover_voc", 0, "", 0 ); 

    private.radio = true;

    ObjAnimate( "spr_target_radio_off", "alp", 0, 0, func_after, 
    { 
      0.0, 0, 1, 
      0.5, 0, 0
    } );

  end;
  
  cmn.Lock( 1 );

end;
--------------------------------------------------------------------------------------------
function public.clk_newspapercs()

  local func_after = function ()

    cmn.SetEventDone( "clk_newspapercs" );
    cmn.CallEventHandler( "clk_newspapercs" );

    cmn.PlayAudio("mus", "assets/levels/level1/rm_cafe/audio/aud_surface7_howl_mus");

    cmn.ShowBbt( "after_newspaper_cs" );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_clk_newspaper");

  cmn.PlayCutScene( "newspaper",
                    "assets/levels/level1/rm_cafe/zz_barcounter/cs/anm_cs_newspaper",
                    { 0.7 },
                    func_after, 
                    "assets/levels/level1/rm_cafe/audio/aud_newspaper_mus",
                    "assets/levels/level1/rm_cafe/audio/aud_newspaper_voc" );


end;
--------------------------------------------------------------------------------------------
function public.clk_laptopopen()

  local func_after = function ()

    cmn.SetEventDone( "clk_laptopopen" );
    cmn.CallEventHandler( "clk_laptopopen" );

    cmn.Lock( 0 );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_clk_laptop");

  ObjAnimate( "spr_barcounter_laptop_open", "alp", 0, 0, "", 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

  ObjAnimate( "obj_barcounter_laptop_cd", "alp", 0, 0, "", 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );

  ObjAnimate( "spr_barcounter_laptop_closed", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 1, 
    0.5, 0, 0
  } );
  
  cmn.Lock( 1 );

end;
--------------------------------------------------------------------------------------------
function public.clk_laptopon()

  local func_after = function ()

    cmn.SetEventDone( "clk_laptopon" );
    cmn.CallEventHandler( "clk_laptopon" );

    cmn.Lock( 0 );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_insert_disk");

  ObjAnimate( "txt_barcounter_laptop_text", "alp", 0, 0, func_after, 
  { 
    0.0, 0, 0, 
    0.5, 0, 1
  } );
  
  cmn.Lock( 1 );

end;
--------------------------------------------------------------------------------------------
function public.clk_gummuchine()

  local func_after = function ()

    cmn.SetEventDone( "clk_gummuchine" );
    cmn.CallEventHandler( "clk_gummuchine" );

    cmn.Lock( 0 );

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_getbublegum");

  ObjSet("anm_barcounter_clk_machine",  { playing = 1, endtrig = func_after });
  
  cmn.Lock( 1 );

end;
--------------------------------------------------------------------------------------------
function public.clk_cafefirst()

  local func_after = function ()

    cmn.SetEventDone( "clk_cafefirst" );
    cmn.CallEventHandler( "clk_cafefirst" );

    cmn.ShowBbt( "after_scary_cafe" );
    cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_empty_mus");

  end;

  cmn.PlayFullscreenVideo( "assets/levels/level1/rm_cafe/vid_scarry_mom", func_after, "assets/levels/level1/rm_cafe/audio/aud_scarry_mom_mus", "" );

end;
--*********************************************************************************************************************
-- function *** OTHER *** () end;
--*********************************************************************************************************************
function private.opn_cafe()

  if not ( cmn.IsEventDone( "opn_cafe" ) ) then

    --cmn.Lock(1);
    ObjSet("obj_cafe_block",  { input = 1 });
    cmn.SetEventDone( "opn_cafe" );
    cmn.CallEventHandler( "opn_cafe" );
    cmn.ShowBbt( "cafe_open_voc" );
    cmn.PlayAudio("voc", "assets/levels/level1/rm_cafe/audio/aud_carol_15_voc");
    ObjSet("tmr_cafe_timer",  { time = 4.8, endtrig = function () ObjSet("obj_cafe_block",  { input = 0 }); end, playing = 1 });

  end;

end;
--------------------------------------------------------------------------------------------
function public.get_radio_play()
  
  return private.radio;

end;

function public.set_radio_stop()
  
  private.radio = false;

end;
--------------------------------------------------------------------------------------------
function public.touch_radio()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_xx_radiopanel");

  cmn.ShowBbt( "obj_target_use_screwdriver" );

  ObjSet("anm_target_radio_touch",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_arrow()

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_xx_arrowinthetarget");

  cmn.ShowBbt( "obj_target_use_pliers" );

  ObjSet("anm_target_arrow_touch",  { playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

end;
--------------------------------------------------------------------------------------------
function public.touch_fishtank()

  local func_after = function ()

    cmn.Lock( 0 );

    ObjSet("anm_barcounter_tank_touch",  { alp = 0, playing = 0 });
    ObjSet("anm_barcounter_tank",  { playing = 1, alp = 1 });

  end;

  cmn.Lock( 1 );

  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_xx_crayfish");

  cmn.ShowBbt( "obj_barcounter_use_net" );

  ObjSet("anm_barcounter_tank_touch",  { alp = 1, playing = 1, endtrig = func_after });
  ObjSet("anm_barcounter_tank",  { playing = 0, alp = 0 });

end;
--------------------------------------------------------------------------------------------
--*********************************************************************************************************************
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** MMG_BATCOUNTER *** () end;
--*********************************************************************************************************************
--********************************************************************************************************************
private.zz_barcounter = {};
public.zz_barcounter = {};

function private.Init_Barcounter()

  private.zz_barcounter.win_state = { "PLOCIE" };
  private.zz_barcounter.active = 0;

  private.zz_barcounter.letters_pos = { { {-136, -72}, {-136, 26}, {-26, 26} },
                                        { {-26, -72}, {-26, -145}, {-81, -145} },
                                        { {-81, -72}, {-81, -21}, {82, -21} },
                                        { {82, -72}, {82, -145}, {28, -145} },
                                        { {28, -72}, {28, 26}, {138, 26} },
                                        { {138, -72} }  };

  --------------------------------------------------------------------------------------------
  game.hint[ "win_barcounter" ] = {

      type = "click",
      use_place = "gzz_barcounter_mmg",
      room = "rm_cafe",
      zz = "zz_barcounter",
      zz_gate = "gzz_cafe_barcounter"
  };
  -----------------------------------------------------------------------------------
  local win_barcounter = function ()

    if cmn.IsEventDone( "win_barcounter" ) then

      ObjMultiSet( { {"obj_barcounter_use_camera", { input = 1 }},
                     {"anm_barcounter_get_print", { frame = 0 }},
                     {"spr_cafe_counter_laptop_finger", { alp = 1 }},
                     {"spr_barcounter_laptop_finger_screen", { alp = 1 }} } );

      ObjDelete( "obj_barcounter_game" );
      ObjDelete( "gzz_barcounter_mmg" );
      ObjDelete( "spr_barcounter_laptop_game" );

      ObjDelete( "spr_cafe_counter_laptop_game" );

    end;

  end;

  -----------------------------------------------------------------------------------
  cmn.AddSubscriber( "win_barcounter", win_barcounter, "rm_cafe" );

end;
--********************************************************************************************************************
function public.zz_barcounter.ZoomMg()

  cmn.Lock( 1 );

  local func_after = private.zz_barcounter.ZoomMg_end;

  private.zz_barcounter.active = 1;

  ObjAnimate( "spr_barcounter_back", "scale_xy", 0, 0, "", { 0,0,1,1,   0.3,0,1,1,    1.5,0,1.5,1.5 } );
  ObjAnimate( "spr_barcounter_back", "pos_xy",   0, 0, func_after, { 0,0,0,0,   0.3,0,0,0,    1.5,0,-127,128 } );

  ObjAnimate( "fx_barcounter_fishtank_water", "alp", 0, 0, "", { 0,0,1,   0.3,0,1,  1,0,0 } );

end;
-----------------------------------------------------------------------------------
function private.zz_barcounter.ZoomMg_end()

  local func_after = function ()

    cmn.MiniGameShow();

    if (string.len(private.zz_barcounter.state[1]) == 6) then
      private.zz_barcounter.CheckWin();
    else 
      cmn.Lock( 0 );
    end;

    ObjSet("spr_barcounter_back",  { pos_x = 0, pos_y = 0, scale_x = 1, scale_y = 1 });
    ObjSet("fx_barcounter_fishtank_water",  { alp = 1 });
    ObjSet("obj_barcounter_game",  { input = 1 });

  end;

  ObjAnimate( "obj_barcounter_game", "alp", 0, 0, func_after, { 0, 0, 0,   0.3, 0, 1 } );

end;
-----------------------------------------------------------------------------------
function private.zz_barcounter.StartConditions()

  ng_global.progress[ "std" ][ "win_barcounter" ].skip = 0;
  ng_global.progress[ "std" ][ "win_barcounter" ].state = { "" };

end;
-----------------------------------------------------------------------------------
function public.zz_barcounter.Reset()

  local need_r = false;

  local len = string.len(private.zz_barcounter.state[1]);
  local let = 0;

  if (private.zz_barcounter.state ~= "") then

    ng_global.progress[ "std" ][ "win_barcounter" ].state = "";

    if not(need_r) then
      need_r = true;
    end;

    for i = 1, len, 1 do

      let = i + (6 -  len);

      ObjAnimate( "spr_barcounter_game_letter_"..let, "pos_x",   0, 0, "", { 0, 0, private.zz_barcounter.letters_pos[i][1][1],    0.5, 0, -136 } );
      ObjAnimate( "spr_barcounter_game_letter_"..let, "alp",   0, 0, "", { 0, 0, 1,    0.5, 0, 1,   1, 0, 0 } );

    end;

  end;

  if need_r then

    private.zz_barcounter.StartConditions();

    cmn.Lock( 1 );
    ObjSet("spr_barcounter_game_button_back",  { input = 0 });

    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_cancellation_cells");

    private.zz_barcounter.state = ng_global.progress[ "std" ][ "win_barcounter" ].state;
    ObjSet("tmr_barcounter_timer",  { time = 1, playing = 1, endtrig = function () cmn.Lock( 0 ); end; });

  end;

end;
-----------------------------------------------------------------------------------
function public.zz_barcounter.Skip()

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_cancellation_cells");

  local len = string.len(private.zz_barcounter.state[1]);
  local let = 0;

  ng_global.progress[ "std" ][ "win_barcounter" ].skip = 1;
  ng_global.progress[ "std" ][ "win_barcounter" ].state = { "PLOCIE" };

  if (private.zz_barcounter.state[1] ~= "") then

    for i = 1, len, 1 do

      let = i + (6 -  len);

      ObjAnimate( "spr_barcounter_game_letter_"..let, "pos_x",   0, 0, "", { 0, 0, private.zz_barcounter.letters_pos[i][1][1],    0.5, 0, -136 } );
      ObjAnimate( "spr_barcounter_game_letter_"..let, "alp",   0, 0, "", { 0, 0, 1,    0.5, 0, 1,   1, 0, 0 } );

    end;

    private.zz_barcounter.state = ng_global.progress[ "std" ][ "win_barcounter" ].state;
    ObjSet("tmr_barcounter_timer",  { time = 1, playing = 1, endtrig = private.zz_barcounter.Skip_end });

  else 

    private.zz_barcounter.state = ng_global.progress[ "std" ][ "win_barcounter" ].state;
    private.zz_barcounter.Skip_end();

  end;

end;
-----------------------------------------------------------------------------------
function private.zz_barcounter.Skip_end()

  for i = 1, 6, 1 do

    let = i;

    ObjAnimate( "spr_barcounter_game_letter_"..let, "pos_x",   0, 0, "", { 0, 0, -136,    0.5, 0, -136,    1, 0, private.zz_barcounter.letters_pos[i][1][1] } );
    ObjAnimate( "spr_barcounter_game_letter_"..let, "alp",   0, 0, "", { 0, 0, 0,    0.5, 0, 1 } );

    ObjSet("txt_barcounter_game_letter_"..let,  { text = string.sub(private.zz_barcounter.win_state[1], i, i) });

  end;

  ObjSet("tmr_barcounter_timer",  { time = 1, playing = 1, endtrig = private.zz_barcounter.CheckWin });

end;
-----------------------------------------------------------------------------------
function private.zz_barcounter.DrawScene()

  local len = string.len(private.zz_barcounter.state[1]);
  local let = 0;

  for i = 1, len, 1 do
  
    let = i + (6 -  len);
    ObjSet("spr_barcounter_game_letter_"..let,  { alp = 1, pos_x = private.zz_barcounter.letters_pos[i][1][1], pos_y = private.zz_barcounter.letters_pos[i][1][2]});
    ObjSet("txt_barcounter_game_letter_"..let,  { text = string.sub(private.zz_barcounter.state[1], i, i) });
    
  end;

  for i = 1, 6-len, 1 do

    ObjSet("spr_barcounter_game_letter_"..i,  { alp = 0 });

  end;

  if (len > 0) then
    ObjSet("spr_barcounter_game_button_back",  { input = 1 });
  else
    ObjSet("spr_barcounter_game_button_back",  { input = 0 });
  end;

end;
-----------------------------------------------------------------------------------
function private.zz_barcounter.CheckWin()

  local win_flag = true;

  --DbgTrace("check "..private.zz_barcounter.state[1]);
  
  if (private.zz_barcounter.state[1] ~= "PLOCIE") then
    win_flag = false;
  end;

  local func_after = function ()

    --ObjSet("anm_barcounter_get_print",  { playing = 1, endtrig = private.zz_barcounter.Win });

  end;

  if win_flag then

    common_impl.PauseAchiev(1);

    ObjMultiSet( { {"spr_barcounter_laptop_finger_screen", { alp = 1 }},
                   {"spr_barcounter_laptop_game", { alp = 0 }},
                   {"gzz_barcounter_mmg", { active = 0, visible = 0, input = 0 }} } );


    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_win_mg_policecode");

    ObjAnimate( "obj_barcounter_game", "alp", 0, 0, private.zz_barcounter.Win,
    { 
      0.0, 0, 1, 
        1, 0, 1, 
      1.5, 0, 0
    } );

  else 

    ObjSet("tmr_barcounter_timer",  { time = 1, playing = 1, endtrig = public.zz_barcounter.Reset });

  end;

end;
-----------------------------------------------------------------------------------
function private.zz_barcounter.Win()

  common_impl.PauseAchiev(0);

  private.zz_barcounter.active = 0;

  cmn.MiniGameHide("barcounter");
  cmn.SetEventDone( "win_barcounter" );
  cmn.CallEventHandler( "win_barcounter" );

  if ng_global.progress[ "std" ][ "win_barcounter" ].skip == 0 and ng_global.noskipgames[ "win_barcounter" ] == nil then

    ng_global.noskipgames[ "win_barcounter" ] = 1;
    common_impl.CheckAchiev("mg");

  end;

  cmn.Lock( 0 );

end;
-----------------------------------------------------------------------------------
function public.zz_barcounter.ClickButton( let )

  cmn.Lock( 1 );

  local len = string.len(private.zz_barcounter.state[1]);
  len = len + 1;
  local let_num = 1 + (6 -  len);
  local let_old;

  if (len == 1) then
    ObjSet("spr_barcounter_game_button_back",  { input = 1 });
    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_first_letter");
  else 
    cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_move_letters");
  end;

  local func_after = function () cmn.Lock( 0 ); end;

  private.zz_barcounter.state[1] = let..private.zz_barcounter.state[1];

  if (len == 6) then
    func_after = private.zz_barcounter.CheckWin;
  end;

  for i = 1, len-1, 1 do
  
    let_old = i+1 + (6 -  len);

    ObjAnimate( "spr_barcounter_game_letter_"..let_old, "pos_xy",   0, 0, "", {   0, 0, private.zz_barcounter.letters_pos[i][1][1], private.zz_barcounter.letters_pos[i][1][2],   
                                                                                0.3, 0, private.zz_barcounter.letters_pos[i][2][1], private.zz_barcounter.letters_pos[i][2][2],
                                                                                0.6, 0, private.zz_barcounter.letters_pos[i][3][1], private.zz_barcounter.letters_pos[i][3][2],  
                                                                                0.9, 0, private.zz_barcounter.letters_pos[i+1][1][1], private.zz_barcounter.letters_pos[i+1][1][2] } );
    
  end;

  ObjSet("txt_barcounter_game_letter_"..let_num,  { text = let });

  if (len > 1) then
    ObjAnimate( "spr_barcounter_game_letter_"..let_num, "alp",   0, 0, func_after, { 0, 0, 0,    0.3, 0, 0,   0.6, 0, 1,  0.9, 0, 1 } );
  else 
    ObjAnimate( "spr_barcounter_game_letter_"..let_num, "alp",   0, 0, func_after, { 0, 0, 0,    0.3, 0, 1 } );
  end;

end;
-----------------------------------------------------------------------------------
function public.zz_barcounter.ClickBack()

  local len = string.len(private.zz_barcounter.state[1]);

  if (len > 0) then

    cmn.Lock( 1 );

    len = len - 1;
    local let_num = (6 -  len);
    local let_old;

    if (len == 0) then
      ObjSet("spr_barcounter_game_button_back",  { input = 0 });
      cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_first_letter");
    else 
      cmn.PlayAudio("snd", "assets/levels/level1/rm_cafe/audio/aud_move_letters");
    end;

    local func_after = function () cmn.Lock( 0 ); end;

    private.zz_barcounter.state[1] = string.sub(private.zz_barcounter.state[1], 2, len+1);

    for i = 2, len+1, 1 do
    
      let_old = i-1 + (6 -  len);

      ObjAnimate( "spr_barcounter_game_letter_"..let_old, "pos_xy",   0, 0, "", {   0, 0, private.zz_barcounter.letters_pos[i][1][1], private.zz_barcounter.letters_pos[i][1][2],   
                                                                                  0.3, 0, private.zz_barcounter.letters_pos[i-1][3][1], private.zz_barcounter.letters_pos[i-1][3][2],
                                                                                  0.6, 0, private.zz_barcounter.letters_pos[i-1][2][1], private.zz_barcounter.letters_pos[i-1][2][2],  
                                                                                  0.9, 0, private.zz_barcounter.letters_pos[i-1][1][1], private.zz_barcounter.letters_pos[i-1][1][2] } );
      
    end;

    ObjSet("txt_barcounter_game_letter_"..let_num,  { text = let });

    ObjAnimate( "spr_barcounter_game_letter_"..let_num, "alp",   0, 0, func_after, { 0, 0, 1,    0.3, 0, 0 } );

  end;

end;
--*****************************************************************************************************************