
function public.Start ( param )

  game.play_hint_aud = false;

  interface.WidgetAdd( InterfaceWidget_Pause, 1800 );

  interface.WidgetAdd( InterfaceWidget_BtnMenu, 10 );
  interface.WidgetAdd( InterfaceWidget_BtnGuide, 6 );

  interface.WidgetAdd( InterfaceWidget_BtnHint, 4  );
  interface.WidgetAdd( InterfaceWidget_BtnSkip, 5 );
  interface.WidgetAdd( InterfaceWidget_BtnInfo, 6 );
  interface.WidgetAdd( InterfaceWidget_BtnReset, 7 );

  interface.WidgetAdd( InterfaceWidget_FrameSubroom, 0 );

  interface.WidgetAdd( InterfaceWidget_TaskHeader, 1 );
  interface.WidgetAdd( InterfaceWidget_Inventory, 2 );
  --interface.WidgetAdd( InterfaceWidget_TaskPanel );
  interface.WidgetAdd( InterfaceWidget_TaskPanel, 3, "assets/interface/int_taskpanel");

  interface.WidgetAdd( InterfaceWidget_Effects, 50 );

  interface.WidgetAdd( InterfaceWidget_BtnMap, 4 );

  interface.WidgetAdd( InterfaceWidget_DialogHo, 260 );

  interface.ButtonLockAdd();

  interface.WidgetAdd( InterfaceWidget_ItemPanel, 3, "assets/interface/int_itempanel" );
  interface.WidgetAdd( InterfaceWidget_Popup, 250 );

  interface.WidgetAdd( InterfaceWidget_BlackBarText, 1500 );
  interface.WidgetAdd( InterfaceWidget_Dialog );

  interface.WidgetAdd( InterfaceWidget_DialogVideo, 300 );
  --interface.WidgetAdd( InterfaceWidget_DialogStory );
  --interface.WidgetAdd( InterfaceWidget_DialogCharacter, 900 );

  interface.WidgetAdd( InterfaceWidget_StrategyGuide );
  interface.WidgetAdd( InterfaceWidget_Window );

  interface.WidgetAdd( InterfaceWidget_Tutorial, 310 );

  interface.WidgetAdd( InterfaceWidget_Map, 200 );

  interface.PanelNotificationAdd();
  interface.ComplexInvAdd();
  interface_impl.DialogHintAdd();

  interface_impl.AchievAdd();
  interface_impl.PopupAchievementAdd();

  interface_impl.BonusAdd();

  --
  private.Init();

  --
  int_map_impl.CreateRooms( "level1" );

  ModLoad( "assets/levels/level1/mod_inventory1" );
  inventory1.Init();

  ModLoad( "assets/levels/menu/rm_achievements/mod_achievements" );
  rm_achievements.Init();

  common.LevelLoad( "level1", "std", "rm_carolsroom", param );

  common_impl.DialogCustomUpdate();
  interface_impl.RemoveFlowersTotal();

  --ModLoad( "assets/interface/map/mod_map" );

  game.play_hint_aud = true;



  common_impl.is_in_map = 0;
  
end;
    
function private.Init()

  game.room_names =
  {
     "rm_carolsroom"
    ,"rm_livingroom"
    ,"rm_street"
    ,"rm_cafe"
    ,"rm_parking"
    ,"rm_policestation"
    ,"rm_orphanagepark"
    ,"rm_foyer"
    --,"rm_eventhall"
    ,"ho_hogift"
    ,"mg_picturesonwall"
    ,"ho_hodetectivedesk"
    ,"ho_hooldthings"
    ,"mg_tvsets"
    ,"mg_keys"

    ,"rm_demoscreen"
  };

-- 1 - открыта
-- 2 - таски выполнены
-- 3 - кол-во тасков
-- 4 блокирована
  game.map_rooms = { 

    [ "rm_carolsroom" ] =    { 1, 0, 1, 0 },
    [ "rm_livingroom" ] =    { 0, 0, 2, 0 },
    [ "rm_street" ]   =      { 0, 0, 1, 0 },
    [ "rm_cafe" ] =          { 0, 0, 2, 0 },
    [ "rm_parking" ] =       { 0, 0, 1, 0 },
    [ "rm_policestation" ] = { 0, 0, 1, 0 },
    [ "rm_orphanagepark" ] = { 0, 0, 1, 0 },
    [ "rm_foyer" ] =         { 0, 0, 1, 0 },
    [ "rm_eventhall" ] =     { 0, 0, 1, 0 }

  };

  game.progress_names =
  {
     "beg_level1"
    --,"clk_clickonalarmclock1"
    --,"clk_clickonalarmclock2"
    ,"clk_clickonalarmclock3"
    --,"clk_clickonclothes1"
    --,"clk_clickonclothes2"
    ,"clk_closemirror"
    ,"clk_firstclkdoor"
    ,"clk_opncurtains"
    ,"opn_window"
    ,"get_pushpin"
    ,"get_scissors"
    ,"get_scissorsclosezz"
    ,"use_scissors"
    ,"opn_hogift"
    ,"win_hogift"
    ,"opn_carolsroomafterho"
    ,"opn_boxstaple"
    ,"clk_clickstaple"
    ,"get_staple"
    ,"use_staple"

    ,"opn_livingroom"
    ,"opn_maptutor"
    ,"clk_playflashback1"
    ,"clk_clickonphone"
    ,"use_pushpinbigtable1"
    ,"get_letter3"
    ,"use_pushpinbigtable2"
    ,"get_letter4"
    ,"get_number18"
    ,"use_pushpinsofa1"
    ,"get_letter1"
    ,"use_pushpinsofa2"
    ,"get_letter2"
    ,"use_number18"
    ,"get_camera"
    ,"use_pushpinshelf"
    ,"get_codereel"
    ,"use_codereel"
    ,"opn_mgsofa"
    ,"win_sofa"
    ,"get_bow"
    ,"get_dograil"
    ,"opn_marydialog"
    ,"clk_marydialoganswer"
    ,"use_dograil"
    ,"get_battery1"
    --,"use_frontkey"

    ,"opn_street"
    ,"use_pushpinmailbox"
    ,"get_letter5"
    ,"use_camera"
    ,"get_photo1"
    ,"use_letter"
    ,"use_photo1"
    ,"win_window"
    ,"get_goldenpendant"
    ,"clk_openlouvre"
    ,"get_flag"
    ,"use_flag"
    ,"clk_clickondrawer"
    ,"get_parcel"
    ,"use_scissorsparcel"
    ,"get_wallpicture"
    ,"get_screwdriver"
    ,"opn_sofascaryface"
    --,"opn_sofascaryfacehide"
    ,"use_screwdriver"
    ,"get_arrow"
    ,"use_arrow"
    ,"get_bowstring1"
    ,"use_bowstring1"
    ,"get_bow2"
    ,"win_pole"
    ,"opn_streetsxarysh"
    ,"get_policekeys"
    ,"clk_policecardoor"
    ,"use_policekeys"
    ,"clk_carradio"
    ,"clk_carradiooff"
    ,"clk_policecarkey2"
    ,"clk_policecarhandle"
    ,"clk_policecarpedal"
    ,"clk_cafedoors"

    ,"opn_cafe"
    ,"clk_cafefirst"
    ,"opn_target"
    ,"opn_target2"
    ,"clk_bulboff"
    ,"get_bulb"
    ,"use_screwdrivertarget"
    ,"get_battery2"
    ,"use_wallpicture"
    ,"win_picturesonwall"
    ,"get_scrap"
    ,"use_scrapinpole"
    ,"clk_openelectrical"
    ,"clk_clickontheswitch"
    ,"clk_switchclosezz"
    ,"opn_neighborcar"
    ,"clk_playflashback2"
    ,"use_scrapneighborcar"
    ,"clk_cardoorhandle"
    ,"get_dog"

    ,"opn_parking"
    ,"use_dog"
    ,"opn_policestation"
    ,"clk_policestationfirst"
    ,"use_bulb"
    ,"opn_hodetectivedesk"
    ,"clk_starthodetectivedesk"
    ,"win_hodetectivedesk"
    ,"use_policebadge"
    ,"get_cd"

    ,"clk_newspapercs"
    ,"clk_laptopopen"
    ,"clk_laptopon"
    ,"use_cd"
    ,"win_barcounter"
    ,"use_camerabarcounter"
    ,"get_codesafe"
    ,"use_codesafe"
    ,"win_safe"
    ,"get_blade"
    ,"use_bladeneighborcar"
    ,"get_net"
    ,"get_hankline"
    ,"use_net"
    ,"get_ringfrombox"
    ,"get_speaker"

    ,"use_ringfrombox"
    ,"get_tangle"
    ,"clk_unraveltangle"
    ,"get_coin"
    ,"get_insulatingtape"
    ,"get_greenbutton"

    ,"use_greenbutton"
    ,"clk_onrecorder"
    ,"get_remotewithoutbatteries"

    ,"clk_remotecover1"
    ,"use_battery"
    ,"clk_remotecover2"
    ,"get_console"
    ,"use_console"
    ,"opn_tvsets"
    ,"win_tvsets"
    ,"get_magnetickey"
    ,"opn_garagescary"
    ,"use_magnetickey"
    ,"get_pliers"
    ,"get_emptycanister"
    ,"use_pliers"
    ,"get_arrow2"
    ,"clk_gastankcover"
    ,"use_emptycanister"
    ,"get_gascanisters"

    ,"use_coin"
    ,"clk_gummuchine"
    ,"get_bubblegum"
    ,"use_bubblegum"
    ,"use_hankline"
    ,"get_arrowwithvelcro"
    ,"use_arrowwithvelcro"
    ,"get_bowwitharrow2"
    --,"use_cameramotorbike"
    ,"get_photo3"
    ,"use_photo3"
    ,"use_bowwitharrow2"
    ,"win_grate"
    ,"get_bow3"
    ,"get_motorbikekey"
    ,"clk_gastankcovermoto"
    ,"use_gascanisters"
    ,"use_motorbikekey"
    ,"clk_clickmotorbike"
    ,"opn_parkingaftergo"

    ,"opn_orphanagepark"
    ,"opn_tree"
    ,"use_speaker"
    ,"get_pruner"
    ,"use_prunerpole"
    ,"get_stairs"

    ,"use_stairs"
    ,"opn_simondialog"
    ,"clk_asksimonsname"
    ,"clk_simondialoganswer1"
    ,"clk_simondialoganswer2"
    ,"get_flute"

    ,"use_prunertree"
    ,"get_wings"
    ,"use_wings"
    ,"use_flute"
    ,"win_foyerentrance"
    --,"get_photo2"

    ,"opn_foyer"
    ,"get_doorhandle"
    ,"use_doorhandle"
    ,"win_hooldthings"
    ,"use_wrench"
    ,"get_valve"
    ,"use_valve"
    ,"clk_valve"
    ,"get_lever"
    ,"use_lever"
    ,"use_insulatingtape"
    ,"clk_cliconbutton"
    --,"use_photo2"
    ,"win_keys"
    ,"get_ironkey"
    ,"use_ironkey"
    ,"use_pliersarchdoors"

    ,"opn_eventhall"


    ,"tutor_enable"
    ,"tutor_1"
    ,"tutor_2"
    ,"tutor_3"
    ,"tutor_4"
    ,"tutor_5"
    ,"tutor_6"
    ,"tutor_7"
    ,"tutor_8"
    ,"tutor_9"
    ,"tutor_10"
    ,"tutor_11"
    ,"tutor_12"
    ,"tutor_13"
    ,"tutor_14"
    ,"tutor_15"
    ,"tutor_16"
    ,"tutor_17"

  };
  
  game.relations = {};

end;

function Test ()
    
  local profiles = GetProfileList();

  local cheater = false;

  for i = 1, #profiles, 1 do

    if ( profiles[ i ] == "CHEATER" ) then

      cheater = true;

    end;

  end;

  AddProfile( "CHEATER" );
  SetCurrentProfile( "CHEATER" );

  if ( not cheater ) then

    ng_global.gamemode = 0;
    ng_global.currentprogress = "std";
    ng_global.progress = {};
    ng_global.progress[ "std" ] = {};
    ng_global.progress[ "std" ].common = {};
    ng_global.progress[ "std" ].common.hinttimer = 0;

    SaveProfiles();

  end;

end;
