--*********************************************************************************************************************
function public.Init()

  private.room_objname = "mg_tvsets";

  --differances between pictures
  private.levels_dif = { 12, 12 };

  --method of change
  private.change = { { 0, 0, 1, 2, 2, 0, 2, 0, 1, 1, 1, 1 },
                     { 0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 1 } }; --0 - delete, 1 - add, 2 - morph
  
  --------------------------------------------------------------------------------------------
  -- function get_magnetickey () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_magnetickey" ] = {

      type = "get",
      get_obj = "spr_tvsets_magnetickey",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  local get_magnetickey_inv = function ()
  
    interface.InventoryItemAdd( "inv_magnetickey", "spr_tvsets_magnetickey" );
  
  end;
  
  local get_magnetickey_closezz = function ()
  
    ObjDelete( "gfx_tvsets_magnetickey" );
    ObjDelete( "gmg_policestation_tvsets" );
    ObjDelete( "spr_policestation_key_card" );
  
  end;
  
  cmn.AddSubscriber( "get_magnetickey", get_magnetickey_inv );
  cmn.AddSubscriber( "get_magnetickey", get_magnetickey_closezz, "rm_policestation" );

  --------------------------------------------------------------------------------------------
  -- function win_tvsets () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "win_tvsets" ] = {

    type = "win",
    room = "rm_policestation",
    zz = "mg_tvsets",
    zz_gate = "gmg_policestation_tvsets"

  };
  -----------------------------------------------------------------------------------
  local win_tvsets = function ()

    if cmn.IsEventDone( "win_tvsets" ) then

      ObjMultiSet( { {"spr_tvsets_magnetickey", { input = 1 }},
                     {"spr_tvsets_box_open", { alp = 1 }},
                     {"obj_tvsets_level_1", { alp = 0, input = 0 }},
                     {"obj_tvsets_level_2", { alp = 1, input = 0 }} } );

      ObjDelete( "spr_tvsets_box_closed" );

    end;

  end;
  local win_tvsets_closezz = function ()

    if cmn.IsEventDone( "win_tvsets" ) then

      ObjSet("anm_policestation_monitors_win", {playing = 1, alp = 1});
      ObjSet("spr_policestation_key_box_open", {alp = 1});

      ObjDelete( "spr_policestation_key_box_closed" );
      ObjDelete( "spr_policestation_screen1" );
      ObjDelete( "spr_policestation_screen2" );
      ObjDelete( "spr_policestation_screen3" );
      ObjDelete( "spr_policestation_screen4" );
      ObjDelete( "spr_policestation_txt_screen_1" );
      ObjDelete( "spr_policestation_txt_screen_2" );
      ObjDelete( "spr_policestation_txt_screen_3" );
      ObjDelete( "spr_policestation_txt_screen_4" );

    end;

  end;

  -----------------------------------------------------------------------------------
  cmn.AddSubscriber( "win_tvsets", win_tvsets, "mg_tvsets" );
  cmn.AddSubscriber( "win_tvsets", win_tvsets_closezz, "rm_policestation" );
  
end;
--*********************************************************************************************************************
function public.Load()

  if not( cmn.IsEventDone( "opn_tvsets" ) ) then
    cmn.SetEventDone("opn_tvsets");
    private.StartConditions();
  end;

  private.state = ng_global.progress[ "std" ][ "win_tvsets" ].state;

end;
--*********************************************************************************************************************
function public.Open() 

  if not(cmn.IsEventDone( "win_tvsets" )) then
    cmn.MiniGameShow();
    private.CheckWin();
    cmn.StartTimePassing("mg_tvsets");
  end;

end;
--*********************************************************************************************************************
function public.PreOpen()

  private.DrawScene();

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()

  if not(cmn.IsEventDone( "win_tvsets" )) then
    cmn.MiniGameHide();
  end;
  
end;
--*********************************************************************************************************************
function public.Reset()

  local need_r = false;

  if (private.state[1] == 2) then

    if not(need_r) then
      need_r = true;
    end;

    for i = 1, private.levels_dif[1], 1 do
    
       if (private.change[1][i] == 2) then

         ObjMultiSet( { {"spr_tvsets_level_1_past_"..i, { alp = 1, input = 1 }},
                        {"spr_tvsets_level_1_newpast_"..i, { alp = 0 }} } );

       elseif (private.change[1][i] == 1) then
      
         ObjSet("spr_tvsets_level_1_past_"..i,  { alp = 0 });

       elseif (private.change[1][i] == 0) then
      
         ObjSet("spr_tvsets_level_1_past_"..i,  { alp = 1 });

       end;

       ObjSet("spr_tvsets_progress_done_1_"..i,  { alp = 0 });
       ObjSet("spr_tvsets_progress_1_"..i,  { alp = 1 });

    end;

    ObjAnimate("obj_tvsets_level_1", "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });
    ObjAnimate("obj_tvsets_level_2", "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });

  elseif (private.state[1] == 1) then

    for i = 1, private.levels_dif[1], 1 do

      if (private.state[3][i] == 1) then

        if not(need_r) then
          need_r = true;
        end;

        if (private.change[1][i] == 2) then

          ObjAnimate("spr_tvsets_level_1_past_"..i, "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });
          ObjAnimate("spr_tvsets_level_1_newpast_"..i, "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });

        elseif (private.change[1][i] == 1) then

          ObjAnimate("spr_tvsets_level_1_past_"..i, "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });

        elseif (private.change[1][i] == 0) then

          ObjAnimate("spr_tvsets_level_1_past_"..i, "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });

        end;

      end;

    end;

    for i = 1, private.state[2], 1 do

      ObjAnimate("spr_tvsets_progress_done_1_"..i, "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });
      ObjAnimate("spr_tvsets_progress_1_"..i, "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });

    end;

  end;

  if need_r then

    ng_global.progress[ "std" ][ "win_tvsets" ].state = { 1, 0, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0} };

    private.StartConditions();

    cmn.Lock( 1 );

    if (private.state[1] == 1) then
      cmn.PlayAudio("snd", "assets/levels/level1/mg_tvsets/audio/aud_clk_change");
    else 
      cmn.PlayAudio("snd", "assets/levels/level1/mg_tvsets/audio/aud_change_page");
    end;

    private.state = ng_global.progress[ "std" ][ "win_tvsets" ].state;
    ObjSet("tmr_tvsets_timer",  { time = 1, playing = 1, endtrig = function () cmn.Lock( 0 ); private.DrawScene(); end; });

  end;

end;
--*********************************************************************************************************************
function public.Skip()

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/mg_tvsets/audio/aud_clk_change");

  local progr = private.state[2];

  ng_global.progress[ "std" ][ "win_tvsets" ].skip = 1;
  ng_global.progress[ "std" ][ "win_tvsets" ].state = { 2, 12, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1} };

  if (private.state[1] == 1) then
    
    ObjAnimate("spr_tvsets_done_lvl_1", "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1 });

    ObjAnimate("obj_tvsets_level_1", "alp", 0, 0, "", { 0, 0, 1,   0.5, 0, 1,   1.5, 0, 0 });
    ObjAnimate("obj_tvsets_level_2", "alp", 0, 0, function () private.Skip_end( 0 ); end, { 0, 0, 0,   0.5, 0, 0,   1.5, 0, 1 });

  else 

    private.Skip_end( progr );
  
  end;

end;

function private.Skip_end( progr )

  ObjAnimate("spr_tvsets_done_lvl_2", "alp", 0, 0, private.Win, { 0, 0, 0,   1, 0, 0,   1.5, 0, 1 });

  for i = private.state[2]+1, private.levels_dif[2], 1 do

    ObjAnimate("spr_tvsets_progress_done_2_"..i, "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });
    ObjAnimate("spr_tvsets_progress_2_"..i, "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });

  end;

  for i = 1, private.levels_dif[2], 1 do

    if (private.state[4][i] == 0) then

      if (private.change[2][i] == 2) then

        ObjAnimate("spr_tvsets_level_2_past_"..i, "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });
        ObjAnimate("spr_tvsets_level_2_newpast_"..i, "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });

      elseif (private.change[2][i] == 1) then

        ObjAnimate("spr_tvsets_level_2_past_"..i, "alp", 0, 0, "", { 0, 0, 0,   1, 0, 1 });

      elseif (private.change[2][i] == 0) then

        ObjAnimate("spr_tvsets_level_2_past_"..i, "alp", 0, 0, "", { 0, 0, 1,   1, 0, 0 });

      end;

    end;

  end;

  private.state = ng_global.progress[ "std" ][ "win_tvsets" ].state;

end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_magnetickey()

  cmn.SetEventDone( "get_magnetickey" );
  cmn.CallEventHandler( "get_magnetickey" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  cmn.GotoRoom( "rm_policestation" );

end;
--------------------------------------------------------------------------------------------
--*********************************************************************************************************************
-- function *** PROGRESS OTHER *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.set_policestation_screens()

  if private.state[1] == 1 then

    ObjMultiSet({
                  {"spr_policestation_screen1",{alp = 1}},
                  {"spr_policestation_screen2",{alp = 1}},
                  {"spr_policestation_screen3",{alp = 0}},
                  {"spr_policestation_screen4",{alp = 0}},
                  {"spr_policestation_txt_screen_1",{alp = 1}},
                  {"spr_policestation_txt_screen_2",{alp = 1}},
                  {"spr_policestation_txt_screen_3",{alp = 0}},
                  {"spr_policestation_txt_screen_4",{alp = 0}}
                });

  elseif private.state[1] == 2 then

    ObjMultiSet({
                  {"spr_policestation_screen1",{alp = 0}},
                  {"spr_policestation_screen2",{alp = 0}},
                  {"spr_policestation_screen3",{alp = 1}},
                  {"spr_policestation_screen4",{alp = 1}},
                  {"spr_policestation_txt_screen_1",{alp = 0}},
                  {"spr_policestation_txt_screen_2",{alp = 0}},
                  {"spr_policestation_txt_screen_3",{alp = 1}},
                  {"spr_policestation_txt_screen_4",{alp = 1}}
                });
  end;

end;
--*********************************************************************************************************************
-- function *** MG *** () end;
--*********************************************************************************************************************
-----------------------------------------------------------------------------------
function private.StartConditions()

  ng_global.progress[ "std" ][ "win_tvsets" ].skip = 0;
  ng_global.progress[ "std" ][ "win_tvsets" ].state = { 1, 0, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0} }; --[1] - level, [2] - found count, [3-4] - found items

end;
-----------------------------------------------------------------------------------
--*********************************************************************************************************************
function private.DrawScene()

  local lev = private.state[1];
  local lev2;
  local progr = { 0, 0 };

  if (lev == 1) then
    lev2 = 2;
    progr[1] = private.state[2];
  else 
    lev2 = 1;
    progr[1] = private.levels_dif[1];
    progr[2] = private.state[2];
    ObjSet("spr_tvsets_done_lvl_1",  { alp = 1 });
  end;

  if cmn.IsEventDone( "win_tvsets" ) then
    ObjSet("spr_tvsets_done_lvl_2",  { alp = 1 });
  end;

  if not(cmn.IsEventDone( "win_tvsets" )) then
  
    ObjMultiSet( { {"obj_tvsets_level_"..lev, { alp = 1, input = 1 }},
                   {"obj_tvsets_level_"..lev2, { alp = 0, input = 0 }} } );

  end;

  for j = 1, 2, 1 do

    for i = 1, private.levels_dif[j], 1 do

      if (private.change[j][i] == 2) then
    
        if (private.state[j+2][i] == 1) then

          ObjMultiSet( { {"spr_tvsets_level_"..j.."_past_"..i, { alp = 0, input = 0 }},
                         {"spr_tvsets_level_"..j.."_newpast_"..i, { alp = 1 }} } );

        else 

          ObjMultiSet( { {"spr_tvsets_level_"..j.."_past_"..i, { alp = 1, input = 1 }},
                         {"spr_tvsets_level_"..j.."_newpast_"..i, { alp = 0 }} } );

        end;

      elseif (private.change[j][i] == 1) then
    
        if (private.state[j+2][i] == 1) then

          ObjSet("spr_tvsets_level_"..j.."_past_"..i,  { alp = 1, input = 0 });

        else 

          ObjSet("spr_tvsets_level_"..j.."_past_"..i,  { alp = 0, input = 1 });

        end;

      elseif (private.change[j][i] == 0) then
    
        if (private.state[j+2][i] == 1) then

          ObjSet("spr_tvsets_level_"..j.."_past_"..i,  { alp = 0, input = 0 });

        else 

          ObjSet("spr_tvsets_level_"..j.."_past_"..i,  { alp = 1, input = 1 });

        end;

      end;
      
    end;

  end;  

  for j = 1, 2, 1 do
  
    for i = 1, progr[j], 1 do
  
      ObjSet("spr_tvsets_progress_done_"..j.."_"..i,  { alp = 1 });
      ObjSet("spr_tvsets_progress_"..j.."_"..i,  { alp = 0 });
    
    end;

    for i = progr[j]+1, private.levels_dif[j], 1 do
  
      ObjSet("spr_tvsets_progress_done_"..j.."_"..i,  { alp = 0 });
      ObjSet("spr_tvsets_progress_"..j.."_"..i,  { alp = 1 });
    
    end;
    
  end;

end;
--*********************************************************************************************************************
--differance found
function public.FoundDif( num )

  cmn.Lock( 1 );
  cmn.PlayAudio("snd", "assets/levels/level1/mg_tvsets/audio/aud_clk_change");

  local lev = private.state[1];

  private.state[2] = private.state[2] + 1;
  private.state[lev+2][num] = 1;

  ObjSet("spr_tvsets_level_"..lev.."_past_"..num,  { input = 0 });

  ObjAnimate("spr_tvsets_progress_done_"..lev.."_"..private.state[2], "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1 });
  ObjAnimate("spr_tvsets_progress_"..lev.."_"..private.state[2], "alp", 0, 0, "", { 0, 0, 1,   0.5, 0, 0 });

  if (private.change[lev][num] == 2) then

    ObjAnimate("spr_tvsets_level_"..lev.."_past_"..num, "alp", 0, 0, private.CheckWin, { 0, 0, 1,   0.5, 0, 0 });
    ObjAnimate("spr_tvsets_level_"..lev.."_newpast_"..num, "alp", 0, 0, "", { 0, 0, 0,   0.5, 0, 1 });

  elseif (private.change[lev][num] == 1) then

    ObjAnimate("spr_tvsets_level_"..lev.."_past_"..num, "alp", 0, 0, private.CheckWin, { 0, 0, 0,   0.5, 0, 1 });

  elseif (private.change[lev][num] == 0) then

    ObjAnimate("spr_tvsets_level_"..lev.."_past_"..num, "alp", 0, 0, private.CheckWin, { 0, 0, 1,   0.5, 0, 0 });

  end;

end;
--*********************************************************************************************************************
function private.CheckWin()

  --change level
  if (private.state[1] == 1) and (private.state[2] == private.levels_dif[1]) then

    cmn.Lock( 1 );
    cmn.PlayAudio("snd", "assets/levels/level1/mg_tvsets/audio/aud_change_page");

    private.state[1] = 2;
    private.state[2] = 0;

    ObjAnimate("spr_tvsets_done_lvl_1", "alp", 0, 0, "", { 0, 0, 0,   1, 0, 0,   1.5, 0, 1 });

    ObjAnimate("obj_tvsets_level_1", "alp", 0, 0, "", { 0, 0, 1,   1, 0, 1,   2, 0, 0 });
    ObjAnimate("obj_tvsets_level_2", "alp", 0, 0, function () private.DrawScene(); cmn.Lock( 0 ); end, { 0, 0, 0,   1, 0, 0,   2, 0, 1 });

  --win
  elseif (private.state[1] == 2) and (private.state[2] == private.levels_dif[2]) then

    cmn.Lock( 1 );

    ObjAnimate("spr_tvsets_done_lvl_2", "alp", 0, 0, private.Win, { 0, 0, 0,   1, 0, 0,   1.5, 0, 1 });

  else 

    cmn.Lock( 0 );

  end;

end;
--*********************************************************************************************************************
function private.WinEnd()

  cmn.SetEventDone( "win_tvsets" );
  cmn.CallEventHandler( "win_tvsets" );

  local func_after = function ()

    if ng_global.progress[ "std" ][ "win_tvsets" ].skip == 0 and not( ng_global.noskipgames[ "win_tvsets" ] ) then

      ng_global.noskipgames[ "win_tvsets" ] = 1;
      common_impl.CheckAchiev("mg");

    end;

    common_impl.PauseAchiev(0);
    cmn.ShowBbt( "tvsets_after_vid" );

    cmn.PlayAudio("mus", "assets/levels/level1/rm_policestation/audio/aud_howlaftershadow_mus");

  end;

  cmn.Lock( 0 );
  cmn.PlayFullscreenVideo( "assets/levels/level1/mg_tvsets/vid_tvset", func_after, "assets/levels/level1/mg_tvsets/audio/aud_tvset_mus", "assets/levels/level1/mg_tvsets/audio/aud_tvset_voc" );

end;
--*********************************************************************************************************************
function private.Win()

  cmn.MiniGameHide();
  --TimerStart( "tmr_tvsets_win", private.WinEnd, 1.0 );

  cmn.PlayAudio("snd", "assets/levels/level1/mg_tvsets/audio/aud_win_mg_tvset");

  common_impl.PauseAchiev(1);
  cmn.EndTimePassing("mg_tvsets");

  --anim win
  ObjAnimate("spr_tvsets_box_open", "alp", 0, 0, private.WinEnd, { 0, 0, 0,   1, 0, 0,   1.5, 0, 1 });
  ObjAnimate("spr_tvsets_box_closed", "alp", 0, 0, "", { 0, 0, 1,   1, 0, 1,   1.5, 0, 0 });

end;
--******************************************************************************************************************