--*********************************************************************************************************************
function public.Init()

  private.room_objname = "mg_picturesonwall";
  --------------------------------------------------------------------------------------------
  -- function win_picturesonwall () end;
  --------------------------------------------------------------------------------------------

  local win_picturesonwall_end = function ()
  
    if cmn.IsEventDone("win_picturesonwall") then

      ObjAttach("obj_picturesonwall_boing", "spr_picturesonwall_mainpicture");
      ObjAttach("obj_picturesonwall_shampoo", "spr_picturesonwall_mainpicture");
      ObjAttach("obj_picturesonwall_car", "spr_picturesonwall_mainpicture");
      ObjAttach("obj_picturesonwall_businesman", "spr_picturesonwall_mainpicture");
      ObjAttach("obj_picturesonwall_model", "spr_picturesonwall_mainpicture");
      ObjAttach("obj_picturesonwall_dollars", "spr_picturesonwall_mainpicture");
      ObjAttach("spr_picturesonwall_mainpicture_br_1", "spr_picturesonwall_mainpicture");
      ObjAttach("spr_picturesonwall_dollars_br", "spr_picturesonwall_mainpicture");

      ObjDelete("obj_picturesonwall_gray_pictures");

      ObjDelete("spr_picturesonwall_dollars_br_grey");
      ObjDelete("spr_picturesonwall_model_good_br_gray");

      for i = 1, #private.items, 1 do
        ObjDelete("spr_picturesonwall_"..private.items[i].."_move");
        ObjDelete("spr_picturesonwall_"..private.items[i].."_select");
        ObjDelete("spr_picturesonwall_"..private.items[i].."_wrong");
        ObjSet("spr_picturesonwall_"..private.items[i].."_good", {alp = 1});
        local zpos = 0;
        if i == 5 then
            zpos = 2;
        elseif i == 6 then
            zpos = 1;
        end;
        ObjSet("obj_picturesonwall_"..private.items[i], {pos_x = private.item_states[private.items[i]][i][1], 
                                                         pos_y = private.item_states[private.items[i]][i][2],
                                                         pos_z = zpos,
                                                         ang = private.item_states[private.items[i]][i][3],
                                                         scale_x = private.item_states[private.items[i]][i][4],
                                                         scale_y = private.item_states[private.items[i]][i][5]});
      end;

      ObjMultiSet({
                    {"spr_picturesonwall_scrap", {input = 1}},
                    {"spr_picturesonwall_mainpicture",{pos_y = -295}},
                    {"obj_picturesonwall_items",{input = 0}}

                  });


    end;
  
  end;
  local win_picturesonwall_loc = function ()

    ObjSet("spr_cafe_main_picture_2",  { alp = 1 });
    ObjSet("spr_cafe_wallpicture_2",  { alp = 1 });

    ObjDelete("spr_cafe_pictures_1");
    ObjDelete("spr_cafe_main_picture_1");
    ObjDelete("spr_cafe_wallpicture");


  end;

  cmn.AddSubscriber( "win_picturesonwall",     win_picturesonwall_end, private.room_objname ); 
  cmn.AddSubscriber( "win_picturesonwall_end", win_picturesonwall_end, private.room_objname );
  cmn.AddSubscriber( "win_picturesonwall_loc", win_picturesonwall_loc, "rm_cafe" );
  cmn.AddSubscriber( "win_picturesonwall", win_picturesonwall_loc, "rm_cafe" );
  --------------------------------------------------------------------------------------------
  -- function get_scrap () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_scrap" ] = {

      type = "get",
      get_obj = "spr_picturesonwall_scrap",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  local get_scrap_inv = function ()
  
    interface.InventoryItemAdd( "inv_scrap", "spr_picturesonwall_scrap" );
  
  end;

  local get_scrap_end = function ()
  
    ObjDelete( "spr_picturesonwall_scrap_sh" );
  
  end;
  
  local get_scrap_closezz = function ()
  
    ObjDelete( "gmg_cafe_picturesonwall" );

    ObjDelete("spr_cafe_scrap");
  
  end;
  
  cmn.AddSubscriber( "get_scrap", get_scrap_inv );
  cmn.AddSubscriber( "get_scrap", get_scrap_end, private.room_objname );
  cmn.AddSubscriber( "get_scrap", get_scrap_closezz, "rm_cafe" );
 -- 
  private.replaced = false;
  private.items = { 
                     "goldcoin",  --1
                     "boing",     --2
                     "shampoo",   --3
                     "car",       --4
                     "businesman",--5
                     "model",     --6
                     "dollars",   --7
                     "deer",      --8
                     "airplane",  --9
                     "man",       --10
                     "heraldry",  --11
                     "stone"      --12
                   };
  private.item_states = {
                    ["goldcoin"] =   { {  234, 191,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},  {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {713,336,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["boing"] =      { {  229, 182,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},  {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {695,334,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["shampoo"] =    { {  229, 182,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},  {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {695,334,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["car"] =        { {  229, 177,   0, 0.25, 0.25 }, {429,85,0.4,0.25,0.25}, {598,92,0.54,0.25,0.25}, {401,285,0,1,1}, {571,276,0,0.7,0.7}, {614,208,0,0.5,0.5}, {716,320,0,0.5,0.5}, {929,238,0,0.5,0.5}, {94,376,0.4,0.25,0.25}, {315,584,0,0.45,0.45}, {516,500,0.6,0.3,0.3}, {712,563,0,1,1} },
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["businesman"] = { {  227, 160,   0,  0.5,  0.5 }, {426,85,-1.2,0.5,0.5}, {595,97,0,0.4,0.4}, {401,285,0,1,1}, {566,241,0,1,1}, {616,208,0,0.7,0.7}, {692,328,0.9,0.5,0.5}, {934,212,0,1,1}, {94,374,-1.2,0.5,0.5}, {307,541,0,1,1}, {514,497,0,0.5,0.5}, {716,560,0,1,1}  },
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["model"] =      { {  227, 160,   0,  0.7,  0.7 }, {426,85,-1.2,0.7,0.7}, {595,97,0,0.6,0.6}, {401,285,0,1,1}, {566,241,0,1,1}, {637,224,0,1,1}, {692,328,0.9,0.7,0.7}, {942,232,0,1,1}, {94,374,-1.2,0.7,0.7}, {307,541,0,1,1}, {514,497,0,0.7,0.7}, {716,560,0,1,1} },
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["dollars"] =    { {  229, 182,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},      {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {695,334,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["deer"] =       { {  229, 182,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},      {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {695,334,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["airplane"] =   { {  229, 182,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},      {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {695,334,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["man"] =        { {  227, 160,   0,  0.5,  0.5 }, {426,85,-1.2,0.5,0.5}, {595,97,0,0.4,0.4}, {401,285,0,1,1}, {566,241,0,1,1}, {616,208,0,0.7,0.7}, {692,328,0.9,0.5,0.5}, {934,212,0,1,1}, {94,374,-1.2,0.5,0.5}, {308,552,0,1,1}, {514,497,0,0.5,0.5}, {716,560,0,1,1} },
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["heraldry"] =   { {  229, 182,   0,    1,    1 }, {438,84,0,1,1},       {596,96,0,1,1},      {401,285,0,1,1}, {566,241,0,1,1}, {621,214,0,1,1}, {695,334,0,1,1}, {921,153,0,1,1}, {91,378,0,1,1}, {308,552,0,1,1}, {525,495,0,1,1}, {731,586,0,1,1} },
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                    ["stone"] =      { {  224, 169,   0,  0.5,  0.5 }, {413,84,0,0.4,0.4}, {595,94,0.4,0.4,0.4},  {471,302,0,1,1}, {566,219,0,1,1}, {627,241,0,0.5,0.5}, {698,331,0,0.3,0.3}, {953,255,0,1,1}, {93,375,0,0.4,0.4}, {314,583,0,0.7,0.7}, {516,498,0.45,0.5,0.5}, {759,581,0,1,1} }
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                   };
  
end;
--*********************************************************************************************************************
function public.Load()

  if not cmn.IsEventDone("use_wallpicture") then
    private.StartConditions(); 
  end;

  private.state = ng_global.progress[ "std" ][ "win_picturesonwall" ].state; 

  if cmn.IsEventDone("use_wallpicture") and (not cmn.IsEventDone("win_picturesonwall")) then

    private.DrawScene();

  end;

end;
--*********************************************************************************************************************
function public.Open()

  if (not cmn.IsEventDone("win_picturesonwall")) then 

    cmn.MiniGameShow( "picturesonwall" );
    cmn.StartTimePassing("mg_picturesonwall");

  end;

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StopAllEnv("assets/levels/common/audio/aud_cafe_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_cafe_env");

  if (not cmn.IsEventDone("win_picturesonwall")) then 

    if (ng_global.progress[ "std" ][ "win_picturesonwall" ].skip == 1) then
      public.Skip();
    else
      private.CheckWin();
    end;

  end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()

  if not cmn.IsEventDone("win_picturesonwall") then

    cmn.MiniGameHide();

  end;
  
end;
--*********************************************************************************************************************
function public.Reset()

local start_state =   {["goldcoin"] =   7,
                       ["boing"] =      9,
                       ["shampoo"] =    11,

                       ["car"] =        12,
                       ["businesman"] = 10,
                       ["model"] =      8,
                       ["dollars"] =    1,
                       ["deer"] =       6,
                       ["airplane"] =   2,

                       ["man"] =        5,
                       ["heraldry"] =   3,
                       ["stone"] =      4
                      };
  local check = false;

  for i = 1, #private.items, 1 do
    if start_state[private.items[i]] ~= private.state[private.items[i]] then
      check = true;
    end;    
  end

  if check then
    for i = 1, #private.items, 1 do

      local trg_after = function ()

        ObjSet("obj_picturesonwall_items", {pos_z = 10});
      
        private.state[private.items[i]] = start_state[private.items[i]];

        ObjMultiSet({
                {"obj_picturesonwall_"..private.items[i], {pos_z = private.GetZPos(private.items[i]), input = 1}},
                {"spr_picturesonwall_"..private.items[i].."_wrong", {alp = 1}},
                {"spr_picturesonwall_"..private.items[i].."_select", {alp = 0}},
                {"spr_picturesonwall_"..private.items[i].."_move", {alp = 0}},
                {"spr_picturesonwall_"..private.items[i].."_good", {alp = 0}},
               }); 

        cmn.Lock(0);

      end;

      ObjAnimate("obj_picturesonwall_"..private.items[i], "pos_xy", 0, 0, trg_after, 
                 {  0, 0, private.item_states[private.items[i]][private.state[private.items[i]]][1], private.item_states[private.items[i]][private.state[private.items[i]]][2],  
                  0.5, 0, private.item_states[private.items[i]][start_state[private.items[i]]][1], private.item_states[private.items[i]][start_state[private.items[i]]][2]});
      ObjAnimate("obj_picturesonwall_"..private.items[i], "ang", 0, 0, "", 
                 {  0, 0, private.item_states[private.items[i]][private.state[private.items[i]]][3],  
                  0.5, 0, private.item_states[private.items[i]][start_state[private.items[i]]][3]});
      ObjAnimate("obj_picturesonwall_"..private.items[i], "scale_xy", 0, 0, "", 
                 {  0, 0, private.item_states[private.items[i]][private.state[private.items[i]]][4], private.item_states[private.items[i]][private.state[private.items[i]]][5],  
                  0.5, 0, private.item_states[private.items[i]][start_state[private.items[i]]][4], private.item_states[private.items[i]][start_state[private.items[i]]][5]});

    end;

    ObjMultiSet({
          {"spr_picturesonwall_picturevillage_gray", {alp = 1}},
          {"spr_picturesonwall_pictureforest_gray", {alp = 1}},
          {"spr_picturesonwall_picturefield_gray", {alp = 1}},
          {"spr_picturesonwall_picturefireplace_gray", {alp = 1}},
          {"spr_picturesonwall_pictureking_gray", {alp = 1}},
          {"spr_picturesonwall_pictureknight_gray", {alp = 1}},
          {"spr_picturesonwall_pictureknight_br", {alp = 1}},
          {"spr_picturesonwall_pictureknight_br_gray", {alp = 1}},
          {"spr_picturesonwall_piktureknight_br_2_grey", {alp = 1}},
          {"spr_picturesonwall_fireplace_br", {alp = 0}},
          {"spr_picturesonwall_fireplace_br_gray", {alp = 1}},
          {"spr_picturesonwall_pictureforest_br_gray", {alp = 1}},
          {"obj_picturesonwall_items", {pos_z = 30}},
         });


    cmn.Lock(1);
  end;

end;
--*********************************************************************************************************************
function public.Skip()

  ng_global.progress[ "std" ][ "win_picturesonwall" ].skip = 1;

  ObjSet("obj_picturesonwall_items", {pos_z = 30});

  for i = 1, #private.items, 1 do

    local trg_after = function ()

      ObjSet("obj_picturesonwall_items", {pos_z = 10});
    
      private.state[private.items[i]] = i;

      private.CheckHit(private.items[i]);  

    end;

    ObjAnimate("obj_picturesonwall_"..private.items[i], "pos_xy", 0, 0, trg_after, 
               {  0, 0, private.item_states[private.items[i]][private.state[private.items[i]]][1], private.item_states[private.items[i]][private.state[private.items[i]]][2],  
                0.5, 0, private.item_states[private.items[i]][i][1], private.item_states[private.items[i]][i][2]});
    ObjAnimate("obj_picturesonwall_"..private.items[i], "ang", 0, 0, "", 
               {  0, 0, private.item_states[private.items[i]][private.state[private.items[i]]][3],  
                0.5, 0, 0});
    ObjAnimate("obj_picturesonwall_"..private.items[i], "scale_xy", 0, 0, "", 
               {  0, 0, private.item_states[private.items[i]][private.state[private.items[i]]][4], private.item_states[private.items[i]][private.state[private.items[i]]][5],  
                0.5, 0, 1, 1});

  end;

  cmn.Lock(1);

end;
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_scrap()

  cmn.SetEventDone( "get_scrap" );
  cmn.CallEventHandler( "get_scrap" );

  cmn.GotoRoom( "rm_cafe" );

end;
--------------------------------------------------------------------------------------------
--*********************************************************************************************************************
function private.StartConditions()

  ng_global.progress[ "std" ][ "win_picturesonwall" ].skip = 0;
  ng_global.progress[ "std" ][ "win_picturesonwall" ].state =  {["goldcoin"] =   7,
                                                                ["boing"] =      9,
                                                                ["shampoo"] =    11,

                                                                ["car"] =        12,
                                                                ["businesman"] = 10,
                                                                ["model"] =      8,
                                                                ["dollars"] =    1,
                                                                ["deer"] =       6,
                                                                ["airplane"] =   2,

                                                                ["man"] =        5,
                                                                ["heraldry"] =   3,
                                                                ["stone"] =      4
                                                               };

end;
--*********************************************************************************************************************
function private.DrawScene()

  for i = 1, #private.items, 1 do
    
    ObjSet("obj_picturesonwall_"..private.items[i], {pos_x = private.item_states[private.items[i]][private.state[private.items[i]]][1], 
                                                     pos_y = private.item_states[private.items[i]][private.state[private.items[i]]][2],
                                                     pos_z = private.GetZPos(private.items[i]),
                                                     ang = private.item_states[private.items[i]][private.state[private.items[i]]][3],
                                                     scale_x = private.item_states[private.items[i]][private.state[private.items[i]]][4],
                                                     scale_y = private.item_states[private.items[i]][private.state[private.items[i]]][5]});

    private.CheckHit(private.items[i], true);
    
  end;
  
end;
--*********************************************************************************************************************
function public.StartDrag(item)

  ObjDetach("obj_picturesonwall_"..item);
  ObjAttach("obj_picturesonwall_"..item, "mg_picturesonwall");

  ObjMultiSet({
                {"obj_picturesonwall_"..item, {pos_z = 20, ang = 0, scale_x = 1, scale_y = 1}},
                {"spr_picturesonwall_"..item.."_wrong", {alp = 0}},
                {"spr_picturesonwall_"..item.."_select", {alp = 0}},
                {"spr_picturesonwall_"..item.."_move", {alp = 1}}
               });

  for i = 1, #private.items, 1 do

    if ((private.items[i] ~= item) and (private.state[private.items[i]] ~= i)) then

      local obj = "spr_picturesonwall_"..private.items[i].."_select";
      local alp = ObjGet( obj ).alp;
      local tme = ( 1 - alp ) * 0.2;

      ObjAnimate( obj, 8, 0, 0, "",
      {
        0.0, 2, alp,
        tme, 2, 1
      } );

        --ObjSet("spr_picturesonwall_"..private.items[i].."_select",{alp = 1});

    end;

  end;

  cmn.PlayAudio("snd", "assets/levels/level1/mg_picturesonwall/audio/aud_takepicturepart");

end;
--*********************************************************************************************************************
function public.StopDrag(item)

  local drop_obj = "obj_picturesonwall_"..item; 
  local z_value = 0;
  local curspos = GetGameCursorPos();
  private.replaced = false;

  for i = 1, #private.items, 1 do

    if ((private.items[i] ~= item) and (private.state[private.items[i]] ~= i)) then
      local obj = "spr_picturesonwall_"..item.."_select";
      local alp = ObjGet( obj ).alp;
      local tme = alp * 0.2;

      ObjAnimate( obj, 8, 0, 0, "",
      {
        0.0, 2, alp,
        tme, 2, 0
      } );
     -- ObjSet("spr_picturesonwall_"..private.items[i].."_select", {alp = 0});
    end;

  end;

  ObjSet("obj_picturesonwall_check_obj", {pos_x = curspos[1], pos_y = curspos[2]});

  for i = 1, #private.items, 1 do
    if private.items[i] ~= item then
      if cmn.ApplyObj( "obj_picturesonwall_check_obj", "obj_picturesonwall_"..private.items[i] ) 
        and  (private.items[i] ~= private.items[private.state[private.items[i]]]) then
        private.state[item], private.state[private.items[i]] = private.state[private.items[i]], private.state[item];

        local trg_after = function ()

          ObjSet("obj_picturesonwall_"..private.items[i], {pos_x = private.item_states[private.items[i]][private.state[private.items[i]]][1], 
                                                           pos_y = private.item_states[private.items[i]][private.state[private.items[i]]][2],
                                                           pos_z = private.GetZPos(private.items[i]),
                                                           ang = private.item_states[private.items[i]][private.state[private.items[i]]][3],
                                                           scale_x = private.item_states[private.items[i]][private.state[private.items[i]]][4],
                                                           scale_y = private.item_states[private.items[i]][private.state[private.items[i]]][5]});
          ObjSet(drop_obj, {pos_z = private.GetZPos(item)});
          ObjDetach(drop_obj);
          ObjAttach(drop_obj, "obj_picturesonwall_items");
          ObjStartDrag("obj_picturesonwall_"..private.items[i]); 
          private.CheckHit(item); 

          cmn.PlayAudio("snd", "assets/levels/level1/mg_picturesonwall/audio/aud_releasepicturepart");
 
        end;

        ObjAnimate(drop_obj, "pos_xy", 0, 0, trg_after, 
                   {  0, 0, curspos[1], curspos[2],  
                    0.2, 0, private.item_states[item][private.state[item]][1], private.item_states[item][private.state[item]][2]});
        ObjAnimate(drop_obj, "ang", 0, 0, "", 
                   {  0, 0, 0,  
                    0.2, 0, private.item_states[item][private.state[item]][3]});
        ObjAnimate(drop_obj, "scale_xy", 0, 0, "", 
                   {  0, 0, 1, 1,  
                    0.2, 0, private.item_states[item][private.state[item]][4], private.item_states[item][private.state[item]][5]});

   
        private.replaced = true;
        break;
          
      end;
    end;  
  end;

  if not private.replaced then

        local trg_after = function ()

          ObjSet(drop_obj, {pos_z = private.GetZPos(item)});
          ObjDetach(drop_obj);
          ObjAttach(drop_obj, "obj_picturesonwall_items");
          private.CheckHit(item); 

          cmn.PlayAudio("snd", "assets/levels/level1/mg_picturesonwall/audio/aud_releasepicturepart");
 
        end;

        ObjAnimate(drop_obj, "pos_xy", 0, 0, trg_after, 
                   {  0, 0, curspos[1], curspos[2],  
                    0.2, 0, private.item_states[item][private.state[item]][1], private.item_states[item][private.state[item]][2]});
        ObjAnimate(drop_obj, "ang", 0, 0, "", 
                   {  0, 0, 0,  
                    0.2, 0, private.item_states[item][private.state[item]][3]});
        ObjAnimate(drop_obj, "scale_xy", 0, 0, "", 
                   {  0, 0, 1, 1,  
                    0.2, 0, private.item_states[item][private.state[item]][4], private.item_states[item][private.state[item]][5]});
 
  end;

  for i = 1, #private.items, 1 do

    local obj = "spr_picturesonwall_"..private.items[i].."_select";

    ObjSet(obj, {alp = 0});

  end;

  cmn.Lock(1);

end;
--*********************************************************************************************************************
function private.CheckHit(item, force)

  if item == private.items[private.state[item]] then
  
    ObjMultiSet({
                  {"obj_picturesonwall_"..item, {input = 0}},
                  {"spr_picturesonwall_"..item.."_good", {alp = 1}},
                  {"spr_picturesonwall_"..item.."_wrong", {alp = 0}},
                  {"spr_picturesonwall_"..item.."_move", {alp = 0}},
                  {"spr_picturesonwall_"..item.."_select", {alp = 0}}
                });

    private.Coloring(item, force);

  else

    ObjMultiSet({
                  {"spr_picturesonwall_"..item.."_wrong", {alp = 1}},
                  {"spr_picturesonwall_"..item.."_move", {alp = 0}}
                 }); 

    cmn.Lock(0);

  end;

end;
--*********************************************************************************************************************
function private.GetZPos(item)

  if private.state[item] == 4 then
    return 2;
  elseif private.state[item] == 5 then
    return 1;
  else 
    return 0;
  end;

end;
--*********************************************************************************************************************
function private.Coloring(item, force)

  local picture = "";

  local trg_after = function ()

    if private.replaced then
      cmn.Lock(0);
    else
      private.CheckWin();
    end;

  end;

  if item == "goldcoin" then
    picture = "spr_picturesonwall_pictureking_gray";
  elseif item == "deer" then
    picture = "spr_picturesonwall_picturefireplace_gray";
  elseif item == "airplane" then
    picture = "spr_picturesonwall_picturefield_gray";
  elseif item == "man" then
    picture = "spr_picturesonwall_picturevillage_gray";
  elseif item == "heraldry" then
    picture = "spr_picturesonwall_pictureknight_gray";
  elseif item == "stone" then
    picture = "spr_picturesonwall_pictureforest_gray";
  end;

  if picture ~= "" then

    if force then

      ObjSet(picture, {alp = 0});

      if item == "heraldry" then
        ObjSet("spr_picturesonwall_pictureknight_br_gray", {alp = 0});
        ObjSet("spr_picturesonwall_piktureknight_br_2_grey", {alp = 0});
      end;

      if item == "deer" then
        ObjSet("spr_picturesonwall_fireplace_br_gray", {alp = 0});
        ObjSet("spr_picturesonwall_fireplace_br", {alp = 1});
      end;

      if item == "stone" then
        ObjSet("spr_picturesonwall_pictureforest_br_gray", {alp = 0});
      end;
      
    else

      ObjAnimate(picture, "alp", 0, 0, trg_after, {0, 0, 1, 0.3, 0, 0});

      if item == "heraldry" then
        ObjAnimate("spr_picturesonwall_pictureknight_br_gray", "alp", 0, 0, "", {0, 0, 1, 0.3, 0, 0});
        ObjAnimate("spr_picturesonwall_piktureknight_br_2_grey", "alp", 0, 0, "", {0, 0, 1, 0.3, 0, 0});
      end;

      if item == "deer" then
        ObjAnimate("spr_picturesonwall_fireplace_br_gray", "alp", 0, 0, "", {0, 0, 1, 0.3, 0, 0});
        ObjAnimate("spr_picturesonwall_fireplace_br", "alp", 0, 0, "", {0, 0, 0, 0.3, 0, 1});
      end;

      if item == "stone" then
        ObjAnimate("spr_picturesonwall_pictureforest_br_gray", "alp", 0, 0, "", {0, 0, 1, 0.3, 0, 0});
      end;

      cmn.PlayAudio("snd", "assets/levels/level1/mg_picturesonwall/audio/aud_wrightpicture");

    end;

  else
    if private.replaced then
      cmn.Lock(0);
    else
      private.CheckWin();
    end;
  end;

end;
--*********************************************************************************************************************
function public.MouseEnter(item)

  SetCursor(  CURSOR_GET  );
  local obj = "spr_picturesonwall_"..item.."_select";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * 0.3;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--*********************************************************************************************************************
function public.MouseLeave(item)
 
  SetCursor( CURSOR_DEFAULT );
  
  local obj = "spr_picturesonwall_"..item.."_select";
  local alp = ObjGet( obj ).alp;
  local tme = alp * 0.3;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 0
  } );

end;
--*********************************************************************************************************************
function private.CheckWin()

  local check = true;

  for i = 1, #private.items, 1 do

    if private.state[private.items[i]] ~= i then

      check = false;
      cmn.Lock(0);
      break;

    end;

  end;

  if check then
    private.Win();
  else 
    cmn.Lock(0);
  end;

end;
--*********************************************************************************************************************
function private.WinEnd()

  cmn.Lock(0);
  common_impl.PauseAchiev(0);

  cmn.SetEventDone( "win_picturesonwall" );
  cmn.CallEventHandler( "win_picturesonwall_end" );

  cmn.CallEventHandler( "win_picturesonwall_loc" );

  if ng_global.progress[ "std" ][ "win_picturesonwall" ].skip == 0 and not( ng_global.noskipgames[ "win_picturesonwall" ] ) then

    ng_global.noskipgames[ "win_picturesonwall" ] = 1;
    common_impl.CheckAchiev("mg");

  end;

end;
--*********************************************************************************************************************
function private.Win()

  common_impl.PauseAchiev(1);
  cmn.EndTimePassing("mg_picturesonwall");

  cmn.MiniGameHide();

  local func_after = function ()

    ObjAttach("obj_picturesonwall_boing", "spr_picturesonwall_mainpicture");
    ObjAttach("obj_picturesonwall_shampoo", "spr_picturesonwall_mainpicture");
    ObjAttach("obj_picturesonwall_car", "spr_picturesonwall_mainpicture");
    ObjAttach("obj_picturesonwall_businesman", "spr_picturesonwall_mainpicture");
    ObjAttach("obj_picturesonwall_model", "spr_picturesonwall_mainpicture");
    ObjAttach("obj_picturesonwall_dollars", "spr_picturesonwall_mainpicture");
    ObjAttach("spr_picturesonwall_mainpicture_br_1", "spr_picturesonwall_mainpicture");
    ObjAttach("spr_picturesonwall_dollars_br", "spr_picturesonwall_mainpicture");

    cmn.PlayAudio("snd", "assets/levels/level1/mg_picturesonwall/audio/aud_win_mg_picturesonwall");

    ObjAnimate("spr_picturesonwall_mainpicture", "pos_y", 0, 0, private.WinEnd, {0, 2, 0,     0.5, 2, 0,     1, 2, -295});

  end;

  ObjAnimate("spr_picturesonwall_mainpicture_gray", "alp", 0, 0, func_after, {0, 0, 1,     0.5, 0, 0,   1, 0, 0});
  ObjAnimate("spr_picturesonwall_dollars_br_grey", "alp", 0, 0, "", {0, 0, 1,     0.5, 0, 0});
  ObjAnimate("spr_picturesonwall_mainpicture_br_1_grey", "alp", 0, 0, "", {0, 0, 1,     0.5, 0, 0});
  ObjAnimate("spr_picturesonwall_mainpicture_br_1", "alp", 0, 0, "", {0, 0, 0,     0.5, 0, 1});
  ObjAnimate("spr_picturesonwall_model_good_br_gray", "alp", 0, 0, "", {0, 0, 1,     0.5, 0, 0});

end;
--*********************************************************************************************************************