--*********************************************************************************************************************
function public.Init()

  private.room_objname = "mg_keys";

 --------------------------------------------------------------------------------------------
  -- function win_keys () end;
  --------------------------------------------------------------------------------------------

  local win_keys_end = function ()
  
    if cmn.IsEventDone("win_keys") then

      ObjDelete("spr_keys_cover_closed");

      for i = 1, 6, 1 do

        ObjDelete("spr_keys_key_"..i.."_1");
        ObjDelete("spr_keys_key_"..i.."_2");

        ObjMultiSet({
                     {"obj_keys_key_"..i.."_1", {input = 0}},
                     {"obj_keys_key_"..i.."_2", {input = 0}},
                     {"spr_keys_key_"..i.."_1_turned", {alp = 1}},
                     {"spr_keys_key_"..i.."_2_turned", {alp = 1}},
                     {"spr_keys_clasp_open_"..i, {alp = 1}}
                    });

      end


      ObjMultiSet({
                    {"spr_keys_cover_open", {alp = 1}},
                    {"spr_keys_ironkey",{input = 1}}
                  });

    end;
  
  end;

  cmn.AddSubscriber( "win_keys",     win_keys_end, private.room_objname ); 
  cmn.AddSubscriber( "win_keys_end", win_keys_end, private.room_objname );
  
  --------------------------------------------------------------------------------------------
  -- function get_ironkey () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "get_ironkey" ] = {

      type = "get",
      get_obj = "spr_keys_ironkey",
      room = private.room_objname
  };
  --------------------------------------------------------------------------------------------
  local get_ironkey_inv = function ()
  
    interface.InventoryItemAdd( "inv_ironkey", "spr_keys_ironkey" );
  
  end;
  
  local get_ironkey_closezz = function ()
  
    ObjDelete( "gfx_keys_ironkey" );
    ObjDelete( "spr_keys_ironkey_sh" );
    ObjDelete( "gmg_foyer_keys" );
  
  end;
  
  cmn.AddSubscriber( "get_ironkey", get_ironkey_inv );
  cmn.AddSubscriber( "get_ironkey", get_ironkey_closezz, "rm_foyer" );

  private.pos =  { { 356, 867 },
                   { 219, 148 },
                   { 787, 495 },
                   { 323, 556 },
                   { 184, 708 },
                   { 833, 670 } };
  
end;
--*********************************************************************************************************************
function public.Load()

  if not cmn.IsEventDone("clk_cliconbutton") then
    private.StartConditions(); 
  end;

  private.state = ng_global.progress[ "std" ][ "win_keys" ].state; 

  if cmn.IsEventDone("clk_cliconbutton") and (not cmn.IsEventDone("win_keys")) then

    private.DrawScene();

  end;

end;
--*********************************************************************************************************************
function public.Open() 

  if (not cmn.IsEventDone("win_keys")) then 

    cmn.MiniGameShow( "keys" );
    cmn.StartTimePassing("mg_keys");

  end;

end;
--*********************************************************************************************************************
function public.PreOpen()

  if (not cmn.IsEventDone("win_keys")) then 

    if (ng_global.progress[ "std" ][ "win_keys" ].skip == 1) then
      public.Skip();
    else
      private.CheckWin();
    end;

  end;

end;
--*********************************************************************************************************************
function public.Close()
end;
--*********************************************************************************************************************
function public.PreClose()

  if not cmn.IsEventDone("win_keys") then

    cmn.MiniGameHide();

  end;
  
end;
--*********************************************************************************************************************
function public.Reset()

  local need_r = false;

  for i = 1, #private.state["complete"], 1 do

    if private.state["complete"][i] == 1 then

      if not(need_r) then
        need_r = true;
      end;

      private.state["complete"][i] = 0;

      ObjAnimate("spr_keys_key_"..i.."_1", "alp", 0, 0, "", 
                  {   0, 2, 0,
                    0.3, 2, 1 });
      ObjAnimate("spr_keys_key_"..i.."_2", "alp", 0, 0, "", 
                  {   0, 2, 0,
                    0.3, 2, 1 });

      ObjAnimate("spr_keys_key_"..i.."_1_turned", "alp", 0, 0, "", 
                  {   0, 2, 1,
                    0.3, 2, 0 });
      ObjAnimate("spr_keys_key_"..i.."_2_turned", "alp", 0, 0, "", 
                  {   0, 2, 1,
                    0.3, 2, 0 });

      ObjAnimate("spr_keys_clasp_close_"..i, "alp", 0, 0, "", 
                  {   0, 1, 0,
                    0.3, 1, 1 });
      ObjAnimate("spr_keys_clasp_open_"..i, "alp", 0, 0, function () cmn.Lock(0); end, 
                  {   0, 1, 1,
                    0.3, 1, 0 });
      ObjMultiSet({
                    {"obj_keys_key_"..i.."_1",{input = 1}},
                    {"obj_keys_key_"..i.."_2",{input = 1}}
                  });
      cmn.Lock(1);

    end;
    
  end;

  if (need_r) then
    cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_reset_keys");
  end;

  if not (private.state["changed"][1] == 0) then

    local changed = private.state["changed"];
    local pos_x = ObjGet("obj_keys_key_"..changed[1].."_"..changed[2]).pos_x;


    private.state["changed"] ={ 0, 0 };

    ObjAnimate("obj_keys_key_"..changed[1].."_"..changed[2], "pos_x", 0, 0, function () cmn.Lock(0); end, 
              {   0, 2, pos_x,
                0.3, 2, pos_x + 80 });  

    cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_clk_key");
    
    cmn.Lock(1);
    
  end;

end;
--*********************************************************************************************************************
function public.Skip()

  ng_global.progress[ "std" ][ "win_keys" ].skip = 1;

  local trg_after = function () 

    for i = 1, #private.state["complete"], 1 do

      if private.state["complete"][i] == 0 then

        private.state["complete"][i] = 1;       
        
        ObjAnimate("spr_keys_key_"..i.."_1", "alp", 0, 0, "", 
                    {   0, 2, 1,
                      0.3, 2, 0 });
        ObjAnimate("spr_keys_key_"..i.."_2", "alp", 0, 0, "", 
                    {   0, 2, 1,
                      0.3, 2, 0 });

        ObjAnimate("spr_keys_key_"..i.."_1_turned", "alp", 0, 0, "", 
                    {   0, 2, 0,
                      0.3, 2, 1 });
        ObjAnimate("spr_keys_key_"..i.."_2_turned", "alp", 0, 0, "", 
                    {   0, 2, 0,
                      0.3, 2, 1 });

        ObjAnimate("spr_keys_clasp_close_"..i, "alp", 0, 0, "", 
                    {   0, 1, 1,
                      0.5, 1, 1,
                      0.8, 1, 0 });
        ObjAnimate("spr_keys_clasp_open_"..i, "alp", 0, 0, function () cmn.Lock(0); end, 
                    {   0, 1, 0,
                      0.5, 1, 0,
                      0.8, 1, 1 });

        ObjMultiSet({
                      {"obj_keys_key_"..i.."_1",{input = 0}},
                      {"obj_keys_key_"..i.."_2",{input = 0}}
                    });

      end;

    end;

    cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_wrightkeys");

    ObjSet("tmr_keys_timer", {endtrig = private.Win, time = 1, playing = 1});

  end;

  if not (private.state["changed"][1] == 0) then

    local changed = private.state["changed"];
    local pos_x = private.pos[changed[1]][changed[2]];

    private.state["changed"] = { 0, 0 };

    ObjAnimate("obj_keys_key_"..changed[1].."_"..changed[2], "pos_x", 0, 0, trg_after, 
              {   0, 2, pos_x - 80,
                0.3, 2, pos_x}); 

    cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_clk_key");

  else 

    trg_after(); 
    
  end;

  cmn.Lock(1);


end;
--*********************************************************************************************************************
-- function *** PROGRESS USE *** () end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** PROGRESS GET *** () end;
--*********************************************************************************************************************
--------------------------------------------------------------------------------------------
function public.get_ironkey()

  cmn.SetEventDone( "get_ironkey" );
  cmn.CallEventHandler( "get_ironkey" );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");

  cmn.GotoRoom( "rm_foyer" );

end;
--------------------------------------------------------------------------------------------
--*********************************************************************************************************************
function private.StartConditions()

  ng_global.progress[ "std" ][ "win_keys" ].skip = 0;
  ng_global.progress[ "std" ][ "win_keys" ].state =  {["changed"] =   { 0, 0 },
                                                      ["complete"] =  { 0, 0, 0, 0, 0, 0 }};

end;
--*********************************************************************************************************************
function private.DrawScene()

  for i = 1, #private.state["complete"], 1 do

    if private.state["complete"][i] == 1 then

      ObjMultiSet({
                    {"obj_keys_key_"..i.."_1",{pos_x = private.pos[i][1], input = 0}},
                    {"obj_keys_key_"..i.."_2",{pos_x = private.pos[i][2], input = 0}},
                    {"spr_keys_key_"..i.."_1",{alp = 0}},
                    {"spr_keys_key_"..i.."_2",{alp = 0}},
                    {"spr_keys_key_"..i.."_1_turned",{alp = 1}},
                    {"spr_keys_key_"..i.."_2_turned",{alp = 1}},
                    {"spr_keys_clasp_close_"..i,{alp = 0}},
                    {"spr_keys_clasp_open_"..i,{alp = 1}}
                  });
    else 

      ObjMultiSet({
                    {"obj_keys_key_"..i.."_1",{pos_x = private.pos[i][1], input = 1, alp = 1}},
                    {"obj_keys_key_"..i.."_2",{pos_x = private.pos[i][2], input = 1, alp = 1}},
                    {"spr_keys_key_"..i.."_1",{alp = 1}},
                    {"spr_keys_key_"..i.."_2",{alp = 1}},
                    {"spr_keys_key_"..i.."_1_turned",{alp = 0}},
                    {"spr_keys_key_"..i.."_2_turned",{alp = 0}},
                    {"spr_keys_clasp_close_"..i,{alp = 1}},
                    {"spr_keys_clasp_open_"..i,{alp = 0}},
                  });

    end;

  end;

  if not (private.state["changed"][1] == 0) then

    ObjSet("obj_keys_key_"..private.state["changed"][1].."_"..private.state["changed"][2], 
            {pos_x = private.pos[private.state["changed"][1]][private.state["changed"][2]] - 80});
    
  end;

end;
--*********************************************************************************************************************
function public.ClkKey(pair, key)

  cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_clk_key");

  if private.state["changed"][1] == 0 then

    private.state["changed"][1] = pair;
    private.state["changed"][2] = key;

    private.KeyMove(pair, key, 1);
  
  elseif  ((private.state["changed"][1] == pair) and (private.state["changed"][2] == key)) then

    private.state["changed"] = {0, 0};

    private.KeyMove(pair, key, -1);

  else
    
    private.KeyMove(pair, key, 1, true);

  end;
    
end;
--*********************************************************************************************************************
function private.CheckCoincidence(pair, key)

  local trg = function ()
  
    local changed = private.state["changed"];

    private.state["changed"] = {0, 0};

    if (pair == changed[1]) then

      cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_wrightkeys");

      private.state["complete"][pair] = 1;

      ObjAnimate("obj_keys_key_"..pair.."_1", "pos_x", 0, 0, "", 
                  {   0, 1, private.pos[pair][1] - 80,
                    0.2, 1, private.pos[pair][1] - 80,
                    0.5, 1, private.pos[pair][1] });
      ObjAnimate("obj_keys_key_"..pair.."_2", "pos_x", 0, 0, "", 
                  {   0, 1, private.pos[pair][2] - 80,
                    0.2, 1, private.pos[pair][2] - 80,
                    0.5, 1, private.pos[pair][2] });

      ObjAnimate("spr_keys_key_"..pair.."_1", "alp", 0, 0, "", 
                  {   0, 2, 1,
                    0.7, 2, 1,
                    1.0, 2, 0 });
      ObjAnimate("spr_keys_key_"..pair.."_2", "alp", 0, 0, "", 
                  {   0, 2, 1,
                    0.7, 2, 1,
                    1.0, 2, 0 });
      ObjAnimate("spr_keys_key_"..pair.."_1_turned", "alp", 0, 0, "", 
                  {   0, 2, 0,
                    0.7, 2, 0,
                    1.0, 2, 1 });
      ObjAnimate("spr_keys_key_"..pair.."_2_turned", "alp", 0, 0, "", 
                  {   0, 2, 0,
                    0.7, 2, 0,
                    1.0, 2, 1 });

      ObjAnimate("spr_keys_clasp_close_"..pair, "alp", 0, 0, "", 
                  {   0, 1, 1,
                    1.2, 1, 1,
                    1.5, 1, 0 });
      ObjAnimate("spr_keys_clasp_open_"..pair, "alp", 0, 0, private.CheckWin, 
                  {   0, 1, 0,
                    1.2, 1, 0,
                    1.5, 1, 1 });

      ObjMultiSet({
                    {"obj_keys_key_"..pair.."_1",{input = 0}},
                    {"obj_keys_key_"..pair.."_2",{input = 0}}
                  });

    else

      cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_wrongkeys");

      private.KeyMove(changed[1], changed[2], -1);
      private.KeyMove(pair, key, -1);

    end;

  end;

  ObjSet("tmr_keys_timer", {endtrig = trg, time = 0.5, playing = 1});


end;
--*********************************************************************************************************************
function private.KeyMove(pair, key, dir, needcheck)

  local trg_after = function () cmn.Lock(0); end;
  local pos_x = ObjGet("obj_keys_key_"..pair.."_"..key).pos_x;



  if needcheck then
    trg_after = function () private.CheckCoincidence(pair, key); end;
  end;

  ObjAnimate("obj_keys_key_"..pair.."_"..key, "pos_x", 0, 0, trg_after, 
                  {   0, 2, pos_x,
                    0.5, 2, pos_x - (80 * dir) });

  cmn.Lock(1);

end;
--*********************************************************************************************************************
function public.MouseEnter(pair, key)

  SetCursor( CURSOR_HAND );
  cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_coursortokey");

  local obj = "spr_keys_key_"..pair.."_"..key.."_touch";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * 0.3;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--*********************************************************************************************************************
function public.MouseLeave(pair, key)

  SetCursor( CURSOR_DEFAULT );
  
  local obj = "spr_keys_key_"..pair.."_"..key.."_touch";
  local alp = ObjGet( obj ).alp;
  local tme = alp * 0.3;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 0
  } );

end;
--*********************************************************************************************************************
function private.CheckWin()

  local check = true;

  for i = 1, #private.state["complete"], 1 do

    if private.state["complete"][i] ~= 1 then

      check = false;
      break;

    end;

  end;

  if check then
    private.Win();
  else 
    cmn.Lock(0);
  end;

end;
--*********************************************************************************************************************
function private.WinEnd()

  cmn.Lock(0);

  cmn.SetEventDone( "win_keys" );
  cmn.CallEventHandler( "win_keys" );

--  cmn.GotoRm( "" );

end;
--*********************************************************************************************************************
function private.Win()

  cmn.MiniGameHide();

  cmn.EndTimePassing("mg_keys");

  cmn.PlayAudio("snd", "assets/levels/level1/mg_keys/audio/aud_win_mg_keys");

  ObjAnimate("spr_keys_cover_closed", "alp", 0, 0, "", 
      {  0, 2, 1,
         0.5, 2, 0 });
  ObjAnimate("spr_keys_cover_open", "alp", 0, 0,   private.WinEnd, 
      {  0, 2, 0,
         0.5, 2, 1 });

  if ng_global.progress[ "std" ][ "win_keys" ].skip == 0 and not( ng_global.noskipgames[ "win_keys" ] ) then

    ng_global.noskipgames[ "win_keys" ] = 1;
    common_impl.CheckAchiev("mg");

  end;

end;
--*********************************************************************************************************************