--*********************************************************************************************************************
function public.Init()
  --------------------------------------------------------------------------------------------------
  room.Define( "ho_hooldthings" );
  game.relations[ "ho_hooldthings" ].exitroom = "rm_orphanagepark";
  game.hooldthings = {};

  private.objects = { "moneybox", "ball", "shovel", "hat", "kite", "shoes", "bag", "umbrella", "drum", "toyfrog", "leaf", "pumpkin" };

  private.thins_pos = { { {718, 581}, {536, 296}, {270, 581}, {341, 412}, {898, 78}, {928, 510}, {696, 275}, {365, 208}, {129, 145}, {127, 390}, {539, 62}, {516, 513} },
                        { {642, 573, 0}, {436, 287, 0}, {192, 538, 0.21}, {347, 358, 0}, {995, 241, -0.05}, {1029, 513, 0}, 
                          {768, 112, 0}, {245, 44, 1.16}, {103, 277, 0.52}, {220, 332, 0.08}, {455, 58, -0.08}, {406, 493, 0} } };

  private.pic_pos = { { {541, 59}, {152, 278}, {965, 450}, {66, 450}, {914, 257}, {920, 92}, {849, 411}, {741, 85}, {69, 137}, {195, 447}, {335, 56}, {193, 92} },
                      { {527, 484}, {678, 460}, {708, 373}, {699, 235}, {583, 204}, {465, 231}, {370, 210}, {331, 309}, {317, 431}, {407, 416}, {494, 367}, {596, 336} } };


  --------------------------------------------------------------------------------------------------
  game.hint[ "win_hooldthings" ] = 
  {
    type = "win",
    room = "rm_orphanagepark",
    zz = "ho_hooldthings",
    zz_gate = "gho_orphanagepark_hooldthings"
  };
  --------------------------------------------------------------------------------------------------
  local win_hooldthings_func = function ()

    if ( cmn.IsEventDone( "win_hooldthings" ) ) then
      interface.InventoryItemAdd( "inv_wrench", "spr_hooldthings_win" );
      ObjDelete("gho_orphanagepark_hooldthings");
      int_map_impl.DecreaseRoomTasks("rm_orphanagepark");
    end;

  end;
  cmn.AddSubscriber( "win_hooldthings", win_hooldthings_func );
  --------------------------------------------------------------------------------------------------
  local start_hooldthings_func = function ()

    if ( cmn.IsEventStart( "win_hooldthings" ) ) then

      common_impl.ProcessHoStart( "hooldthings" );

      local ho_found = ng_global.progress[ "std" ][ "win_hodetectivedesk" ].found;

      if (ho_found) then

        for i = 1, #ho_found, 1 do
          ObjDelete( ho_found[ i ][ "object" ] );
        end;

      end;

    end;

  end;
  cmn.AddSubscriber( "win_hooldthings", start_hooldthings_func, "ho_hooldthings" );  

end;
--*********************************************************************************************************************
function public.Load()

  if not(ng_global.progress[ "std" ][ "win_hooldthings" ].state) then 
    ng_global.progress[ "std" ][ "win_hooldthings" ].state = { { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
                                                                                                       { 1, 5, 6, 7, 0, 2, 7, 4, 3, 0, 1, 5 } };
  end;

  if not(ng_global.progress[ "std" ][ "win_hooldthings" ].stage) then 
    ng_global.progress[ "std" ][ "win_hooldthings" ].stage = { 1, 3 };   --[1] - номер стадии, [2] - количество стадий
  end;

end;
--*********************************************************************************************************************
function public.PreOpen()

  private.DrawScene();

  cmn.StartTimePassing("ho_hooldthings");

  cmn.StopAllEnv("assets/levels/common/audio/aud_orphanagepark_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_orphanagepark_env");
  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_ho_1lvl_mus", 1);

  if not cmn.IsEventStart( "win_hooldthings" ) then
    cmn.InitHo( "hooldthings" );
  end;

  local ho_tasks = private.stages_task();

  if (not cmn.IsEventDone("win_hooldthings")) and
     ( ng_global.progress[ "std" ][ "win_hooldthings" ].stage[1] <= ng_global.progress[ "std" ][ "win_hooldthings" ].stage[2] ) then

    interface_impl.TaskPanelShow( ho_tasks );

  else
    common_impl.DialogHo_Show();
  end;

end;
--*********************************************************************************************************************
function public.PreClose()

  if not(cmn.IsEventDone("win_hooldthings")) then
    interface_impl.TaskPanelHide();
  end;

  cmn.StopAllMus();

  ObjSet("int_inventory",  { input = 1 });

  if ( cmn.IsEventDone( "win_hooldthings" ) ) then

    common_impl.PauseAchiev(0);

    cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_howl_mus");

    if ng_global.progress[prg.current][ "win_hooldthings" ].is_hint ~= 1 then

      if ng_global.state_ho[3] == 0 then
        common_impl.CheckAchiev( "ho" );
        ng_global.state_ho[3] = 1;
      end;

    end;

  end;

end;
--*********************************************************************************************************************
function public.Close()

  cmn.HideNote(0);

end;
--*********************************************************************************************************************
function public.HoComplete()

  common_impl.PauseAchiev(1);

  if ng_global.state_ho[3] == 0 then
    cmn.EndTimePassing("ho_hooldthings");
  end;

end;
--*********************************************************************************************************************
function public.ItemFound( ind )

  local item_name = private.objects[ind];
  local func_after = function ()

    private.PartFound( ind );

  end;

  ng_global.progress[ "std" ][ "win_hooldthings" ].state[1][ind] = 1;
  ObjSet("spr_hooldthings_"..item_name,  { input = 0 });

  cmn.HoTaskFind("obj_hooldthings_"..item_name, item_name);

  ObjAnimate("spr_hooldthings_"..item_name, "pos_xy", 0, 0, func_after, { 0, 0, private.thins_pos[1][ind][1], private.thins_pos[1][ind][2],
                                                                        0.5, 0, private.thins_pos[2][ind][1], private.thins_pos[2][ind][2] });

  ObjAnimate("spr_hooldthings_"..item_name, "ang", 0, 0, "", { 0, 0, 0,     0.5, 0, private.thins_pos[2][ind][3] });

  if (ind == 12) then

    ObjAnimate("spr_hooldthings_overlap_6", "alp", 0, 0, "", { 0, 0, 0,    0.5, 0, 1 });

  end;

end;
--------------------------------------------------------------------------------------------
function private.PartFound( ind )

  ObjAnimate("spr_hooldthings_puzzle_"..ind.."_1", "alp", 0, 0, "", { 0, 0, 1,    0.3, 0, 0 });
  ObjAnimate("spr_hooldthings_puzzle_"..ind.."_2", "alp", 0, 0, "", { 0, 0, 0,    0.3, 0, 0,   0.6, 0, 1 });

end;
--------------------------------------------------------------------------------------------
function public.WrenchFound()

  ObjDelete("spr_hooldthings_wrench_sh");
  cmn.HoTaskFind("spr_hooldthings_wrench", "wrench");

end;
---------------------------------------------------------------------------------
function public.rat_touch()

  cmn.PlayAudio("snd", "assets/levels/level1/ho_hooldthings/audio/aud_xx_rat");

  local func_after = function ()

    ObjSet("anm_hooldthings_rat", { playing = 1, alp = 1 });
    ObjSet("anm_hooldthings_rat_2", { alp = 0 });    
    ObjSet("obj_hooldthings_rat",  { input = 1 });

  end;

  ObjSet("anm_hooldthings_rat", { playing = 0, alp = 0 });
  ObjSet("anm_hooldthings_rat_2", { endtrig = func_after, playing = 1, alp = 1 });

  ObjSet("obj_hooldthings_rat",  { input = 0 });
  --cmn.ShowBbt( "obj_pole_use_bowstring1" );

end;
---------------------------------------------------------------------------------
--*********************************************************************************************************************
function private.DrawScene()

  local ho_found = ng_global.progress[ "std" ][ "win_hooldthings" ].state[1];
  local item_name;

  for i = 1, #ho_found, 1 do

    if (ho_found[i] == 1) then

      item_name = private.objects[i];
      ObjSet("spr_hooldthings_"..item_name,  { pos_x = private.thins_pos[2][i][1],  pos_y = private.thins_pos[2][i][2], ang = private.thins_pos[2][i][3], input = 0 });
      ObjSet("spr_hooldthings_puzzle_"..i.."_2",  { alp = 1 });
      ObjDelete("spr_hooldthings_puzzle_"..i.."_1");

    end;

  end;

  if (ho_found[12] == 1) then

    ObjSet("spr_hooldthings_overlap_6", { alp = 1 });

  end;

  local ho_game = ng_global.progress[ "std" ][ "win_hooldthings" ].state[2];
  local game_ang = ng_global.progress[ "std" ][ "win_hooldthings" ].state[3];
  local k_ang = 0.785;

  for i = 1, #ho_game, 1 do

    ObjSet("spr_hooldthings_picture_"..i,  { ang = -k_ang*game_ang[i] });

  end;

  if ( ng_global.progress[ "std" ][ "win_hooldthings" ].stage[1] == 2 ) then

    ObjSet( "obj_hooldthings_game", { input = 1, alp = 1 } );

    for i = 1, #ho_game, 1 do

      if (ho_game[i] == 1) then

        ObjSet("spr_hooldthings_picture_"..i,  { pos_x = private.pic_pos[2][i][1],  pos_y = private.pic_pos[2][i][2] });

      end;

      if (ho_game[i] == 1) and (game_ang[i] == 0) then

        ObjSet("spr_hooldthings_picture_"..i,  { input = 0 });

      end;

    end;

  elseif ( ng_global.progress[ "std" ][ "win_hooldthings" ].stage[1] == 3 ) then

    ObjDelete("obj_hooldthings_game");
    ObjDelete("spr_hooldthings_box_closed");
    ObjDelete("obj_hooldthings_puzzle_parts_2");
    ObjSet("spr_hooldthings_box_open",  { alp = 1, input = 1 });

  end;

end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** STAGES *** () end;
--*********************************************************************************************************************
------------------------------------------------------------------------------
function private.stages_task()

  local ho_tasks = {};

  if ( ng_global.progress[ "std" ][ "win_hooldthings" ].stage[1] == 1 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "moneybox",      1, 0, { { "obj_hooldthings_moneybox" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "ball",          1, 0, { { "obj_hooldthings_ball" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "shovel",        1, 0, { { "obj_hooldthings_shovel" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "hat",           1, 0, { { "obj_hooldthings_hat" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "kite",          1, 0, { { "obj_hooldthings_kite" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "shoes",         1, 0, { { "obj_hooldthings_shoes" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "bag",           1, 0, { { "obj_hooldthings_bag" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "umbrella",      1, 0, { { "obj_hooldthings_umbrella" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "drum",          1, 0, { { "obj_hooldthings_drum" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "toyfrog",       1, 0, { { "obj_hooldthings_toyfrog" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "leaf",          1, 0, { { "obj_hooldthings_leaf" } } );
    interface.TaskPanelTaskAdd( ho_tasks, "pumpkin",       1, 0, { { "obj_hooldthings_pumpkin" } } );

  elseif ( ng_global.progress[ "std" ][ "win_hooldthings" ].stage[1] == 2 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "game",        1, 0, { { "obj_hooldthings_game_complete" } } );


  elseif ( ng_global.progress[ "std" ][ "win_hooldthings" ].stage[1] == 3 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "wrench",        1, 0, { { "obj_hooldthings_wrench_hint" } } );

    ObjSet( "spr_hooldthings_wrench", { input = 1 } );

  end;

  return ho_tasks;

end;
------------------------------------------------------------------------------
------------------------------------------------------------------------------
function public.stage_1()

  

end;
------------------------------------------------------------------------------
function public.stage_2()

  local func_after = function ()

    ObjSet( "obj_hooldthings_game", { input = 1 } );

  end;

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  ObjAnimate("obj_hooldthings_game", "alp", 0, 0, func_after, { 0, 0, 0,   0.5, 0, 1 });

end;
------------------------------------------------------------------------------
function public.stage_3()

  ObjSet( "obj_hooldthings_game", { input = 0 } );

  local func_after = function ()

    ObjSet( "spr_hooldthings_box_open", { input = 1 } );

  end;

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  ObjAnimate("spr_hooldthings_box_closed", "alp", 0, 0, "", { 0, 0, 1,    0.5, 0, 0 });
  ObjAnimate("spr_hooldthings_box_open", "alp", 0, 0, func_after, { 0, 0, 0,    0.5, 0, 1 });

end;
------------------------------------------------------------------------------
--*********************************************************************************************************************
-- function *** GAME *** () end;
--*********************************************************************************************************************
------------------------------------------------------------------------------
function public.PicMDown( num )

  cmn.PlayAudio("snd", "assets/levels/level1/ho_hooldthings/audio/aud_takepuzzlepart");

end;
------------------------------------------------------------------------------
function public.StartDrag( num )

  ObjAttach("spr_hooldthings_picture_"..num,  "obj_hooldthings_game_fly");

end;
------------------------------------------------------------------------------
function public.DropPic( num )

  cmn.PlayAudio("snd", "assets/levels/level1/ho_hooldthings/audio/aud_putpuzzlepart");

  ObjAttach("spr_hooldthings_picture_"..num,  "obj_hooldthings_game");

  local px = GetGameCursorPos()[1];
  local py = GetGameCursorPos()[2];

--  local old_x = ObjGet("spr_hooldthings_picture_"..num).pos_x;
--  local old_y = ObjGet("spr_hooldthings_picture_"..num).pos_y;
--
--  if (math.abs(old_x - px) <= 10) and (math.abs(old_y - py) <= 10) then
--
--    private.RotatePic( num );
--
--  else

  if (private.CheckHit(px, py, num)) then

    ng_global.progress[ "std" ][ "win_hooldthings" ].state[2][num] = 1;
    ObjSet("spr_hooldthings_picture_"..num,  { pos_x = private.pic_pos[2][num][1],  pos_y = private.pic_pos[2][num][2] });

    if (ng_global.progress[ "std" ][ "win_hooldthings" ].state[3][num] == 0) then
      ObjSet("spr_hooldthings_picture_"..num,  { input = 0 });
    end;

    private.CheckWin();

  end;

end;
------------------------------------------------------------------------------
function public.RotatePic( num )

  cmn.Lock(1, { interface = 1, closezz = 1, block = 1 });    

  local new_ang = ng_global.progress[ "std" ][ "win_hooldthings" ].state[3][num] + 1;
  local old_ang = ng_global.progress[ "std" ][ "win_hooldthings" ].state[3][num];

  if (new_ang == 8) then
    ng_global.progress[ "std" ][ "win_hooldthings" ].state[3][num] = 0;
  else 
    ng_global.progress[ "std" ][ "win_hooldthings" ].state[3][num] = new_ang;
  end;

  if (ng_global.progress[ "std" ][ "win_hooldthings" ].state[2][num] == 1) and (ng_global.progress[ "std" ][ "win_hooldthings" ].state[3][num] == 0) then
    ObjSet("spr_hooldthings_picture_"..num,  { input = 0 });
  end;

  local k_ang = 0.785;

  ObjAnimate("spr_hooldthings_picture_"..num, "ang", 0, 0, function () cmn.Lock( 0 ); private.CheckWin() end, { 0, 0, -k_ang*old_ang,   0.3, 0, -k_ang*new_ang });

end;
------------------------------------------------------------------------------
function private.CheckHit( px, py, num )

  local centr = {0, 0}; 
  local accuracy = 40;

  centr[1] = private.pic_pos[2][num][1];
  centr[2] = private.pic_pos[2][num][2];

  if ( (px - centr[1])^2 + (py - centr[2])^2 ) <= accuracy^2 then 

    return true;

  else

    return false;

  end; 

end;
------------------------------------------------------------------------------
function private.CheckWin()

  local func_after = function ()

    cmn.HoTaskFind("obj_hooldthings_game_complete", "game");
    ObjDelete("obj_hooldthings_puzzle_parts_2");
    ObjAnimate("obj_hooldthings_game", "alp", 0, 0, func_after, { 0, 0, 1,  0.5, 0, 0 });

  end;

  local win_flag = true;

  local ho_game = ng_global.progress[ "std" ][ "win_hooldthings" ].state[2];
  local game_ang = ng_global.progress[ "std" ][ "win_hooldthings" ].state[3];

  for i = 1, #ho_game, 1 do

    if (ho_game[i] == 0) or (game_ang[i] ~= 0) then

      win_flag = false;
      break;

    end;

  end;

  if win_flag then

    ObjAnimate("obj_hooldthings_game", "alp", 0, 0, func_after, { 0, 0, 1,   0.5, 0, 1 });

  end;

end;
--*********************************************************************************************************************
