--*********************************************************************************************************************
function public.Init()
  --------------------------------------------------------------------------------------------------
  room.Define( "ho_hogift" );
  game.relations[ "ho_hogift" ].exitroom = "rm_carolsroom";
  game.hogift = {};
  --------------------------------------------------------------------------------------------------
  game.hint[ "win_hogift" ] = 
  {
    type = "win",
    room = "rm_carolsroom",
    zz = "ho_hogift",
    zz_gate = "gho_carolsroom_hogift"
  };
  local win_hogift_func = function ()

    if ( cmn.IsEventDone( "win_hogift" ) ) then
      common_impl.InventoryComplexItemAdd( "inv_boxstaple", "spr_hogift_win" );
      ObjSet("inv_boxstaple_star_light",  { alp = 1 });

      ObjDelete("gho_carolsroom_hogift");
      ObjDelete("spr_carolsroom_table_ho_objects");
    end;

  end;
  cmn.AddSubscriber( "win_hogift", win_hogift_func );
  --------------------------------------------------------------------------------------------------
  local start_hogift_func = function ()

    if ( cmn.IsEventStart( "win_hogift" ) ) then

      common_impl.ProcessHoStart( "hogift" );
      local ho_found = ng_global.progress[ "std" ][ "win_hogift" ].found;

      for i = 1, #ho_found, 1 do
        ObjDelete( ho_found[ i ][ "object" ] );
        ObjDelete( ho_found[ i ][ "object" ].."_sh" );
      end;

    end;

  end;
  cmn.AddSubscriber( "win_hogift", start_hogift_func, "ho_hogift" );

end;  
--*********************************************************************************************************************
function public.Load()

end;
--*********************************************************************************************************************
function public.PreOpen()

  cmn.StartTimePassing("ho_hogift");

  cmn.StopAllEnv("assets/levels/common/audio/aud_carolsroom_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_carolsroom_env");
  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_ho_1lvl_mus", 1);

  if not cmn.IsEventStart( "win_hogift" ) then
    cmn.InitHo( "hogift" );
  end;

  local ho_items = {};

  interface_impl.ItemPanelItemAdd( ho_items, "arrow", 0, "spr_hogift_arrow" );
  interface_impl.ItemPanelItemAdd( ho_items, "bird", 0, "spr_hogift_bird" );
  interface_impl.ItemPanelItemAdd( ho_items, "butterfly", 0, "spr_hogift_butterfly" );
  interface_impl.ItemPanelItemAdd( ho_items, "candle", 0, "spr_hogift_candle" );
  interface_impl.ItemPanelItemAdd( ho_items, "cherry", 0, "spr_hogift_cherry" );
  interface_impl.ItemPanelItemAdd( ho_items, "comb", 0, "spr_hogift_comb" );
  interface_impl.ItemPanelItemAdd( ho_items, "cupcake", 0, "spr_hogift_cupcake" );
  interface_impl.ItemPanelItemAdd( ho_items, "lipstick", 0, "spr_hogift_lipstick" );
  interface_impl.ItemPanelItemAdd( ho_items, "necklace", 0, "spr_hogift_necklace" );
  interface_impl.ItemPanelItemAdd( ho_items, "gift", 0, "spr_hogift_gift" );
  interface_impl.ItemPanelItemAdd( ho_items, "ring", 0, "spr_hogift_ring" );
  interface_impl.ItemPanelItemAdd( ho_items, "sun", 0, "spr_hogift_sun" );

  if (not cmn.IsEventDone("win_hogift")) then
    interface_impl.ItemPanelShow( ho_items );
  else
    common_impl.DialogHo_Show();
  end;

end;
--*********************************************************************************************************************
function public.Open()

  if not(cmn.IsEventDone("opn_hogift")) then

    cmn.SetEventDone("opn_hogift");

    local arrows = { { pos_x = 0, pos_y = 120, ang = 3.14 } };
    cmn.TutorialShow( "tutor_6", 0, 512, 450, arrows );

  end;

end;
--*********************************************************************************************************************
function public.PreClose()

  if (not cmn.IsEventDone("win_hogift")) then
    interface_impl.ItemPanelHide();
  end;

  cmn.StopAllMus();

  if ( cmn.IsEventDone( "win_hogift" ) ) then

    common_impl.PauseAchiev(0);

    if ng_global.progress[prg.current][ "win_hogift" ].is_hint ~= 1 then

      if ng_global.state_ho[1] == 0 then
        common_impl.CheckAchiev( "ho" );
        ng_global.state_ho[1] = 1;
      end;

    end;

  end;

end;
--*********************************************************************************************************************
function public.Close()


end;
--*********************************************************************************************************************
function public.HoComplete()

  common_impl.PauseAchiev(1);

  if ng_global.state_ho[1] == 0 then
    cmn.EndTimePassing("ho_hogift");
  end;

end;
--*********************************************************************************************************************
--function public.ItemFound( item_name )
--
--  local item_object_name = "obj_"..cmn.GetObjectName( item_name );
--
--  ObjDelete( item_object_name );
--
--  interface.ItemPanelTryToComplete();
--
--end;
--*********************************************************************************************************************
