--*********************************************************************************************************************
function public.Init()
  --------------------------------------------------------------------------------------------------
  room.Define( "ho_hodetectivedesk" );
  game.relations[ "ho_hodetectivedesk" ].exitroom = "rm_policestation";
  game.hodetectivedesk = {};

  public.ho_hint_progress_names = { "clk_starthodetectivedesk" };

  public.change_stage_anim_type = "alp";

  private.audio = { "policeman_1", "policeman_2", "alex_1", "alex_2", "chloe_1", "chloe_2", "chloe_3", "policeman_4", "alex_3", "alex_4", "alex_5", "alex_6" }
  --------------------------------------------------------------------------------------------------
  game.hint[ "win_hodetectivedesk" ] = 
  {
    type = "win",
    room = "rm_policestation",
    zz = "ho_hodetectivedesk",
    zz_gate = "gho_policestation_hodetectivedesk"
  };
  --------------------------------------------------------------------------------------------------
  local win_hodetectivedesk_func = function ()

    if ( cmn.IsEventDone( "win_hodetectivedesk" ) ) then
      interface.InventoryItemAdd( "inv_policebadge", "spr_hodetectivedesk_win" );
      ObjDelete("gho_policestation_hodetectivedesk");
      ObjDelete("spr_policestation_ho_start");
    end;

  end;
  cmn.AddSubscriber( "win_hodetectivedesk", win_hodetectivedesk_func );
  --------------------------------------------------------------------------------------------------
  local start_hodetectivedesk_func = function ()

    if ( cmn.IsEventStart( "win_hodetectivedesk" ) ) then

      common_impl.ProcessHoStart( "hodetectivedesk" );
      local ho_found = ng_global.progress[ "std" ][ "win_hodetectivedesk" ].found;

      for i = 1, #ho_found, 1 do
        ObjDelete( ho_found[ i ][ "object" ] );

        if (ho_found[ i ][ "object" ].."_sh") then
          ObjDelete( ho_found[ i ][ "object" ].."_sh" );
        end;

      end;

    end;

  end;
  cmn.AddSubscriber( "win_hodetectivedesk", start_hodetectivedesk_func, "ho_hodetectivedesk" );  

  --------------------------------------------------------------------------------------------
  -- function clk_starthodetectivedesk () end;
  --------------------------------------------------------------------------------------------
  game.hint[ "clk_starthodetectivedesk" ] = {

      type = "click",
      use_place = "obj_hodetectivedesk_dictaphone_click",
      room = "ho_hodetectivedesk"

  };
  --------------------------------------------------------------------------------------------
  local clk_starthodetectivedesk = function ()

    ObjMultiSet( { {"obj_hodetectivedesk_dictaphone_click", { event_mup = public.RepeatVoice }},
                   {"spr_hodetectivedesk_dic_but_on", { alp = 1 }},
                   {"spr_hodetectivedesk_dic_but_off", { alp = 0 }},
                   {"anm_hodetectivedesk_dictophone", { playing = 1 }} } );

    ObjDelete("obj_hodetectivedesk_first_click");
  
  end;
  --------------------------------------------------------------------------------------------
  cmn.AddSubscriber( "clk_starthodetectivedesk", clk_starthodetectivedesk, "ho_hodetectivedesk" );

end;
--*********************************************************************************************************************
function public.Load()

  if not(ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage) then
    --DbgTrace("stages init");
    ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage = { 1, 12 };   --[1] - номер стадии, [2] - количество стадий
  end;

end;
--*********************************************************************************************************************
function public.PreOpen()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  cmn.StopAllEnv("assets/levels/common/audio/aud_policestation_env");
  cmn.PlayAudio("env", "assets/levels/common/audio/aud_policestation_env");
  cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_dark_choir_mus", 1);

  if not cmn.IsEventStart( "win_hodetectivedesk" ) then
    cmn.InitHo( "hodetectivedesk" );
  end;

  if cmn.IsEventDone("clk_starthodetectivedesk") then

    cmn.StartTimePassing("ho_hodetectivedesk");

    local ho_tasks = private.stages_task();

    if (not cmn.IsEventDone("win_hodetectivedesk")) and
       ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] <= ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[2] ) then

      interface_impl.TaskPanelShow( ho_tasks );

    else
      common_impl.DialogHo_Show();
    end;

  end;

end;
--*********************************************************************************************************************
function public.PreClose()

  local num = ng_global.progress[ prg.current ][ "win_hodetectivedesk" ].stage[1];
  local aud = private.audio[num];

  if aud then
    SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_"..aud.."_voc", 0.5);
  end;

  if (num == 5) then
    SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_3_voc", 0.5);
  end;

  if cmn.IsEventDone("clk_starthodetectivedesk") and not(cmn.IsEventDone("win_hodetectivedesk")) then
    interface_impl.TaskPanelHide();
  end;

  cmn.StopAllMus();

  ObjSet("int_inventory",  { input = 1 });

  if ( cmn.IsEventDone( "win_hodetectivedesk" ) ) then

    common_impl.PauseAchiev(0);

    if ng_global.progress[prg.current][ "win_hogift" ].is_hint ~= 1 then

      if ng_global.state_ho[2] == 0 then
        common_impl.CheckAchiev( "ho" );
        ng_global.state_ho[2] = 1;
      end;

    end;

  end;

end;
--*********************************************************************************************************************
function public.Close()

  if ( cmn.IsEventDone( "win_hodetectivedesk" ) ) then

    cmn.ShowBbt( "after_hodesk" );
    cmn.PlayAudio("mus", "assets/levels/common/audio/aud_surface7_empty_mus");

  end;

end;
--*********************************************************************************************************************
function public.HoComplete()

  cmn.ShowBbt( "hodetectivedesk_voice_end" );
  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_6_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_5_voc");

  common_impl.PauseAchiev(1);

  if ng_global.state_ho[2] == 0 then
    cmn.EndTimePassing("ho_hodetectivedesk");
  end;

end;
--*********************************************************************************************************************
function public.ItemFound( item_name, task_name )

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 0 });

  if ( item_name.."_sh" ) then
    ObjDelete( item_name.."_sh" );
  end;  

  cmn.HoTaskFind(item_name, task_name);

end;
--*********************************************************************************************************************
function public.RepeatVoice()

  cmn.PlayAudio("snd", "assets/levels/level1/ho_hodetectivedesk/audio/aud_pressplay");

  local num = ng_global.progress[ prg.current ][ "win_hodetectivedesk" ].stage[1];
  local aud = private.audio[num];

  if aud then
    SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_"..aud.."_voc", 0.5);
  end;

  if (num == 5) then

    SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_3_voc", 0.5);
    cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_3_voc");

    local func_after = function ()

      cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_1_voc");

    end;

    ObjSet("tmr_hodetectivedesk_timer", { playing = 1, time = 2.5, endtrig = func_after });

  else 
    cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_"..aud.."_voc");
  end;

  ObjAnimate("spr_hodetectivedesk_dic_but_on", "alp", 0, 0, "", { 0, 0, 1,   0.15, 0, 0,  0.3, 0, 1 });
  ObjAnimate("spr_hodetectivedesk_dic_but_off", "alp", 0, 0, "", { 0, 0, 0,   0.15, 0, 1,  0.3, 0, 0 });

end;
------------------------------------------------------------------------------
function public.StartHo()

  cmn.PlayAudio("snd", "assets/levels/level1/ho_hodetectivedesk/audio/aud_pressplay");

  cmn.SetEventDone("clk_starthodetectivedesk");
  cmn.CallEventHandler("clk_starthodetectivedesk");

  cmn.StartTimePassing("ho_hodetectivedesk");

  local ho_tasks = private.stages_task();

  if (not cmn.IsEventDone("win_hodetectivedesk")) and
     ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] <= ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[2] ) then

    interface_impl.TaskPanelShow( ho_tasks );

  else
    common_impl.DialogHo_Show();
  end;

  ObjAnimate("spr_hodetectivedesk_dic_but_off", "alp", 0, 0, "", { 0, 0, 1,   0.3, 0, 0 });
  ObjAnimate("spr_hodetectivedesk_dic_but_on", "alp", 0, 0, "", { 0, 0, 0,   0.3, 0, 1 });

end;
--*********************************************************************************************************************
--*********************************************************************************************************************
-- function *** STAGES *** () end;
--*********************************************************************************************************************
------------------------------------------------------------------------------
function private.stages_task()

  local ho_tasks = {};

  if ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 1 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "orphanage",        1, 0, { { "spr_hodetectivedesk_orphanage" } } );

    ObjSet( "spr_hodetectivedesk_orphanage", { input = 1 } );

    if not (cmn.IsEventDone("opn_hodetectivedesk")) then
      ObjSet("tmr_hodetectivedesk_timer", { playing = 1, time = 0.5, endtrig = public.stage_1() });
      cmn.SetEventDone("opn_hodetectivedesk");
    end;

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 2 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "pen",        1, 0, { { "spr_hodetectivedesk_pen" } } );

    ObjSet( "spr_hodetectivedesk_pen", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 3 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "plate",        1, 0, { { "spr_hodetectivedesk_plate" } } );

    ObjSet( "spr_hodetectivedesk_plate", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 4 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "voice",        1, 0, { { "spr_hodetectivedesk_voice" } } );

    ObjSet( "spr_hodetectivedesk_voice", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 5 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "glasses",        1, 0, { { "spr_hodetectivedesk_glasses" } } );

    ObjSet( "spr_hodetectivedesk_glasses", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 6 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "demon",        1, 0, { { "spr_hodetectivedesk_demon" } } );

    ObjSet( "spr_hodetectivedesk_demon", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 7 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "badge",        1, 0, { { "spr_hodetectivedesk_badge" } } );

    ObjSet( "spr_hodetectivedesk_badge", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 8 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "water",        1, 0, { { "spr_hodetectivedesk_water" } } );

    ObjSet( "spr_hodetectivedesk_water", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 9 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "one",        1, 0, { { "spr_hodetectivedesk_one" } } );

    ObjSet( "spr_hodetectivedesk_one", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 10 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "parrot",        1, 0, { { "spr_hodetectivedesk_parrot" } } );

    ObjSet( "spr_hodetectivedesk_parrot", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 11 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "book",        1, 0, { { "spr_hodetectivedesk_book" } } );

    ObjSet( "spr_hodetectivedesk_book", { input = 1 } );

  elseif ( ng_global.progress[ "std" ][ "win_hodetectivedesk" ].stage[1] == 12 ) then

    interface.TaskPanelTaskAdd( ho_tasks, "lock",        1, 0, { { "spr_hodetectivedesk_lock" } } );

    ObjSet( "spr_hodetectivedesk_lock", { input = 1 } );

  end;

  return ho_tasks;

end;
------------------------------------------------------------------------------
------------------------------------------------------------------------------
function public.stage_1()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_1_voc");

end;
------------------------------------------------------------------------------
function public.stage_2()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_1_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_2_voc");

end;
------------------------------------------------------------------------------
function public.stage_3()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_2_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_1_voc");

end;
------------------------------------------------------------------------------
function public.stage_4()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_1_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_2_voc");

end;
------------------------------------------------------------------------------
function public.stage_5()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  local func_after = function ()

    cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_1_voc");

  end;

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_2_voc", 0.5);

  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_3_voc");
  ObjSet("tmr_hodetectivedesk_timer", { playing = 1, time = 2.5, endtrig = func_after });

end;
------------------------------------------------------------------------------
function public.stage_6()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  ObjSet("tmr_hodetectivedesk_timer", { playing = 0 });

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_3_voc", 0.5);
  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_1_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_2_voc");

end;
------------------------------------------------------------------------------
function public.stage_7()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_2_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_3_voc");

end;
------------------------------------------------------------------------------
function public.stage_8()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_chloe_3_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_4_voc");

end;
------------------------------------------------------------------------------
function public.stage_9()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_policeman_4_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_3_voc");

end;
------------------------------------------------------------------------------
function public.stage_10()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_3_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_4_voc");

end;
------------------------------------------------------------------------------
function public.stage_11()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_4_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_5_voc");

end;
------------------------------------------------------------------------------
function public.stage_12()

  ObjSet("obj_hodetectivedesk_dictaphone_click",  { input = 1 });

  local ho_tasks = private.stages_task();

  interface_impl.TaskPanelSetNewTask( ho_tasks );

  SndStop("assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_5_voc", 0.5);
  cmn.PlayAudio("voc", "assets/levels/level1/ho_hodetectivedesk/audio/aud_alex_6_voc");

end;
------------------------------------------------------------------------------
