--********************************************************************************************************************
function public.Init()

  public.BLACK = "spr_subroom_black_screen";
  private.BLACK_ALP = 0.8;

  private.SHOW_TIME = 0.5;
  private.HIDE_TIME = 0.5;

end;
--********************************************************************************************************************
function public.Show( event_id, subroom_name, pos_beg, pos_end )

  local trg = function() subroom.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_TIME;

  local alpha_anm_table = {0,0,0, tme,1,1};
  local pos_xy_anm_table = {0,0,pos_beg.x,pos_beg.y, tme,1,pos_end.x,pos_end.y};
  local scale_xy_anm_table = {0,0,0,0, tme,1,1,1};

  ObjAnimate( subroom_name, "alp", 0, 0, trg, alpha_anm_table );
  ObjAnimate( subroom_name, "pos_xy", 0, 0, "", pos_xy_anm_table );
  ObjAnimate( subroom_name, "scale_xy", 0, 0, "", scale_xy_anm_table );
  ObjAnimate( public.BLACK, "alp", 0, 0, "", {0,0,0, tme,0,private.BLACK_ALP} );

  interface.ShowFrameSubroom( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table );

end;
--********************************************************************************************************************
function public.Hide( event_id, subroom_name, pos_beg, pos_end )

  local trg = function() subroom.EventAnimEnd( event_id ); end;
  local tme = private.HIDE_TIME;

  local alpha_anm_table = {0,0,1, tme,0,0};
  local pos_xy_anm_table = {0,0,pos_end.x,pos_end.y, tme,0,pos_beg.x,pos_beg.y};
  local scale_xy_anm_table = {0,0,1,1, tme,0,0,0};

  ObjAnimate( subroom_name, "alp", 0, 0, trg, alpha_anm_table );
  ObjAnimate( subroom_name, "pos_xy", 0, 0, "", pos_xy_anm_table );
  ObjAnimate( subroom_name, "scale_xy", 0, 0, "", scale_xy_anm_table );
  ObjAnimate( public.BLACK, "alp", 0, 0, "", {0,0,private.BLACK_ALP, tme,0,0} );

  interface.HideFrameSubroom( alpha_anm_table, pos_xy_anm_table, scale_xy_anm_table );

end;
--********************************************************************************************************************
