
function public.Init ()

  private.InitGlobalConstant();

  --int.AchievAdd                = public.AchievAdd;
  --int.ShowAchiev               = public.ShowAchiev;
  --int.PopupAchievementAdd      = public.PopupAchievementAdd;
  --int.PopupAchievementShow     = public.PopupAchievementShow;
  --int.PopupAchievementHide     = public.PopupAchievementHide;

end;
--*********************************************************************************************************************
function private.InitGlobalConstant()

  InterfaceWidget_DialogHint = "InterfaceWidget_DialogHint";

--commands

  Command_DialogHint_Show = "Command_DialogHint_Show";
  Command_DialogHint_Hide = "Command_DialogHint_Hide";
  
end;
--*********************************************************************************************************************
--***function *** DialogHint *** () end*********************************************************************************
--*********************************************************************************************************************
  function public.DialogHintAdd( pos_z )

    interface.CustomWidgetAdd( InterfaceWidget_DialogHint, "assets/interface/int_dialog_hint", "int_dialog_hint", pos_z );

  end;
  -------------------------------------------------------------------------------------
  -------------------------------------------------------------------------------------
  function public.DialogHintShow( dlg_room )

    MsgSend( Command_DialogHint_Show, { room = dlg_room } );

  end;
  -------------------------------------------------------------------------------------
  -------------------------------------------------------------------------------------
  function public.DialogHintHide()

    MsgSend(Command_DialogHint_Hide);

  end;
--*********************************************************************************************************************
--***function *** TaskPanel *** () end*********************************************************************************
--*********************************************************************************************************************
  function public.TaskPanelSetNewTask( ho_tasks )

    --int.WidgetSetInput( InterfaceWidget_Inventory, 0 );

    --if (ho_tasks) then
    --  DbgTrace("ho_tasks exist");
    --end;

    --cmn.Lock( 1, { interface = 1, block = 1 } ); 

    public.taskpanel_countdown = 0;

    local ho_name = cmn.GetObjectName( GetCurrentRoom() );

    for i = 1, #ho_tasks, 1 do

      local task_name = ho_tasks[ i ][ "name" ];

      ho_tasks[ i ][ "name" ] = interface.TaskPanelGetTaskId( ho_name, task_name );

      public.taskpanel_countdown = public.taskpanel_countdown + ho_tasks[ i ][ "count" ];

    end;

    --if (ho_tasks) then
    --  DbgTrace("ho_tasks exist");
    --else 
    --  DbgTrace("ho_tasks does not exist");
    --end;

    int_taskpanel.Show( ho_tasks, true, true);

  end;
--*********************************************************************************************************************
  public.taskpanel_countdown = 0;
  -------------------------------------------------------------------------------------
  function public.TaskPanelShow( ho_tasks )
  
    public.taskpanel_countdown = 0;
  
    interface.WidgetSetInput( InterfaceWidget_Inventory, false );
    MsgSend( Command_Level_SetZoom, { zoom = true } );
    
    if ( not _G[ "int_taskheader" ] ) then
      interface.WidgetSetVisible( InterfaceWidget_Inventory, false, true );
    end;
  
    local ho_name = interface.GetObjectName( GetCurrentRoom() );
    local ho_progress = ng_global.progress[ ng_global.currentprogress ][ "win_"..ho_name ];
  
    for i = 1, #ho_tasks, 1 do

      ObjSet("txt_int_taskpanel_task_"..i,  { alp = 1, visible = 1 });
  
      local task_name = ho_tasks[ i ][ "name" ];
  
      if ( ho_progress.start == 1 ) then
  
        if ( ho_tasks[ i ][ "marked" ] == 1 ) then

          if ( ho_progress.unmark[ task_name ].done == 1 ) then
  
            ho_tasks[ i ][ "marked" ] = 0;
  
          end;
  
        end;
  
        for j = 1, #ho_progress.found, 1 do
  
          if ( task_name == ho_progress.found[ j ][ "task" ] ) then
  
            ho_tasks[ i ][ "count" ] = ho_tasks[ i ][ "count" ] - 1;
  
          end;
  
        end;
  
      end;
  
      ho_tasks[ i ][ "name" ] = interface.TaskPanelGetTaskId( ho_name, task_name );
  
      public.taskpanel_countdown = public.taskpanel_countdown + ho_tasks[ i ][ "count" ];
      ho_progress.start = 1;

    end;
  
    if ( not _G[ "int_taskheader" ] ) then
  
      if _G[ "int_taskpanel" ] then int_taskpanel.Show( ho_tasks ); end;
  
    else
      
      if _G[ "int_taskheader" ] then int_taskheader.Show(); end;
      if _G[ "int_inventory"  ] then int_inventory.ShowForTaskHeader(); end;
      if _G[ "int_taskpanel"  ] then int_taskpanel.ShowForTaskHeader( ho_tasks ); end;
  
    end;

  end;
  -------------------------------------------------------------------------------------
  function public.TaskPanelTaskComplete( ho_name, task_name, object_name )

    --DbgTrace( "HO < "..ho_name.." > task complete: "..task_name );
    --DbgTrace(""..public.taskpanel_countdown);
      
    public.taskpanel_countdown = public.taskpanel_countdown - 1;

    --DbgTrace(""..public.taskpanel_countdown);
  
    if ( public.taskpanel_countdown == 0 ) then
  
      local ho_name = interface.GetObjectName( GetCurrentRoom() );
      local ho_stage = ng_global.progress[ prg.current ][ "win_"..ho_name ].stage;

      if ( ho_stage ) and ( ho_stage[1] <= ho_stage[2] ) then

        ho_stage[1] = ho_stage[1] + 1;

        if ( ho_stage[1] > ho_stage[2] ) then

          _G[ "ho_"..ho_name ].HoComplete();

        end;

      else
      
        ng_global.progress[ ng_global.currentprogress ][ "win_"..ho_name ].done = 1;
        ng_global.progress[ ng_global.currentprogress ].common.currentroom = game.relations[ "ho_"..ho_name ].exitroom;
    
        _G[ "ho_"..ho_name ].HoComplete();

      end;
  
    end;
  
    local task_id = interface.TaskPanelGetTaskId( ho_name, task_name );
  
    if _G[ "int_taskpanel" ] then
      int_taskpanel.CompleteTask( task_id, object_name );
    end;

  end;
  --*********************************************************************************************************************
  function public.TaskPanelHide()

    interface.TaskPanelHide();

    int_inventory.HideForTaskHeader();

  end;
--*********************************************************************************************************************
--***function *** ItemPanel *** () end*********************************************************************************
--*********************************************************************************************************************
  function public.ItemPanelItemRemove( item_name, countdown )

    --DbgTrace( "***int.ItemPanelItemRemove: item_name = "..item_name..", countdown = "..countdown );

    int_itempanel.DeleteObject( item_name );

    if ( countdown >= 7 ) then --ставим инпут для итема который показался на панели

      local new_item_num = 7 + #int_itempanel.ho_items - countdown;

      --DbgTrace( "*появился "..int.itempanel.ho_items[ new_item_num ].name..", marked = "..int.itempanel.ho_items[ new_item_num ].marked..", hint = "..int.itempanel.ho_items[ new_item_num ].hint );

      if ( int_itempanel.ho_items[ new_item_num ].marked == 0 ) then

        ObjSet( int_itempanel.ho_items[ new_item_num ].hint, { input = 1 } );

      end;

    end;


    local room_prefix = common.GetObjectPrefix( GetCurrentRoom() );

    if ( room_prefix == "ho" ) then --потомучто можем выйти в другую комнату пока летит предмет

      interface.ItemPanelTryToComplete();

    end;

  end;
  --*********************************************************************************************************************
  function public.ItemPanelItemAdd( ho_items, item_name, item_marked, ho_hint )

    --DbgTrace("***ItemPanelItemAdd: item_name = "..item_name..", item_marked = "..item_marked..", ho_hint = "..ho_hint);

    local ho_name = common.GetObjectName( GetCurrentRoom() );
    local ho_progress = ng_global.progress[ ng_global.currentprogress ][ "win_"..ho_name ];

    local item_object_name = "itm_"..ho_name.."_"..item_name;

    local item_found = false;

    for i = 1, #ho_progress.found, 1 do

      if ( ho_progress.found[ i ][ "item" ] == item_object_name ) then

        item_found = true;
        break;

      end;

    end;

    if ( not item_found ) then

      if ( item_marked == 1 ) then

        if ( ho_progress.unmark[ item_name ].done == 1 ) then

          item_marked = 0;

          --DbgTrace("***item_name = "..item_name..", item_marked = "..item_marked);

        end;

      end;

      local item_table = { name = item_object_name, marked = item_marked, hint = ho_hint };--, count = 1

      table.insert( ho_items, item_table );

      if ( #ho_items > 7 ) or ( item_marked == 1 ) then   --убираем инпут у предметов, которые невидны на панели или требуют доп действий
        ObjSet( ho_hint, { input = 0 } );
      else
        ObjSet( ho_hint, { input = 1 } );
      end;

    end;

  end;
  --*********************************************************************************************************************
  function public.ItemPanelHoHintShow()

    if ( int_itempanel.already_hide == false ) then

      local item_found = false;

      for i = 1, #int_itempanel.ho_items, 1 do

        if ( ObjGet( int_itempanel.ho_items[i].hint ).input ) then

          item_found = true;
          break;

        end;

      end;

      if ( item_found ) then

        int_itempanel.ShowHoHint();

      else

        common_impl.HoHint_NoObjects();

      end;

    end;

  end;
  --*********************************************************************************************************************
  function public.ItemPanelShow( ho_items )

    interface.ItemPanelShow( ho_items );

    int_inventory.ShowForTaskHeader();
    
  end;
  --*********************************************************************************************************************
  function public.ItemPanelHide()

    interface.ItemPanelHide();

    int_inventory.HideForTaskHeader();

  end;
--*********************************************************************************************************************
--*********************************************************************************************************************
--***function *** Achievements *** () end**********************************************************************************
--*********************************************************************************************************************
  -------------------------------------------------------------------------------------
  function public.AchievAdd()

    --InterfaceWidget_Achiev = int.CustomWidgetNew();
    interface.CustomWidgetAdd( InterfaceWidget_Achiev, "assets/interface/int_achiev", "int_achiev", 250 );

    --Command_Achiev_Show = int.CustomWidgetMessageNew();
    --int.CustomWidgetMessageAdd( InterfaceWidget_Achiev, Command_Achiev_Show );

    --Command_Achiev_Hide = int.CustomWidgetMessageNew();
    --int.CustomWidgetMessageAdd( InterfaceWidget_Achiev, Command_Achiev_Hide );

    int_achiev.CheckScreen();

  end;
  ------------------------------------------------------------------------------------
  ------------------------------------------------------------------------------------
  function public.ShowAchiev(name)

    --SendMessage( Command_Achiev_Show, { ach_name = name } );  

    --local command_params = ne_params.table;
    --local achiev_name = command_params["ach_name"];

    local achiev_name = name;

    if ( string.sub( achiev_name, 1, 7 ) == "ce_col_" ) then

      int_achiev.stack_name[#int_achiev.stack_name + 1] = achiev_name;
      int_achiev.SetAchiev( achiev_name );

    else

      local achiev_state = ng_global.achiev[achiev_name][1];
      local achiev_complete = ng_global.achiev[achiev_name][3];

      if achiev_state == achiev_complete then 

        int_achiev.stack_name[#int_achiev.stack_name + 1] = achiev_name;
        int_achiev.SetAchiev( achiev_name );
        cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_small_window" );

      end;

    end;

    if not(cmn.IsEventDone("tutor_11")) then

      int_achiev.AchMouseEnter( 1 );

      if ( GetWideScreen() ) then

        ObjMultiSet( { {"obj_tutorial_tutor_11", { pos_x = -512 }},
                       {"obj_tutorial_tutor_11_1", { pos_x = -80 }} } );

        local arrows = { { pos_x = -320, pos_y = 0, ang = 1.57 } };

        cmn.TutorialShow( "tutor_11", 0, 512, 159, arrows );

      else 

        ObjMultiSet( { {"obj_tutorial_tutor_11", { pos_x = -700 }},
                       {"obj_tutorial_tutor_11_1", { pos_x = 69 }} } );

        local arrows = { { pos_x = -320, pos_y = 0, ang = 1.57 } };

        cmn.TutorialShow( "tutor_11", 0, 700, 159, arrows );

      end;

    end;

  end;
  ------------------------------------------------------------------------------------
  function public.HideAchiev()

    local event_id = "show";
    local panel_id = int_achiev.close_id;--int_achiev.stack_panel[ int_achiev.state_anim_end + 1 ];

    int_achiev.state_anim_end = int_achiev.close_id;--int_achiev.state_anim_end + 1;

    int_achiev.HideAnim( event_id, panel_id );

  end;
  -------------------------------------------------------------------------------------
  -------------------------------------------------------------------------------------
  function public.PopupAchievementAdd()

    --InterfaceWidget_PopupAchievement = int.CustomWidgetNew();
    interface.CustomWidgetAdd( InterfaceWidget_PopupAchievement, "assets/interface/int_popup_achievements", "int_popup_achievements" );

    --Command_Popup_Achievements_Show = int.CustomWidgetMessageNew();
    --int.CustomWidgetMessageAdd( InterfaceWidget_PopupAchievement, Command_Popup_Achievements_Show );

    --Command_Popup_Achievements_Hide = int.CustomWidgetMessageNew();
    --int.CustomWidgetMessageAdd( InterfaceWidget_PopupAchievement, Command_Popup_Achievements_Hide );

  end;
  -------------------------------------------------------------------------------------
  -------------------------------------------------------------------------------------
  function public.PopupAchievementShow( table )

    --SendMessage( Command_Popup_Achievements_Show, { table = table } );

    int_popup_achievements.event_tmr_end = table;

    ObjSet( "tmr_int_popup_achievements_show",
    {
      endtrig = int_popup_achievements.Show,
      time    = int_popup_achievements.SHOW_TIME,
      playing = 1
    } );
  --[[
    local popup_achievements_text1 = table[ "text1" ];
    local popup_achievements_text2 = table[ "text2" ];

    ObjSet( "tmr_int_popup_achievements_show",
    {
      endtrig = int_popup_achievements.Show( &apos;"..popup_achievements_text1.."&apos;,&apos;"..popup_achievements_text2.."&apos; );",
      time    = int_popup_achievements.SHOW_TIME,
      playing = 1
    } );
  --]]

  end;
  -------------------------------------------------------------------------------------
  -------------------------------------------------------------------------------------
  function public.PopupAchievementHide()

    --SendMessage( Command_Popup_Achievements_Hide, {} );

    ObjSet( "tmr_int_popup_achievements_show", { playing = 0 } );

    if ( not int_popup_achievements.ishideanim ) then

      int_popup_achievements.ishideanim = true;

      local event_id = "hide";
      int_popup_achievements.event_anim_end[ event_id ] = {};
      int_popup_achievements.HideAnim( event_id );

    end;

  end;
  -------------------------------------------------------------------------------------
--*********************************************************************************************************************
--*********************************************************************************************************************
--***function *** Bonus *** () end**********************************************************************************
--*********************************************************************************************************************
  -------------------------------------------------------------------------------------
  function public.BonusAdd()

    --InterfaceWidget_Bonus = interface.CustomWidgetNew();

    interface.CustomWidgetAdd( InterfaceWidget_Bonus, "assets/interface/int_bonus", "int_bonus" );

    int_bonus.CheckScreen();

  end;
  --------------------------------------------------------------------
  function public.GetBonus( num, count )

    cmn.PlayAudio("snd", "assets/levels/common/audio/aud_achive_flower"); 

    local bonus_obj = "spr_bonus_"..num;
    local index = num;

    public.AnimBonusObj(bonus_obj);

    if ng_global.show_bonus == 0 then

      public.SetBonus();

      int_bonus.ShowAnim( "hide" );

      ng_global.show_bonus = 1;
      int_bonus.iter = 0;
      int_bonus.state = 0;
      int_bonus.fly = 0;
      ng_global.bonus_count_current = ng_global.bonus_count_counter;

      ng_global.bonus_count_counter = ng_global.bonus_count + count;

    else 

      int_bonus.WaitAnim( "increase" );
      if int_bonus.state == 0 and int_bonus.fly < 1 then
        ng_global.bonus_count_counter = ng_global.bonus_count + count;
      end;

    end;

    ng_global.bonus[index] = 1;
    ng_global.bonus_count = ng_global.bonus_count + count;
    ng_global.bonus_count_total = ng_global.bonus_count_total + count;

    DbgTrace("***bonus_count_total = "..ng_global.bonus_count_total);

    if ( ng_global.bonus_count_total > 0 ) and ( ng_global.achiev["collect_1_flower"][1] == 0 ) then
      common_impl.CompleteAchiev("collect_1_flower");
    end;
    if ( ng_global.bonus_count_total > 4 ) and ( ng_global.achiev["collect_5_flowers"][1] == 0 ) then
      common_impl.CompleteAchiev("collect_5_flowers");
    end;
    if ( ng_global.bonus_count_total > 14 ) and ( ng_global.achiev["collect_15_flowers"][1] == 0 ) then
      common_impl.CompleteAchiev("collect_15_flowers");
    end;
    if ( ng_global.bonus_count_total > 29 ) and ( ng_global.achiev["collect_30_flowers"][1] == 0 ) then
      common_impl.CompleteAchiev("collect_30_flowers");
    end;
    if ( ng_global.bonus_count_total > 99 ) and ( ng_global.achiev["collect_100_flowers"][1] == 0 ) then
      common_impl.CompleteAchiev("collect_100_flowers");
    end;
    if ( ng_global.bonus_count_total > 149 ) and ( ng_global.achiev["collect_200_flowers"][1] == 0 ) then
      common_impl.CompleteAchiev("collect_200_flowers");
    end;


    --if ng_global.currentprogress == "std" then
    --  if ng_global.progress[ "std" ].common.chapter == "level1" and 
    --     ng_global.progress[ "std" ][ "tutor_bonus" ].done == 0 then
    --    ld.tutorial.TutorialShowBonus("tutor_bonus", 1, 512, 384, 300, 0, 1.57);
    --    ng_global.progress[ "std" ][ "tutor_bonus" ].done = 1;
    --  end;
    --end;

    --проверка количества цветов и вывод окна приглашения в bonus room
--    if ng_global.bonus_count_total >= 5 and not ng_global.show_dlg_open_bonusroom then
--   
--      ng_global.show_dlg_open_bonusroom = true;
--
--      cmn.DialogWindowShow( "common", "dlg_open_bonusroom", false );
--
--    end;

  end;
  -------------------------------------------------------------------------------------
  function public.SetBonus()

    local hundred = math.modf(ng_global.bonus_count / 100);
    local ten = math.modf((ng_global.bonus_count - 100 * hundred) / 10);
    local edin = ng_global.bonus_count - 100 * hundred - 10 * ten;

    int_bonus.iter = 0;
    int_bonus.state = 0;

    ObjSet("spr_int_bonus_count_1", {pos_y = -hundred*50} );
    ObjSet("spr_int_bonus_count_1_1", {pos_y = -hundred*50-500} );
    ObjSet("spr_int_bonus_count_2", {pos_y = -ten*50} );
    ObjSet("spr_int_bonus_count_2_1", {pos_y = -ten*50-500} );
    ObjSet("spr_int_bonus_count_3", {pos_y = -edin*50} );
    ObjSet("spr_int_bonus_count_3_1", {pos_y = -edin*50-500} );

  end;
  ------------------------------------------------------------------------------------
  function public.AnimBonusObj(sender)

    local bonus_obj = sender;
    local pos = GetObjPosByObj(bonus_obj, "int_bonus");
    local offset = 176;

    int_bonus.fly = int_bonus.fly + 1;

    ObjSet(bonus_obj, {input=0});
    ObjCreate("fx_"..bonus_obj, "partsys_pm");
    ObjAttach("fx_"..bonus_obj, "int_bonus");
    ObjAttach(bonus_obj, "int_bonus");
    ObjSet(bonus_obj, {pos_x = pos[1], pos_y = pos[2]});
    ObjSet("fx_"..bonus_obj, {pos_x = pos[1], pos_y = pos[2], res="assets/interface/resources/fx/ho_get_obj"});
    ObjAnimate(bonus_obj, 3,0,0, function () public.AnimBonusObjEnd(bonus_obj); end, {0, 3, pos[1], pos[2],   2, 3, -offset, 0});
    ObjAnimate("fx_"..bonus_obj, 0,0,0, "", {0, 3, pos[1],   2, 3, -offset});
    ObjAnimate("fx_"..bonus_obj, 1,0,0, "", {0, 0, pos[2],   2, 0, 0});

    --cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_achive_open_window" );
    --cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_achive_flower" );

  end;
  ------------------------------------------------------------------------------------
  function public.AnimBonusObjEnd(bonus_obj)

    --cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_achive_number" );

    int_bonus.fly = int_bonus.fly - 1;
    ObjAnimate(bonus_obj, 6,0,0, function () ObjDelete(bonus_obj); end, {0,0,1,1, 0.3,0,0,0});
    ObjAnimate("fx_"..bonus_obj, "alp",0,0, function () ObjDelete("fx_"..bonus_obj); end, {0,0,1, 0.3,0,1, 0.6,0,0});

    int_bonus.CountTotal( "increase" );

  end;
  ------------------------------------------------------------------------------------
  function public.ShowBonus( )

    --cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_achive_open_window" );

    if ng_global.show_bonus == 0 then

      ng_global.bonus_count_counter = ng_global.bonus_count;
      public.SetBonus();

      int_bonus.ShowAnim( "hide" );

    end;

    ng_global.show_bonus = 1;

  end;
  ------------------------------------------------------------------------------------
  function public.HideBonus()

    --cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_achive_close_window" );

    int_bonus.HideAnim( "show" );

  end;
  ------------------------------------------------------------------------------------
  function public.SpendBonus(count)

    --cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_achive_number" );

    if ( ng_global.bonus_count - count ) >= 0 then
      ng_global.bonus_count = ng_global.bonus_count - count;
      ng_global.bonus_count_counter = ng_global.bonus_count;

      int_bonus.CountTotal( "decrease" );

    else
      -- not flowers
    end;

  end;
  ------------------------------------------------------------------------------------
  function public.RemoveFlowersTotal()

    if  IsCollectorsEdition() or IsSurveyEdition() then

      if (ng_global.bonus) then

        for i = 1, 150, 1 do 

          if ng_global.bonus[i] == 1 then
            ObjDelete("spr_bonus_"..i);
          end;

        end;

      end;

    else
      for i = 1, 150, 1 do 
        ObjDelete("spr_bonus_"..i);
      end;
    end;

  end;
  -------------------------------------------------------------------------------------
