--******************************************************************************************
function public.Init ()

  public.GRID_CORNER_W = 84;
  public.GRID_CORNER_H = 60;
  public.GRID_MID_W    =  4;
  public.GRID_MID_H    =  4;

  public.GRID_FIXED_W  = 500;
  public.GRID_BORDER_H =  20;
  public.GRID_MIN_H    = 100;

  private.SHOW_ANIM_TIME = 0.3;
  private.MOUSE_OVER_ANIM_TIME = 0.3;
  private.default_arrow = ObjGet( "spr_int_tutorial_arrow" );
  private.default_arrow.name = nil;

  ObjSet("obj_int_tutorial_buttons_left", {
    event_mdown = function () int_tutorial.MouseDown('yes'); end,
    event_menter = function () private.MouseEnterAnim( "obj_int_tutorial_buttons_left" ); end,
    event_mleave = function () private.MouseLeaveAnim( "obj_int_tutorial_buttons_left" ); end
  });
  ObjSet("obj_int_tutorial_buttons_right", {
    event_mdown = function () int_tutorial.MouseDown('no'); end,
    event_menter = function () private.MouseEnterAnim( "obj_int_tutorial_buttons_right" ); end,
    event_mleave = function () private.MouseLeaveAnim( "obj_int_tutorial_buttons_right" ); end
  });
  ObjSet("obj_int_tutorial_buttons_center", {
    event_mdown = function () int_tutorial.MouseDown('some'); end,
    event_menter = function () private.MouseEnterAnim( "obj_int_tutorial_buttons_center" ); end,
    event_mleave = function () private.MouseLeaveAnim( "obj_int_tutorial_buttons_center" ); end
  });
  ObjSet("obj_int_tutorial_transpanent", {
    event_mdown = function () int_tutorial.MouseDown('empty'); end
  });

end;
--******************************************************************************************
function private.TutorAnimEnd( event_id )

  int_tutorial.EventAnimEnd( event_id );

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () private.TutorAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_tutorial", "alp", 0, 0, trg,
  {
    0.0, 2, 0,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () private.TutorAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_tutorial", "alp", 0, 0, trg,
  {
    0.0, 2, 1,
    tme, 2, 0
  } );

end;
--******************************************************************************************
function public.ArrowHide( arrow_id )

  local arrow = string.format( "spr_int_tutorial_arrow_%i", arrow_id );
  local trg = function () ObjDelete( arrow ); end;
  local tme = private.SHOW_ANIM_TIME;
  ObjAnimate( arrow, "alp", 0, 0, trg,
  {
    0.0, 2, 1,
    tme, 2, 0
  } );

end;
--******************************************************************************************
function public.ArrowAnim( arrow )

  arrow = arrow or "spr_int_tutorial_arrow";

  local arrow_params = ObjGet( arrow );

  local beg_x = arrow_params.pos_x;
  local beg_y = arrow_params.pos_y;

  local ang = arrow_params.ang;

  local sin = math.sin( ang );
  local cos = math.cos( ang );

  local end_x = 0 * cos - 20 * sin;
  local end_y = 0 * sin + 20 * cos;

  ObjAnimate( arrow, "pos_xy", 1, 0, "",
  {
    0.0, 3, beg_x,         beg_y,
    0.7, 3, beg_x - end_x, beg_y + end_y,
    1.4, 3, beg_x,         beg_y
  } );

end;
--******************************************************************************************
function private.MouseEnterAnim( sender )

  SetCursor( CURSOR_HAND );
  local but_name = interface.GetObjectName( sender );
  but_name = "spr_"..but_name.."_focus";
  local but_alp = ObjGet( but_name ).alp;
  ObjAnimate( but_name, "alp", 0, 0, "", { 0, 0, but_alp, ( private.MOUSE_OVER_ANIM_TIME * ( 1 - but_alp ) ), 0, 1 } );

end;
--******************************************************************************************
function private.MouseLeaveAnim( sender )

  SetCursor( CURSOR_DEFAULT );
  local but_name = interface.GetObjectName( sender );
  but_name = "spr_"..but_name.."_focus";
  local but_alp = ObjGet( but_name ).alp;
  ObjAnimate( but_name, "alp", 0, 0, "", { 0, 0, but_alp, ( private.MOUSE_OVER_ANIM_TIME * but_alp ), 0, 0 } );

end;
--******************************************************************************************
function public.ArrowShow( arrow_id, arrow_params )

  local arrow = string.format( "spr_int_tutorial_arrow_%i", arrow_id );
  --local arrow = "spr_tutorial_arrow_"..arrow_id;

  ObjCreate( arrow, "spr" );
  
  ObjSet(arrow, {res = "assets/interface/resources/tutorial_arrow", pos_x = arrow_params["pos_x"], pos_y = arrow_params["pos_y"], ang = arrow_params["ang"]});

  ObjAttach(arrow, "int_tutorial_impl");

  --ObjSet( arrow, private.default_arrow );

--  if ( arrow_params.target ) then
--
--    ObjAttach( arrow, arrow_params.target );
--    table.remove( arrow_params, target );
--
--  else
--
--    ObjAttach( arrow, "int_tutorial" );
--
--  end;
--
--  ObjSet( arrow, arrow_params );

  public.ArrowAnim( arrow );

  ObjAnimate( arrow, "alp", 0, 0, "",
  {
    0.0, 3, 0,
    0.3, 3, 1
  } );

end
--******************************************************************************************