--******************************************************************************************
function public.Init ()

  public.DIRECTION = 0;

  private.TASK_COLOR_R = 0;
  private.TASK_COLOR_G = 1;
  private.TASK_COLOR_B = 0;

  private.TASK_MARKED_COLOR_R = 1;
  private.TASK_MARKED_COLOR_G = 0;
  private.TASK_MARKED_COLOR_B = 0;

  private.TASK_COMPLETED_COLOR_R = 0;
  private.TASK_COMPLETED_COLOR_G = 0.1;
  private.TASK_COMPLETED_COLOR_B = 0;

  private.MOVE_ANIM_TIME     = 0.6;
  private.MOVE_ANIM_POS_Y_TOP = 688;
  private.MOVE_ANIM_POS_Y_BOT = 888;

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  local tme = private.MOVE_ANIM_TIME;

  ObjAnimate( "int_taskpanel_impl", "pos_y", 0, 0, trg,
  {
    0.0, 2, private.MOVE_ANIM_POS_Y_BOT,
    tme, 2, private.MOVE_ANIM_POS_Y_TOP
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  local tme = private.MOVE_ANIM_TIME;

  ObjAnimate( "int_taskpanel_impl", "pos_y", 0, 0, trg,
  {
    0.0, 1, private.MOVE_ANIM_POS_Y_TOP,
    tme, 1, private.MOVE_ANIM_POS_Y_BOT
  } );

end;
--******************************************************************************************
function public.CompleteTaskAnim( object_name, task_id, tsk_count, event_id )

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  ObjAnimate( object_name, "scale_xy", 0, 0, trg,
  {
    0.0, 3, 1, 1,
    0.3, 3, 2, 2,
    0.9, 3, 0, 0
  } );
  
end;
--******************************************************************************************
function public.SetTask( task_id, task_params )

  local task_color_r = private.TASK_COLOR_R;
  local task_color_g = private.TASK_COLOR_G;
  local task_color_b = private.TASK_COLOR_B;

  if ( task_params.count < 1 ) then

    task_color_r = private.TASK_COMPLETED_COLOR_R;
    task_color_g = private.TASK_COMPLETED_COLOR_G;
    task_color_b = private.TASK_COMPLETED_COLOR_B;    

  end;

  if ( task_params.marked == 1 ) then

    task_color_r = private.TASK_MARKED_COLOR_R;
    task_color_g = private.TASK_MARKED_COLOR_G;
    task_color_b = private.TASK_MARKED_COLOR_B;

  end;

  local task_pattern = "str_int_taskpanel_pattern";

  if ( task_params.count > 1 ) then

    task_pattern = "str_int_taskpanel_pattern_multiple";

  end;

  ObjSet( "txt_int_taskpanel_task_"..task_id,
  {
    text   = task_pattern,
    param0 = task_color_r,
    param1 = task_color_g,
    param2 = task_color_b,
    param3 = StringGet( task_params.name ),
    param4 = task_params.count
  } );

end;
--******************************************************************************************
function public.UnmarkTaskAnim( task_id, event_id )

  local task_color_r = private.TASK_COLOR_R;
  local task_color_g = private.TASK_COLOR_G;
  local task_color_b = private.TASK_COLOR_B;

  ObjSet( "txt_int_taskpanel_task_"..task_id,
  {
    param0 = task_color_r,
    param1 = task_color_g,
    param2 = task_color_b,
  } );

end;
--******************************************************************************************
function public.MarkTaskAnim( task_id, event_id )

  --

end;
--******************************************************************************************
