--******************************************************************************************
function public.Init()

  public.DIRECTION = 0;

  private.TASK_COLOR_R = 1;
  private.TASK_COLOR_G = 1;
  private.TASK_COLOR_B = 1;

  private.TASK_MARKED_COLOR_R = 0.517647;
  private.TASK_MARKED_COLOR_G = 0.835294;
  private.TASK_MARKED_COLOR_B = 0.960784;

  private.TASK_COMPLETED_COLOR_R = 0.552941;
  private.TASK_COMPLETED_COLOR_G = 0.454902;
  private.TASK_COMPLETED_COLOR_B = 0.443137;

  private.MOVE_ANIM_TIME      = 0.6;
  private.MOVE_ANIM_POS_Y_TOP = 500;
  private.MOVE_ANIM_POS_Y_BOT = 1000;

  local pos_offset = 0;
  private.TASKHEADER_MOVE_ANIM_TIME_BEG  = int_taskheader_impl.MOVE_ANIM_TIME_BEG;
  private.TASKHEADER_MOVE_ANIM_TIME_END  = int_taskheader_impl.MOVE_ANIM_TIME_END;
  private.TASKHEADER_MOVE_ANIM_POS_Y_TOP = int_taskheader_impl.MOVE_ANIM_POS_Y_TOP + pos_offset;
  private.TASKHEADER_MOVE_ANIM_POS_Y_BOT = int_taskheader_impl.MOVE_ANIM_POS_Y_BOT + pos_offset;

  private.CHANGE_TASK_ALP_TIME = 0.3; --время анимации замены тасков по альфе во время перехода на следующую стадию хо

  public.HO_TASK_NEW = {};   --таблица новых тасков при замене

  private.ICONS_POS_Y = 18;                 --параметры иконок для хошек с парами
  private.MOVE_ICON_ANIM_POS_X_START = 320;
  private.MOVE_ICON_ANIM_POS_X_END = 210;
  private.ICON_LINE_SPR_REAL_WIDTH = 152;
  private.ICON_LINE_OFFSET = 10;

  ObjAttach( "obj_int_taskpanel_collect", InterfaceWidget_Top_Name );

  private.task_line_pos_x_offset = 81;
  private.task_line_pos_y_offset = 11;


end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local obj = "int_taskpanel_impl";

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  local tme = private.MOVE_ANIM_TIME;

  local beg_y = ObjGet( obj ).pos_y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0, 2, beg_y,--private.MOVE_ANIM_POS_Y_BOT,
    tme, 2, private.MOVE_ANIM_POS_Y_TOP
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local obj = "int_taskpanel_impl";

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  local tme = private.MOVE_ANIM_TIME;

  local beg_y = ObjGet( obj ).pos_y; 

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0, 1, beg_y,--private.MOVE_ANIM_POS_Y_TOP,
    tme, 1, private.MOVE_ANIM_POS_Y_BOT
  } );

end;
--******************************************************************************************
function public.TaskHeaderShowAnim( event_id )

  ObjStopAnimate( "obj_int_taskpanel_collect", "pos_y" );
  ObjSet( "obj_int_taskpanel_collect", { pos_y = 0 } );

  local obj = "int_taskpanel_impl";

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  local tme_beg = private.TASKHEADER_MOVE_ANIM_TIME_BEG;
  local tme_end = private.TASKHEADER_MOVE_ANIM_TIME_END;

  local beg_y = ObjGet( obj ).pos_y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0,     0, private.TASKHEADER_MOVE_ANIM_POS_Y_BOT,
    tme_beg, 0, private.TASKHEADER_MOVE_ANIM_POS_Y_BOT,
    tme_end, 2, private.TASKHEADER_MOVE_ANIM_POS_Y_TOP
  } );

  local room = GetCurrentRoom();

  local panel_icons_obj_name = "obj_"..common.GetObjectName(room).."_panel_icons";

  if ( ObjGet( panel_icons_obj_name ) ) then

    ObjSet( panel_icons_obj_name, { pos_y = private.ICONS_POS_Y } );

    ObjAttach( panel_icons_obj_name, "spr_int_taskpanel" );

  end;
--DbgTrace(room);
--DbgTrace(" ".._G[ room ].changed_name[1]);
  if ( _G[ room ].changed_name ) and ( _G[ room ].changed_name[1] ~= "" ) then

    local panel_icon_spr_name = _G[ room ].changed_name[1].."_panel_icon";

    if ( ObjGet( panel_icon_spr_name ) ) then

      ObjSet( panel_icon_spr_name, { pos_x = -private.MOVE_ICON_ANIM_POS_X_END, alp = 1 } );

    end;

  end;

end;
--******************************************************************************************
function public.TaskHeaderHideAnim( event_id )

  local obj = "int_taskpanel_impl";

  local trg = function () int_taskpanel.EventAnimEnd( event_id ); end;

  local tme_beg = ( private.TASKHEADER_MOVE_ANIM_TIME_END - private.TASKHEADER_MOVE_ANIM_TIME_BEG );
  local tme_end = private.TASKHEADER_MOVE_ANIM_TIME_END;

  local beg_y = ObjGet( obj ).pos_y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0,     0, beg_y,--private.TASKHEADER_MOVE_ANIM_POS_Y_TOP,
    tme_beg, 1, private.TASKHEADER_MOVE_ANIM_POS_Y_BOT,
    tme_end, 0, private.TASKHEADER_MOVE_ANIM_POS_Y_BOT
  } );

  ObjAnimate( "obj_int_taskpanel_collect", "pos_y", 0, 0, "",
  {
    0.0,     0, 0,
    tme_beg, 1, ( private.TASKHEADER_MOVE_ANIM_POS_Y_BOT - private.TASKHEADER_MOVE_ANIM_POS_Y_TOP )
  } );

end;
--******************************************************************************************
function private.CompleteTaskAnimEnd( task_name, task_count, event_id )

  local fx_task = task_name.."_effect";

  local trg_del = function () ObjDelete(fx_task); end;

  local trg_end = function () int_taskpanel.EventAnimEnd( event_id ); end;

  ObjCreate( fx_task, "partsys" );
  ObjSet( fx_task, { res = "assets/interface/resources/fx/ho_item_list" } );
  ObjAttach( fx_task, task_name );

  ObjAnimate( fx_task, "alp", 0, 0, trg_del,
  {
    0.0, 0, 0,
    0.3, 0, 1,
    0.6, 0, 0
  } );

  --local line_scale_x = ( ObjGet( "txt_"..cmn.GetObjectName( task_name ) ).draw_width + int.taskpanel.ICON_LINE_OFFSET ) / int.taskpanel.ICON_LINE_SPR_REAL_WIDTH;

  ObjSet( task_name.."_line", { scale_x = 0.526,
                                color_r = private.TASK_COMPLETED_COLOR_R,
                                color_g = private.TASK_COMPLETED_COLOR_G,
                                color_b = private.TASK_COMPLETED_COLOR_B } );--scale_x = line_scale_x

  ObjAnimate( task_name.."_line", "alp", 0, 0, trg_end,
  {
    0.0, 0, 0,
    0.3, 0, 0.7
  } );

end;
--******************************************************************************************
function public.CompleteTaskAnim( item_name, task_id, task_count, event_id )

  local task_name = "obj_int_taskpanel_task_"..task_id;

  local trg = function () private.CompleteTaskAnimEnd( task_name, task_count, event_id ); end;

  if ( task_count ~= 0 ) then

    trg = function ()
            ObjSet( "txt_int_taskpanel_task_"..task_id, 
                    { param4 = int_taskpanel.task_params[ task_id ].count } );
          end;

  end;

  local fx_item = item_name.."_effect_"..task_count;

  ObjCreate( fx_item, "partsys" );
  ObjSet( fx_item, { res = "assets/interface/resources/fx/ho_get_obj"  } );
  ObjAttach( fx_item, item_name );

  int_taskpanel.StdFlyAnimation( fx_item, task_name, function () ObjDelete( fx_item ); end );
  int_taskpanel.StdFlyAnimation( item_name, task_name, trg, 0.2 );

end;
--******************************************************************************************
function public.SetTask( task_id, task_params )

  local task_color_r = private.TASK_COLOR_R;
  local task_color_g = private.TASK_COLOR_G;
  local task_color_b = private.TASK_COLOR_B;

  if ( task_params.count < 1 ) then

    task_color_r = private.TASK_COMPLETED_COLOR_R;
    task_color_g = private.TASK_COMPLETED_COLOR_G;
    task_color_b = private.TASK_COMPLETED_COLOR_B;    

  end;

  if ( task_params.marked == 1 ) then

    task_color_r = private.TASK_MARKED_COLOR_R;
    task_color_g = private.TASK_MARKED_COLOR_G;
    task_color_b = private.TASK_MARKED_COLOR_B;

  end;

  local task_pattern = "str_int_taskpanel_pattern";

  if ( task_params.count > 1 ) then

    task_pattern = "str_int_taskpanel_pattern_multiple";

  end;

  ObjSet( "txt_int_taskpanel_task_"..task_id,
  {
    text   = task_pattern,
    param0 = task_color_r,
    param1 = task_color_g,
    param2 = task_color_b,
    param3 = StringGet( task_params.name ),
    param4 = task_params.count
  } );

  if ( task_params.count < 1 ) then

    --local line_scale_x = ( ObjGet( "txt_int_taskpanel_task_"..task_id ).draw_width + int.taskpanel.ICON_LINE_OFFSET ) / int.taskpanel.ICON_LINE_SPR_REAL_WIDTH;

    ObjSet( "obj_int_taskpanel_task_"..task_id.."_line", { scale_x = 0.526, alp = 0.7,
                                                           color_r = private.TASK_COMPLETED_COLOR_R,
                                                           color_g = private.TASK_COMPLETED_COLOR_G,
                                                           color_b = private.TASK_COMPLETED_COLOR_B } );--scale_x = line_scale_x,

  else

    ObjSet( "obj_int_taskpanel_task_"..task_id.."_line", { alp = 0 } );

  end;

end;
--******************************************************************************************
function public.UnmarkTaskAnim( task_id, event_id )

  local task_color_r = private.TASK_COLOR_R;
  local task_color_g = private.TASK_COLOR_G;
  local task_color_b = private.TASK_COLOR_B;

  ObjSet( "txt_int_taskpanel_task_"..task_id,
  {
    param0 = task_color_r,
    param1 = task_color_g,
    param2 = task_color_b
  } );

end;
--******************************************************************************************
function public.MarkTaskAnim( task_id, event_id )

  --

end;
--******************************************************************************************
function public.SetNewTaskAnim()

  local ho_name = common.GetObjectName( GetCurrentRoom() );

  if ( _G[ "ho_"..ho_name ].change_stage_anim_type ) and ( _G[ "ho_"..ho_name ].change_stage_anim_type == "alp" ) then

    local trg = function () private.SetNewTaskAnimBeg( "alp" ); end;

    ObjAnimate( "obj_int_taskpanel_tasks", "alp", 0, 0, trg,
    {
      0.0,                                0, 1,
      private.CHANGE_TASK_ALP_TIME, 0, 0
    } );

  else

    local trg = private.SetNewTaskAnimBeg;

    local tme_end = ( private.TASKHEADER_MOVE_ANIM_TIME_END - private.TASKHEADER_MOVE_ANIM_TIME_BEG );

    ObjAnimate( "int_taskpanel_impl", "pos_y", 0, 0, trg,
    {
      0.0,     0, ObjGet( "int_taskpanel_impl" ).pos_y,
      tme_end, 1, private.TASKHEADER_MOVE_ANIM_POS_Y_BOT
    } );

    ObjAnimate( "int_inventory_impl", "pos_y", 0, 0, "",
    {
      0.0,     0, ObjGet( "int_inventory_impl" ).pos_y,
      tme_end, 1, int_inventory_impl.TASKHEADER_MOVE_ANIM_POS_Y_BOT
    } );

    ObjAnimate( "int_taskheader_impl", "pos_y", 0, 0, "",
    {
      0.0,     0, ObjGet( "int_taskheader_impl" ).pos_y,
      tme_end, 1, int_taskheader_impl.MOVE_ANIM_POS_Y_BOT
    } );

  end;

end;
--******************************************************************************************
function private.SetNewTaskAnimBeg( change_stage_anim_type )

  change_stage_anim_type = change_stage_anim_type or "default";

  int_taskpanel.already_hide = false;

  local ho_tasks = public.HO_TASK_NEW;

  --DbgTrace( "tasks count: "..#ho_tasks );

  int_taskpanel.task_id     = {};
  int_taskpanel.task_params = {};

  for i = 1, #ho_tasks, 1 do

    local task_name   = ho_tasks[ i ][ "name"   ];
    local task_count  = ho_tasks[ i ][ "count"  ];
    local task_marked = ho_tasks[ i ][ "marked" ];

    int_taskpanel.task_id[ task_name ] = i;
    int_taskpanel.task_params[ i ] =
    {
      name   = task_name,
      count  = task_count,
      marked = task_marked
    };

    int_taskpanel_impl.SetTask( i, int_taskpanel.task_params[ i ] );

  end;

  for i = #ho_tasks + 1, 12, 1 do

    ObjSet( "txt_int_taskpanel_task_"..i, { visible = 0 } );

    ObjSet( "obj_int_taskpanel_task_"..i.."_line", { alp = 0 } );

  end;

  public.SetTaskPos( #ho_tasks );


  local trg = private.SetNewTaskAnimEnd;


  if ( change_stage_anim_type == "alp" ) then

    --DbgTrace("anm alp to 1");

    ObjAnimate( "obj_int_taskpanel_tasks", "alp", 0, 0, trg,
    {
      0.0,                                0, 0,
      private.CHANGE_TASK_ALP_TIME, 0, 1
    } );

  else

    local tme_end = private.TASKHEADER_MOVE_ANIM_TIME_BEG;

    ObjAnimate( "int_taskpanel_impl", "pos_y", 0, 0, trg,
    {
      0.0,     0, private.TASKHEADER_MOVE_ANIM_POS_Y_BOT,
      tme_end, 2, private.TASKHEADER_MOVE_ANIM_POS_Y_TOP
    } );

    ObjAnimate( "int_inventory_impl", "pos_y", 0, 0, "",
    {
      0.0,     0, int_inventory_impl.TASKHEADER_MOVE_ANIM_POS_Y_BOT,
      tme_end, 2, int_inventory_impl.TASKHEADER_MOVE_ANIM_POS_Y_TOP
    } );

    ObjAnimate( "int_taskheader_impl", "pos_y", 0, 0, "",
    {
      0.0,     0, int_taskheader_impl.MOVE_ANIM_POS_Y_BOT,
      tme_end, 2, int_taskheader_impl.MOVE_ANIM_POS_Y_TOP
    } );

  end;

end;
--******************************************************************************************
function private.SetNewTaskAnimEnd()

  public.HO_TASK_NEW = {};

  --int.WidgetSetInput( InterfaceWidget_Inventory, 1 );
  --ld.Lock( 0 );

end;
--******************************************************************************************
function public.SetTaskPos( task_num )

  ObjSet( "obj_int_taskpanel_tasks_line_1", { pos_x = 0 } );
  ObjSet( "obj_int_taskpanel_tasks_line_2", { pos_x = 0 } );
  ObjSet( "obj_int_taskpanel_tasks_line_3", { pos_x = 0 } );

  local task_line_num = math.ceil( task_num / 4 );

  local last_line_task_num = task_num - 4 * ( task_line_num - 1 );

  local tasks_pos_y = -private.task_line_pos_y_offset * ( task_line_num - 1 );

  ObjSet( "obj_int_taskpanel_tasks", { pos_y = tasks_pos_y } );

  local tasks_last_line_pos_x = private.task_line_pos_x_offset * ( 3 - ( last_line_task_num - 1 ) );

  ObjSet( "obj_int_taskpanel_tasks_line_"..task_line_num, { pos_x = tasks_last_line_pos_x } );

end;
--******************************************************************************************
function private.IconShowAnim()

  local room =  GetCurrentRoom();

  if ( _G[ room ].changed_name ) and ( _G[ room ].changed_name[1] ~= "" ) and ( _G[ room ].changed_name[2] == "" ) then

    local panel_icon_spr_name = _G[ room ].changed_name[1].."_panel_icon";

    if ( ObjGet( panel_icon_spr_name ).name ) then

      ObjSet( panel_icon_spr_name, { pos_x = -private.MOVE_ICON_ANIM_POS_X_START, alp = 0 } );

      ObjAnimate( panel_icon_spr_name, "pos_x", 0, 0, "", {   0, 0, -private.MOVE_ICON_ANIM_POS_X_START,
                                                            0.3, 0, -private.MOVE_ICON_ANIM_POS_X_END    } );

      ObjAnimate( panel_icon_spr_name, "alp",   0, 0, "", {   0, 0, 0,    0.3, 0, 1 } );

    end;

  elseif ( _G[ room ].changed_name ) and ( _G[ room ].changed_name[1] ~= "" ) and ( _G[ room ].changed_name[2] ~= "" ) then

    local panel_icon_spr_name = _G[ room ].changed_name[2].."_panel_icon";

    if ( ObjGet( panel_icon_spr_name ).name ) then

      ObjSet( panel_icon_spr_name, { pos_x = int.taskpanel.MOVE_ICON_ANIM_POS_X_START, active = 1, visible = 1, alp = 0 } );

      ObjAnimate( panel_icon_spr_name, "pos_x", 0, 0, "", {   0, 0, private.MOVE_ICON_ANIM_POS_X_START,
                                                            0.3, 0, private.MOVE_ICON_ANIM_POS_X_END    } );

      ObjAnimate( panel_icon_spr_name, "alp",   0, 0, "", {   0, 0, 0,    0.3, 0, 1 } );

    end;


  end;

end;
--******************************************************************************************
function private.IconHideAnim()

  local room = GetCurrentRoom();

  if ( _G[ room ].changed_name ) and ( _G[ room ].changed_name[1] ~= "" ) then

    local panel_icon_spr_name = _G[ room ].changed_name[1].."_panel_icon";

    if ( ObjGet( panel_icon_spr_name )) then

      ObjAnimate( panel_icon_spr_name, "alp",   0, 0, "", {   0, 0, 1,    0.3, 0, 0 } );

    end;

  end;

  if ( _G[ room ].changed_name ) and ( _G[ room ].changed_name[2] ~= "" ) then

    local panel_icon_spr_name = _G[ room ].changed_name[2].."_panel_icon";

    if ( ObjGet( panel_icon_spr_name ) ) then

      ObjAnimate( panel_icon_spr_name, "alp",   0, 0, "", {   0, 0, 1,    0.3, 0, 0 } );

    end;

  end;

end;
--******************************************************************************************
