--******************************************************************************************
function public.Init ()

  public.DIRECTION = 0;

  private.MOUSE_OVER_ANIM_TIME = 0.3;

  public.MOVE_ANIM_TIME_BEG  = 0.6;
  public.MOVE_ANIM_TIME_END  = 1.2;
  public.MOVE_ANIM_POS_Y_TOP = 646;
  public.MOVE_ANIM_POS_Y_BOT = 830;

  ObjSet( "obj_int_taskheader_inventory", {
    event_mdown  = function () int_taskheader.MouseDown( "inventory" ); end,
    event_menter = function () private.MouseEnterAnim( "inventory" ); end,
    event_mleave = function () private.MouseLeaveAnim( "inventory" ); end
  } );

  ObjSet( "obj_int_taskheader_taskpanel", {
    event_mdown  = function () int_taskheader.MouseDown( "taskpanel" ); end,
    event_menter = function () private.MouseEnterAnim( "taskpanel" ); end,
    event_mleave = function () private.MouseLeaveAnim( "taskpanel" ); end
  } );

end;
--******************************************************************************************
function public.InventoryActivateAnim()

  ObjSet( "spr_int_taskheader_inventory_focus", { alp = 1 } );

  private.active = "inventory";

  private.MouseLeaveAnim( "taskpanel" );

end;
--******************************************************************************************
function public.TaskPanelActivateAnim()

  ObjSet( "spr_int_taskheader_taskpanel_focus", { alp = 1 } );

  private.active = "taskpanel";

  private.MouseLeaveAnim( "inventory" );
  
end;
--******************************************************************************************
function public.ShowAnim( event_id )

  public.TaskPanelActivateAnim();

  local obj = "int_taskheader_impl";

  local trg = function () int_taskheader.EventAnimEnd( event_id ); end;

  local tme_beg = public.MOVE_ANIM_TIME_BEG;
  local tme_end = public.MOVE_ANIM_TIME_END;

  local beg_y = ObjGet( obj ).pos_y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0,     0, public.MOVE_ANIM_POS_Y_BOT,
    tme_beg, 0, public.MOVE_ANIM_POS_Y_BOT,
    tme_end, 2, public.MOVE_ANIM_POS_Y_TOP
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local obj = "int_taskheader_impl";

  local trg = function () private.HideAnimEnd( event_id ); end;

  local tme_beg = ( public.MOVE_ANIM_TIME_END - public.MOVE_ANIM_TIME_BEG );
  local tme_end = public.MOVE_ANIM_TIME_END;

  local beg_y = ObjGet( obj ).pos_y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0,     0, beg_y,
    tme_beg, 1, public.MOVE_ANIM_POS_Y_BOT,
    tme_end, 0, public.MOVE_ANIM_POS_Y_BOT
  } );

end;
--******************************************************************************************
function private.HideAnimEnd( event_id )

  local tme_beg = ( public.MOVE_ANIM_TIME_END - public.MOVE_ANIM_TIME_BEG );
  local tme_end = public.MOVE_ANIM_TIME_END;

  int_taskheader.EventAnimEnd( event_id );

end;
--******************************************************************************************
function private.MouseEnterAnim( objname )

  if ( private.active ~= objname ) then

    SetCursor( CURSOR_HAND );

    local obj = "spr_int_taskheader_"..objname.."_focus";
    local alp = ObjGet( obj ).alp;
    local tme = ( 1 - alp ) * private.MOUSE_OVER_ANIM_TIME;

    ObjAnimate( obj, "alp", 0, 0, "",
    {
      0.0, 2, alp,
      tme, 2, 1
    } );

  end;

end;
--******************************************************************************************
function private.MouseLeaveAnim( objname )

  if ( private.active ~= objname ) then

    SetCursor( CURSOR_DEFAULT );

    local obj = "spr_int_taskheader_"..objname.."_focus";
    local alp = ObjGet( obj ).alp;
    local tme = alp * private.MOUSE_OVER_ANIM_TIME;

    ObjAnimate( obj, "alp", 0, 0, "",
    {
      0.0, 1, alp,
      tme, 1, 0
    } );

  end;

end;
--******************************************************************************************
