--******************************************************************************************
function public.Init()

  public.DIRECTION = 0;

  local TEXT_WIDTH_1 = 600;
  local TEXT_WIDTH_2 = 800;

  local IMAGE_COLUMN_1 = 200;
  local IMAGE_COLUMN_2 = 380;

  local IMAGE_ROW_1 = - 140;
  local IMAGE_ROW_2 =     0;
  local IMAGE_ROW_3 =   140;

  public.PAGE_CONTENT_DATA = {

    {
      text   =  { maxwidth = TEXT_WIDTH_2 },
      images =  {
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_1 }
                },
    },

    {
      text   =  { maxwidth = TEXT_WIDTH_2 },
      images =  {
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_2 }
                }
    },

    {
      text   =  { maxwidth = TEXT_WIDTH_2 },
      images =  {
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_2 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_3 }
                }
    },

    {
      text   =  { maxwidth = TEXT_WIDTH_1 },
      images =  {
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_2 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_2 }
                }
    },

    {
      text   =  { maxwidth = TEXT_WIDTH_1 },
      images =  {
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_2 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_2 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_3 }
                }
    },

    {
      text   =  { maxwidth = TEXT_WIDTH_1 },
      images =  {
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_1 },
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_2 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_2 },
                  { pos_x = IMAGE_COLUMN_1, pos_y = IMAGE_ROW_3 },
                  { pos_x = IMAGE_COLUMN_2, pos_y = IMAGE_ROW_3 }
                }
    }

  };

  --private.MOUSE_OVER_ANIM_TIME = 0.3;

  ObjSet( "btn_int_strategy_guide_button_close", {
    event_mdown  = function () int_strategy_guide.ButtonCloseMouseDown(); end,
    event_menter = function () private.ButtonMouseEnterAnim( "btn_int_strategy_guide_button_close" ); end,
    event_mleave = function () private.ButtonMouseLeaveAnim( "btn_int_strategy_guide_button_close" ); end,
  } );
  ObjSet( "btn_int_strategy_guide_button_toc", {
    event_mdown  = function () int_strategy_guide.ButtonTOCMouseDown(); end,
    event_menter = function () private.ButtonMouseEnterAnim( "btn_int_strategy_guide_button_toc" ); end,
    event_mleave = function () private.ButtonMouseLeaveAnim( "btn_int_strategy_guide_button_toc" ); end,
  } );
  ObjSet( "btn_int_strategy_guide_button_next", {
    event_mdown  = function () int_strategy_guide.ButtonNextMouseDown(); end,
    event_menter = function () private.ButtonMouseEnterAnim( "btn_int_strategy_guide_button_next" ); end,
    event_mleave = function () private.ButtonMouseLeaveAnim( "btn_int_strategy_guide_button_next" ); end,
  } );
  ObjSet( "btn_int_strategy_guide_button_prev", {
    event_mdown  = function () int_strategy_guide.ButtonPrevMouseDown(); end,
    event_menter = function () private.ButtonMouseEnterAnim( "btn_int_strategy_guide_button_prev" ); end,
    event_mleave = function () private.ButtonMouseLeaveAnim( "btn_int_strategy_guide_button_prev" ); end,
  } );
  ObjSet( "wnd_int_strategy_guide_image", {
    event_mdown  = function () int_strategy_guide.ImageHide(); end,
    event_menter = function () SetCursor( CURSOR_DOWN ); end,
    event_mleave = function () SetCursor( CURSOR_DEFAULT ); end,
  } );
  for i = 1, 6 do
    ObjSet( "obj_int_strategy_guide_page_image_"..i, {
      event_mdown  = function () int_strategy_guide.ImageShow( i ); end,
      event_menter = function () private.ButtonMouseEnterAnim( "obj_int_strategy_guide_page_image_"..i, "grd" ); end,
      event_mleave = function () private.ButtonMouseLeaveAnim( "obj_int_strategy_guide_page_image_"..i, "grd" ); end,
    } );
  end;

end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    --
  
  else

    --

  end;

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local obj = "int_strategy_guide_impl";
  local trg = function () int_strategy_guide.EventAnimEnd( event_id ); end;

  ObjAnimate( obj, "alp", 0, 0, trg,
  {
    0.0, 0, 0,
    0.6, 0, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local obj = "int_strategy_guide_impl";
  local trg = function () int_strategy_guide.EventAnimEnd( event_id ); end;

  ObjAnimate( obj, "alp", 0, 0, trg,
  {
    0.0, 0, 1,
    0.6, 0, 0
  } );

end;
--******************************************************************************************
function public.PageShowAnim( obj_name, event_id )

  local trg = function () int_strategy_guide.EventAnimEnd( event_id ); end;

  int_strategy_guide.StdPageShowAnimation( obj_name, trg );

end;
--******************************************************************************************
function public.PageHideAnim( obj_name, event_id )

  local trg = function () int_strategy_guide.EventAnimEnd( event_id ); end;

  int_strategy_guide.StdPageHideAnimation( obj_name, trg );

end;
--******************************************************************************************
function private.ButtonMouseEnterAnim( sender, focus_type )

  focus_type = focus_type or "spr";

  local focus = string.format( "%s_%s_focus", focus_type, interface.GetObjectName( sender ) );

  interface.ButtonMouseEnterAnim( sender, "alp", focus );

end;
--******************************************************************************************
function private.ButtonMouseLeaveAnim( sender, focus_type )

  focus_type = focus_type or "spr";

  local focus = string.format( "%s_%s_focus", focus_type, interface.GetObjectName( sender ) );

  interface.ButtonMouseLeaveAnim( sender, "alp", focus );

end;
--******************************************************************************************

