--******************************************************************************************
function public.Init ()

  -- параметры грида
  public.GRID_CORNER_W = 28;
  public.GRID_CORNER_H = 21;
  public.GRID_MID_W    =  2;
  public.GRID_MID_H    =  2;

  -- добавочные ширина и высота
  public.GRID_BORDER_W = 60;
  public.GRID_BORDER_H = 20;

  -- смещение позиции
  public.OFFSET_POS_X  = 20;
  public.OFFSET_POS_Y  = 20;

  public.SHOW_TIME_DELAY = 0.1;

  private.SHOW_ANIM_TIME = 0.2;
  private.HIDE_ANIM_TIME = 0.2;

end;
--******************************************************************************************
function public.ShowAnim( pos_beg, pos_end, event_id )

  local trg = function () int_popup.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_popup", "alp", 0, 0, trg,
  {
    0.0, 1, 0,
    tme, 1, 1
  } );

  ObjAnimate( "int_popup", "pos_xy", 0, 0, "",
  {
    0.0, 1, pos_beg[ 1 ], pos_beg[ 2 ],
    tme, 1, pos_end[ 1 ], pos_end[ 2 ]
  } );

  ObjAnimate( "int_popup", "scale_xy", 0, 0, "",
  {
    0.0, 1, 0, 0,
    tme, 1, 1, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_popup.EventAnimEnd( event_id ); end;
  local tme = private.HIDE_ANIM_TIME;

  ObjAnimate( "int_popup", "alp", 0, 0, trg,
  {
    0.0, 2, 1,
    tme, 2, 0
  } );

  ObjAnimate( "int_popup", "scale_xy", 0, 0, "",
  {
    0.0, 2, 1, 1,
    tme, 2, 0, 0
  } );

end;
--******************************************************************************************