--******************************************************************************************
function public.Init()

  public.ishideanim = false;
  public.SHOW_TIME = 0.35;
  public.event_tmr_end = {};
  public.event_anim_end = {};

  private.GRID_CORNER_W = 50;
  private.GRID_CORNER_H = 22;
  private.GRID_MID_W    =  2;
  private.GRID_MID_H    =  2;

  ObjAttach( "tmr_int_popup_achievements_show", InterfaceWidget_Top_Name );
  ObjAttach("int_popup_achievements", "ng_interface");

end;
--******************************************************************************************
------------------------------------------------------------------------------------
function public.EventAnimEnd( event_id )

  --DbgTrace("event_id "..event_id);

  local event_params = public.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    public.ishideanim = false;

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    local loc_obj_hub = "obj_int_popup_achievements_hub";
    --public.ishideanim = false;

    ObjDelete( loc_obj_hub );

    ObjSet( "int_popup_achievements", { active = 0, visible = 0 } );

  end;

end;
------------------------------------------------------------------------------------
function public.ShowAnim( pos_beg, pos_end, event_id )

  local trg = function () public.EventAnimEnd( event_id ); end;

  ObjAnimate( "int_popup_achievements", 8, 0, 0, trg,
  {
    0.0, 1, 0,
    0.2, 1, 1
  } );

  ObjAnimate( "int_popup_achievements", 3, 0, 0, "",
  {
    0.0, 1, pos_beg[ 1 ], pos_beg[ 2 ],
    0.2, 1, pos_end[ 1 ], pos_end[ 2 ]
  } );

  ObjAnimate( "int_popup_achievements", 6, 0, 0, "",
  {
    0.0, 1, 0, 0,
    0.2, 1, 1, 1
  } );

end;

function public.HideAnim( event_id )

  local trg = function () public.EventAnimEnd( event_id ); end;

  ObjAnimate( "int_popup_achievements", 8, 0, 0, trg,
  {
    0.0, 2, 1,
    0.2, 2, 0
  } );

  ObjAnimate( "int_popup_achievements", 6, 0, 0, "",
  {
    0.0, 2, 1, 1,
    0.2, 2, 0, 0
  } );

end;
------------------------------------------------------------------------------------
function public.Show()
  
  private.ishide = false;

  local popup_achievements_table = public.event_tmr_end;

  local num_ach = #popup_achievements_table


  local loc_obj_hub = "obj_int_popup_achievements_hub";

  if not( ObjGet(loc_obj_hub) ) then

    ObjCreate( loc_obj_hub, "obj" );
    ObjAttach( loc_obj_hub, "grd_int_popup_achievements" );

  end;

  local loc_txt_1_param = ObjGet( "txt_int_popup_achievements_1_default" );
  loc_txt_1_param.name = nil;

  local loc_txt_2_param = ObjGet( "txt_int_popup_achievements_2_default" );
  loc_txt_2_param.name = nil;


  local draw_width  = 0;
  local draw_height  = 0;


  for index = 1 , num_ach , 1 do

    local obj_header = "txt_int_popup_achievements_header_"..index;
    local obj_description = "txt_int_popup_achievements_description_"..index;

    if not( ObjGet(obj_header) ) then

      ObjCreate( obj_header, "text");
      ObjAttach( obj_header , loc_obj_hub );
      ObjSet( obj_header, loc_txt_1_param );

    end;

    if not( ObjGet(obj_description) ) then

      ObjCreate( obj_description, "text");
      ObjAttach( obj_description , loc_obj_hub );
      ObjSet( obj_description, loc_txt_2_param );

    end;

    ObjSet( obj_header, 
    { 
      text = popup_achievements_table[ index ].str_1, 
      pos_y = loc_txt_1_param.pos_y + draw_height + 2, 
      color_r = popup_achievements_table[ index ].color_r_1,
      color_g = popup_achievements_table[ index ].color_g_1,
      color_b = popup_achievements_table[ index ].color_b_1
    } );

    ObjSet( obj_description, 
    { 
      text = popup_achievements_table[ index ].str_2,
      --pos_y = loc_txt_1_param.pos_y + draw_height, 
      color_r = popup_achievements_table[ index ].color_r_2,
      color_g = popup_achievements_table[ index ].color_g_2,
      color_b = popup_achievements_table[ index ].color_b_2
    } );


    local obj_header_draw_height = ObjGet( obj_header ).draw_height;
    local obj_header_draw_width  = ObjGet( obj_header ).draw_width;

    local obj_description_draw_height = 0;
    local obj_description_draw_width  = 0;

    if not ( popup_achievements_table[ index ].str_2 == nil or popup_achievements_table[ index ].str_2 == "" ) then
      obj_description_draw_height = ObjGet( obj_description ).draw_height;
      obj_description_draw_width  = ObjGet( obj_description ).draw_width;
    end;


    ObjSet( obj_description, { pos_y = draw_height + loc_txt_2_param.pos_y + obj_header_draw_height/2 + obj_description_draw_height/2 + 2 } );

    draw_height = draw_height + ( ( loc_txt_2_param.pos_y - loc_txt_1_param.pos_y ) + obj_header_draw_height + obj_description_draw_height );

    if ( obj_header_draw_width >= draw_width ) then
      draw_width = obj_header_draw_width;
    end;

    if ( obj_description_draw_width >= draw_width ) then
      draw_width = obj_description_draw_width;
    end;

  end;

  --ObjSet( "spr_int_popup_achievements", { pos_y = draw_height/2 + 18 } );

  local pos_beg = GetGameCursorPos();

  ObjSet( "int_popup_achievements", { active = 1, visible = 1, pos_x = pos_beg[ 1 ], pos_y = ( pos_beg[ 2 ] ) } );

  local off_x = 60;

  local off_y = 30;

  ObjSet( loc_obj_hub, { pos_y = (- draw_height / 2) + off_y / 2 })

  local popup_achievements_w = draw_width  + off_x;

  local popup_achievements_h =  draw_height + off_y;

  local pos_end = {};

  pos_end[ 1 ] = pos_beg[ 1 ];

  pos_end[ 2 ] = pos_beg[ 2 ];

  local pos_off = 20;

  local screen_min_x = 0;

  local screen_max_x = 1024;

  if ( GetWideScreen() ) then

    screen_min_x = screen_min_x - 171;

    screen_max_x = screen_max_x + 171;

  end;

  if ( pos_beg[ 1 ] <= ( screen_min_x + ( 0.5 * popup_achievements_w ) ) ) then

    pos_end[ 1 ] = screen_min_x + ( 0.5 * popup_achievements_w ) + pos_off;

  end;

  if ( pos_beg[ 1 ] >= ( screen_max_x - ( 0.5 * popup_achievements_w ) ) ) then
    
    pos_end[ 1 ] = screen_max_x - ( 0.5 * popup_achievements_w ) - pos_off;

  end;

  if ( pos_beg[ 2 ] <= popup_achievements_h ) then

    if ( pos_beg[ 1 ] <= ( screen_min_x + popup_achievements_w ) ) then

      local cursor_w = 32;

      pos_end[ 1 ] = pos_beg[ 1 ] + ( 0.5 * popup_achievements_w ) + ( pos_off + cursor_w );

    else

      pos_end[ 1 ] = pos_beg[ 1 ] - ( 0.5 * popup_achievements_w ) - pos_off;

    end;
        
    pos_end[ 2 ] = pos_beg[ 2 ] + ( 0.5 * popup_achievements_h ) + pos_off;

  else

    pos_end[ 2 ] = pos_beg[ 2 ] - ( 0.5 * popup_achievements_h ) - pos_off;

  end;

  local grid_corner_w = private.GRID_CORNER_W;
  local grid_corner_h = private.GRID_CORNER_H;

  local grid_mid_w = private.GRID_MID_W;
  local grid_mid_h = private.GRID_MID_H;

  interface.FrameGridSet( "int_popup_achievements",
  {
    grid_w   = popup_achievements_w,
    grid_h   = popup_achievements_h,
    corner_w = grid_corner_w,
    corner_h = grid_corner_h,
    mid_w    = grid_mid_w,
    mid_h    = grid_mid_h
  } );

  local event_id = "show";
  public.event_anim_end[ event_id ] = {};
  public.ShowAnim( pos_beg, pos_end, event_id );

end;

--[[
------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
function public.Show( popup_achievements_text, popup_achievements_text_2 )
  
  private.ishide = false;

  ObjSet( "txt_int_popup_achievements", { text = popup_achievements_text } );
  ObjSet( "txt_int_popup_achievements_2", { text = popup_achievements_text_2, pos_y = ObjGet("txt_int_popup_achievements").pos_y + ObjGet( "txt_int_popup_achievements" ).draw_height/50 + 30} );

  local pos_beg = GetGameCursorPos();

  ObjSet( "int_popup_achievements", { active = 1, visible = 1, pos_x = pos_beg[ 1 ], pos_y = ( pos_beg[ 2 ] ) } );

  local off_x = 60;
  local off_y = 30;

  local draw_width  = 0;

  if ObjGet( "txt_int_popup_achievements" ).draw_width &gt; ObjGet( "txt_int_popup_achievements_2" ).draw_width then
    draw_width = ObjGet( "txt_int_popup_achievements" ).draw_width;
  else
    draw_width = ObjGet( "txt_int_popup_achievements_2" ).draw_width;
  end;

  local popup_achievements_w = draw_width  + off_x;
  local popup_achievements_h = ObjGet( "txt_int_popup_achievements" ).draw_height + ObjGet( "txt_int_popup_achievements_2" ).draw_height + off_y;

  local pos_end = {};

  pos_end[ 1 ] = pos_beg[ 1 ];
  pos_end[ 2 ] = pos_beg[ 2 ];

  local pos_off = 20;

  local screen_min_x = 0;
  local screen_max_x = 1024;

  if ( GetWideScreen() ) then

    screen_min_x = screen_min_x - 171;
    screen_max_x = screen_max_x + 171;

  end;

  if ( pos_beg[ 1 ] <= ( screen_min_x + ( 0.5 * popup_achievements_w ) ) ) then

    pos_end[ 1 ] = screen_min_x + ( 0.5 * popup_achievements_w ) + pos_off;

  end;

  if ( pos_beg[ 1 ] >= ( screen_max_x - ( 0.5 * popup_achievements_w ) ) ) then
    
    pos_end[ 1 ] = screen_max_x - ( 0.5 * popup_achievements_w ) - pos_off;

  end;

  if ( pos_beg[ 2 ] <= popup_achievements_h ) then

    if ( pos_beg[ 1 ] <= ( screen_min_x + popup_achievements_w ) ) then

      local cursor_w = 32;

      pos_end[ 1 ] = pos_beg[ 1 ] + ( 0.5 * popup_achievements_w ) + ( pos_off + cursor_w );

    else

      pos_end[ 1 ] = pos_beg[ 1 ] - ( 0.5 * popup_achievements_w ) - pos_off;

    end;
        
    pos_end[ 2 ] = pos_beg[ 2 ] + ( 0.5 * popup_achievements_h ) + pos_off;

  else

    pos_end[ 2 ] = pos_beg[ 2 ] - ( 0.5 * popup_achievements_h ) - pos_off;

  end;

  local grid_corner_w = private.GRID_CORNER_W;
  local grid_corner_h = private.GRID_CORNER_H;

  local grid_mid_w = private.GRID_MID_W;
  local grid_mid_h = private.GRID_MID_H;

  interface.FrameGridSet( "int_popup_achievements",
  {
    grid_w   = popup_achievements_w,
    grid_h   = popup_achievements_h,
    corner_w = grid_corner_w,
    corner_h = grid_corner_h,
    mid_w    = grid_mid_w,
    mid_h    = grid_mid_h
  } );

  local event_id = "show";
  public.event_anim_end[ event_id ] = {};
  public.ShowAnim( pos_beg, pos_end, event_id );

end;

--]]
------------------------------------------------------------------------------------
------------------------------------------------------------------------------------