--******************************************************************************************
function public.Init()

  public.DELAY_TIME = 4;

  public.DIRECTION      =   - 1;
  public.POSITION       =   0;
  private.SHOW_POSITION =   128;
  private.HIDE_POSITION = - 128;

  private.SHOW_TIME            = 0.6;
  private.MOUSE_OVER_ANIM_TIME = 0.3;

  ObjSet( "btn_int_panel_notification_achievement_goto", {
    event_mdown = function () int_panel_notification.MouseDown(); end,
    event_menter = function () private.MouseEnter( "achievement" ); end,
    event_mleave = function () private.MouseLeave( "achievement" ); end
  } );

  ObjSet( "btn_int_panel_notification_coin_goto", {
    event_mdown = function () int_panel_notification.MouseDown(); end,
    event_menter = function () private.MouseEnter( "coin" ); end,
    event_mleave = function () private.MouseLeave( "coin" ); end
  } );

end;
--******************************************************************************************
function public.SetExtended( notification_type, notification_params )

  -- Установка свойств объектов для текущего типа по заданным параметам.
  -- example
  ObjSet( "txt_int_panel_notification_"..notification_type, notification_params );

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local objname = "int_panel_notification_impl_root";

  local hide_position = private.HIDE_POSITION;
  local show_position = private.SHOW_POSITION;

  ObjSet( objname, { pos_x = hide_position } );

  local trg = function () int_panel_notification.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_TIME;

  ObjAnimate( objname, "pos_x", 0, 0, trg,
  {
    0.0, 2, hide_position,
    tme, 2, show_position
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local objname = "int_panel_notification_impl_root";

  local hide_position = private.HIDE_POSITION;
  local show_position = private.SHOW_POSITION;

  local tme = private.SHOW_TIME;
  local trg = function () int_panel_notification.EventAnimEnd( event_id ); end;

  ObjAnimate( objname, "pos_x", 0, 0, trg,
  {
    0.0, 1, show_position,
    tme, 1, hide_position
  } );

end;
--******************************************************************************************
function private.MouseEnter( notification_type )

  local focus_name = "spr_int_panel_notification_"..notification_type.."_goto_focus";

  local cur_alp = ObjGet( focus_name ).alp;

  local tme = private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( focus_name, "alp", 0, 0, "",
  {
    0.0,             3, cur_alp,
    tme*(1-cur_alp), 3, 1
  } );

  SetCursor( CURSOR_HAND );

end;
--******************************************************************************************
function private.MouseLeave( notification_type )

  local focus_name = "spr_int_panel_notification_"..notification_type.."_goto_focus";

  local cur_alp = ObjGet( focus_name ).alp;

  local tme = private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( focus_name, "alp", 0, 0, "",
  {
    0.0,         3, cur_alp,
    tme*cur_alp, 3, 0
  } );

  SetCursor( CURSOR_DEFAULT );

end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    --

  else

    --

  end;

end;
--******************************************************************************************
