--******************************************************************************************
function public.Init()

  public.DIRECTION = 0;

  private.SHOW_ANIM_TIME = 0.3;
  private.HIDE_ANIM_TIME = 0.3;

  ObjSet( "spr_int_map_back", {
    event_mup = int_map_impl.Close
  } );

  private.MAP_ICON_MOUSE_OVER_ANIM_TIME = 0.3; --время анимации подсветки мест локации

end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    --

  else

    --

  end;

end;
--******************************************************************************************
private.old_map_room = "";
function public.ShowAnim( event_id )

  local trg = function () 
    int_map.EventAnimEnd( event_id );
    ObjSet("obj_int_map_impl_close", { input = 1 } ); 
    common_impl.is_in_map = 1; 
  end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_map", "alp", 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_mapopen");

  local cur_map_room = common.GetCurrentRoom();

  if ( not game.map_rooms[ cur_map_room ] ) then

    cur_map_room = common.GetPrevRoom();

  end;


  if ( private.old_map_room ~= cur_map_room ) then

    local cur_map_room_obj = "obj_int_map_"..cur_map_room;

    ObjSet( "spr_int_map_here", { pos_x = ObjGet( cur_map_room_obj ).pos_x, pos_y = ObjGet( cur_map_room_obj ).pos_y } );

    --ObjSet( cur_map_room_spr, { pos_x = ObjGet( cur_map_room_spr ).pos_x + 25 } );

    if ( private.old_map_room ~= "" ) then

      local old_map_room_spr = "spr_int_map_"..private.old_map_room.."_task";

      --ObjSet( old_map_room_spr, { pos_x = ObjGet( old_map_room_spr ).pos_x - 25 } );

    end;

    private.old_map_room = cur_map_room;

  end;

  local task_alp = 1;

  if ( ng_global.gamemode == 1 ) or ( ng_global.gamemode == 2 ) or ( ng_global.gamemode == 3 and ng_global.custom_gamemode.tasks == 0 ) then

    task_alp = 0;

    ObjMultiSet({
                  {"text_int_map_all_task_fulfilled", { alp = 0 }},
                  {"text_int_map_task_to_fulfill",    { alp = 0 }},
                  {"spr_int_map_all_task_fulfilled", { alp = 0 }},
                  {"spr_int_map_task_to_fulfill", { alp = 0 }}
                });

  else

    task_alp = 1;

    ObjMultiSet({
                  {"text_int_map_all_task_fulfilled", { alp = 1 }},
                  {"text_int_map_task_to_fulfill",    { alp = 1 }},
                  {"spr_int_map_all_task_fulfilled", { alp = 1 }},
                  {"spr_int_map_task_to_fulfill", { alp = 1 }}
               });
  end;


  for key, value in pairs( game.map_rooms ) do

    if game.map_rooms[ key ][ 1 ] == 0 or game.map_rooms[ key ][ 4 ] == 1 then

      ObjSet( "spr_int_map_"..key.."_task", { alp = 1 } );

    else

      ObjSet( "spr_int_map_"..key.."_task", { alp = task_alp } );

    end;

  end;

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_map.EventAnimEnd( event_id ); end;
  local tme = private.HIDE_ANIM_TIME;

  common_impl.is_in_map = 0;

  ObjAnimate( "int_map", "alp", 0, 0, trg,
  {
    0.0, 3, 1,
    tme, 3, 0
  } );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_map_close");

end;
--******************************************************************************************
function public.MouseEnterMapIcon(room_name)

  SetCursor(CURSOR_HAND);

  local obj = "spr_int_map_"..room_name.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.MAP_ICON_MOUSE_OVER_ANIM_TIME;

  local obj2 = "obj_int_map_"..room_name;
  local scale = ObjGet( obj2 ).scale_x;
  local tme2 = ( 0.1 - (scale - 1) ) * 10 * private.MAP_ICON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

  ObjAnimate( obj2, 6, 0, 0, "",
  {
    0.0, 2, scale, scale, 
    tme2, 2, 1.1, 1.1
  } );

  interface.PopupShow( "pop_"..cmn.GetObjectName( room_name ) );

end;
--******************************************************************************************
function public.MouseLeaveMapIcon(room_name)

  interface.PopupHide();

  SetCursor(CURSOR_DEFAULT);

  local obj = "spr_int_map_"..room_name.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.MAP_ICON_MOUSE_OVER_ANIM_TIME;

  local obj2 = "obj_int_map_"..room_name;
  local scale = ObjGet( obj2 ).scale_x;
  local tme2 = ( scale - 1 ) * 10 * private.MAP_ICON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

  ObjAnimate( obj2, 6, 0, 0, "",
  {
    0.0, 2, scale, scale, 
    tme2, 2, 1, 1
  } );

end;
--******************************************************************************************
function public.CreateRooms( level )

  ObjAttach( "spr_int_map_back_"..level, "int_map_impl" );

  local map_room_obj = "";

  for key, value in pairs( game.map_rooms ) do

    map_room_obj = "spr_int_map_"..key;

    ObjSet( map_room_obj, { event_mdown= function () cmn.ShowBbt('wrong_map_clk'); end });

  end;

  --for key, value in pairs( game.map_rooms ) do
  --  DbgTrace( "[ "..key.." ] = { "..value[1]..", "..value[2]..", "..value[3]..", "..value[4].." }");
  --end;

end;
--******************************************************************************************
function public.OpenRoom( room_name )

  game.map_rooms[ room_name ][ 1 ] = 1;

  game.map_rooms[ room_name ][ 4 ] = 0;

  ObjSet( "spr_int_map_"..room_name, { event_mdown  = function () int_map_impl.ClkMapRoom(room_name) end,
                                       event_menter = function () int_map_impl.MouseEnterMapIcon(room_name) end, 
                                       event_mleave = function () int_map_impl.MouseLeaveMapIcon(room_name) end } );

  if ( game.map_rooms[ room_name ][ 3 ] == 0 ) and ( game.map_rooms[ room_name ][ 2 ] == 1 ) then
  
    ObjSet( "spr_int_map_"..room_name.."_task", { res = "assets/interface/resources/map/task_check" } );

  else

    ObjSet( "spr_int_map_"..room_name.."_task", { res = "assets/interface/resources/map/task" } );

  end;

  ObjSet( "spr_int_map_"..room_name, {alp = 1} );
  ObjSet( "spr_int_map_"..room_name.."_icon", {alp = 1} );

end;
--******************************************************************************************
function public.BlockRoom( room_name )

  game.map_rooms[ room_name ][ 4 ] = 1;

  ObjSet( "spr_int_map_"..room_name, { event_mdown = "" } );

  ObjSet( "spr_int_map_"..room_name.."_task", { res = "assets/interface/resources/map/blocked" } );

end;
--******************************************************************************************
function public.ClkMapRoom( room_name )

  if ( common_impl.is_in_map == 1 ) then

    if ( not game.map_rooms[ common.GetCurrentRoom() ] ) and ( room_name == common.GetPrevRoom() ) then

      int_map_impl.CloseLd();

    else

      int_map_impl.CloseLd();
      cmn.GotoRoom( room_name );

    end;

  end;

end;
--******************************************************************************************
function public.DecreaseRoomTasks(room_name)

  game.map_rooms[ room_name ][ 3 ] = game.map_rooms[ room_name ][ 3 ] - 1;

  if ( game.map_rooms[ room_name ][ 3 ] == 0 ) and ( game.map_rooms[ room_name ][ 2 ] == 0 ) then

    game.map_rooms[ room_name ][ 2 ] = 1;

    ObjSet( "spr_int_map_"..room_name.."_task", { res = "assets/interface/resources/map/task_check" } );

  end;

end;
--******************************************************************************************
function public.MouseEnterBack()

  SetCursor(CURSOR_HAND);

  local obj = "spr_int_map_impl_btn_back_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.MAP_ICON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
------------------------------------------------------------------------------------
function public.MouseLeaveBack()

  SetCursor(CURSOR_DEFAULT);

  local obj = "spr_int_map_impl_btn_back_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.MAP_ICON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function public.CloseLd()  --обертка

  ObjSet( "int_map", { input = 0 } );

  int_map.Close();

end;
--******************************************************************************************
function public.AddDiarypage(count)

  ng_global.map_diary_pages = count;
  ng_global.map_diary_current_page = ng_global.map_diary_pages;

end;
--******************************************************************************************
function public.ShowDiary()

  ObjSet( "spr_int_map_diary_back", { input = 1 } );
  ObjSet( "obj_int_map_impl_close", { input = 0, event_mup = int_map_impl.HideDiary } );
  ObjSet( "obj_int_map_impl_btn_back", { event_mup = int_map_impl.HideDiary } );

  local trg = function () ObjSet("obj_int_map_impl_close", { input = 1 } ); end;

  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "spr_int_map_diary_back", 8, 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_taskjournal");

  int_map_impl.SetDiary();

end;
--******************************************************************************************
function public.HideDiary()

  ObjSet( "spr_int_map_diary_back", { input = 0 } );
  ObjSet( "obj_int_map_impl_close", { input = 0, event_mup = int_map_impl.CloseLd } );
  ObjSet( "obj_int_map_impl_btn_back", { event_mup = int_map_impl.CloseLd } );

  local trg = function () ObjSet("obj_int_map_impl_close", { input = 1 } ); end;

  local tme = private.HIDE_ANIM_TIME;

  ObjAnimate( "spr_int_map_diary_back", 8, 0, 0, trg,
  {
    0.0, 3, 1,
    tme, 3, 0
  } );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_taskjournal_close");

end;
--******************************************************************************************
function public.SetDiary()

  --DbgTrace("***int.map.SetDiary current_page = "..ng_global.map_diary_current_page..", pages = "..ng_global.map_diary_pages);



    local page_num = ng_global.map_diary_current_page;

    if ( math.fmod( page_num, 2 ) == 0 ) then
      page_num = page_num - 1;
    end;

    if ( page_num > 1 ) then
      ObjSet( "obj_int_map_btn_left", { input = 1 } );
      ObjSet( "spr_int_map_btn_left_na", { alp = 0 } );
    else
      ObjSet( "obj_int_map_btn_left", { input = 0 } );
      ObjSet( "spr_int_map_btn_left_na", { alp = 1 } );
    end;

    if ( ( page_num + 1 ) < ng_global.map_diary_pages ) then
      ObjSet( "obj_int_map_btn_right", { input = 1 } );
      ObjSet( "spr_int_map_btn_right_na", { alp = 0 } );
    else
      ObjSet( "obj_int_map_btn_right", { input = 0 } );
      ObjSet( "spr_int_map_btn_right_na", { alp = 1 } );
    end;

  if ng_global.map_diary_pages ~= 0 then

    ObjSet( "txt_int_map_diary_page", { text = math.ceil(page_num/2) } );

    ObjSet( "txt_int_map_diary_left", { text = "str_diary_page_"..page_num } );
    ObjSet( "spr_int_map_diary_left", { res = "assets/interface/resources/map/map_diary/diary_page_"..page_num } );


    if ( page_num < ng_global.map_diary_pages ) then

      page_num = page_num + 1;

      ObjSet( "txt_int_map_diary_right", { text = "str_diary_page_"..page_num, alp = 1 } );
      ObjSet( "spr_int_map_diary_right", { res = "assets/interface/resources/map/map_diary/diary_page_"..page_num, alp = 1 } );

    else

      ObjSet( "txt_int_map_diary_right", { alp = 0 } );
      ObjSet( "spr_int_map_diary_right", { alp = 0 } );

    end;

  else 

    ObjSet( "txt_int_map_diary_page", { text = 1} );

  end;

  ObjAnimate( "obj_int_map_diary", 8,0,0, "", { 0,0,0, 0.3,0,1 } );

end;
--******************************************************************************************
function public.MouseClkBtnDiary( side )

  ObjSet( "obj_int_map_btn_"..side, { input = 0 } );

  if ( side == "left" ) then

    ng_global.map_diary_current_page = ng_global.map_diary_current_page - 2;

  elseif ( side == "right" ) and ( math.fmod( ng_global.map_diary_current_page, 2 ) == 0 ) then

    ng_global.map_diary_current_page = ng_global.map_diary_current_page + 1;

  elseif ( side == "right" ) and ( math.fmod( ng_global.map_diary_current_page, 2 ) ~= 0 ) then

    ng_global.map_diary_current_page = ng_global.map_diary_current_page + 2;

  end

  ObjAnimate( "obj_int_map_diary", 8,0,0, int_map_impl.SetDiary, { 0,0,1, 0.3,0,0 } );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_turnpage");

end;
--******************************************************************************************
function public.MouseEnterBtnDiary( side )

  SetCursor(CURSOR_HAND);

  local obj = "spr_int_map_btn_"..side.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * 0.3;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function public.MouseLeaveBtnDiary( side )

  SetCursor(CURSOR_DEFAULT);

  local obj = "spr_int_map_btn_"..side.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * 0.3;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************