--******************************************************************************************
function public.Init ()

  public.ITEM_POSITION_OFFSET = 101;

  local pos_offset = 0;
  private.MOVE_ANIM_TIME_BEG  = int_taskheader_impl.MOVE_ANIM_TIME_BEG;--MOVE_ANIM_TIME = 0.6;
  private.MOVE_ANIM_TIME_END  = int_taskheader_impl.MOVE_ANIM_TIME_END;
  private.MOVE_ANIM_POS_Y_TOP = int_taskheader_impl.MOVE_ANIM_POS_Y_TOP + pos_offset;-- = 695;
  private.MOVE_ANIM_POS_Y_BOT = int_taskheader_impl.MOVE_ANIM_POS_Y_BOT + pos_offset;-- = 840;

  public.ITEM_MOVE_ANIM_TIME = 0.3;
  private.ITEM_DRAG_ANIM_TIME = 0.1;
  private.ITEM_DROP_ANIM_TIME = 0.2;

  private.ITEM_MOUSE_OVER_ANIM_TIME = 0.15;

  public.ITEM_SCALE       = 0.62;
  private.ITEM_SCALE_FOCUS = 0.72;
  private.ITEM_SCALE_FLY   = 1.00;

  private.ARROW_ANIM_TIME  = 0.3;

  -- public.DONT_DELETE_ITEMS = true;

  ObjSet("obj_int_itempanel_btn_left", {
    event_mdown = function () int_itempanel.ArrowClick( "left" ); end,
    event_menter = function () private.ArrowMouseEnterAnim( "left" ); end,
    event_mleave = function () private.ArrowMouseLeaveAnim( "left" ); end
  });
  ObjSet("obj_int_itempanel_btn_right", {
    event_mdown = function () int_itempanel.ArrowClick( "right" ); end,
    event_menter = function () private.ArrowMouseEnterAnim( "right" ); end,
    event_mleave = function () private.ArrowMouseLeaveAnim( "right" ); end
  });

end;
--******************************************************************************************
function public.ArrowSetVisible( arrow_type, arrow_visible )

  local arrow_objname = string.format( "obj_int_itempanel_btn_%s", arrow_type );
  ObjSet( arrow_objname, { visible = arrow_visible } );

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  local tme_beg = private.MOVE_ANIM_TIME_BEG;
  local tme_end = private.MOVE_ANIM_TIME_END;

  ObjAnimate( "int_itempanel_impl", "pos_y", 0, 0, trg,
  {
    0.0,     0, private.MOVE_ANIM_POS_Y_BOT,
    tme_beg, 0, private.MOVE_ANIM_POS_Y_BOT,
    tme_end, 2, private.MOVE_ANIM_POS_Y_TOP
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local obj = "int_itempanel_impl";

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  local tme_beg = (private.MOVE_ANIM_TIME_END - private.MOVE_ANIM_TIME_BEG);
  local tme_end = private.MOVE_ANIM_TIME_END;

  local beg_y = ObjGet( obj ).pos_y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0,     0, beg_y,
    tme_beg, 1, private.MOVE_ANIM_POS_Y_BOT,
    tme_end, 0, private.MOVE_ANIM_POS_Y_BOT
  } );

end;
--******************************************************************************************
function public.ItemSet( item_name, item_position, item_visible )

  ObjSet( item_name,
  {
    pos_x   = item_position,
    alp     = item_visible,
    scale_x = item_visible,
    scale_y = item_visible
  } );

end;
--******************************************************************************************
function public.ItemDragAnim( fly_name, item_name, event_id )

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  int_itempanel.StdItemDragAnimation( fly_name, item_name, trg );

end;
--******************************************************************************************
function public.ItemDropAnim( fly_name, item_name, event_id )

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  int_itempanel.StdItemDropAnimation( fly_name, item_name, trg, public.ITEM_SCALE );

end;
--******************************************************************************************
function public.ItemMoveAnim( object_name, move_type, move_pos, event_id )

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  local tme = public.ITEM_MOVE_ANIM_TIME;

  local obj_params = ObjGet( object_name );

  ObjAnimate( object_name, "pos_x", 0, 0, trg,
  {
    0.0, 3, obj_params.pos_x,
    tme, 3, move_pos
  } );

  if ( move_type == 0 ) then

    --ObjStopAnimate( object_name, "scale_xy" );
    --ObjStopAnimate( object_name, "alp" );

  elseif ( move_type == 1 ) then

    ObjAnimate( object_name, "scale_xy", 0, 0, "",
    {
      0.0, 2, obj_params.scale_x, obj_params.scale_y,
      tme, 2, 0, 0
    } );

    ObjAnimate( object_name, "alp", 0, 0, "",
    {
      0.0, 2, obj_params.alp,
      tme, 2, 0
    } );

  elseif ( move_type == 2 ) then

    ObjAnimate( object_name, "scale_xy", 0, 0, "",
    {
      0.0, 1, obj_params.scale_x, obj_params.scale_y,
      tme, 1, 1, 1
    } );

    ObjAnimate( object_name, "alp", 0, 0, "",
    {
      0.0, 1, obj_params.alp,
      tme, 1, 1
    } );

  end;

end;
--******************************************************************************************
function public.ItemMouseEnterAnim( item_name, event_id )

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  local cur_scale_x = ObjGet( item_name ).scale_x;
  local cur_scale_y = ObjGet( item_name ).scale_y;

  local end_scale_x = private.ITEM_SCALE_FOCUS;
  local end_scale_y = private.ITEM_SCALE_FOCUS;

  local tme = private.ITEM_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( item_name, 6, 0, 0, trg,
  {
    0.0, 3, cur_scale_x, cur_scale_y,
    tme, 3, end_scale_x, end_scale_x
  } );

end;
--******************************************************************************************
function public.ItemMouseLeaveAnim( item_name, event_id )

  local trg = function () int_itempanel.EventAnimEnd( event_id ); end;

  local cur_scale_x = ObjGet( item_name ).scale_x;
  local cur_scale_y = ObjGet( item_name ).scale_y;

  local end_scale_x = public.ITEM_SCALE;
  local end_scale_y = public.ITEM_SCALE;

  local tme = private.ITEM_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( item_name, "scale_xy", 0, 0, trg,
  {
    0.0, 3, cur_scale_x, cur_scale_y,
    tme, 3, end_scale_x, end_scale_y
  } );

end;
--******************************************************************************************
function private.ArrowMouseEnterAnim( arrow )

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_itempanel_btn_"..arrow.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.ARROW_ANIM_TIME;

  ObjAnimate( obj, "scale_xy", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.ArrowMouseLeaveAnim( arrow )

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_itempanel_btn_"..arrow.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.ARROW_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function public.HoItemContourFindAnim( item_object_name, item_name, countdown )

  ObjSet( item_object_name, { input = 0 } );

  local fx_item = item_object_name.."_effect";

  ObjCreate( fx_item, "partsys" );
  ObjSet( fx_item, { res = "assets/interface/resources/fx/ho_get_obj" } );
  ObjAttach( fx_item, item_object_name );

  int_itempanel.StdItemFlyAnimation( fx_item,          item_name, function () ObjDelete( fx_item ) end);
  int_itempanel.StdItemFlyAnimation( item_object_name, item_name, function () interface_impl.ItemPanelItemRemove( item_name, countdown ) end);

end;
--******************************************************************************************