--******************************************************************************************
function public.Init()

  public.ITEM_POSITION_OFFSET = 100;

  private.SHOW_ANIM_TIME = 0.6;
  private.SHOW_POS_Y     = 705;
  private.HIDE_POS_Y     = 778;

  public.ITEM_FLY_ANIM_TIME  = 0.5;
  public.ITEM_MOVE_ANIM_TIME = 0.3;
  public.ITEM_DRAG_ANIM_TIME = 0.1;
  public.ITEM_DROP_ANIM_TIME = 0.2;

  private.ITEM_MOUSE_OVER_ANIM_TIME = 0.15;

  public.ITEM_SCALE       = 0.7;
  private.ITEM_SCALE_FOCUS = 0.8;
  private.ITEM_SCALE_FLY   = 1.0;

  private.ARROW_ANIM_TIME  = 0.3;

  public.DONT_DELETE_ITEMS = true;

  ObjSet("obj_int_inventory_btn_left", {
    event_mdown = function () int_inventory.ArrowClick( "left" ); end,
    event_menter = function () private.ArrowMouseEnterAnim( "left" ); int_inventory.Show( true ); end,
    event_mleave = function () private.ArrowMouseLeaveAnim( "left" ); int_inventory.Hide( false ); end
  });
  ObjSet("obj_int_inventory_btn_right", {
    event_mdown = function () int_inventory.ArrowClick( "right" ); end,
    event_menter = function () private.ArrowMouseEnterAnim( "right" ); int_inventory.Show( true );  end,
    event_mleave = function () private.ArrowMouseLeaveAnim( "right" ); int_inventory.Hide( false ); end
  });
  ObjSet("spr_int_inventory", {
    event_menter = function () int_inventory.Show( true ); end,
    event_mleave = function () int_inventory.Hide( false ); end
  });

end;
--******************************************************************************************
function public.ForceShow()
  ObjSet( "int_inventory_impl", { pos_y = private.SHOW_POS_Y } );
end;
--******************************************************************************************
function public.ShowAnim( event_id )

  ObjSet( "obj_int_inventory_fairy", { active = true } );
  private.do_fly_anim = true;
  private.FairyAnimLoop();

  local obj = "int_inventory_impl";
  local trg = function () 
    private.do_fly_anim = false;
    int_inventory.EventAnimEnd( event_id );
  end;
  local tme = private.SHOW_ANIM_TIME;
  local cur_y = ObjGet( obj ).pos_y;
  local new_y = private.SHOW_POS_Y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0, 2, cur_y,
    tme, 2, new_y
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  ObjSet( "obj_int_inventory_fairy", { active = true } );
  private.do_fly_anim = true;
  private.FairyAnimLoop();

  local obj = "int_inventory_impl";
  local trg = function () 
    private.do_fly_anim = false;
    int_inventory.EventAnimEnd( event_id ); 
  end;
  local tme = private.SHOW_ANIM_TIME;
  local cur_y = ObjGet( obj ).pos_y;
  local new_y = private.HIDE_POS_Y;

  ObjAnimate( obj, "pos_y", 0, 0, trg,
  {
    0.0, 1, cur_y,
    tme, 1, new_y
  } );

end;
--******************************************************************************************
function public.ItemFlyAnim( fly_name, item_name, item_count, event_id )

  local first_item = false;

  if ( item_count == 1 ) then

    first_item = true;

  end;

  local trg = function () int_inventory.EventAnimEnd( event_id ); end;

  int_inventory.StdItemFlyAnimation( fly_name, item_name, trg, first_item );

end;
--******************************************************************************************
function public.ItemDragAnim( fly_name, item_name, event_id )

  local trg = function () int_inventory.EventAnimEnd( event_id ); end;

  int_inventory.StdItemDragAnimation( fly_name, item_name, trg );

end;
--******************************************************************************************
function public.ItemDropAnim( fly_name, item_name, event_id )

  local trg = function () int_inventory.EventAnimEnd( event_id ); end;

  int_inventory.StdItemDropAnimation( fly_name, item_name, trg, public.ITEM_SCALE );

end;
--******************************************************************************************
function public.ItemMoveAnim( object_name, move_type, move_pos, event_id )

  local trg = function () int_inventory.EventAnimEnd( event_id ); end;

  local tme = public.ITEM_MOVE_ANIM_TIME;

  local obj_params = ObjGet( object_name );

  ObjAnimate( object_name, "pos_x", 0, 0, trg,
  {
    0.0, 3, obj_params.pos_x,
    tme, 3, move_pos
  } );

  if ( move_type == 0 ) then

    --ObjStopAnimate( object_name, 6 );
    --ObjStopAnimate( object_name, 8 );

  elseif ( move_type == 1 ) then

    ObjAnimate( object_name, "scale_xy", 0, 0, "",
    {
      0.0, 2, obj_params.scale_x, obj_params.scale_y,
      tme, 2, 0, 0
    } );

    ObjAnimate( object_name, "alp", 0, 0, "",
    {
      0.0, 2, obj_params.alp,
      tme, 2, 0
    } );

  elseif ( move_type == 2 ) then

    ObjAnimate( object_name, "scale_xy", 0, 0, "",
    {
      0.0, 1, obj_params.scale_x, obj_params.scale_y,
      tme, 1, 1, 1
    } );

    ObjAnimate( object_name, "alp", 0, 0, "",
    {
      0.0, 1, obj_params.alp,
      tme, 1, 1
    } );

  end;

end;
--******************************************************************************************
function public.ItemMouseEnterAnim( item_name, event_id )

  local trg = function () int_inventory.EventAnimEnd( event_id ); end;

  local cur_scale_x = ObjGet( item_name ).scale_x;
  local cur_scale_y = ObjGet( item_name ).scale_y;

  local end_scale_x = private.ITEM_SCALE_FOCUS;
  local end_scale_y = private.ITEM_SCALE_FOCUS;

  local tme = private.ITEM_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( item_name, "scale_xy", 0, 0, trg,
  {
    0.0, 3, cur_scale_x, cur_scale_y,
    tme, 3, end_scale_x, end_scale_x
  } );

end;
--******************************************************************************************
function public.ItemMouseLeaveAnim( item_name, event_id )

  local trg = function () int_inventory.EventAnimEnd( event_id ); end;

  local cur_scale_x = ObjGet( item_name ).scale_x;
  local cur_scale_y = ObjGet( item_name ).scale_y;

  local end_scale_x = public.ITEM_SCALE;
  local end_scale_y = public.ITEM_SCALE;

  local tme = private.ITEM_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( item_name, "scale_xy", 0, 0, trg,
  {
    0.0, 3, cur_scale_x, cur_scale_y,
    tme, 3, end_scale_x, end_scale_y
  } );

end;
--******************************************************************************************
function private.FairyAnimLoop()

  if ( private.do_fly_anim ) then
  
    ObjSet( "anm_int_inventory_fairy_left", { playing = true, animfunc = "DoAnim", endtrig = private.FairyAnimLoop } );
    ObjSet( "anm_int_inventory_fairy_right", { playing = true, animfunc = "DoAnim" } );

  else

    ObjSet( "obj_int_inventory_fairy", { active = false } );

  end;

end;
--******************************************************************************************
function private.ArrowMouseLeaveAnim( arrow )

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_inventory_btn_"..arrow.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.ARROW_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function private.ArrowMouseEnterAnim( arrow )

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_inventory_btn_"..arrow.."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.ARROW_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
