--******************************************************************************************
function public.Init ()

  public.GRID_CORNER_W = 198;
  public.GRID_CORNER_H = 198;
  public.GRID_MID_W    =  4;
  public.GRID_MID_H    =  4;

  -- расстояние от внут. рамки до границ спрайта
  public.GRID_BORDER_W = 56;
  public.GRID_BORDER_H = 56;

  private.BUTTON_CLOSE_MOUSE_OVER_TIME = 0.3;

  ObjSet("obj_int_frame_subroom_button", {
    event_mdown = int_frame_subroom.ButtonCloseClick,
    event_menter = private.ButtonCloseMouseEnterAnim,
    event_mleave = private.ButtonCloseMouseLeaveAnim
  });

  ObjSet("obj_int_frame_subroom_top", {
    event_mdown = int_frame_subroom.ButtonCloseClick,
    event_menter = int_frame_subroom.FieldCloseMouseEnter,
    event_mleave = int_frame_subroom.FieldCloseMouseLeave
  });
  ObjSet("obj_int_frame_subroom_bot", {
    event_mdown = int_frame_subroom.ButtonCloseClick,
    event_menter = int_frame_subroom.FieldCloseMouseEnter,
    event_mleave = int_frame_subroom.FieldCloseMouseLeave
  });
  ObjSet("obj_int_frame_subroom_left", {
    event_mdown = int_frame_subroom.ButtonCloseClick,
    event_menter = int_frame_subroom.FieldCloseMouseEnter,
    event_mleave = int_frame_subroom.FieldCloseMouseLeave
  });
  ObjSet("obj_int_frame_subroom_right", {
    event_mdown = int_frame_subroom.ButtonCloseClick,
    event_menter = int_frame_subroom.FieldCloseMouseEnter,
    event_mleave = int_frame_subroom.FieldCloseMouseLeave
  });


end;
--******************************************************************************************
function private.ButtonCloseMouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_frame_subroom_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.BUTTON_CLOSE_MOUSE_OVER_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.ButtonCloseMouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_frame_subroom_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.BUTTON_CLOSE_MOUSE_OVER_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************