--******************************************************************************************
function public.Init ()

  private.SKIP_POS_X     = 465;
  private.CONTINUE_POS_X = 465;

  private.SHOW_ANIM_TIME                = 0.6;
  private.CONTINUE_MOUSE_OVER_ANIM_TIME = 0.3;
  private.SKIP_MOUSE_OVER_ANIM_TIME     = 0.3;
  private.CHANGE_ANIM_TIME              = 0.3;
  private.SKIP_SHOW_ANIM_TIME           = 0.3;

  ObjSet("obj_int_dialog_story_skip", {
    event_mdown = int_dialog_story.SkipClick,
    event_menter = private.SkipMouseEnterAnim,
    event_mleave = private.SkipMouseLeaveAnim
  });

  ObjSet("obj_int_dialog_story_input", {
    event_mdown = int_dialog_story.ContinueClick
  });

end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    ObjSet( "obj_int_dialog_story_skip",     { pos_x = private.SKIP_POS_X     } );
    ObjSet( "obj_int_dialog_story_continue", { pos_x = private.CONTINUE_POS_X } );

  else

    local offset = 0.5 * ( GetAppWidth() - 1024 );

    ObjSet( "obj_int_dialog_story_skip",     { pos_x = ( private.SKIP_POS_X     + offset ) } );
    ObjSet( "obj_int_dialog_story_continue", { pos_x = ( private.CONTINUE_POS_X + offset ) } );

  end;

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_dialog_story.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_dialog_story", "alp", 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_dialog_story.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_dialog_story", "alp", 0, 0, trg,
  {
    0.0, 3, 1,
    tme, 3, 0
  } );

end;
--******************************************************************************************
function public.ChangeProcAnim( event_id )

  local obj = "txt_int_dialog_story";
  local trg = function () int_dialog_story.EventAnimEnd( event_id ); end;
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * ( 0.5 * private.CHANGE_ANIM_TIME );

  ObjAnimate( obj, "alp", 0, 0, trg,
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function public.ChangeBeginAnim( event_id )

  local obj = "txt_int_dialog_story";
  local trg = function () int_dialog_story.EventAnimEnd( event_id ); end;
  local alp = ObjGet( obj ).alp;
  local tme = alp * ( 0.5 * private.CHANGE_ANIM_TIME );

  ObjAnimate( obj, "alp", 0, 0, trg,
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function public.SkipShowAnim( event_id )

  local obj = "obj_int_dialog_story_skip";
  local trg = function () int_dialog_story.EventAnimEnd( event_id ); end;
  local tme = private.SKIP_SHOW_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

end;
--******************************************************************************************
function private.ContinueMouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "txt_int_dialog_story_continue_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.CONTINUE_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.ContinueMouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "txt_int_dialog_story_continue_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.CONTINUE_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function private.SkipMouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "txt_int_dialog_story_skip_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.SKIP_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.SkipMouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "txt_int_dialog_story_skip_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.SKIP_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************