--******************************************************************************************
function public.Init ()

  private.MOUSE_OVER_ANIM_TIME = 0.3;
  private.SHOW_ANIM_TIME       = 0.6;
  ObjSet("obj_int_dialog_ho_button", {
    event_mdown = private.MouseDwn,
    event_menter = private.MouseEnterAnim,
    event_mleave = private.MouseLeaveAnim
  });
  ObjSet("obj_int_dialog_ho_get", {
    event_mdown = private.MouseDwn
  });
  ObjSet("obj_int_dialog_ho_exit", {
    event_mdown = private.MouseDwn,
    event_menter = function () SetCursor( CURSOR_DOWN ); end,
    event_mleave = function () SetCursor( CURSOR_DEFAULT ); end
  });

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_dialog_ho.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "obj_int_dialog_ho_root", "scale_xy", 0, 0, trg,
  {
    ( 0.0 * tme ), 2, 0, 0,
    ( 1.0 * tme ), 2, 1, 1
  } );

  ObjAnimate( "int_dialog_ho_impl", "alp", 0, 0, "",
  {
    ( 0.0 * tme ), 2, 0,
    ( 0.5 * tme ), 2, 0,
    ( 1.0 * tme ), 2, 1 
  });

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_dialog_ho.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "obj_int_dialog_ho_root", "scale_xy", 0, 0, trg,
  {
    ( 0.0 * tme ), 1, 1, 1,
    ( 1.0 * tme ), 1, 0, 0
  } );

  ObjAnimate( "int_dialog_ho_impl", "alp", 0, 0, "",
  {
    ( 0.0 * tme ), 1, 1,
    ( 0.5 * tme ), 1, 0,
    ( 1.0 * tme ), 1, 0
  } );

end;
--******************************************************************************************
function private.MouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_dialog_ho_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.MouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_dialog_ho_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );


end;
--******************************************************************************************
function private.MouseDwn() --обертка

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_takeobject");
  --PlaySfx( "assets/levels/common/audio/aud_takeobject", 0, "", 0.1 );

  int_dialog_ho.MouseDown();

end;
--******************************************************************************************
