--******************************************************************************************
function public.Init( pos_z )

  ObjAttach( "int_dialog_hint", interface.originhub );
  ObjSet( "int_dialog_inv", { pos_z = pos_z } );

  private.event_anim_end = {};

  private.SHOW_ANIM_TIME = 0.3;
  private.BUTTON_CLOSE_MOUSE_OVER_TIME = 0.3;


  MsgSubscribe( Command_DialogHint_Show, private.ShowHintDialog );
  MsgSubscribe( Command_DialogHint_Hide, private.HideHintDialog );
  
end;

--******************************************************************************************
function public.Destroy()

  MsgUnsubscribe( Command_DialogHint_Show, private.ShowHintDialog );
  MsgUnsubscribe( Command_DialogHint_Hide, private.HideHintDialog );

end;

function private.EventAnimEnd( event_id )

  local event_params = private.event_anim_end[ event_id ];

------------------------------------------------------------------------------------
  if ( event_id == "show" ) then

    ObjSet( "int_dialog_hint", { active = 1, visible = 1, input = 1 } );

------------------------------------------------------------------------------------
  elseif ( event_id == "hide" ) then

    common_impl.show_hint.dialog = nil;
    ObjSet( "int_dialog_hint", { active = 0, visible = 0, input = 0 } );

------------------------------------------------------------------------------------
  end;

end;
--******************************************************************************************
function public.MouseDown( dialog_room )

  if common.IsInSubRoom() then
    common.CloseSubRoom();
  end;

  cmn.GotoRoom( dialog_room ); 
  interface_impl.DialogHintHide();

  cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_gotolocation" );
  --PlaySfx( "assets/levels/common/audio/aud_takeobject_ho", 0, "", 0.1 );

end;
--******************************************************************************************
function private.ShowAnim( event_id )

  local trg = function () private.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  --ShowBlur(1);

  --ld.PlayAudio( "aud_teleport_env", 0,1,0 )

  ObjAnimate( "int_dialog_hint", "alp", 0, 0, trg,
  {
    0.0, 2, 0,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.HideAnim( event_id )

  local trg = private.EventAnimEnd( event_id );
  local tme = private.SHOW_ANIM_TIME;

  --ShowBlur(0);

  --SndStop( "assets/levels/common/audio/aud_teleport_env" );

  ObjAnimate( "int_dialog_hint", "alp", 0, 0, trg,
  {
    0.0, 2, 1,
    1, 2, 0
  } );

end;
--******************************************************************************************
function public.ButtonCloseMouseEnterAnim(sender)

  SetCursor( CURSOR_HAND );

  local obj = "spr_"..common.GetObjectName(sender).."_focus";

  DbgTrace(""..obj);
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.BUTTON_CLOSE_MOUSE_OVER_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

  --PlaySfx( "assets/interface/resources/audio/aud_menu_navigate", 0, 0 );

end;
--******************************************************************************************
function public.ButtonCloseMouseLeaveAnim(sender)

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_"..common.GetObjectName(sender).."_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.BUTTON_CLOSE_MOUSE_OVER_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function private.ShowHintDialog(msg, message_params)

    --DbgTrace(""..message_params[ "room" ]);

    local dialog_room = ""; 
    if message_params[ "room" ] ~= nil then
      dialog_room = message_params[ "room" ];
    end;

    ObjSet( "spr_int_dialog_hint", 
    {
      input = 1,
      visible = 1,
      res = string.format( "assets/levels/%s/%s/miniback", ng_global.progress[ prg.current ].common.chapter, dialog_room ),
      event_mdown = function () int_dialog_hint.MouseDown( dialog_room ); end
    } );

    ObjSet( "obj_int_dialog_hint_teleport", { event_mdown = function () int_dialog_hint.MouseDown( dialog_room ); end });

    --local room_name = "";
    --if cmn.GetObjectName(dialog_room) then
    --  room_name = cmn.GetObjectName(dialog_room);
    --end;
    --ObjSet( "txt_int_dialog_hint_room_name", { text = "pop_"..room_name } );

    ObjSet( "int_dialog_hint", { active = 1, visible = 1, input = 1 } );

    local event_id = "show";
    private.event_anim_end[ event_id ] = {};
    private.ShowAnim( event_id );

end;
 -------------------------------------------------------------------------------------
function private.HideHintDialog()

    ObjSet( "int_dialog_hint",
    {
      input = 0
    } );
    
    local event_id = "hide";
    private.event_anim_end[ event_id ] = {};
    private.HideAnim( event_id );

end;
--******************************************************************************************