--******************************************************************************************
function public.Init()

  private.SHOW_ANIM_TIME = 0.5;
  private.SKIP_MOUSE_OVER_ANIM_TIME = 0.5;

  ObjSet( "btn_int_complex_inv_impl_close", {
    event_mdown  = int_complex_inv.Hide,
    event_menter = private.CloseMouseEnterAnim,
    event_mleave = private.CloseMouseLeaveAnim
  } );

  ObjSet( "obj_int_complex_inv_impl_exit", {
    event_mdown  = int_complex_inv.Hide,
    event_menter = private.ExitMouseEnterAnim,
    event_mleave = private.ExitMouseLeaveAnim
  } );

  ObjSet( "spr_int_complex_inv_impl_back", {
    event_mdown  = int_complex_inv.Hide
  } );

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_complex_inv.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_complex_inv", "alp", 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_complex_inv.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_complex_inv", "alp", 0, 0, trg,
  {
    0.0, 3, 1,
    tme, 3, 0
  } );


  local cur_chapter_num = string.sub( ng_global.progress[ prg.current ].common.chapter, -1 );
  local cur_complex_inv = interface.GetCurrentComplexInv();

  if ( _G[ "inventory"..cur_chapter_num ][ cur_complex_inv.."_close" ] ) then

    _G[ "inventory"..cur_chapter_num ][ cur_complex_inv.."_close" ]();

  end;

end;
--******************************************************************************************
function private.ExitMouseEnterAnim()

  SetCursor( CURSOR_DOWN );

  local obj = "spr_int_complex_inv_impl_exit_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.SKIP_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.ExitMouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_complex_inv_impl_exit_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.SKIP_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function private.CloseMouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_complex_inv_impl_close_focus";

  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.SKIP_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.CloseMouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_complex_inv_impl_close_focus";

  local alp = ObjGet( obj ).alp;
  local tme = alp * private.SKIP_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************