function public.Init ()

  public.DIRECTION = 0;

  private.RELOAD_ANIM_FRAME_COUNT = 3611;
  private.RELOAD_BEGIN_ANIM_TIME  = 0.583;

  private.BUTTON_MOUSE_OVER_ANIM_TIME = 0.3;
  private.SHOW_ANIM_TIME = 0.3;

  ObjSet("obj_int_button_skip_button", {
    event_mdown = int_button_skip.MouseDown,
    event_menter = private.MouseEnterAnim,
    event_mleave = private.MouseLeaveAnim
  });

end;
--******************************************************************************************
function public.WideScreenUpdate()

--  if ( not GetWideScreen() ) then
--
--  else
--
--  end;

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_button_skip.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_button_skip", "alp", 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_button_skip.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_button_skip", "alp", 0, 0, trg,
  {
    0.0, 3, 1,
    tme, 3, 0
  } );

end;
--******************************************************************************************
function public.ChangeToStatic()

  ObjSet( "obj_int_button_skip_reload", { active = false, visible = false } );
  ObjSet( "obj_int_button_skip_static", { active = true, visible = true } );

  VidPlay( "vid_int_button_skip_static", function () end );

end;
--******************************************************************************************
function public.ChangeToReload( is_begin )

  VidStop( "vid_int_button_skip_static" );
  ObjSet( "obj_int_button_skip_static", { active = false, visible = false } );

  ObjSet( "obj_int_button_skip_reload", { active = true, visible = true } );
  VidStop( "vid_int_button_skip_reload_begin" );
  VidStop( "vid_int_button_skip_reload_begin_light" );

  if ( is_begin ) then

    ObjSet( "vid_int_button_skip_reload",       { active = false, visible = false } );
    ObjSet( "vid_int_button_skip_reload_begin", { active = true, visible = true, playing = true, 
        endtrig = function () private.ReloadAnim( true ); end } );

    ObjSet( "vid_int_button_skip_reload_begin_light", 
            { active = true, visible = true, playing = true } );
    
    --VidPlay( "vid_int_button_skip_reload_begin", function () end );

  else

    private.ReloadAnim( true );

  end;

end;
--******************************************************************************************
function public.SetHardcore( is_hardcore )

  if ( is_hardcore ) or ( ng_global.gamemode == 3 and ng_global.custom_gamemode.use_skip == 0 ) then

    ObjSet( "obj_int_button_skip_active",   { visible = false } );
    ObjSet( "obj_int_button_skip_hardcore", { active = true, visible = true } );

  else

    ObjSet( "obj_int_button_skip_hardcore", { active = false, visible = false } );
    ObjSet( "obj_int_button_skip_active",   { visible = true } );

  end;

end;
--******************************************************************************************
function private.ReloadAnim( is_first )

  if ( is_first ) then

    ObjSet( "vid_int_button_skip_reload_begin", { active = false, visible = false } );
    ObjSet( "vid_int_button_skip_reload",       { active = true, visible = true } );

  end;

  local time_min    = int_button_skip.GetTimeMin();
  local time_remain = int_button_skip.GetTimeRemain();
  local time_full   = int_button_skip.GetTimeFull();

  local frame_count = private.RELOAD_ANIM_FRAME_COUNT;

  -- время на один фрейм
  local time_frame = time_full / frame_count;
  local time_current = time_full - time_remain;
  local frame_current = math.floor( time_current / time_frame );

  --DbgTrace( "SKIP RELOAD: time = "..time_current..", frame = "..frame_current );

  ObjSet( "vid_int_button_skip_reload", { frame = frame_current, active = true, visible = true } );

  if ( frame_current < frame_count ) then

    local trg = private.ReloadAnim;
    ObjSet( "tmr_int_button_skip_reload_anim", { endtrig = trg, time = time_min, playing = true } );

  end;

end;
--******************************************************************************************
function private.MouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_button_guide_skip_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.BUTTON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.MouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_button_guide_skip_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.BUTTON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************