--******************************************************************************************
function public.Init ()
  --
  public.DIRECTION = 0;

  private.MOUSE_OVER_ANIM_TIME = 0.3;

  ObjSet("obj_int_button_map", {
    event_mdown = public.MouseDown,
    event_menter = public.MouseEnterAnim,
    event_mleave = public.MouseLeaveAnim
  });

end;
--******************************************************************************************
function public.MouseDown()

  if common.IsInSubRoom() then
    common.CloseSubRoom();
  end;

  if interface.GetCurrentComplexInv() ~= "" then
    common_impl.HideComplexItem();
  end;

  int_button_map.MouseDown();

  if cmn.IsEventDone("tutor_10") and not(cmn.IsEventDone("opn_maptutor")) then

    cmn.SetEventDone("opn_maptutor");

    cmn.TutorialShow( "tutor_16", 0, 512, 384 );

  end;

end;
--******************************************************************************************
function public.MouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj1 = "spr_int_button_map_diary";
  local pos1 = ObjGet( obj1 ).pos_x;
  local tme1 = ( pos1/16  ) * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj1, "pos_x", 0, 0, "",
  {
    0.0, 2, pos1,
    tme1, 2, 0
  } );

  local obj2 = "spr_int_button_map_map";
  local pos2 = ObjGet( obj2 ).pos_x;
  local tme2 = ((1 - pos2/34) ) * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj2, "pos_x", 0, 0, "",
  {
    0.0, 2, pos2,
    tme2, 2, 34
  } );

  cmn.PlayAudio("snd", "assets/levels/common/audio/aud_mapfocus");

end;
--******************************************************************************************
function public.MouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj1 = "spr_int_button_map_diary";
  local pos1 = ObjGet( obj1 ).pos_x;
  local tme1 = (1 - pos1/16) * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj1, "pos_x", 0, 0, "",
  {
    0.0, 1, pos1,
    tme1, 1, 16
  } );

  local obj2 = "spr_int_button_map_map";
  local pos2 = ObjGet( obj2 ).pos_x;
  local tme2 = (pos2/34) * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj2, "pos_x", 0, 0, "",
  {
    0.0, 1, pos2,
    tme2, 1, 0
  } );

end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    --
  
  else

    --

  end;

end;
--******************************************************************************************