--******************************************************************************************
function public.Init ()

  public.DIRECTION = 0;
  private.BUTTON_MOUSE_OVER_ANIM_TIME = 0.3;

  ObjSet( "obj_int_button_lock", {
    event_mdown = function () private.LdMouseDown(); end,
    event_menter = function () private.MouseEnterAnim(); end,
    event_mleave = function () private.MouseLeaveAnim(); end
  } );


  ObjAttach("obj_int_button_lock", "spr_int_inventory");
end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    --

  else

    --

  end;

end;
--******************************************************************************************
function public.LockAnim( lock, event_id )

  -- lock: true or false
  if lock then
    ObjSet("spr_int_button_lock_0", { visible = 0 });
    ObjSet("spr_int_button_lock_1", { visible = 1 } );
  else                                
    ObjSet("spr_int_button_lock_0", { visible = 1 });
    ObjSet("spr_int_button_lock_1", { visible = 0 } );
  end;

end;
--******************************************************************************************
function private.MouseEnterAnim()

  int_button_lock.MouseEnter();

  SetCursor( CURSOR_HAND );

  local obj  = "spr_int_button_lock_focus_0";
  local obj1 = "spr_int_button_lock_focus_1";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.BUTTON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

  ObjAnimate( obj1, 8, 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function private.MouseLeaveAnim()

  int_button_lock.MouseLeave();

  SetCursor( CURSOR_DEFAULT );

  local obj  = "spr_int_button_lock_focus_0";
  local obj1 = "spr_int_button_lock_focus_1";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.BUTTON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, 8, 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

  ObjAnimate( obj1, 8, 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
function private.LdMouseDown()  --обертка

  if ( interface.InventoryAutoHideGet() ) then

    cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_inventory_lock_open" );

  else

    cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_inventory_lock_close" );

  end;

  int_button_lock.MouseDown();

end;
--******************************************************************************************