--******************************************************************************************
function public.Init ()

  public.DIRECTION = 1;
  public.POSITION = 956;

  private.MOUSE_OVER_ANIM_TIME = 0.3;

  private.MOVE_ANIM_POS_X_BEG = 1101;
  private.MOVE_ANIM_POS_X_END =   956;
  private.MOVE_ANIM_TIME      =  0.6;

  ObjSet("obj_int_button_info", {
    event_mdown = public.LdMouseDown,
    event_menter = public.MouseEnterAnim,
    event_mleave = public.MouseLeaveAnim
  });

end;
--******************************************************************************************
function public.LdMouseDown()

  if not int_complex_inv.IsOnScreen() then

    int_button_info.MouseDown();

  else

    local deploy_inventory_mmg_name = cmn.GetObjectName( interface.GetCurrentComplexInv() );

--    if ld[ deploy_inventory_mmg_name ] and ld[ deploy_inventory_mmg_name ].Reset then
--
--      ld[ deploy_inventory_mmg_name ].Reset();
--
--    end;

    DbgTrace("переделать с учетом названия функции в сложном предмете "..deploy_inventory_mmg_name);

  end;

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local obj = "int_button_info_impl";
  local trg = function () int_button_info.EventAnimEnd( event_id ); end;
  local tme = private.MOVE_ANIM_TIME;
  local offset = 0.5 * ( GetAppWidth() - 1024 );

  ObjAnimate( obj, "pos_x", 0, 0, trg,
  {
    0.0, 2, public.DIRECTION*offset + private.MOVE_ANIM_POS_X_BEG,
    tme, 2, public.DIRECTION*offset + private.MOVE_ANIM_POS_X_END
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local obj = "int_button_info_impl";
  local trg = function () int_button_info.EventAnimEnd( event_id ); end;
  local tme = private.MOVE_ANIM_TIME;
  local offset = 0.5 * ( GetAppWidth() - 1024 );

  ObjAnimate( obj, "pos_x", 0, 0, trg,
  {
    0.0, 1, public.DIRECTION*offset + private.MOVE_ANIM_POS_X_END,
    tme, 1, public.DIRECTION*offset + private.MOVE_ANIM_POS_X_BEG
  } );

end;
--******************************************************************************************
function public.WideScreenUpdate()

  if ( not GetWideScreen() ) then

    --
  
  else

    --

  end;

end;
--******************************************************************************************
function public.MouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_button_info_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function public.MouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_button_info_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************
