function public.Init ()

  public.DIRECTION = 0;

  private.RELOAD_ANIM_FRAME_COUNT = 3611;
  private.RELOAD_BEGIN_ANIM_TIME  = 0.583;

  private.BUTTON_MOUSE_OVER_ANIM_TIME = 0.3;
  private.SHOW_ANIM_TIME = 0.3;

  private.BUTTON_SPRITE_NAME = "vid_int_button_hint_static";

--на маке убираем видео стаического хинта и ставим картинку
  --if GetPlatform() == "mac" then
  --  ObjDelete( "vid_int_button_hint_static" );
  --  ObjSet( "spr_int_button_hint_static", { visible = 1 } );
  --  private.BUTTON_SPRITE_NAME = "spr_int_button_hint_static";
  --else
  --  ObjDelete( "spr_int_button_hint_static" );
  --end;

  ObjSet("obj_int_button_hint_button", {
    event_mdown = int_button_hint.MouseDown,
    event_menter = public.MouseEnterAnim,
    event_mleave = public.MouseLeaveAnim
  });

end;
--******************************************************************************************
function public.WideScreenUpdate()

  --if ( not GetWideScreen() ) then
  --  ObjSet( "spr_int_button_hint_back_add", { visible = false } );
  --else
  --  ObjSet( "spr_int_button_hint_back_add", { visible = true } );
  --end;

end;
--******************************************************************************************
function public.ShowAnim( event_id )

  local trg = function () int_button_hint.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_button_hint", "alp", 0, 0, trg,
  {
    0.0, 3, 0,
    tme, 3, 1
  } );

end;
--******************************************************************************************
function public.HideAnim( event_id )

  local trg = function () int_button_hint.EventAnimEnd( event_id ); end;
  local tme = private.SHOW_ANIM_TIME;

  ObjAnimate( "int_button_hint", "alp", 0, 0, trg,
  {
    0.0, 3, 1,
    tme, 3, 0
  } );

end;
--******************************************************************************************
function public.ChangeToStatic()

  if ( game.play_hint_aud ) then  --чтоб не проигрывал при загрузке лвла
    cmn.PlayAudio( "snd", "assets/levels/common/audio/aud_hint_reload" );
  end;

  ObjSet( "obj_int_button_hint_reload", { active = false, visible = false } );
  ObjSet( "vid_int_button_hint_reload_end", { active = 1, visible = 1, frame = 1 } );
  ObjSet( private.BUTTON_SPRITE_NAME, { active = 0, visible = 0 } );
  ObjSet( "obj_int_button_hint_static", { active = true, visible = true } );

  VidPlay("vid_int_button_hint_reload_end",   
          function ()
            ObjSet( "vid_int_button_hint_reload_end", { active = 0, visible = 0 } );
            ObjSet( private.BUTTON_SPRITE_NAME, { active = 1, visible = 1 } );
          end 
         );

  --if GetPlatform() ~= "mac" then
   VidPlay( "vid_int_button_hint_static", function () end );
  --end;

end;
--******************************************************************************************
function public.ChangeToReload( is_begin )

  --if GetPlatform() ~= "mac" then  
    VidStop( "vid_int_button_hint_static" );
  --end;

  ObjSet( "obj_int_button_hint_static", { active = false, visible = false } );

  ObjSet( "obj_int_button_hint_reload", { active = true, visible = true } );
  VidStop( "vid_int_button_hint_reload_begin" );
  VidStop( "vid_int_button_hint_reload_begin_light" );

  if ( is_begin ) then

    ObjSet( "vid_int_button_hint_reload",       { active = false, visible = false } );
    ObjSet( "vid_int_button_hint_reload_begin", 
            { active = true, visible = true, playing = true,
              endtrig = function () private.ReloadAnim( true ); end } ); 

    ObjSet( "vid_int_button_hint_reload_begin_light", 
            { active = true, visible = true, playing = true } );
    
    --VidPlay( "vid_int_button_hint_reload_begin", function () end );
    --VidPlay( "vid_int_button_hint_reload_begin_light" );


  else

    private.ReloadAnim( true );

  end;

end;
--******************************************************************************************
function public.SetHardcore( is_hardcore )

  if ( is_hardcore ) or ( ng_global.gamemode == 3 and ng_global.custom_gamemode.use_hint == 0 ) then

    ObjSet( "obj_int_button_hint_active",   { visible = false } );
    ObjSet( "obj_int_button_hint_hardcore", { active = true, visible = true } );

  else

    ObjSet( "obj_int_button_hint_hardcore", { active = false, visible = false } );
    ObjSet( "obj_int_button_hint_active",   { visible = true } );

  end;

end;
--******************************************************************************************
function private.ReloadAnim( is_first )

  if ( is_first ) then

    ObjSet( "vid_int_button_hint_reload_begin", { active = false, visible = false } );
    ObjSet( "vid_int_button_hint_reload",       { active = true, visible = true } );

  end;

  local time_min    = int_button_hint.GetTimeMin();
  local time_remain = int_button_hint.GetTimeRemain();
  local time_full   = int_button_hint.GetTimeFull();

  local frame_count = private.RELOAD_ANIM_FRAME_COUNT;

  -- время на один фрейм
  local time_frame = time_full / frame_count;
  local time_current = time_full - time_remain;
  local frame_current = math.floor( time_current / time_frame );

  --DbgTrace( "HINT RELOAD: time = "..time_current..", frame = "..frame_current );

  ObjSet( "vid_int_button_hint_reload", 
          { frame = frame_current, active = true, visible = true } );

  if ( frame_current < frame_count ) then

    local trg = private.ReloadAnim;
    ObjSet( "tmr_int_button_hint_reload_anim", 
            { endtrig = trg, time = time_min, playing = true } );

  end;

end;
--******************************************************************************************
function public.MouseEnterAnim()

  SetCursor( CURSOR_HAND );

  local obj = "spr_int_button_guide_hint_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = ( 1 - alp ) * private.BUTTON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 2, alp,
    tme, 2, 1
  } );

end;
--******************************************************************************************
function public.MouseLeaveAnim()

  SetCursor( CURSOR_DEFAULT );

  local obj = "spr_int_button_guide_hint_button_focus";
  local alp = ObjGet( obj ).alp;
  local tme = alp * private.BUTTON_MOUSE_OVER_ANIM_TIME;

  ObjAnimate( obj, "alp", 0, 0, "",
  {
    0.0, 1, alp,
    tme, 1, 0
  } );

end;
--******************************************************************************************